/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions;

import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.http.ServletContextLocator;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.preexecute.ALPreExecuteService;
import com.aimluck.eip.services.social.gadgets.ALGadgetContext;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.util.ALSessionUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.modules.actions.JetspeedSessionValidator;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.util.Base64;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ALSessionValidator
extends JetspeedSessionValidator {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALSessionValidator.class.getName());

    public void doPerform(RunData data) throws Exception {
        String paramPortlet;
        CustomLocalizationService locService;
        Locale locale;
        JetspeedUser loginuser;
        block72: {
            try {
                super.doPerform(data);
            }
            catch (Throwable other) {
                this.setOrgParametersForError(data);
                data.setScreenTemplate(JetspeedResources.getString((String)"template.error"));
                return;
            }
            if (this.checkDbError(data)) {
                this.setOrgParametersForError(data);
                data.setScreenTemplate("DBError.vm");
                return;
            }
            if (data.getRequest().isRequestedSessionIdFromURL()) {
                JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)data);
                String url = jsLink.getHomePage().toString().replaceAll(";.*", "");
                data.setRedirectURI(url);
                return;
            }
            loginuser = (JetspeedUser)data.getUser();
            if (this.isLogin(loginuser)) {
                try {
                    JetspeedSecurityCache.load((String)loginuser.getUserName());
                }
                catch (Exception e1) {
                    String message = e1.getMessage();
                    if (message == null || message.indexOf("Error detecting database type") == -1) break block72;
                    this.setOrgParametersForError(data);
                    String template = data.getParameters().get("template");
                    if (template.endsWith("DBError")) {
                        data.setScreenTemplate("DBError.vm");
                    } else {
                        ALEipUtils.redirectDBError(data);
                    }
                    return;
                }
            }
        }
        if (ALSessionUtils.isImageRequest(data) && this.isLogin(loginuser)) {
            return;
        }
        if (ALSessionUtils.isJsonScreen(data) && this.isLogin(loginuser)) {
            return;
        }
        if (data.getRequest().getAttribute("com.aipo.requireDigestAuth") != null) {
            HttpServletRequest hreq = data.getRequest();
            HttpServletResponse hres = data.getResponse();
            if (!this.isLogin(loginuser)) {
                String auth = hreq.getHeader("Authorization");
                if (auth == null) {
                    this.requireAuth(hres);
                    return;
                }
                try {
                    String decoded = this.decodeAuthHeader(auth);
                    int pos = decoded.indexOf(":");
                    String username = decoded.substring(0, pos);
                    String password = decoded.substring(pos + 1);
                    JetspeedUser juser = JetspeedSecurity.login((String)username, (String)password);
                    if (juser == null || !"F".equals(juser.getDisabled())) {
                        this.requireAuth(hres);
                        return;
                    }
                    JetspeedSecurity.saveUser((JetspeedUser)juser);
                }
                catch (RuntimeException ex) {
                    this.requireAuth(hres);
                    return;
                }
                catch (Exception ex) {
                    this.requireAuth(hres);
                    return;
                }
            }
            if (this.isICalRequest(data)) {
                data.setScreenTemplate("ScheduleiCalScreen");
                return;
            }
            hres.sendError(404);
            return;
        }
        Context context = TurbineVelocity.getContext((RunData)data);
        this.setOrgParameters(data, context);
        context.put("utils", (Object)new ALCommonUtils());
        context.put("l10n", (Object)ALLocalizationUtils.createLocalization(data));
        if (!this.isLogin(loginuser) && !data.getParameters().get("template").equals("CookieError")) {
            String username = data.getParameters().getString("username", "");
            String password = data.getParameters().getString("password", "");
            if (username.length() > 0) {
                if (ALCellularUtils.isSmartPhone(data) && "admin".equals(username)) {
                    data.setUser((User)JetspeedSecurity.getAnonymousUser());
                    data.setMessage(ALLocalizationUtils.getl10n("LOGINACTION_LOGIN_ONLY_PC"));
                    data.getUser().setHasLoggedIn(Boolean.FALSE);
                } else {
                    try {
                        loginuser = JetspeedSecurity.login((String)username, (String)password);
                        if (loginuser != null && "F".equals(loginuser.getDisabled())) {
                            JetspeedSecurity.saveUser((JetspeedUser)loginuser);
                        } else {
                            data.setUser((User)JetspeedSecurity.getAnonymousUser());
                            data.setMessage(ALLocalizationUtils.getl10n("LOGINACTION_INVALIDATION_USER"));
                            data.getUser().setHasLoggedIn(Boolean.FALSE);
                        }
                    }
                    catch (LoginException e) {
                        // empty catch block
                    }
                }
            }
        }
        String externalLoginUrl = ALConfigService.get(ALConfigHandler.Property.EXTERNAL_LOGIN_URL);
        boolean isScreenTimeout = false;
        if (!this.isLogin(loginuser) && JetspeedResources.getBoolean((String)"automatic.logon.enable", (boolean)false)) {
            if (data.getRequest().getCookies() != null) {
                String userName = data.getCookies().getString("username", "");
                String loginCookieValue = data.getCookies().getString("logincookie", "");
                if (userName.length() > 0 && loginCookieValue.length() > 0) {
                    try {
                        loginuser = JetspeedSecurity.getUser((String)userName);
                        if (loginuser.getPerm("logincookie", (Object)"").equals(loginCookieValue)) {
                            data.setUser((User)loginuser);
                            loginuser.setHasLoggedIn(Boolean.TRUE);
                            loginuser.updateLastLogin();
                            data.save();
                        }
                    }
                    catch (LoginException noSuchUser) {
                    }
                    catch (UnknownUserException unknownUser) {
                        logger.warn((Object)("Username from the cookie was not found: " + userName));
                    }
                    catch (Exception other) {
                        logger.error((Object)"ALSessionValidator.doPerform", (Throwable)other);
                    }
                }
            }
        } else if (!this.isLogin(loginuser) && !JetspeedResources.getBoolean((String)"automatic.logon.enable", (boolean)false)) {
            String uri = data.getRequest().getRequestURI().trim();
            String template = data.getScreenTemplate();
            Class<?> cls = null;
            try {
                cls = Class.forName(new StringBuffer().append("com.aimluck.eip.modules.screens.").append(template).toString());
            }
            catch (Exception e) {
                cls = null;
            }
            String newTemplate = null;
            if (cls != null) {
                if (Class.forName("com.aimluck.eip.modules.screens.ALJSONScreen").isAssignableFrom(cls)) {
                    newTemplate = "ALJSONTimeoutScreen";
                } else if (Class.forName("com.aimluck.eip.modules.screens.ALVelocityScreen").isAssignableFrom(cls)) {
                    newTemplate = "ALVelocityTimeoutScreen";
                }
            }
            if (newTemplate != null) {
                isScreenTimeout = true;
                data.setScreenTemplate(newTemplate);
                if (data.getSession() != null) {
                    try {
                        data.getSession().invalidate();
                    }
                    catch (IllegalStateException ex) {
                        logger.debug((Object)"\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                    }
                }
            } else {
                String portalPath;
                String contextPath = ServletContextLocator.get().getContextPath();
                if ("/".equals(contextPath)) {
                    contextPath = "";
                }
                if (!uri.equals((portalPath = contextPath + "/portal") + "/") && !uri.equals(portalPath)) {
                    data.setScreenTemplate("Timeout");
                    if (!"".equals(externalLoginUrl)) {
                        data.setRedirectURI(externalLoginUrl);
                    }
                    StringBuffer sb = new StringBuffer(uri);
                    int count = 0;
                    String key = null;
                    Enumeration enu = data.getRequest().getParameterNames();
                    if (enu.hasMoreElements()) {
                        sb.append("?");
                    }
                    while (enu.hasMoreElements()) {
                        if (count != 0) {
                            sb.append("&");
                        }
                        key = (String)enu.nextElement();
                        sb.append(key).append("=").append(data.getRequest().getParameter(key));
                        ++count;
                    }
                    if (data.getUser() != null) {
                        data.getUser().setTemp("redirect", (Object)StringEscapeUtils.escapeHtml((String)sb.toString()));
                        context.put("alEipUtils", (Object)new ALEipUtils());
                        context.put("alEipManager", (Object)ALEipManager.getInstance());
                    }
                    if (data.getSession() != null) {
                        try {
                            data.getSession().invalidate();
                        }
                        catch (IllegalStateException ex) {
                            logger.debug((Object)"\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                        }
                    }
                }
            }
        }
        JetspeedRunData jdata = null;
        try {
            jdata = (JetspeedRunData)data;
        }
        catch (ClassCastException e) {
            logger.error((Object)"The RunData object does not implement the expected interface, please verify the RunData factory settings", (Throwable)e);
            return;
        }
        String language = data.getRequest().getParameter("js_language");
        if (null != language) {
            loginuser.setPerm("language", (Object)language);
        }
        if ((locale = (locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService")).getLocale(data)) == null) {
            locale = new Locale(TurbineResources.getString((String)"locale.default.language", (String)"en"), TurbineResources.getString((String)"locale.default.country", (String)"US"));
        }
        if (loginuser != null) {
            loginuser.setTemp("locale", (Object)locale);
        }
        if ((paramPortlet = jdata.getParameters().getString("js_peid")) != null && paramPortlet.length() > 0) {
            jdata.setJs_peid(paramPortlet);
        }
        if (!isScreenTimeout && !"".equals(externalLoginUrl)) {
            HttpServletRequest request = data.getRequest();
            if (!this.isLogin(loginuser)) {
                String url;
                StringBuilder buf = new StringBuilder();
                buf.append(request.getScheme()).append("://").append(request.getServerName());
                if (request.getServerPort() != 80 && request.getServerPort() != 443) {
                    buf.append(":").append(request.getServerPort());
                }
                buf.append(request.getRequestURI());
                String queryString = request.getQueryString();
                if (queryString != null && !"".equals(queryString)) {
                    buf.append("?").append(queryString);
                }
                if (!(url = buf.toString()).equals(externalLoginUrl)) {
                    data.setRedirectURI(externalLoginUrl);
                }
            }
        }
        if (this.isLogin(loginuser)) {
            String client;
            ALPreExecuteService.migratePsml(data, context);
            boolean hasMessage = false;
            Map<String, Entry> portlets = ALEipUtils.getGlobalPortlets(data);
            Entry entry = portlets.get("Message");
            if (entry != null && entry.getId().equals(jdata.getJs_peid())) {
                hasMessage = true;
            }
            boolean push = !"IPHONE".equals(client = ALEipUtils.getClient(data)) || hasMessage;
            HttpServletRequest request = ((JetspeedRunData)data).getRequest();
            String requestUrl = request.getRequestURL().toString();
            String checkActivityUrl = ALConfigService.get(ALConfigHandler.Property.CHECK_ACTIVITY_URL);
            String interval = ALConfigService.get(ALConfigHandler.Property.CHECK_ACTIVITY_INTERVAL);
            ALEipUser eipUser = ALEipUtils.getALEipUser(data);
            String orgId = Database.getDomainName();
            String viewer = orgId + ":" + eipUser.getName().getValue();
            ALGadgetContext gadgetContext = new ALGadgetContext(data, viewer, "1", "/", 0L);
            String relayUrl = ALConfigService.get(ALConfigHandler.Property.CHECK_ACTIVITY_RELAY_URL);
            String rpctoken = String.valueOf(System.nanoTime());
            String checkUrl = ("".equals(checkActivityUrl) ? "check.html" : checkActivityUrl) + "?" + "st=" + gadgetContext.getSecureToken() + "&parent=" + URLEncoder.encode(requestUrl, "utf-8") + "&interval=" + interval + "&push=" + (push ? 1 : 0) + "#rpctoken=" + rpctoken;
            if (data.getSession() != null && Boolean.parseBoolean((String)data.getSession().getAttribute("changeToPc"))) {
                context.put("client", (Object)ALEipUtils.getClient(data));
            }
            context.put("requestUrl", (Object)requestUrl);
            context.put("relayUrl", (Object)relayUrl);
            context.put("rpctoken", (Object)rpctoken);
            context.put("checkUrl", (Object)checkUrl);
            context.put("st", (Object)gadgetContext.getSecureToken());
            context.put("hasAuthorityCustomize", (Object)ALEipUtils.getHasAuthority(data, context, 8));
        }
    }

    protected void requireAuth(HttpServletResponse hres) throws IOException {
        hres.setHeader("WWW-Authenticate", "BASIC realm=\"Aipo\"");
        hres.sendError(401);
    }

    protected String decodeAuthHeader(String header) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String ret = "";
        try {
            String encStr = header.substring(6);
            byte[] dec = Base64.decodeAsByteArray((String)encStr);
            ret = new String(dec);
        }
        catch (Exception ex) {
            ret = "";
        }
        return ret;
    }

    private boolean isLogin(JetspeedUser loginuser) {
        return loginuser != null && loginuser.hasLoggedIn();
    }

    protected boolean isICalRequest(RunData data) {
        String contextPath = ServletContextLocator.get().getContextPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        HttpServletRequest hreq = data.getRequest();
        String requestURI = hreq.getRequestURI();
        return requestURI.equalsIgnoreCase(contextPath + "/ical/calendar.ics");
    }

    private void setOrgParametersForError(RunData data) {
        Context context = TurbineVelocity.getContext((RunData)data);
        this.setOrgParameters(data, context);
        context.put("isError", (Object)"true");
    }

    private void setOrgParameters(RunData data, Context context) {
        ALOrgUtilsService.assignCommonContext(context);
    }

    private boolean checkDbError(RunData data) {
        String message = data.getMessage();
        return null != message && message.indexOf("Error detecting database type") != -1;
    }
}

