/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm.query;

import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Query;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;

public abstract class AbstractQuery<M>
implements Query<M> {
    protected DataContext dataContext;
    protected Class<M> rootClass;

    public AbstractQuery(Class<M> rootClass) {
        this.rootClass = rootClass;
        this.dataContext = DataContext.getThreadDataContext();
    }

    public AbstractQuery(DataContext dataContext, Class<M> rootClass) {
        this.rootClass = rootClass;
        this.dataContext = dataContext;
    }

    @Override
    public M fetchSingle() {
        Database.beginTransaction(this.dataContext);
        List list = this.fetchList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void deleteAll() {
        List list = this.fetchList();
        if (list.size() > 0) {
            this.dataContext.deleteObjects(list);
        }
    }

    @Override
    public DataContext getDataContext() {
        return this.dataContext;
    }

    protected Object getValueFromDataRow(DataRow dataRow, String key) {
        String lowerKey = key.toLowerCase();
        if (dataRow.containsKey((Object)lowerKey)) {
            return dataRow.get((Object)lowerKey);
        }
        return dataRow.get((Object)key.toUpperCase());
    }

    protected ObjectId createObjectId(String entityName, DataRow dataRow, DbEntity entity) {
        List pk = entity.getPrimaryKey();
        if (pk.size() == 1) {
            DbAttribute attribute = (DbAttribute)pk.get(0);
            String key = attribute.getName();
            Object val = this.getValueFromDataRow(dataRow, key);
            if (val == null) {
                return null;
            }
            return new ObjectId(entityName, attribute.getName(), val);
        }
        HashMap<String, Object> idMap = new HashMap<String, Object>(pk.size() * 2);
        for (DbAttribute attribute : pk) {
            String key = attribute.getName();
            Object val = this.getValueFromDataRow(dataRow, key);
            if (val == null) {
                return null;
            }
            idMap.put(attribute.getName(), val);
        }
        return new ObjectId(entityName, idMap);
    }

    protected M newInstanceFromRowData(DataRow dataRow, Class<M> rootClass) {
        try {
            M model = rootClass.newInstance();
            CayenneDataObject obj = (CayenneDataObject)model;
            ObjEntity objEntity = this.getDataContext().getEntityResolver().lookupObjEntity((Persistent)obj);
            ObjectId objId = this.createObjectId(objEntity.getName(), dataRow, objEntity.getDbEntity());
            if (objId != null) {
                obj.setObjectId(objId);
            }
            for (ObjAttribute objAttribute : objEntity.getAttributes()) {
                DbAttribute dbAttribute = objAttribute.getDbAttribute();
                Object value = this.getValueFromDataRow(dataRow, dbAttribute.getName());
                if (value == null) continue;
                obj.writeProperty(objAttribute.getName(), value);
            }
            return model;
        }
        catch (InstantiationException ignore) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }
}

