/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.social;

import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALActivityCount;
import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.common.ALOAuthConsumer;
import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.social.ALContainerConfigService;
import com.aimluck.eip.services.social.gadgets.ALGadgetSpec;
import com.aimluck.eip.services.social.gadgets.ALOAuthService;
import com.aimluck.eip.services.social.model.ALActivityGetRequest;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.services.social.model.ALApplicationPutRequest;
import com.aimluck.eip.services.social.model.ALOAuthConsumerPutRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

public abstract class ALSocialApplicationHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALSocialApplicationHandler.class.getName());

    public abstract ResultList<ALApplication> getApplicationList(ALApplicationGetRequest var1);

    public abstract ALApplication getApplication(ALApplicationGetRequest var1);

    public abstract void createApplication(ALApplicationPutRequest var1);

    public abstract void updateApplication(String var1, ALApplicationPutRequest var2);

    public abstract void deleteApplication(String ... var1);

    public abstract void deleteApplication(List<String> var1);

    public abstract void enableApplication(String ... var1);

    public abstract void enableApplication(List<String> var1);

    public abstract void disableApplication(String ... var1);

    public abstract void disableApplication(List<String> var1);

    public abstract boolean checkApplicationAvailability(String var1);

    public abstract List<ALOAuthConsumer> getOAuthConsumer(String var1);

    public abstract void putOAuthConsumer(ALOAuthConsumerPutRequest var1);

    public abstract String getContainerConfig(Property var1);

    public abstract void putContainerConfig(Property var1, String var2);

    public abstract ResultList<ALActivity> getActivityList(ALActivityGetRequest var1);

    public abstract ALActivity getActivity(ALActivityGetRequest var1);

    public abstract ALActivityCount getActivityCount(ALActivityGetRequest var1);

    public abstract void setAllReadActivity(String var1);

    public abstract void setReadActivity(int var1, String var2);

    public abstract void createActivity(ALActivityPutRequest var1);

    public abstract long getNextModuleId();

    public abstract void deleteUserData(String ... var1);

    public abstract void deleteUserData(List<String> var1);

    protected abstract void daysFirstActivate(String var1);

    protected String generateConsumerKey(String url) {
        return Database.getDomainName() + ":" + new String(Base64.encodeBase64((byte[])DigestUtils.sha((byte[])(System.nanoTime() + "::" + url).getBytes()))).replace("=", "");
    }

    protected String generateConsumerSecret() {
        return DigestUtils.shaHex((String)(UUID.randomUUID().toString() + System.nanoTime()));
    }

    public ALGadgetSpec getMetaData(String specUrl) {
        return this.getMetaData(specUrl, false);
    }

    public ALGadgetSpec getMetaData(String specUrl, boolean isDetail) {
        ArrayList<String> specUrls = new ArrayList<String>();
        specUrls.add(specUrl);
        Map<String, ALGadgetSpec> metaData = this.getMetaData(specUrls, "home", isDetail, true);
        return metaData.get(specUrl);
    }

    public Map<String, ALGadgetSpec> getMetaData(List<String> specUrls) {
        return this.getMetaData(specUrls, "home", false, true);
    }

    protected String getMetaDataUrl() {
        String baseUrl = ALContainerConfigService.get(Property.CONTAINER_URL);
        if (baseUrl == null || baseUrl.length() == 0) {
            HttpServletRequest request = HttpServletRequestLocator.get();
            Integer port = request.getServerPort();
            String scheme = request.getScheme();
            String continerPath = JetspeedResources.getString((String)"aipo.container.path");
            baseUrl = scheme + "://127.0.0.1:" + port + (continerPath == null ? "" : continerPath);
        }
        return baseUrl + "/gadgets/metadata";
    }

    public Map<String, ALGadgetSpec> getMetaData(List<String> specUrls, String view, boolean isDetail, boolean nocache) {
        HashMap<String, ALGadgetSpec> maps = new HashMap<String, ALGadgetSpec>();
        if (specUrls == null || specUrls.size() == 0) {
            return maps;
        }
        try {
            HttpClient httpClient = new HttpClient();
            httpClient.getParams().setParameter("http.connection.timeout", (Object)10000);
            httpClient.getParams().setParameter("http.socket.timeout", (Object)10000);
            PostMethod postMethod = new PostMethod(this.getMetaDataUrl());
            postMethod.addRequestHeader("Content-Type", "application/javascript");
            postMethod.addParameter("st", "default:st");
            postMethod.addParameter("req", "1");
            postMethod.addParameter("callback", "1");
            JSONObject jsonObject = new JSONObject();
            JSONObject context = new JSONObject();
            context.put((Object)"country", (Object)"JP");
            context.put((Object)"language", (Object)"ja");
            context.put((Object)"view", (Object)(view == null ? "home" : view));
            context.put((Object)"container", (Object)"default");
            context.put((Object)"nocache", (Object)(nocache ? 1 : 0));
            if (isDetail) {
                context.put((Object)"withDescription", (Object)"1");
                context.put((Object)"withOAuthService", (Object)"1");
            }
            JSONArray gadgets = new JSONArray();
            for (String specUrl : specUrls) {
                JSONObject gadget = new JSONObject();
                gadget.put((Object)"url", (Object)specUrl);
                gadget.put((Object)"moduleId", (Object)1);
                gadgets.add((Object)gadget);
            }
            jsonObject.put((Object)"context", (Object)context);
            jsonObject.put((Object)"gadgets", (Object)gadgets);
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(jsonObject.toString(), "application/javascript", "UTF-8"));
            httpClient.executeMethod((HttpMethod)postMethod);
            String result = postMethod.getResponseBodyAsString();
            JSONObject fromObject = JSONObject.fromObject((Object)result);
            JSONArray jsonArray = (JSONArray)fromObject.get("gadgets");
            HashMap<String, Class> classMap = new HashMap<String, Class>();
            classMap.put("oauthService", ALOAuthService.class);
            classMap.put("userPrefs", HashMap.class);
            if (jsonArray == null) {
                return maps;
            }
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                try {
                    JSONObject object = jsonArray.getJSONObject(i);
                    Object e = object.get("errors");
                    if (e != null) continue;
                    ALGadgetSpec spec = (ALGadgetSpec)JSONObject.toBean((JSONObject)object, ALGadgetSpec.class, classMap);
                    maps.put(spec.getUrl(), spec);
                    continue;
                }
                catch (Throwable t) {
                    logger.warn((Object)"[ALSocialApplicationHandler]", t);
                }
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"[ALSocialApplicationHandler]", t);
        }
        return maps;
    }

    public static enum Property {
        LOCKED_DOMAIN_REQUIRED("lockedDomainRequired"){

            @Override
            public String defaultValue() {
                return "false";
            }
        }
        ,
        LOCKED_DOMAIN_SUFFIX("lockedDomainSuffix"){

            @Override
            public String defaultValue() {
                return "";
            }
        }
        ,
        UNLOCKED_DOMAIN("unLockedDomain"){

            @Override
            public String defaultValue() {
                return "";
            }
        }
        ,
        CACHE_GADGET_XML("cacheGadgetXml"){

            @Override
            public String defaultValue() {
                return "true";
            }
        }
        ,
        ACTIVITY_SAVE_LIMIT("activitySaveLimit"){

            @Override
            public String defaultValue() {
                return "30";
            }
        }
        ,
        CONTAINER_URL("containerUrl"){

            @Override
            public String defaultValue() {
                return JetspeedResources.getString((String)"aipo.container.url");
            }
        };

        private final String property;

        private Property(String property) {
            this.property = property;
        }

        public String toString() {
            return this.property;
        }

        public abstract String defaultValue();
    }
}

