/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note;

import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.note.NoteClientResultData;
import com.aimluck.eip.note.util.NoteUtils;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteClientSelectData
extends ALAbstractSelectData<EipTNoteMap, EipTNoteMap>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteClientSelectData.class.getName());
    private String userId;
    private int newNoteAllSum = 0;
    private int unreadReceivedNotesAllSum = 0;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
            logger.debug((Object)("Init Parameter (Note) : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort")));
        }
        super.init(action, rundata, context);
    }

    protected ResultList<EipTNoteMap> selectList(RunData rundata, Context context) {
        try {
            this.userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            this.newNoteAllSum = NoteUtils.getNewReceivedNoteAllSum(rundata, this.userId);
            this.unreadReceivedNotesAllSum = NoteUtils.getUnreadReceivedNotesAllSum(rundata, this.userId);
            SelectQuery<EipTNoteMap> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery<EipTNoteMap> buildSelectQueryForListViewSort(SelectQuery<EipTNoteMap> query, RunData rundata, Context context) {
        String sort = "create_date";
        String sort_type = "desc";
        String crt_key = null;
        Attributes map = this.getColumnMap();
        crt_key = map.getValue(sort);
        if (crt_key == null) {
            return query;
        }
        query.orderDesending(crt_key);
        this.current_sort = sort;
        this.current_sort_type = sort_type;
        return query;
    }

    protected EipTNoteMap selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(EipTNoteMap map) {
        try {
            EipTNote record = map.getEipTNote();
            NoteClientResultData rd = new NoteClientResultData();
            rd.initField();
            rd.setNoteId(record.getNoteId().intValue());
            rd.setClientName(ALCommonUtils.compressString((String)record.getClientName(), (int)this.getStrLength()));
            rd.setCompanyName(ALCommonUtils.compressString((String)record.getCompanyName(), (int)this.getStrLength()));
            rd.setNoteStat(map.getNoteStat());
            rd.setAcceptDate(record.getAcceptDate());
            String subject = "";
            if (record.getSubjectType().equals("0")) {
                subject = ALCommonUtils.compressString((String)record.getCustomSubject(), (int)this.getStrLength());
            } else if (record.getSubjectType().equals("1")) {
                subject = ALLocalizationUtils.getl10n((String)"NOTE_CALL_AGAIN_NO_PERIOD");
            } else if (record.getSubjectType().equals("2")) {
                subject = ALLocalizationUtils.getl10n((String)"NOTE_MAIL_CALL_BACK");
            } else if (record.getSubjectType().equals("3")) {
                subject = ALLocalizationUtils.getl10n((String)"NOTE_MAIL_TELL_ME");
            } else if (record.getSubjectType().equals("4")) {
                subject = ALLocalizationUtils.getl10n((String)"NOTE_MAIL_TAKE_A_MESSAGE");
            }
            rd.setSubject(subject);
            if ("1".equals(map.getNoteStat())) {
                rd.setNoteStat("1");
                rd.setNoteStatImage("images/note/note_new_message.gif");
                rd.setNoteStatImageDescription(ALLocalizationUtils.getl10n((String)"NOTE_NEW_MESSAGE"));
            } else if ("2".equals(map.getNoteStat())) {
                rd.setNoteStat("2");
                rd.setNoteStatImage("images/note/note_unread_message.gif");
                rd.setNoteStatImageDescription(ALLocalizationUtils.getl10n((String)"NOTE_UNREAD_MESSAGE"));
            } else {
                rd.setNoteStat("3");
                rd.setNoteStatImage("images/note/note_read_message.gif");
                rd.setNoteStatImageDescription(ALLocalizationUtils.getl10n((String)"NOTE_READ_MESSAGE"));
            }
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(record.getOwnerId()));
            rd.setSrcUserId(record.getOwnerId());
            rd.setSrcUserFullName(user.getAliasName().getValue());
            return rd;
        }
        catch (RuntimeException e) {
            logger.error((Object)"note", (Throwable)e);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"note", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTNoteMap obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("client_name", "eipTNote.clientName");
        map.putValue("subject_type", "eipTNote.subjectType");
        map.putValue("create_date", "eipTNote.createDate");
        map.putValue("accept_date", "eipTNote.acceptDate");
        map.putValue("note_stat", "noteStat");
        return map;
    }

    private SelectQuery<EipTNoteMap> getSelectQuery(RunData rundata, Context context) {
        return NoteUtils.getSelectQueryNoteList(rundata, context);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName(String userId) {
        return NoteUtils.getUserName(userId);
    }

    public String getUserFullName(String userId) {
        try {
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(userId));
            return user.getAliasName().getValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getUserId(String userName) {
        return NoteUtils.getUserId(userName);
    }

    public int getNewNoteAllSum() {
        return this.newNoteAllSum;
    }

    public int getUnreadReceivedNotesAllSum() {
        return this.unreadReceivedNotesAllSum;
    }
}

