/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.ObjectContextQueryAction;

class DataContextQueryAction
extends ObjectContextQueryAction {
    public DataContextQueryAction(DataContext actingContext, ObjectContext targetContext, Query query) {
        super(actingContext, targetContext, query);
    }

    public QueryResponse execute() {
        if (!(this.interceptPaginatedQuery() || this.interceptOIDQuery() || this.interceptRelationshipQuery() || this.interceptLocalCache())) {
            this.runQuery();
        }
        this.interceptObjectConversion();
        return this.response;
    }

    protected boolean interceptOIDQuery() {
        Object object;
        ObjectIdQuery oidQuery;
        if (this.query instanceof ObjectIdQuery && !(oidQuery = (ObjectIdQuery)this.query).isFetchMandatory() && (object = this.actingContext.getGraphManager().getNode(oidQuery.getObjectId())) != null) {
            if (oidQuery.isFetchingDataRows()) {
                object = ((DataContext)this.actingContext).currentSnapshot((DataObject)object);
            }
            this.response = new ListResponse(object);
            return true;
        }
        return false;
    }

    private boolean interceptPaginatedQuery() {
        if (this.metadata.getPageSize() > 0) {
            this.response = new ListResponse(new IncrementalFaultList((DataContext)this.actingContext, this.query));
            return true;
        }
        return false;
    }

    private boolean interceptLocalCache() {
        List cachedResults;
        boolean cacheOrCacheRefresh;
        String cacheKey = this.metadata.getCacheKey();
        if (cacheKey == null) {
            return false;
        }
        boolean cache = "localcache".equals(this.metadata.getCachePolicy());
        boolean bl = cacheOrCacheRefresh = cache || "localcache_refresh".equals(this.metadata.getCachePolicy());
        if (!cacheOrCacheRefresh) {
            return false;
        }
        ObjectStore objectStore = ((DataContext)this.actingContext).getObjectStore();
        if (cache && (cachedResults = objectStore.getCachedQueryResult(cacheKey)) != null) {
            this.response = new ListResponse(cachedResults);
            return true;
        }
        this.runQuery();
        objectStore.cacheQueryResult(cacheKey, this.response.firstList());
        return true;
    }
}

