/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.NodeDiff;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.CollectionProperty;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyVisitor;
import org.apache.cayenne.property.SingleObjectArcProperty;
import org.apache.cayenne.util.Util;

class ObjectDiff
extends NodeDiff {
    private final ObjectStore objectStore;
    private final String entityName;
    private transient ClassDescriptor classDescriptor;
    private Collection otherDiffs;
    private Map snapshot;
    private Map arcSnapshot;
    private Map currentArcSnapshot;
    private Map flatIds;

    ObjectDiff(ObjectStore objectStore, final Persistent object) {
        super(object.getObjectId());
        EntityResolver entityResolver = objectStore.getContext().getEntityResolver();
        this.entityName = object.getObjectId().getEntityName();
        this.objectStore = objectStore;
        this.classDescriptor = entityResolver.getClassDescriptor(this.entityName);
        int state = object.getPersistenceState();
        if (state == 3 || state == 6 || state == 4) {
            ObjEntity entity = entityResolver.getObjEntity(this.entityName);
            final boolean lock = entity.getLockType() == 1;
            this.snapshot = new HashMap();
            this.arcSnapshot = new HashMap();
            this.classDescriptor.visitProperties(new PropertyVisitor(){

                public boolean visitProperty(Property property) {
                    ObjectDiff.this.snapshot.put(property.getName(), property.readProperty(object));
                    return true;
                }

                public boolean visitCollectionArc(CollectionProperty property) {
                    return true;
                }

                public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                    Object target;
                    Object object2 = target = lock ? property.readProperty(object) : property.readPropertyDirectly(object);
                    if (target instanceof Persistent) {
                        target = ((Persistent)target).getObjectId();
                    }
                    ObjectDiff.this.arcSnapshot.put(property.getName(), target);
                    return true;
                }
            });
        }
    }

    ClassDescriptor getClassDescriptor() {
        if (this.classDescriptor == null) {
            EntityResolver entityResolver = this.objectStore.getContext().getEntityResolver();
            this.classDescriptor = entityResolver.getClassDescriptor(this.entityName);
        }
        return this.classDescriptor;
    }

    Object getSnapshotValue(String propertyName) {
        return this.snapshot != null ? this.snapshot.get(propertyName) : null;
    }

    ObjectId getArcSnapshotValue(String propertyName) {
        ObjectId value;
        ObjectId objectId = value = this.arcSnapshot != null ? (ObjectId)this.arcSnapshot.get(propertyName) : null;
        if (value instanceof Fault) {
            Persistent source = (Persistent)this.objectStore.getNode(this.nodeId);
            Persistent target = (Persistent)((Fault)((Object)value)).resolveFault(source, propertyName);
            value = target != null ? target.getObjectId() : null;
            this.arcSnapshot.put(propertyName, value);
        }
        return value;
    }

    boolean containsArcSnapshot(String propertyName) {
        return this.arcSnapshot != null ? this.arcSnapshot.containsKey(propertyName) : false;
    }

    void appendDiffs(Collection collection) {
        if (this.otherDiffs != null) {
            collection.addAll(this.otherDiffs);
        }
        collection.add(new NodeDiff(this.nodeId, this.diffId){

            public void apply(GraphChangeHandler tracker) {
                ObjectDiff.this.applySimplePropertyChanges(tracker);
            }

            public void undo(GraphChangeHandler tracker) {
                throw new UnsupportedOperationException();
            }
        });
    }

    void addDiff(GraphDiff diff) {
        boolean addDiff = true;
        if (diff instanceof ArcOperation && this.snapshot != null) {
            ArcOperation arcDiff = (ArcOperation)diff;
            Object targetId = arcDiff.getTargetNodeId();
            String arcId = arcDiff.getArcId().toString();
            Property property = this.getClassDescriptor().getProperty(arcId);
            if (property instanceof CollectionProperty) {
                ObjEntity entity = this.objectStore.context.getEntityResolver().getObjEntity(this.entityName);
                ObjRelationship relationship = (ObjRelationship)entity.getRelationship(property.getName());
                if (relationship.isFlattened()) {
                    ArcOperation oldOp;
                    if (this.flatIds == null) {
                        this.flatIds = new HashMap();
                    }
                    if ((oldOp = this.flatIds.put(arcDiff, arcDiff)) != null && oldOp.isDelete() != arcDiff.isDelete()) {
                        addDiff = false;
                        this.flatIds.remove(arcDiff);
                        if (this.otherDiffs != null) {
                            this.otherDiffs.remove(oldOp);
                        }
                    }
                }
            } else if (property instanceof SingleObjectArcProperty) {
                if (this.currentArcSnapshot == null) {
                    this.currentArcSnapshot = new HashMap();
                }
                this.currentArcSnapshot.put(arcId, targetId);
            } else {
                String message = property == null ? "No property for arcId " + arcId : "Unrecognized property for arcId " + arcId + ": " + property;
                throw new CayenneRuntimeException(message);
            }
        }
        if (addDiff) {
            if (this.otherDiffs == null) {
                this.otherDiffs = new ArrayList(3);
            }
            this.otherDiffs.add(diff);
        }
    }

    public boolean isNoop() {
        if (this.snapshot == null) {
            return false;
        }
        if (this.flatIds != null && !this.flatIds.isEmpty()) {
            return false;
        }
        final boolean[] modFound = new boolean[1];
        final Persistent object = (Persistent)this.objectStore.getNode(this.nodeId);
        int state = object.getPersistenceState();
        if (state == 2 || state == 6) {
            return false;
        }
        this.getClassDescriptor().visitProperties(new PropertyVisitor(){

            public boolean visitProperty(Property property) {
                Object newValue;
                Object oldValue = ObjectDiff.this.snapshot.get(property.getName());
                if (!Util.nullSafeEquals(oldValue, newValue = property.readProperty(object))) {
                    modFound[0] = true;
                }
                return !modFound[0];
            }

            public boolean visitCollectionArc(CollectionProperty property) {
                return true;
            }

            public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                if (ObjectDiff.this.arcSnapshot == null) {
                    return true;
                }
                Object newValue = property.readPropertyDirectly(object);
                if (newValue instanceof Fault) {
                    return true;
                }
                Object oldValue = ObjectDiff.this.arcSnapshot.get(property.getName());
                if (!Util.nullSafeEquals(oldValue, newValue != null ? ((Persistent)newValue).getObjectId() : null)) {
                    modFound[0] = true;
                }
                return !modFound[0];
            }
        });
        return !modFound[0];
    }

    public void undo(GraphChangeHandler handler) {
        throw new UnsupportedOperationException();
    }

    public void apply(GraphChangeHandler handler) {
        if (this.otherDiffs != null) {
            Iterator it = this.otherDiffs.iterator();
            while (it.hasNext()) {
                ((GraphDiff)it.next()).apply(handler);
            }
        }
        this.applySimplePropertyChanges(handler);
    }

    private void applySimplePropertyChanges(final GraphChangeHandler handler) {
        final Persistent object = (Persistent)this.objectStore.getNodeNoSync(this.nodeId);
        this.getClassDescriptor().visitProperties(new PropertyVisitor(){

            public boolean visitProperty(Property property) {
                Object newValue = property.readProperty(object);
                if (ObjectDiff.this.snapshot == null) {
                    if (newValue != null) {
                        handler.nodePropertyChanged(ObjectDiff.this.nodeId, property.getName(), null, newValue);
                    }
                } else {
                    Object oldValue = ObjectDiff.this.snapshot.get(property.getName());
                    if (!Util.nullSafeEquals(oldValue, newValue)) {
                        handler.nodePropertyChanged(ObjectDiff.this.nodeId, property.getName(), oldValue, newValue);
                    }
                }
                return true;
            }

            public boolean visitCollectionArc(CollectionProperty property) {
                return true;
            }

            public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                return true;
            }
        });
    }

    void updateArcSnapshot(String propertyName, Persistent object) {
        if (this.arcSnapshot == null) {
            this.arcSnapshot = new HashMap();
        }
        this.arcSnapshot.put(propertyName, object != null ? object.getObjectId() : null);
    }

    static final class ArcOperation
    extends NodeDiff {
        private Object targetNodeId;
        private Object arcId;
        private boolean delete;

        public ArcOperation(Object nodeId, Object targetNodeId, Object arcId, boolean delete) {
            super(nodeId);
            this.targetNodeId = targetNodeId;
            this.arcId = arcId;
            this.delete = delete;
        }

        boolean isDelete() {
            return this.delete;
        }

        public int hashCode() {
            return this.arcId.hashCode() + this.targetNodeId.hashCode() + 5;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ArcOperation)) {
                return false;
            }
            ArcOperation other = (ArcOperation)object;
            return this.arcId.equals(other.arcId) && Util.nullSafeEquals(this.targetNodeId, other.targetNodeId);
        }

        public void apply(GraphChangeHandler tracker) {
            if (this.delete) {
                tracker.arcDeleted(this.nodeId, this.targetNodeId, this.arcId);
            } else {
                tracker.arcCreated(this.nodeId, this.targetNodeId, this.arcId);
            }
        }

        public void undo(GraphChangeHandler tracker) {
            throw new UnsupportedOperationException();
        }

        public Object getArcId() {
            return this.arcId;
        }

        public Object getTargetNodeId() {
            return this.targetNodeId;
        }
    }
}

