/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.access.jdbc.ParameterBinding;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.util.IDUtil;
import org.apache.cayenne.util.Util;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class QueryLogger {
    private static final Logger logObj = Logger.getLogger(QueryLogger.class);
    public static final Level DEFAULT_LOG_LEVEL = Level.INFO;
    public static final int TRIM_VALUES_THRESHOLD = 300;
    static ThreadLocal logLevel = new ThreadLocal();

    public static void sqlLiteralForObject(StringBuffer buf, Object anObject) {
        if (anObject == null) {
            buf.append("NULL");
        } else if (anObject instanceof String) {
            buf.append('\'');
            String literal = (String)anObject;
            if (literal.length() > 300) {
                literal = literal.substring(0, 300) + "...";
            }
            int curPos = 0;
            int endPos = 0;
            while ((endPos = literal.indexOf(39, curPos)) >= 0) {
                buf.append(literal.substring(curPos, endPos + 1)).append('\'');
                curPos = endPos + 1;
            }
            if (curPos < literal.length()) {
                buf.append(literal.substring(curPos));
            }
            buf.append('\'');
        } else if (anObject instanceof Number) {
            buf.append(anObject);
        } else if (anObject instanceof java.sql.Date) {
            buf.append('\'').append(anObject).append('\'');
        } else if (anObject instanceof Time) {
            buf.append('\'').append(anObject).append('\'');
        } else if (anObject instanceof Date) {
            long time = ((Date)anObject).getTime();
            buf.append('\'').append(new Timestamp(time)).append('\'');
        } else if (anObject instanceof byte[]) {
            buf.append("< ");
            byte[] b = (byte[])anObject;
            int len = b.length;
            boolean trimming = false;
            if (len > 300) {
                len = 300;
                trimming = true;
            }
            for (int i = 0; i < len; ++i) {
                IDUtil.appendFormattedByte(buf, b[i]);
                buf.append(' ');
            }
            if (trimming) {
                buf.append("...");
            }
            buf.append('>');
        } else if (anObject instanceof Boolean) {
            buf.append('\'').append(anObject).append('\'');
        } else if (anObject instanceof ParameterBinding) {
            QueryLogger.sqlLiteralForObject(buf, ((ParameterBinding)anObject).getValue());
        } else {
            buf.append("[").append(anObject.getClass().getName()).append(": ").append(anObject).append("]");
        }
    }

    protected static void appendFormattedByte(StringBuffer buffer, byte byteValue) {
        IDUtil.appendFormattedByte(buffer, byteValue);
    }

    public static Level getLoggingLevel() {
        Level level = (Level)logLevel.get();
        return level != null ? level : Level.INFO;
    }

    public static void setLoggingLevel(Level level) {
        logLevel.set(level);
    }

    public static void log(String message) {
        if (message != null) {
            logObj.log(QueryLogger.getLoggingLevel(), message);
        }
    }

    public static void logConnect(String dataSource) {
        if (QueryLogger.isLoggable()) {
            logObj.log(QueryLogger.getLoggingLevel(), "Connecting. JNDI path: " + dataSource);
        }
    }

    public static void logConnect(String url, String userName, String password) {
        if (QueryLogger.isLoggable()) {
            StringBuffer buf = new StringBuffer("Opening connection: ");
            buf.append(url);
            buf.append("\n\tLogin: ").append(userName);
            buf.append("\n\tPassword: *******");
            logObj.log(QueryLogger.getLoggingLevel(), buf.toString());
        }
    }

    public static void logPoolCreated(DataSourceInfo dsi) {
        if (QueryLogger.isLoggable()) {
            StringBuffer buf = new StringBuffer("Created connection pool: ");
            if (dsi != null) {
                buf.append(dsi.getDataSourceUrl());
                if (dsi.getAdapterClassName() != null) {
                    buf.append("\n\tCayenne DbAdapter: ").append(dsi.getAdapterClassName());
                }
                buf.append("\n\tDriver class: ").append(dsi.getJdbcDriver());
                if (dsi.getMinConnections() >= 0) {
                    buf.append("\n\tMin. connections in the pool: ").append(dsi.getMinConnections());
                }
                if (dsi.getMaxConnections() >= 0) {
                    buf.append("\n\tMax. connections in the pool: ").append(dsi.getMaxConnections());
                }
            } else {
                buf.append(" pool information unavailable");
            }
            logObj.log(QueryLogger.getLoggingLevel(), buf.toString());
        }
    }

    public static void logConnectSuccess() {
        logObj.log(QueryLogger.getLoggingLevel(), "+++ Connecting: SUCCESS.");
    }

    public static void logConnectFailure(Throwable th) {
        logObj.log(QueryLogger.getLoggingLevel(), "*** Connecting: FAILURE.", th);
    }

    public static void logQuery(String queryStr, List params) {
        QueryLogger.logQuery(queryStr, params, -1L);
    }

    public static void logQuery(String queryStr, List params, long time) {
        if (QueryLogger.isLoggable()) {
            StringBuffer buf = new StringBuffer(queryStr);
            if (params != null && params.size() > 0) {
                buf.append(" [bind: ");
                QueryLogger.sqlLiteralForObject(buf, params.get(0));
                int len = params.size();
                for (int i = 1; i < len; ++i) {
                    buf.append(", ");
                    QueryLogger.sqlLiteralForObject(buf, params.get(i));
                }
                buf.append(']');
            }
            if (time > 5L) {
                buf.append(" - prepared in ").append(time).append(" ms.");
            }
            logObj.log(QueryLogger.getLoggingLevel(), buf.toString());
        }
    }

    public static void logQueryParameters(String label, List parameters) {
        if (QueryLogger.isLoggable() && parameters.size() > 0) {
            int len = parameters.size();
            StringBuffer buf = new StringBuffer("[");
            buf.append(label).append(": ");
            QueryLogger.sqlLiteralForObject(buf, parameters.get(0));
            for (int i = 1; i < len; ++i) {
                buf.append(", ");
                QueryLogger.sqlLiteralForObject(buf, parameters.get(i));
            }
            buf.append(']');
            logObj.log(QueryLogger.getLoggingLevel(), buf.toString());
        }
    }

    public static void logSelectCount(int count) {
        QueryLogger.logSelectCount(count, -1L);
    }

    public static void logSelectCount(int count, long time) {
        if (QueryLogger.isLoggable()) {
            StringBuffer buf = new StringBuffer();
            if (count == 1) {
                buf.append("=== returned 1 row.");
            } else {
                buf.append("=== returned ").append(count).append(" rows.");
            }
            if (time >= 0L) {
                buf.append(" - took ").append(time).append(" ms.");
            }
            logObj.log(QueryLogger.getLoggingLevel(), buf.toString());
        }
    }

    public static void logUpdateCount(int count) {
        if (QueryLogger.isLoggable()) {
            if (count < 0) {
                logObj.log(QueryLogger.getLoggingLevel(), "=== updated ? rows");
            } else {
                String countStr = count == 1 ? "=== updated 1 row." : "=== updated " + count + " rows.";
                logObj.log(QueryLogger.getLoggingLevel(), countStr);
            }
        }
    }

    public static void logBeginTransaction(String transactionLabel) {
        logObj.log(QueryLogger.getLoggingLevel(), "--- " + transactionLabel);
    }

    public static void logCommitTransaction(String transactionLabel) {
        logObj.log(QueryLogger.getLoggingLevel(), "+++ " + transactionLabel);
    }

    public static void logRollbackTransaction(String transactionLabel) {
        logObj.log(QueryLogger.getLoggingLevel(), "*** " + transactionLabel);
    }

    public static void logQueryError(Throwable th) {
        if (QueryLogger.isLoggable()) {
            if (th != null) {
                th = Util.unwindException(th);
            }
            logObj.log(QueryLogger.getLoggingLevel(), "*** error.", th);
            if (th instanceof SQLException) {
                for (SQLException sqlException = ((SQLException)th).getNextException(); sqlException != null; sqlException = sqlException.getNextException()) {
                    logObj.log(QueryLogger.getLoggingLevel(), "*** nested SQL error.", sqlException);
                }
            }
        }
    }

    public static void logQueryStart(int count) {
        if (QueryLogger.isLoggable()) {
            String countStr = count == 1 ? "--- will run 1 query." : "--- will run " + count + " queries.";
            logObj.log(QueryLogger.getLoggingLevel(), countStr);
        }
    }

    public static boolean isLoggable() {
        return logObj.isEnabledFor(QueryLogger.getLoggingLevel());
    }

    public static void logConnect(Level logLevel, String dataSource) {
        QueryLogger.logConnect(dataSource);
    }

    public static void logConnect(Level logLevel, String url, String userName, String password) {
        QueryLogger.logConnect(url, userName, password);
    }

    public static void logPoolCreated(Level logLevel, DataSourceInfo dsi) {
        QueryLogger.logPoolCreated(dsi);
    }

    public static void logConnectSuccess(Level logLevel) {
        QueryLogger.logConnectSuccess();
    }

    public static void logConnectFailure(Level logLevel, Throwable th) {
        QueryLogger.logConnectFailure(th);
    }

    public static void logQuery(Level logLevel, String queryStr, List params) {
        QueryLogger.logQuery(queryStr, params);
    }

    public static void logQuery(Level logLevel, String queryStr, List params, long time) {
        QueryLogger.logQuery(queryStr, params, time);
    }

    public static void logQueryParameters(Level logLevel, String label, List parameters) {
        QueryLogger.logQueryParameters(label, parameters);
    }

    public static void logSelectCount(Level logLevel, int count) {
        QueryLogger.logSelectCount(count);
    }

    public static void logSelectCount(Level logLevel, int count, long time) {
        QueryLogger.logSelectCount(count, time);
    }

    public static void logUpdateCount(Level logLevel, int count) {
        QueryLogger.logUpdateCount(count);
    }

    public static void logBeginTransaction(Level logLevel, String transactionLabel) {
        QueryLogger.logBeginTransaction(transactionLabel);
    }

    public static void logCommitTransaction(Level logLevel, String transactionLabel) {
        QueryLogger.logCommitTransaction(transactionLabel);
    }

    public static void logRollbackTransaction(Level logLevel, String transactionLabel) {
        QueryLogger.logRollbackTransaction(transactionLabel);
    }

    public static void logQueryError(Level logLevel, Throwable th) {
        QueryLogger.logQueryError(th);
    }

    public static void logQueryStart(Level logLevel, int count) {
        QueryLogger.logQueryStart(count);
    }

    public static boolean isLoggable(Level logLevel) {
        return QueryLogger.isLoggable();
    }
}

