/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.query.InsertQuery;

public class InsertTranslator
extends QueryAssembler {
    protected List columnList = new ArrayList();

    public String aliasForTable(DbEntity dbEnt) {
        throw new RuntimeException("aliases not supported");
    }

    public void dbRelationshipAdded(DbRelationship dbRel) {
        throw new RuntimeException("db relationships not supported");
    }

    public String createSqlString() throws Exception {
        int i;
        this.prepareLists();
        StringBuffer queryBuf = new StringBuffer("INSERT INTO ");
        DbEntity dbE = this.getRootDbEntity();
        queryBuf.append(dbE.getFullyQualifiedName()).append(" (");
        int len = this.columnList.size();
        queryBuf.append(this.columnList.get(0));
        for (i = 1; i < len; ++i) {
            queryBuf.append(", ").append(this.columnList.get(i));
        }
        queryBuf.append(") VALUES (");
        if (len > 0) {
            queryBuf.append('?');
            for (i = 1; i < len; ++i) {
                queryBuf.append(", ?");
            }
        }
        queryBuf.append(')');
        return queryBuf.toString();
    }

    public InsertQuery insertQuery() {
        return (InsertQuery)this.query;
    }

    protected void prepareLists() throws Exception {
        Map id;
        DbEntity dbE = this.getRootDbEntity();
        ObjectId oid = this.insertQuery().getObjectId();
        Map map = id = oid != null ? oid.getIdSnapshot() : null;
        if (id != null) {
            Iterator idIt = id.entrySet().iterator();
            while (idIt.hasNext()) {
                Map.Entry entry = idIt.next();
                String attrName = (String)entry.getKey();
                DbAttribute attr = (DbAttribute)dbE.getAttribute(attrName);
                Object attrValue = entry.getValue();
                this.columnList.add(attrName);
                this.addToParamList(attr, attrValue);
            }
        }
        Map snapshot = this.insertQuery().getObjectSnapshot();
        Iterator columnsIt = snapshot.entrySet().iterator();
        while (columnsIt.hasNext()) {
            Map.Entry entry = columnsIt.next();
            String attrName = (String)entry.getKey();
            if (id != null && id.get(attrName) != null) continue;
            DbAttribute attr = (DbAttribute)dbE.getAttribute(attrName);
            Object attrValue = entry.getValue();
            this.columnList.add(attrName);
            this.addToParamList(attr, attrValue);
        }
    }
}

