/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import javax.sql.DataSource;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DBCPDataSourceBuilder;
import org.apache.cayenne.conf.DBCPDataSourceProperties;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DBCPDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = Logger.getLogger(DBCPDataSourceFactory.class);
    public static final String PROPERTY_PREFIX = "cayenne.dbcp.";
    public static final String PS_PROPERTY_PREFIX = "cayenne.dbcp.ps.";
    protected Configuration parentConfiguration;

    public void initializeWithParentConfiguration(Configuration parentConfiguration) {
        this.parentConfiguration = parentConfiguration;
    }

    public DataSource getDataSource(String location, Level logLevel) throws Exception {
        return this.getDataSource(location);
    }

    public DataSource getDataSource(String location) throws Exception {
        DBCPDataSourceProperties properties = new DBCPDataSourceProperties(this.parentConfiguration.getResourceLocator(), location);
        if (logger.isDebugEnabled()) {
            logger.debug("DBCP Properties: " + properties.getProperties());
        }
        DBCPDataSourceBuilder builder = new DBCPDataSourceBuilder(properties);
        return builder.createDataSource();
    }
}

