/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dataview;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.text.Format;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.dataview.CalcTypeEnum;
import org.apache.cayenne.dataview.DataTypeSpec;
import org.apache.cayenne.dataview.EventDispatcher;
import org.apache.cayenne.dataview.FieldValueChangeEvent;
import org.apache.cayenne.dataview.FieldValueChangeListener;
import org.apache.cayenne.dataview.FormatFactory;
import org.apache.cayenne.dataview.LookupCache;
import org.apache.cayenne.dataview.ObjEntityView;
import org.apache.cayenne.dataview.ObjEntityViewField;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DataView {
    private Locale locale = Locale.US;
    private DataTypeSpec dataTypeSpec = new DataTypeSpec();
    private FormatFactory formatFactory = new FormatFactory();
    private EntityResolver entityResolver;
    private Map objEntityViews = new TreeMap();
    private Set lookupEntityViewFields;
    private LookupCache lookupCache = new LookupCache();
    private EventDispatcher fieldValueChangeDispatcher;
    private Map lookupReferenceTable;

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        Validate.notNull(entityResolver);
        this.entityResolver = entityResolver;
    }

    public void load(File[] xmlSources) throws IOException {
        Validate.noNullElements(xmlSources);
        SAXBuilder builder = new SAXBuilder();
        Document[] documents = new Document[xmlSources.length];
        for (int i = 0; i < xmlSources.length; ++i) {
            try {
                documents[i] = builder.build(xmlSources[i]);
                continue;
            }
            catch (JDOMException ex) {
                ex.printStackTrace();
            }
        }
        this.load(documents);
    }

    public void load(URL[] xmlSources) throws IOException {
        Validate.noNullElements(xmlSources);
        SAXBuilder builder = new SAXBuilder();
        Document[] documents = new Document[xmlSources.length];
        for (int i = 0; i < xmlSources.length; ++i) {
            try {
                documents[i] = builder.build(xmlSources[i]);
                continue;
            }
            catch (JDOMException ex) {
                ex.printStackTrace();
            }
        }
        this.load(documents);
    }

    public void load(Reader[] xmlSources) throws IOException {
        Validate.noNullElements(xmlSources);
        SAXBuilder builder = new SAXBuilder();
        Document[] documents = new Document[xmlSources.length];
        for (int i = 0; i < xmlSources.length; ++i) {
            try {
                documents[i] = builder.build(xmlSources[i]);
                continue;
            }
            catch (JDOMException ex) {
                ex.printStackTrace();
            }
        }
        this.load(documents);
    }

    public void load(InputStream[] xmlSources) throws IOException {
        Validate.noNullElements(xmlSources);
        SAXBuilder builder = new SAXBuilder();
        Document[] documents = new Document[xmlSources.length];
        for (int i = 0; i < xmlSources.length; ++i) {
            try {
                documents[i] = builder.build(xmlSources[i]);
                continue;
            }
            catch (JDOMException ex) {
                ex.printStackTrace();
            }
        }
        this.load(documents);
    }

    public void load(Document[] views) {
        Validate.noNullElements(views);
        this.lookupReferenceTable = new HashMap();
        for (int i = 0; i < views.length; ++i) {
            Element root = views[i].getRootElement();
            List entityViews = root.getChildren("obj-entity-view");
            Iterator j = entityViews.iterator();
            while (j.hasNext()) {
                Element entityViewElement = (Element)j.next();
                this.loadEntityView(entityViewElement);
            }
        }
        this.resolveLookupReferences();
        this.lookupReferenceTable = null;
    }

    private void resolveLookupReferences() {
        this.lookupEntityViewFields = new HashSet();
        Iterator i = this.lookupReferenceTable.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ObjEntityViewField field = (ObjEntityViewField)entry.getKey();
            String[] lookupDescriptor = (String[])entry.getValue();
            ObjEntityView lookupEntityView = this.getObjEntityView(lookupDescriptor[0]);
            ObjEntityViewField lookupField = lookupEntityView.getField(lookupDescriptor[1]);
            field.setLookupField(lookupField);
            this.lookupEntityViewFields.add(lookupField);
        }
    }

    private void loadEntityView(Element element) {
        String name = element.getAttributeValue("name");
        Validate.isTrue(name != null && !this.objEntityViews.containsKey(name));
        String objEntityName = element.getAttributeValue("obj-entity-name");
        Validate.notNull(objEntityName);
        ObjEntity objEntity = this.entityResolver.getObjEntity(objEntityName);
        ObjEntityView entityView = new ObjEntityView();
        entityView.setName(name);
        entityView.setObjEntity(objEntity);
        this.objEntityViews.put(name, entityView);
        entityView.setOwner(this);
        List fields = element.getChildren("field");
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            Element fieldElement = (Element)i.next();
            this.loadField(entityView, fieldElement);
        }
    }

    private void loadField(ObjEntityView entityView, Element element) {
        Element defaultValueElement;
        Element displayFormatElement;
        Element editFormatElement;
        String name = element.getAttributeValue("name");
        ObjEntityViewField field = new ObjEntityViewField();
        field.setName(name);
        String prefIndex = element.getAttributeValue("pref-index");
        field.setPreferredIndex(NumberUtils.toInt(prefIndex, -1));
        entityView.insertField(field);
        String calcType = element.getAttributeValue("calc-type");
        Validate.notNull(calcType);
        CalcTypeEnum fieldCalcType = CalcTypeEnum.getEnum(calcType);
        Validate.isTrue(CalcTypeEnum.NO_CALC_TYPE.equals(fieldCalcType) || CalcTypeEnum.LOOKUP_TYPE.equals(fieldCalcType), "Calc Type not supported yet: ", fieldCalcType);
        field.setCalcType(fieldCalcType);
        ObjEntity objEntity = entityView.getObjEntity();
        if (CalcTypeEnum.NO_CALC_TYPE.equals(fieldCalcType)) {
            String objAttributeName = element.getAttributeValue("obj-attribute-name");
            Validate.notNull(objAttributeName);
            ObjAttribute objAttribute = (ObjAttribute)objEntity.getAttribute(objAttributeName);
            field.setObjAttribute(objAttribute);
        } else if (CalcTypeEnum.LOOKUP_TYPE.equals(fieldCalcType)) {
            String objRelationshipName = element.getAttributeValue("obj-relationship-name");
            Validate.notNull(objRelationshipName);
            ObjRelationship objRelationship = (ObjRelationship)objEntity.getRelationship(objRelationshipName);
            field.setObjRelationship(objRelationship);
            Element lookupElement = element.getChild("lookup");
            Validate.notNull(lookupElement);
            String lookupEntityView = lookupElement.getAttributeValue("obj-entity-view-name");
            Validate.notNull(lookupEntityView);
            String lookupEntityField = lookupElement.getAttributeValue("field-name");
            Validate.notNull(lookupEntityField);
            String[] lookupDescriptor = new String[]{lookupEntityView, lookupEntityField};
            this.lookupReferenceTable.put(field, lookupDescriptor);
        }
        String dataType = element.getAttributeValue("data-type");
        Validate.notNull(dataType);
        field.setDataType(this.dataTypeSpec.getDataType(dataType));
        String editable = element.getAttributeValue("editable");
        field.setEditable(BooleanUtils.toBoolean(editable));
        String visible = element.getAttributeValue("visible");
        field.setVisible(BooleanUtils.toBoolean(visible));
        Element captionElement = element.getChild("caption");
        if (captionElement != null) {
            field.setCaption(StringUtils.stripToEmpty(captionElement.getText()));
        }
        if ((editFormatElement = element.getChild("edit-format")) != null) {
            String formatClassName = editFormatElement.getAttributeValue("class");
            Validate.notNull(formatClassName);
            try {
                Class<?> formatClass = Class.forName(formatClassName);
                Map parameters = DataView.childrenToMap(editFormatElement);
                Format format = this.formatFactory.createFormat(formatClass, this.locale, parameters);
                field.setEditFormat(format);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if ((displayFormatElement = element.getChild("display-format")) != null) {
            String formatClassName = displayFormatElement.getAttributeValue("class");
            Validate.notNull(formatClassName);
            try {
                Class<?> formatClass = Class.forName(formatClassName);
                Map parameters = DataView.childrenToMap(displayFormatElement);
                Format format = this.formatFactory.createFormat(formatClass, this.locale, parameters);
                field.setDisplayFormat(format);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if ((defaultValueElement = element.getChild("default-value")) != null) {
            String defaultValueStr = StringUtils.stripToEmpty(defaultValueElement.getText());
            Object defaultValue = this.dataTypeSpec.create(field.getDataType(), defaultValueStr);
            field.setDefaultValue(defaultValue);
        }
    }

    public Set getObjEntityViewNames() {
        return Collections.unmodifiableSet(this.objEntityViews.keySet());
    }

    public Collection getObjEntityViews() {
        return Collections.unmodifiableCollection(this.objEntityViews.values());
    }

    public ObjEntityView getObjEntityView(String viewName) {
        return (ObjEntityView)this.objEntityViews.get(viewName);
    }

    public LookupCache getLookupCache() {
        return this.lookupCache;
    }

    public void setLookupCache(LookupCache lookupCache) {
        Validate.notNull(lookupCache);
        this.lookupCache = lookupCache;
    }

    public Set getLookupObjEntityViewFields() {
        return Collections.unmodifiableSet(this.lookupEntityViewFields);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public DataTypeSpec getDataTypeSpec() {
        return this.dataTypeSpec;
    }

    public void setDataTypeSpec(DataTypeSpec dataTypeSpec) {
        this.dataTypeSpec = dataTypeSpec;
    }

    public FormatFactory getFormatFactory() {
        return this.formatFactory;
    }

    public void setFormatFactory(FormatFactory formatFactory) {
        this.formatFactory = formatFactory;
    }

    private static Map childrenToMap(Element element) {
        List children = element.getChildren();
        if (children.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>(children.size());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            map.put(child.getName(), StringUtils.stripToNull(child.getText()));
        }
        return map;
    }

    public void addFieldValueChangeListener(FieldValueChangeListener listener) {
        this.fieldValueChangeDispatcher = EventDispatcher.add(this.fieldValueChangeDispatcher, listener);
    }

    public void removeFieldValueChangeListener(FieldValueChangeListener listener) {
        this.fieldValueChangeDispatcher = EventDispatcher.remove(this.fieldValueChangeDispatcher, listener);
    }

    public void clearFieldValueChangeListeners() {
        if (this.fieldValueChangeDispatcher != null) {
            this.fieldValueChangeDispatcher.clear();
            this.fieldValueChangeDispatcher = null;
        }
    }

    public void fireFieldValueChangeEvent(ObjEntityViewField source, DataObject modifiedObject, Object oldValue, Object newValue) {
        if (this.fieldValueChangeDispatcher != null && source.getRootOwner() == this) {
            this.fieldValueChangeDispatcher.dispatch(new FieldValueChangeEvent(source, modifiedObject, oldValue, newValue));
        }
    }
}

