/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;

public class PostgresQualifierTranslator
extends TrimmingQualifierTranslator {
    public PostgresQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler, "RTRIM");
    }

    public void startNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2) {
            this.detectObjectMatch(node);
            if (this.parenthesisNeeded(node, parentNode)) {
                this.qualBuf.append('(');
            }
        } else {
            super.startNode(node, parentNode);
        }
    }

    public void endNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2) {
            if (this.matchingObject) {
                this.appendObjectMatch();
            }
            if (this.parenthesisNeeded(node, parentNode)) {
                this.qualBuf.append(')');
            }
        } else {
            super.endNode(node, parentNode);
        }
    }

    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (!hasMoreChildren) {
            return;
        }
        switch (node.getType()) {
            case 12: {
                this.finishedChildNodeAppendExpression(node, " ILIKE ");
                break;
            }
            case 38: {
                this.finishedChildNodeAppendExpression(node, " NOT ILIKE ");
                break;
            }
            default: {
                super.finishedChild(node, childIndex, hasMoreChildren);
            }
        }
    }

    private void finishedChildNodeAppendExpression(Expression node, String operation) {
        StringBuffer buf = this.matchingObject ? new StringBuffer() : this.qualBuf;
        buf.append(operation);
        if (this.matchingObject) {
            this.objectMatchTranslator.setOperation(buf.toString());
            this.objectMatchTranslator.setExpression(node);
        }
    }
}

