/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.ObjEntity;

public class EntityInheritanceTree {
    protected ObjEntity entity;
    protected Collection subentities;
    protected Expression normalizedQualifier;

    public EntityInheritanceTree(ObjEntity entity) {
        this.entity = entity;
    }

    public Expression qualifierForEntityAndSubclasses() {
        Expression qualifier = this.entity.getDeclaredQualifier();
        if (qualifier == null) {
            return null;
        }
        if (this.subentities != null) {
            Iterator it = this.subentities.iterator();
            while (it.hasNext()) {
                EntityInheritanceTree child = (EntityInheritanceTree)it.next();
                Expression childQualifier = child.qualifierForEntityAndSubclasses();
                if (childQualifier == null) {
                    return null;
                }
                qualifier = qualifier.orExp(childQualifier);
            }
        }
        return qualifier;
    }

    public ObjEntity entityMatchingRow(DataRow row) {
        Expression qualifier;
        if (this.subentities != null) {
            Iterator it = this.subentities.iterator();
            while (it.hasNext()) {
                EntityInheritanceTree child = (EntityInheritanceTree)it.next();
                ObjEntity matched = child.entityMatchingRow(row);
                if (matched == null) continue;
                return matched;
            }
        }
        if ((qualifier = this.entity.getDeclaredQualifier()) != null) {
            if (this.normalizedQualifier == null) {
                this.normalizedQualifier = this.entity.translateToDbPath(qualifier);
            }
            return this.normalizedQualifier.match(row) ? this.entity : null;
        }
        return this.entity;
    }

    public void addChildNode(EntityInheritanceTree node) {
        if (this.subentities == null) {
            this.subentities = new ArrayList(2);
        }
        this.subentities.add(node);
    }

    public int getChildrenCount() {
        return this.subentities != null ? this.subentities.size() : 0;
    }

    public Collection getChildren() {
        return this.subentities != null ? this.subentities : Collections.EMPTY_LIST;
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    public Collection allAttributes() {
        if (this.subentities == null) {
            return this.entity.getAttributes();
        }
        ArrayList c = new ArrayList();
        this.appendDeclaredAttributes(c);
        ObjEntity superEntity = this.entity.getSuperEntity();
        if (superEntity != null) {
            c.addAll(superEntity.getAttributes());
        }
        return c;
    }

    public Collection allRelationships() {
        if (this.subentities == null) {
            return this.entity.getRelationships();
        }
        ArrayList c = new ArrayList();
        this.appendDeclaredRelationships(c);
        ObjEntity superEntity = this.entity.getSuperEntity();
        if (superEntity != null) {
            c.addAll(superEntity.getRelationships());
        }
        return c;
    }

    protected void appendDeclaredAttributes(Collection c) {
        c.addAll(this.entity.getDeclaredAttributes());
        if (this.subentities != null) {
            Iterator it = this.subentities.iterator();
            while (it.hasNext()) {
                EntityInheritanceTree child = (EntityInheritanceTree)it.next();
                child.appendDeclaredAttributes(c);
            }
        }
    }

    protected void appendDeclaredRelationships(Collection c) {
        c.addAll(this.entity.getDeclaredRelationships());
        if (this.subentities != null) {
            Iterator it = this.subentities.iterator();
            while (it.hasNext()) {
                EntityInheritanceTree child = (EntityInheritanceTree)it.next();
                child.appendDeclaredRelationships(c);
            }
        }
    }
}

