/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.project.ProjectDataSource;
import org.apache.log4j.Logger;

public class ProjectDataSourceFactory
extends DriverDataSourceFactory {
    private static Logger logObj = Logger.getLogger(ProjectDataSourceFactory.class);
    protected File projectDir;

    public ProjectDataSourceFactory(File projectDir) throws Exception {
        this.projectDir = projectDir;
    }

    public DataSource getDataSource(String location) throws Exception {
        try {
            this.load(location);
        }
        catch (ConfigurationException e) {
            logObj.info("No data source at '" + location + "', ignoring.");
        }
        return new ProjectDataSource(this.getDriverInfo());
    }

    protected DataSourceInfo getDriverInfo() {
        DataSourceInfo temp = super.getDriverInfo();
        if (null == temp) {
            temp = new DataSourceInfo();
        }
        return temp;
    }
}

