/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.xml;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.property.PropertyUtils;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.xml.XMLMappingDescriptor;
import org.apache.cayenne.xml.XMLSerializable;
import org.apache.cayenne.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XMLDecoder {
    static final Map classMapping = new HashMap();
    private Element root;
    private DataContext dataContext;
    private List decodedCollections = new ArrayList();

    public XMLDecoder() {
        this(null);
    }

    public XMLDecoder(DataContext dc) {
        this.dataContext = dc;
    }

    public Boolean decodeBoolean(String xmlTag) {
        String val = this.decodeString(xmlTag);
        if (null == val) {
            return null;
        }
        return Boolean.valueOf(val);
    }

    public Double decodeDouble(String xmlTag) {
        String val = this.decodeString(xmlTag);
        if (null == val) {
            return null;
        }
        return Double.valueOf(val);
    }

    public Float decodeFloat(String xmlTag) {
        String val = this.decodeString(xmlTag);
        if (null == val) {
            return null;
        }
        return Float.valueOf(val);
    }

    public Integer decodeInteger(String xmlTag) {
        String val = this.decodeString(xmlTag);
        if (null == val) {
            return null;
        }
        return Integer.valueOf(val);
    }

    public Object decodeObject(String xmlTag) {
        Element child = XMLUtil.getChild(this.root, xmlTag);
        return this.decodeObject(child);
    }

    private Object decodeObject(Element child) {
        if (null == child) {
            return null;
        }
        String type = child.getAttribute("type");
        if (Util.isEmptyString(type)) {
            throw new CayenneRuntimeException("No type specified for tag '" + child.getNodeName() + "'.");
        }
        Class<?> objectClass = (Class<?>)classMapping.get(type);
        if (null == objectClass) {
            try {
                objectClass = Class.forName(type);
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Unrecognized class '" + objectClass + "'", e);
            }
        }
        try {
            if ((null != child.getParentNode() && XMLUtil.getChildren(child.getParentNode(), child.getNodeName()).size() > 1 || child.getAttribute("forceList").toUpperCase().equals("YES")) && !this.decodedCollections.contains(child)) {
                return this.decodeCollection(child);
            }
            if (XMLSerializable.class.isAssignableFrom(objectClass)) {
                Element oldRoot = this.root;
                this.root = child;
                XMLSerializable ret = (XMLSerializable)objectClass.newInstance();
                ret.decodeFromXML(this);
                this.root = oldRoot;
                return ret;
            }
            Constructor<?> c = objectClass.getConstructor(String.class);
            if (c != null) {
                return c.newInstance(XMLUtil.getText(child));
            }
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error decoding tag '" + child.getNodeName() + "'", e);
        }
        throw new CayenneRuntimeException("Error decoding tag '" + child.getNodeName() + "': " + "specified class does not have a constructor taking either a String or an XMLDecoder");
    }

    public String decodeString(String xmlTag) {
        Element child = XMLUtil.getChild(this.root, xmlTag);
        return child != null ? XMLUtil.getText(child) : null;
    }

    public Object decode(Reader xml) throws CayenneRuntimeException {
        Document data = XMLDecoder.parse(xml);
        return this.decodeElement(data.getDocumentElement());
    }

    public Object decode(Reader xml, String mappingUrl) throws CayenneRuntimeException {
        Document data = XMLDecoder.parse(xml);
        XMLMappingDescriptor mu = new XMLMappingDescriptor(mappingUrl);
        Object ret = mu.decode(data.getDocumentElement(), this.dataContext);
        return ret;
    }

    private Object decodeElement(Element element) throws CayenneRuntimeException {
        Object object;
        Element oldRoot = this.root;
        this.root = element;
        try {
            object = this.decodeObject(element);
        }
        catch (Throwable th) {
            throw new CayenneRuntimeException("Error instantiating object", th);
        }
        if (null != this.dataContext && object instanceof DataObject) {
            this.dataContext.registerNewObject((DataObject)object);
        }
        this.root = oldRoot;
        this.decodedCollections.clear();
        return object;
    }

    private Collection decodeCollection(Element xml) throws CayenneRuntimeException {
        Collection ret;
        try {
            String parentClass = ((Element)xml.getParentNode()).getAttribute("type");
            Object property = Class.forName(parentClass).newInstance();
            Collection c = (Collection)PropertyUtils.getProperty(property, xml.getNodeName());
            ret = (Collection)c.getClass().newInstance();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Could not create collection with no-arg constructor.", ex);
        }
        Iterator it = XMLUtil.getChildren(xml.getParentNode(), xml.getNodeName()).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            this.decodedCollections.add(e);
            Object o = this.decodeElement(e);
            ret.add(o);
        }
        return ret;
    }

    public static List decodeList(Reader xml) throws CayenneRuntimeException {
        return XMLDecoder.decodeList(xml, null, null);
    }

    public static List decodeList(Reader xml, DataContext dc) throws CayenneRuntimeException {
        return XMLDecoder.decodeList(xml, null, dc);
    }

    public static List decodeList(Reader xml, String mappingUrl) throws CayenneRuntimeException {
        return XMLDecoder.decodeList(xml, mappingUrl, null);
    }

    public static List decodeList(Reader xml, String mappingUrl, DataContext dataContext) throws CayenneRuntimeException {
        List ret;
        XMLDecoder decoder = new XMLDecoder(dataContext);
        Element listRoot = XMLDecoder.parse(xml).getDocumentElement();
        try {
            String parentClass = listRoot.getAttribute("type");
            ret = (List)Class.forName(parentClass).newInstance();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Could not create collection with no-arg constructor.", ex);
        }
        XMLMappingDescriptor mu = null;
        if (mappingUrl != null) {
            mu = new XMLMappingDescriptor(mappingUrl);
        }
        Iterator it = XMLUtil.getChildren(listRoot).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            decoder.decodedCollections.add(e);
            Object o = mu != null ? mu.decode(e, dataContext) : decoder.decodeElement(e);
            ret.add(o);
        }
        return ret;
    }

    private static Document parse(Reader in) throws CayenneRuntimeException {
        DocumentBuilder builder = XMLUtil.newBuilder();
        try {
            return builder.parse(new InputSource(in));
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error parsing XML", ex);
        }
    }

    static {
        classMapping.put("boolean", Boolean.class);
        classMapping.put("int", Integer.class);
        classMapping.put("char", Character.class);
        classMapping.put("float", Float.class);
        classMapping.put("byte", Byte.class);
        classMapping.put("short", Short.class);
        classMapping.put("long", Long.class);
        classMapping.put("double", Double.class);
    }
}

