/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;

public class IndegreeTopologicalSort
extends Algorithm {
    private Digraph digraph;
    private LinkedList vertices = new LinkedList();
    private Map inDegrees = new HashMap();
    private ListIterator current;

    public IndegreeTopologicalSort(Digraph digraph) {
        this.digraph = digraph;
        Iterator iterator = digraph.vertexIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.vertices.add(e);
            this.inDegrees.put(e, new InDegree(digraph.incomingSize(e)));
        }
        this.current = this.vertices.listIterator();
    }

    public boolean hasNext() {
        return !this.vertices.isEmpty();
    }

    public Object next() {
        boolean bl = true;
        while (this.hasNext()) {
            if (!this.current.hasNext()) {
                if (!bl) break;
                bl = false;
                this.current = this.vertices.listIterator();
            }
            Object e = this.current.next();
            InDegree inDegree = (InDegree)this.inDegrees.get(e);
            if (inDegree.value != 0) continue;
            this.removeVertex(e);
            this.current.remove();
            return e;
        }
        return null;
    }

    private void removeVertex(Object object) {
        ArcIterator arcIterator = this.digraph.outgoingIterator(object);
        while (arcIterator.hasNext()) {
            arcIterator.next();
            Object object2 = arcIterator.getDestination();
            InDegree inDegree = (InDegree)this.inDegrees.get(object2);
            --inDegree.value;
        }
    }

    private static class InDegree {
        int value;

        InDegree(int n) {
            this.value = n;
        }
    }
}

