/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.storage.impl;

import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.storage.ALStorageHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import org.apache.commons.io.IOUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALDefaultStorageHandler
extends ALStorageHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALDefaultStorageHandler.class.getName());
    private static final String EXT_FILENAME = ".txt";
    private static ALStorageHandler instance;

    public static ALStorageHandler getInstance() {
        if (instance == null) {
            instance = new ALDefaultStorageHandler();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(InputStream is, String folderPath, String filename) {
        File path = new File(this.getAbsolutePath(folderPath));
        if (!path.exists()) {
            try {
                path.mkdirs();
            }
            catch (Exception e) {
                logger.error((Object)("Can't create directory...:" + path));
            }
        }
        String filepath = path + this.separator() + filename;
        File file = new File(filepath);
        OutputStream os = null;
        try {
            int c;
            if (!file.exists() && !file.createNewFile()) {
                throw new RuntimeException("createNewFile error");
            }
            os = new FileOutputStream(filepath);
            while ((c = is.read()) != -1) {
                ((FileOutputStream)os).write(c);
            }
        }
        catch (IOException e) {
            logger.error((Object)"ALDefaultStorageHandler.saveFile", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    ((FileOutputStream)os).close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewFile(InputStream is, String filepath) {
        File file = new File(this.getAbsolutePath(filepath));
        if (!file.exists()) {
            try {
                File dir;
                String parent = file.getParent();
                if (parent != null && !(dir = new File(parent)).exists() && !dir.mkdirs()) {
                    throw new RuntimeException("mkdir error");
                }
                if (!file.createNewFile()) {
                    throw new RuntimeException("createNewFile error");
                }
            }
            catch (IOException e) {
                logger.error((Object)("Can't create file...:" + file), (Throwable)e);
            }
        }
        FileOutputStream os = null;
        try {
            int c;
            os = new FileOutputStream(this.getAbsolutePath(filepath));
            while ((c = is.read()) != -1) {
                os.write(c);
            }
        }
        catch (IOException e) {
            logger.error((Object)"ALDefaultStorageHandler.createNewFile", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewFile(InputStream is, String folderPath, String filename) {
        File path = new File(this.getAbsolutePath(folderPath));
        if (!path.exists()) {
            try {
                path.mkdirs();
            }
            catch (Exception e) {
                logger.error((Object)("Can't create directory...:" + path));
            }
        }
        String filepath = path + this.separator() + filename;
        File file = new File(filepath);
        OutputStream os = null;
        try {
            int c;
            if (!file.createNewFile()) {
                throw new RuntimeException("createNewFile error");
            }
            os = new FileOutputStream(filepath);
            while ((c = is.read()) != -1) {
                ((FileOutputStream)os).write(c);
            }
        }
        catch (IOException e) {
            logger.error((Object)"ALDefaultStorageHandler.createNewFile", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    ((FileOutputStream)os).close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewTmpFile(InputStream is, int uid, String dir, String fileName, String realFileName) {
        File path = new File(this.getAbsolutePath(FOLDER_TMP_FOR_ATTACHMENT_FILES) + this.separator() + Database.getDomainName() + this.separator() + uid + this.separator() + dir);
        if (!path.exists()) {
            try {
                path.mkdirs();
            }
            catch (Exception e) {
                logger.error((Object)("Can't create directory...:" + path));
            }
        }
        try {
            String filepath = path + this.separator() + fileName;
            File file = new File(filepath);
            if (!file.createNewFile()) {
                throw new RuntimeException("createNewFile error");
            }
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            try {
                int c;
                bis = new BufferedInputStream(is, 0x100000);
                bos = new BufferedOutputStream(new FileOutputStream(filepath), 0x100000);
                while ((c = bis.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException e) {
                try {
                    logger.error((Object)"ALDefaultStorageHandler.createNewTmpFile", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bis);
                    IOUtils.closeQuietly(bos);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)bis);
                IOUtils.closeQuietly(bos);
            }
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((OutputStream)bos);
            PrintWriter w = null;
            try {
                w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath + EXT_FILENAME), "UTF-8"));
                w.println(realFileName);
            }
            catch (IOException e) {
                logger.error((Object)"ALDefaultStorageHandler.createNewTmpFile", (Throwable)e);
            }
            finally {
                if (w != null) {
                    try {
                        w.flush();
                        w.close();
                    }
                    catch (Throwable e) {}
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"ALDefaultStorageHandler.createNewTmpFile", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"ALDefaultStorageHandler.createNewTmpFile", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFile(String srcRootPath, String srcDir, String srcFileName, String destRootPath, String destDir, String destFileName) {
        File destPath;
        File srcPath = new File(this.getAbsolutePath(srcRootPath) + this.separator() + Database.getDomainName() + this.separator() + srcDir);
        if (!srcPath.exists()) {
            try {
                srcPath.mkdirs();
            }
            catch (Exception e) {
                logger.error((Object)("Can't create directory...:" + srcPath));
                return false;
            }
        }
        if (!(destPath = new File(this.getAbsolutePath(destRootPath) + this.separator() + Database.getDomainName() + this.separator() + destDir)).exists()) {
            try {
                destPath.mkdirs();
            }
            catch (Exception e) {
                logger.error((Object)("Can't create directory...:" + destPath));
                return false;
            }
        }
        File from = new File(srcPath + this.separator() + srcFileName);
        File to = new File(destPath + this.separator() + destFileName);
        boolean res = true;
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            srcChannel = new FileInputStream(from).getChannel();
            destChannel = new FileOutputStream(to).getChannel();
            ((FileChannel)destChannel).transferFrom(srcChannel, 0L, srcChannel.size());
        }
        catch (Exception ex) {
            logger.error((Object)"ALDefaultStorageHandler.copyFile", (Throwable)ex);
            res = false;
        }
        finally {
            if (destChannel != null) {
                try {
                    destChannel.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"ALDefaultStorageHandler.copyFile", (Throwable)ex);
                    res = false;
                }
            }
            if (srcChannel != null) {
                try {
                    srcChannel.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"ALDefaultStorageHandler.copyFile", (Throwable)ex);
                    res = false;
                }
            }
        }
        return res;
    }

    public long getFolderSize(String rootPath, String dir) {
        return this.getFolderSize(rootPath + this.separator() + Database.getDomainName() + this.separator() + dir);
    }

    protected long getFolderSize(String folderPath) {
        if (folderPath == null || folderPath.equals("")) {
            return 0L;
        }
        File folder = new File(this.getAbsolutePath(folderPath));
        if (!folder.exists()) {
            return 0L;
        }
        if (folder.isFile()) {
            return this.getFileSize(folder);
        }
        int fileSizeSum = 0;
        File file = null;
        String[] files = folder.list();
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            file = new File(this.getAbsolutePath(folderPath) + this.separator() + files[i]);
            if (file.isFile()) {
                fileSizeSum += this.getFileSize(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            fileSizeSum = (int)((long)fileSizeSum + this.getFolderSize(file.getAbsolutePath()));
        }
        return fileSizeSum;
    }

    public long getFileSize(String rootPath, String dir, String filename) {
        return this.getFileSize(new File(this.getAbsolutePath(rootPath) + this.separator() + Database.getDomainName() + this.separator() + dir + this.separator() + filename));
    }

    protected int getFileSize(File file) {
        if (file == null) {
            return -1;
        }
        FileInputStream fileInputStream = null;
        int size = -1;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedInputStream input = new BufferedInputStream(fileInputStream);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] b = new byte[512];
            int len = -1;
            while ((len = input.read(b)) != -1) {
                output.write(b, 0, len);
                output.flush();
            }
            input.close();
            fileInputStream.close();
            byte[] fileArray = output.toByteArray();
            size = fileArray.length;
            output.close();
        }
        catch (FileNotFoundException e) {
            return -1;
        }
        catch (IOException ioe) {
            return -1;
        }
        return size;
    }

    public boolean deleteFolder(String rootPath, String dir) {
        File file = new File(this.getAbsolutePath(rootPath) + this.separator() + Database.getDomainName() + this.separator() + dir);
        if (!file.exists()) {
            return true;
        }
        return this.deleteFolder(file);
    }

    protected boolean deleteFolder(File folder) {
        if (folder == null) {
            return true;
        }
        String[] files = folder.list();
        if (files == null) {
            if (!folder.delete()) {
                throw new RuntimeException("delete error");
            }
            return true;
        }
        int length = files.length;
        if (length <= 0) {
            if (!folder.delete()) {
                throw new RuntimeException("delete error");
            }
            return true;
        }
        String folderPath = folder.getAbsolutePath() + this.separator();
        File tmpfile = null;
        for (int i = 0; i < length; ++i) {
            tmpfile = new File(folderPath + files[i]);
            if (!tmpfile.exists()) continue;
            if (tmpfile.isFile()) {
                if (tmpfile.delete()) continue;
                throw new RuntimeException("delete error");
            }
            if (!tmpfile.isDirectory()) continue;
            this.deleteFolder(tmpfile);
        }
        if (!folder.delete()) {
            throw new RuntimeException("delete error");
        }
        return true;
    }

    public InputStream getFile(String rootPath, String dir, String fileName) throws FileNotFoundException {
        return this.getFile(rootPath + this.separator() + Database.getDomainName() + this.separator() + dir + this.separator() + fileName);
    }

    public InputStream getFile(String filePath) throws FileNotFoundException {
        return new FileInputStream(this.getAbsolutePath(filePath));
    }

    public String getDocumentPath(String rootPath, String categoryKey) {
        File rootDir = new File(this.getAbsolutePath(rootPath));
        String org_name = Database.getDomainName();
        if (!rootDir.exists()) {
            try {
                rootDir.mkdirs();
            }
            catch (Exception e) {
                logger.error((Object)("Can't create directory...:" + rootPath));
                return rootDir.getAbsolutePath();
            }
        }
        if (org_name == null) {
            return rootDir.getAbsolutePath();
        }
        File base = null;
        base = new File(rootDir.getAbsolutePath() + this.separator() + org_name + this.separator() + categoryKey);
        if (!base.exists()) {
            try {
                base.mkdirs();
            }
            catch (Exception e) {
                logger.error((Object)("Can't create directory...:" + base));
                return base.getAbsolutePath();
            }
        }
        return base.getAbsolutePath();
    }

    public String separator() {
        return File.separator;
    }

    public boolean deleteFile(String rootPath, String dir, String filename) {
        File file = new File(this.getDocumentPath(rootPath, dir) + this.separator() + filename);
        if (file != null && file.exists() && !file.delete()) {
            throw new RuntimeException("delete error");
        }
        return true;
    }

    public boolean deleteFile(String filePath) {
        File file = new File(this.getAbsolutePath(filePath));
        if (file != null && file.exists() && !file.delete()) {
            throw new RuntimeException("delete error");
        }
        return true;
    }

    public boolean deleteOldFolder(String folderPath, Calendar cal) {
        Calendar mod = Calendar.getInstance();
        boolean flag = true;
        File parent_folder = new File(this.getAbsolutePath(folderPath));
        try {
            if (!parent_folder.exists()) {
                return false;
            }
            if (parent_folder.isFile()) {
                return false;
            }
            String[] folders_path = parent_folder.list();
            if (folders_path.length == 0) {
                return true;
            }
            int length = folders_path.length;
            for (int i = 0; i < length; ++i) {
                File folder = new File(parent_folder.getAbsolutePath() + File.separator + folders_path[i]);
                mod.setTimeInMillis(folder.lastModified());
                if (folder.isDirectory()) {
                    if (!this.deleteOldFolder(folder.getAbsolutePath(), cal)) {
                        flag = false;
                        continue;
                    }
                    if (!mod.before(cal) || folder.delete()) continue;
                    flag = false;
                    continue;
                }
                if (mod.before(cal)) {
                    if (folder.delete()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALDefaultStorageHandler.deleteOldFolder", (Throwable)e);
            return false;
        }
        return flag;
    }

    protected String getAbsolutePath(String folderPath) {
        try {
            Path path = Paths.get(folderPath, new String[0]);
            if (path == null) {
                return folderPath;
            }
            if (path.isAbsolute()) {
                return folderPath;
            }
            String root = System.getProperty("catalina.home");
            if (root == null) {
                return folderPath;
            }
            return root + this.separator() + folderPath;
        }
        catch (Throwable throwable) {
            return folderPath;
        }
    }
}

