/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotData;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class ClasspathSnapshotFactory {
    private final ClasspathEntrySnapshotter classpathEntrySnapshotter;
    private final BuildOperationExecutor buildOperationExecutor;

    public ClasspathSnapshotFactory(ClasspathEntrySnapshotter classpathEntrySnapshotter, BuildOperationExecutor buildOperationExecutor) {
        this.classpathEntrySnapshotter = classpathEntrySnapshotter;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    ClasspathSnapshot createSnapshot(Iterable<File> entries) {
        Set<CreateSnapshot> snapshotOperations = this.snapshotAll(entries);
        LinkedHashMap<File, ClasspathEntrySnapshot> snapshots = new LinkedHashMap<File, ClasspathEntrySnapshot>();
        LinkedHashMap<File, HashCode> hashes = new LinkedHashMap<File, HashCode>();
        HashSet<String> allClasses = new HashSet<String>();
        HashSet<String> duplicateClasses = new HashSet<String>();
        for (CreateSnapshot operation : snapshotOperations) {
            File entry = operation.entry;
            ClasspathEntrySnapshot snapshot = operation.snapshot;
            if (snapshot == null) continue;
            snapshots.put(entry, snapshot);
            hashes.put(entry, snapshot.getHash());
            for (String c : snapshot.getClasses()) {
                if (allClasses.add(c)) continue;
                duplicateClasses.add(c);
            }
        }
        ClasspathSnapshotData classpathSnapshotData = new ClasspathSnapshotData(hashes, duplicateClasses);
        return new ClasspathSnapshot(snapshots, classpathSnapshotData);
    }

    private Set<CreateSnapshot> snapshotAll(Iterable<File> entries) {
        LinkedHashSet<CreateSnapshot> snapshotOperations = new LinkedHashSet<CreateSnapshot>();
        this.buildOperationExecutor.runAll(buildOperationQueue -> {
            for (File entry : entries) {
                CreateSnapshot operation = new CreateSnapshot(entry);
                snapshotOperations.add(operation);
                buildOperationQueue.add((BuildOperation)operation);
            }
        });
        return snapshotOperations;
    }

    private class CreateSnapshot
    implements RunnableBuildOperation {
        private final File entry;
        private ClasspathEntrySnapshot snapshot;

        private CreateSnapshot(File entry) {
            this.entry = entry;
        }

        public void run(BuildOperationContext context) {
            if (this.entry.exists()) {
                this.snapshot = ClasspathSnapshotFactory.this.classpathEntrySnapshotter.createSnapshot(this.entry);
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Create incremental compile snapshot for " + this.entry));
        }
    }
}

