/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public class FileSystemSnapshotBuilder {
    private final Interner<String> stringInterner;
    private final FileHasher fileHasher;
    private DirectoryBuilder rootDirectoryBuilder;
    private String rootPath;
    private String rootName;
    private RegularFileSnapshot rootFileSnapshot;

    public FileSystemSnapshotBuilder(Interner<String> stringInterner, FileHasher fileHasher) {
        this.stringInterner = stringInterner;
        this.fileHasher = fileHasher;
    }

    public void addDir(File dir, String[] segments) {
        this.checkNoRootFileSnapshot("directory", dir);
        DirectoryBuilder rootBuilder = this.getOrCreateRootDir(dir, segments);
        rootBuilder.addDir(segments, 0);
    }

    public void addFile(File file, String[] segments, String fileName, FileMetadata metadata) {
        this.checkNoRootFileSnapshot("another root file", file);
        HashCode contentHash = this.fileHasher.hash(file, metadata.getLength(), metadata.getLastModified());
        RegularFileSnapshot fileSnapshot = new RegularFileSnapshot((String)this.stringInterner.intern((Object)file.getAbsolutePath()), fileName, contentHash, metadata);
        if (segments.length == 0) {
            this.rootFileSnapshot = fileSnapshot;
        } else {
            DirectoryBuilder rootDir = this.getOrCreateRootDir(file, segments);
            rootDir.addFile(segments, 0, fileSnapshot);
        }
    }

    private void checkNoRootFileSnapshot(String description, File file) {
        if (this.rootFileSnapshot != null) {
            throw new IllegalArgumentException(String.format("Cannot add %s '%s' for root file '%s'", description, file, this.rootFileSnapshot.getAbsolutePath()));
        }
    }

    private DirectoryBuilder getOrCreateRootDir(File dir, String[] segments) {
        if (this.rootDirectoryBuilder == null) {
            this.rootDirectoryBuilder = new DirectoryBuilder();
            Path rootDir = dir.toPath();
            for (String ignored : segments) {
                rootDir = rootDir.getParent();
            }
            this.rootPath = (String)this.stringInterner.intern((Object)rootDir.toAbsolutePath().toString());
            this.rootName = (String)this.stringInterner.intern((Object)rootDir.getFileName().toString());
        }
        return this.rootDirectoryBuilder;
    }

    public FileSystemSnapshot build() {
        if (this.rootFileSnapshot != null) {
            return this.rootFileSnapshot;
        }
        if (this.rootDirectoryBuilder == null) {
            return FileSystemSnapshot.EMPTY;
        }
        MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.sortingRequired();
        this.rootDirectoryBuilder.accept(this.rootPath, this.rootName, builder);
        return (FileSystemSnapshot)Preconditions.checkNotNull((Object)builder.getResult());
    }

    private static FileMetadata.AccessType determineAccessTypeForLocation(String absolutePath) {
        return FileMetadata.AccessType.viaSymlink((boolean)Files.isSymbolicLink(Paths.get(absolutePath, new String[0])));
    }

    private class DirectoryBuilder {
        private final Map<String, DirectoryBuilder> subDirs = new HashMap<String, DirectoryBuilder>();
        private final Map<String, RegularFileSnapshot> files = new HashMap<String, RegularFileSnapshot>();

        private DirectoryBuilder() {
        }

        public void addFile(String[] segments, int offset, RegularFileSnapshot fileSnapshot) {
            if (segments.length == offset) {
                throw new IllegalStateException("A file cannot be in the same place as a directory: " + fileSnapshot.getAbsolutePath());
            }
            String currentSegment = (String)FileSystemSnapshotBuilder.this.stringInterner.intern((Object)segments[offset]);
            if (segments.length == offset + 1) {
                if (this.subDirs.containsKey(currentSegment)) {
                    throw new IllegalStateException("A file cannot be added in the same place as a directory: " + fileSnapshot.getAbsolutePath());
                }
                this.files.put(currentSegment, fileSnapshot);
            } else {
                DirectoryBuilder subDir = this.getOrCreateSubDir(currentSegment);
                subDir.addFile(segments, offset + 1, fileSnapshot);
            }
        }

        public void addDir(String[] segments, int offset) {
            if (segments.length == offset) {
                return;
            }
            String currentSegment = (String)FileSystemSnapshotBuilder.this.stringInterner.intern((Object)segments[offset]);
            DirectoryBuilder subDir = this.getOrCreateSubDir(currentSegment);
            subDir.addDir(segments, offset + 1);
        }

        private DirectoryBuilder getOrCreateSubDir(String currentSegment) {
            if (this.files.containsKey(currentSegment)) {
                RegularFileSnapshot fileSnapshot = this.files.get(currentSegment);
                throw new IllegalStateException("A file cannot be added in the same place as a directory:" + fileSnapshot.getAbsolutePath());
            }
            DirectoryBuilder subDir = this.subDirs.get(currentSegment);
            if (subDir == null) {
                subDir = new DirectoryBuilder();
                this.subDirs.put(currentSegment, subDir);
            }
            return subDir;
        }

        public void accept(String directoryPath, String directoryName, MerkleDirectorySnapshotBuilder builder) {
            builder.enterDirectory(FileSystemSnapshotBuilder.determineAccessTypeForLocation(directoryPath), directoryPath, directoryName, MerkleDirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
            for (Map.Entry<String, DirectoryBuilder> entry : this.subDirs.entrySet()) {
                String subDirName = entry.getKey();
                String subDirPath = (String)FileSystemSnapshotBuilder.this.stringInterner.intern((Object)(directoryPath + File.separatorChar + subDirName));
                entry.getValue().accept(subDirPath, subDirName, builder);
            }
            for (RegularFileSnapshot fileSnapshot : this.files.values()) {
                builder.visitLeafElement((FileSystemLeafSnapshot)fileSnapshot);
            }
            builder.leaveDirectory();
        }
    }
}

