/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import tokyocabinet.BDB;
import tokyocabinet.BDBCUR;
import tokyocabinet.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class BDBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();
    static /* synthetic */ Class class$tokyocabinet$BDBTest;

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            BDBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = BDBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = BDBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = BDBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = BDBTest.runmisc(stringArray);
        } else {
            BDBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static final void usage() {
        STDERR.println("test cases of the B+ tree database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        StringBuffer stringBuffer = new StringBuffer("  java ");
        Class clazz = class$tokyocabinet$BDBTest;
        if (clazz == null) {
            clazz = class$tokyocabinet$BDBTest = BDBTest.class("[Ltokyocabinet.BDBTest;", false);
        }
        STDERR.println(stringBuffer.append(clazz.getName()).append(" arguments...").toString());
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tcbtest.rb write [-tl] [-td|-tb|-tt] [-nl|-nb] path rnum [lmemb [nmemb [bnum [apow [fpow]]]]]");
        STDERR.println("  tcbtest.rb read [-nl|-nb] path");
        STDERR.println("  tcbtest.rb remove [-nl|-nb] path");
        STDERR.println("  tcbtest.rb misc [-tl] [-td|-tb|-tt] [-nl|-nb] path rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static final void eprint(BDB bDB, String string) {
        String string2 = bDB.path();
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$tokyocabinet$BDBTest;
        if (clazz == null) {
            clazz = class$tokyocabinet$BDBTest = BDBTest.class("[Ltokyocabinet.BDBTest;", false);
        }
        STDERR.println(stringBuffer.append(clazz.getName()).append(": ").append(string2).append(": ").append(string).append(": ").append(bDB.errmsg()).toString());
    }

    private static final int runwrite(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < stringArray.length) {
            String string8 = stringArray[n3];
            if (string == null && string8.startsWith("-")) {
                if (string8.equals("-tl")) {
                    n |= 1;
                } else if (string8.equals("-td")) {
                    n |= 2;
                } else if (string8.equals("-tb")) {
                    n |= 4;
                } else if (string8.equals("-tt")) {
                    n |= 8;
                } else if (string8.equals("-nl")) {
                    n2 |= 0x10;
                } else if (string8.equals("-nb")) {
                    n2 |= 0x20;
                } else {
                    BDBTest.usage();
                }
            } else if (string == null) {
                string = string8;
            } else if (string2 == null) {
                string2 = string8;
            } else if (string3 == null) {
                string3 = string8;
            } else if (string4 == null) {
                string4 = string8;
            } else if (string5 == null) {
                string5 = string8;
            } else if (string6 == null) {
                string6 = string8;
            } else if (string7 == null) {
                string7 = string8;
            } else {
                BDBTest.usage();
            }
            ++n3;
        }
        if (string == null || string2 == null) {
            BDBTest.usage();
        }
        if ((n3 = Util.atoi(string2)) < 1) {
            BDBTest.usage();
        }
        int n4 = string3 != null ? Util.atoi(string3) : -1;
        int n5 = string4 != null ? Util.atoi(string4) : -1;
        int n6 = string5 != null ? Util.atoi(string5) : -1;
        int n7 = string6 != null ? Util.atoi(string6) : -1;
        int n8 = string7 != null ? Util.atoi(string7) : -1;
        int n9 = BDBTest.procwrite(string, n3, n4, n5, n6, n7, n8, n, n2);
        return n9;
    }

    private static final int runread(String[] stringArray) {
        String string = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n |= 0x10;
                } else if (string2.equals("-nb")) {
                    n |= 0x20;
                } else {
                    BDBTest.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                BDBTest.usage();
            }
            ++n2;
        }
        if (string == null) {
            BDBTest.usage();
        }
        n2 = BDBTest.procread(string, n);
        return n2;
    }

    private static final int runremove(String[] stringArray) {
        String string = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n |= 0x10;
                } else if (string2.equals("-nb")) {
                    n |= 0x20;
                } else {
                    BDBTest.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                BDBTest.usage();
            }
            ++n2;
        }
        if (string == null) {
            BDBTest.usage();
        }
        n2 = BDBTest.procremove(string, n);
        return n2;
    }

    private static final int runmisc(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < stringArray.length) {
            String string3 = stringArray[n3];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-tl")) {
                    n |= 1;
                } else if (string3.equals("-td")) {
                    n |= 2;
                } else if (string3.equals("-tb")) {
                    n |= 4;
                } else if (string3.equals("-tt")) {
                    n |= 8;
                } else if (string3.equals("-nl")) {
                    n2 |= 0x10;
                } else if (string3.equals("-nb")) {
                    n2 |= 0x20;
                } else {
                    BDBTest.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                BDBTest.usage();
            }
            ++n3;
        }
        if (string == null || string2 == null) {
            BDBTest.usage();
        }
        if ((n3 = Util.atoi(string2)) < 1) {
            BDBTest.usage();
        }
        int n4 = BDBTest.procmisc(string, n3, n, n2);
        return n4;
    }

    private static final int procwrite(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  lmemb=" + n2 + "  nmemb=" + n3 + "  bnum=" + n4 + "  apow=" + n5 + "  fpow=" + n6 + "  opts=" + n7 + "  omode=" + n8);
        STDOUT.println("");
        int n9 = 0;
        double d = Util.time();
        BDB bDB = new BDB();
        if (!bDB.tune(n2, n3, n4, n5, n6, n7)) {
            BDBTest.eprint(bDB, "tune");
            n9 = 1;
        }
        if (!bDB.open(string, 0xE | n8)) {
            BDBTest.eprint(bDB, "open");
            n9 = 1;
        }
        int n10 = 1;
        while (n10 <= n) {
            String string2 = Util.itoa(n10, 8, '0');
            if (!bDB.put(string2, string2)) {
                BDBTest.eprint(bDB, "put");
                n9 = 1;
                break;
            }
            if (n > 250 && n10 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n10 == n || n10 % (n / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n10;
        }
        STDOUT.println("record number: " + bDB.rnum());
        STDOUT.println("size: " + bDB.fsiz());
        if (!bDB.close()) {
            BDBTest.eprint(bDB, "close");
            n9 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n9 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n9;
    }

    private static final int procread(String string, int n) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        int n2 = 0;
        double d = Util.time();
        BDB bDB = new BDB();
        if (!bDB.open(string, 1 | n)) {
            BDBTest.eprint(bDB, "open");
            n2 = 1;
        }
        int n3 = (int)bDB.rnum();
        int n4 = 1;
        while (n4 <= n3) {
            String string2 = Util.itoa(n4, 8, '0');
            if (bDB.get(string2) == null) {
                BDBTest.eprint(bDB, "get");
                n2 = 1;
                break;
            }
            if (n3 > 250 && n4 % (n3 / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n3 || n4 % (n3 / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("record number: " + bDB.rnum());
        STDOUT.println("size: " + bDB.fsiz());
        if (!bDB.close()) {
            BDBTest.eprint(bDB, "close");
            n2 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n2 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n2;
    }

    private static final int procremove(String string, int n) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        int n2 = 0;
        double d = Util.time();
        BDB bDB = new BDB();
        if (!bDB.open(string, 2 | n)) {
            BDBTest.eprint(bDB, "open");
            n2 = 1;
        }
        int n3 = (int)bDB.rnum();
        int n4 = 1;
        while (n4 <= n3) {
            String string2 = Util.itoa(n4, 8, '0');
            if (!bDB.out(string2)) {
                BDBTest.eprint(bDB, "out");
                n2 = 1;
                break;
            }
            if (n3 > 250 && n4 % (n3 / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n3 || n4 % (n3 / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("record number: " + bDB.rnum());
        STDOUT.println("size: " + bDB.fsiz());
        if (!bDB.close()) {
            BDBTest.eprint(bDB, "close");
            n2 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n2 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n2;
    }

    private static final int procmisc(String string, int n, int n2, int n3) {
        int n4;
        Object object;
        String string2;
        Object object2;
        String string3;
        String string4;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  opts=" + n2 + "  omode=" + n3);
        STDOUT.println("");
        int n5 = 0;
        double d = Util.time();
        BDB bDB = new BDB();
        if (!bDB.tune(10, 10, n / 50, 2, -1, n2)) {
            BDBTest.eprint(bDB, "tune");
            n5 = 1;
        }
        if (!bDB.setcache(128, 256)) {
            BDBTest.eprint(bDB, "setcache");
            n5 = 1;
        }
        if (!bDB.setxmsiz(n * 4)) {
            BDBTest.eprint(bDB, "setxmsiz");
            n5 = 1;
        }
        if (!bDB.setdfunit(8)) {
            BDBTest.eprint(bDB, "setdfunit");
            n5 = 1;
        }
        if (!bDB.open(string, 0xE | n3)) {
            BDBTest.eprint(bDB, "open");
            n5 = 1;
        }
        STDOUT.println("writing:");
        int n6 = 1;
        while (n6 <= n) {
            string4 = Util.itoa(n6, 8, '0');
            if (!bDB.put(string4, string4)) {
                BDBTest.eprint(bDB, "put");
                n5 = 1;
                break;
            }
            if (n > 250 && n6 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n6 == n || n6 % (n / 10) == 0) {
                    STDOUT.println(" (" + string4 + ')');
                }
            }
            ++n6;
        }
        STDOUT.println("reading:");
        n6 = 1;
        while (n6 <= n) {
            string4 = Util.itoa(n6, 8, '0');
            if (bDB.get(string4) == null) {
                BDBTest.eprint(bDB, "get");
                n5 = 1;
                break;
            }
            if (n > 250 && n6 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n6 == n || n6 % (n / 10) == 0) {
                    STDOUT.println(" (" + string4 + ')');
                }
            }
            ++n6;
        }
        STDOUT.println("removing:");
        n6 = 1;
        while (n6 <= n) {
            string4 = Util.itoa(n6, 8, '0');
            if (RND.nextInt(2) == 0 && !bDB.out(string4)) {
                BDBTest.eprint(bDB, "get");
                n5 = 1;
                break;
            }
            if (n > 250 && n6 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n6 == n || n6 % (n / 10) == 0) {
                    STDOUT.println(" (" + string4 + ')');
                }
            }
            ++n6;
        }
        STDOUT.println("checking cursor:");
        BDBCUR bDBCUR = new BDBCUR(bDB);
        if (!bDBCUR.first() && bDB.ecode() != 22) {
            BDBTest.eprint(bDB, "cur::first");
            n5 = 1;
        }
        int n7 = 0;
        while ((string3 = bDBCUR.key2()) != null) {
            object2 = bDBCUR.val2();
            if (object2 == null) {
                BDBTest.eprint(bDB, "cur::val");
                n5 = 1;
            }
            bDBCUR.next();
            if (n7 > 0 && n > 250 && n7 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n7 == n || n7 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ')');
                }
            }
            ++n7;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ')');
        }
        if (bDB.ecode() != 22 || (long)n7 != bDB.rnum()) {
            BDBTest.eprint(bDB, "(validation)");
            n5 = 1;
        }
        object2 = bDB.fwmkeys("0", 10);
        if (bDB.rnum() >= 10L && object2.size() != 10) {
            BDBTest.eprint(bDB, "fwmkeys");
            n5 = 1;
        }
        STDOUT.println("checking counting:");
        int n8 = 1;
        while (n8 <= n) {
            String string5 = "[" + RND.nextInt(n) + ']';
            if (RND.nextInt(2) == 0) {
                if (bDB.addint(string5, 1) == Integer.MIN_VALUE && bDB.ecode() != 21) {
                    BDBTest.eprint(bDB, "addint");
                    n5 = 1;
                    break;
                }
            } else if (bDB.adddouble(string5, 1.0) == -2.147483648E9 && bDB.ecode() != 21) {
                BDBTest.eprint(bDB, "adddouble");
                n5 = 1;
                break;
            }
            if (n > 250 && n8 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n8 == n || n8 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n8, 8, '0') + ')');
                }
            }
            ++n8;
        }
        if (!bDB.sync()) {
            BDBTest.eprint(bDB, "sync");
            n5 = 1;
        }
        if (!bDB.optimize()) {
            BDBTest.eprint(bDB, "optimize");
            n5 = 1;
        }
        if (!bDB.copy(string2 = string + "-tmp")) {
            BDBTest.eprint(bDB, "copy");
            n5 = 1;
        }
        new File(string2).delete();
        if (!bDB.vanish()) {
            BDBTest.eprint(bDB, "vanish");
            n5 = 1;
        }
        STDOUT.println("random writing:");
        int n9 = 1;
        while (n9 <= n) {
            object = Util.itoa(RND.nextInt(n9), 8, '0');
            if (!bDB.putdup((String)object, (String)object)) {
                BDBTest.eprint(bDB, "putdup");
                n5 = 1;
                break;
            }
            if (n > 250 && n9 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n9 == n || n9 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n9, 8, '0') + ')');
                }
            }
            ++n9;
        }
        STDOUT.println("cursor updating:");
        n9 = 1;
        while (n9 <= n) {
            if (RND.nextInt(10) == 0) {
                object = Util.itoa(RND.nextInt(n), 8, '0');
                bDBCUR.jump((String)object);
                int n10 = 1;
                while (n10 <= 10) {
                    string3 = bDBCUR.key2();
                    if (string3 == null) break;
                    if (RND.nextInt(3) == 0) {
                        bDBCUR.out();
                    } else {
                        n4 = RND.nextInt(3);
                        bDBCUR.put((String)object, n4);
                    }
                    bDBCUR.next();
                    ++n10;
                }
            }
            if (n > 250 && n9 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n9 == n || n9 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n9, 8, '0') + ')');
                }
            }
            ++n9;
        }
        if (!bDB.tranbegin()) {
            BDBTest.eprint(bDB, "tranbegin");
            n5 = 1;
        }
        bDB.putdup("::1", "1");
        bDB.putdup("::2", "2a");
        bDB.putdup("::2", "2b");
        bDB.putdup("::3", "3");
        bDBCUR.jump("::2");
        bDBCUR.put("2A", 0);
        bDBCUR.put("2-", 1);
        bDBCUR.put("2+", 0);
        bDBCUR.next();
        bDBCUR.next();
        bDBCUR.put("mid", 1);
        bDBCUR.put("2C", 2);
        bDBCUR.prev();
        bDBCUR.out();
        List list = bDB.getlist("::2");
        if (list == null || list.size() != 4) {
            BDBTest.eprint(bDB, "getlist");
            n5 = 1;
        }
        object = new ArrayList();
        object.add("hop");
        object.add("step");
        object.add("jump");
        if (!bDB.putlist("::1", (List)object)) {
            BDBTest.eprint(bDB, "putlist");
            n5 = 1;
        }
        if (!bDB.outlist("::1")) {
            BDBTest.eprint(bDB, "outlist");
            n5 = 1;
        }
        if (!bDB.trancommit()) {
            BDBTest.eprint(bDB, "trancommit");
            n5 = 1;
        }
        if (!bDB.tranbegin() || !bDB.tranabort()) {
            BDBTest.eprint(bDB, "tranbegin");
            n5 = 1;
        }
        STDOUT.println("checking common interface:");
        BDB bDB2 = bDB;
        n4 = 1;
        while (n4 <= n) {
            String string6 = "[" + Util.itoa(RND.nextInt(n), 8, '0') + ']';
            int n11 = RND.nextInt(3);
            if (n11 == 0) {
                bDB2.put(string6, string6);
            } else if (n11 == 1) {
                bDB2.get(string6);
            } else {
                bDB2.out(string6);
            }
            if (n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("checking iterator:");
        n7 = 0;
        if (!bDB2.iterinit()) {
            BDBTest.eprint(bDB, "iterinit");
            n5 = 1;
        }
        while ((string3 = bDB2.iternext2()) != null) {
            String string7 = bDB2.get(string3);
            if (string7 == null) {
                BDBTest.eprint(bDB, "get");
                n5 = 1;
            }
            if (n7 > 0 && n > 250 && n7 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n7 == n || n7 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ')');
                }
            }
            ++n7;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ')');
        }
        STDOUT.println("record number: " + bDB.rnum());
        STDOUT.println("size: " + bDB.fsiz());
        if (!bDB.close()) {
            BDBTest.eprint(bDB, "close");
            n5 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n5 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n5;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private BDBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

