"""Add user <-> portal/puppet mappings to db

Revision ID: 41712fc6d14b
Revises: ba113d486f7f
Create Date: 2019-08-12 22:47:28.243599

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '41712fc6d14b'
down_revision = 'ba113d486f7f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('contact',
    sa.Column('user', sa.String(length=255), nullable=False),
    sa.Column('contact', sa.String(length=255), nullable=False),
    sa.Column('in_community', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.ForeignKeyConstraint(['contact'], ['puppet.gid'], ),
    sa.PrimaryKeyConstraint('user', 'contact')
    )
    op.create_table('user_portal',
    sa.Column('user', sa.String(length=255), nullable=False),
    sa.Column('portal', sa.String(length=255), nullable=False),
    sa.Column('portal_receiver', sa.String(length=255), nullable=False),
    sa.Column('in_community', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.ForeignKeyConstraint(['portal', 'portal_receiver'], ['portal.gid', 'portal.receiver'], onupdate='CASCADE', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('user', 'portal', 'portal_receiver')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('user_portal')
    op.drop_table('contact')
    # ### end Alembic commands ###
