/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.physics;

import br.arca.morcego.Config;
import br.arca.morcego.physics.Spring;
import br.arca.morcego.physics.Vector3D;

public class PunctualBody
extends Vector3D {
    private float mass;
    private float charge;
    private Vector3D speed = new Vector3D(0.0f, 0.0f, 0.0f);
    private Vector3D instantForce = new Vector3D(0.0f, 0.0f, 0.0f);
    private boolean positionFixed = false;
    private Spring punctualSpring;
    private float eletrostaticConstant;

    public PunctualBody(int x, int y, int z) {
        super(x, y, z);
        this.construct();
    }

    public PunctualBody() {
        this.construct();
    }

    private void construct() {
        this.mass = Config.getFloat(Config.nodeMass);
        this.charge = Config.getFloat(Config.nodeCharge);
        this.eletrostaticConstant = Config.getFloat(Config.eletrostaticConstant);
    }

    public void applyForce() {
        if (!this.positionFixed) {
            this.applyUnconditionalForce();
        } else if (this.punctualSpring != null) {
            this.instantForce = this.punctualSpring.strech();
            this.applyUnconditionalForce();
        }
    }

    private void applyUnconditionalForce() {
        this.instantForce.add(this.friction());
        this.speed.add(this.instantForce.multiplyByScalar(1.0f / this.mass));
        this.instantForce = new Vector3D(0.0f, 0.0f, 0.0f);
    }

    public Vector3D friction() {
        float frictionConstant = Config.getFloat(Config.frictionConstant);
        return new Vector3D(this.speed.x, this.speed.y, this.speed.z).multiplyByScalar(-(frictionConstant *= this.mass));
    }

    public void releasePosition() {
        this.positionFixed = false;
        this.punctualSpring = null;
    }

    public void fixPosition() {
        this.positionFixed = true;
    }

    public void fixPosition(int x, int y, int z) {
        this.positionFixed = true;
        this.punctualSpring = new Spring(this, new PunctualBody(x, y, z));
        this.punctualSpring.setSize(0.0f);
        this.punctualSpring.setElasticConstant(Config.getFloat(Config.punctualElasticConstant));
    }

    public void move() {
        this.moveBy(this.speed.x, this.speed.y, this.speed.z);
    }

    public Vector3D getSpeed() {
        return this.speed;
    }

    public void rotate(float xTheta, float yTheta) {
        super.rotate(xTheta, yTheta);
        this.speed.rotate(xTheta, yTheta);
    }

    public Vector3D repel(PunctualBody body) {
        Vector3D force = new Vector3D(this.x - body.x, this.y - body.y, this.z - body.z);
        float distance = force.module();
        force.resize(1.0f / distance);
        float repelConstant = this.eletrostaticConstant * this.charge * body.charge;
        force.resize(repelConstant / (float)Math.pow(distance /= 25.0f, 2.0));
        return force;
    }

    public float getCharge() {
        return this.charge;
    }

    public void setCharge(float charge) {
        this.charge = charge;
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public Vector3D getInstantForce() {
        return this.instantForce;
    }

    public void setInstantForce(Vector3D instantForce) {
        this.instantForce = instantForce;
    }
}

