/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.KeepAliveInputStream;
import org.apache.tools.ant.util.KeepAliveOutputStream;
import org.apache.tools.ant.util.TeeOutputStream;

public class SSHExec
extends SSHBase {
    private static final int BUFFER_SIZE = 8192;
    private static final int RETRY_INTERVAL = 500;
    private String command = null;
    private long maxwait = 0L;
    private Thread thread = null;
    private String outputProperty = null;
    private String errorProperty = null;
    private String resultProperty = null;
    private File outputFile = null;
    private File errorFile = null;
    private String inputProperty = null;
    private String inputString = null;
    private File inputFile = null;
    private boolean append = false;
    private boolean appenderr = false;
    private boolean usePty = false;
    private boolean useSystemIn = false;
    private Resource commandResource = null;
    private static final String TIMEOUT_MESSAGE = "Timeout period exceeded, connection dropped.";
    private boolean suppressSystemOut = false;
    private boolean suppressSystemErr = false;

    public void setCommand(String command) {
        this.command = command;
    }

    public void setCommandResource(String f) {
        this.commandResource = new FileResource(new File(f));
    }

    public void setTimeout(long timeout) {
        this.maxwait = timeout;
    }

    public void setOutput(File output) {
        this.outputFile = output;
    }

    public void setErrorOutput(File output) {
        this.errorFile = output;
    }

    public void setInput(File input) {
        this.inputFile = input;
    }

    public void setInputProperty(String inputProperty) {
        this.inputProperty = inputProperty;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setErrAppend(boolean appenderr) {
        this.appenderr = appenderr;
    }

    public void setOutputproperty(String property) {
        this.outputProperty = property;
    }

    public void setErrorproperty(String property) {
        this.errorProperty = property;
    }

    public void setResultproperty(String property) {
        this.resultProperty = property;
    }

    public void setUsePty(boolean b) {
        this.usePty = b;
    }

    public void setUseSystemIn(boolean useSystemIn) {
        this.useSystemIn = useSystemIn;
    }

    public void setSuppressSystemOut(boolean suppressSystemOut) {
        this.suppressSystemOut = suppressSystemOut;
    }

    public void setSuppressSystemErr(boolean suppressSystemErr) {
        this.suppressSystemErr = suppressSystemErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Session session;
        block20: {
            if (this.getHost() == null) {
                throw new BuildException("Host is required.");
            }
            if (this.getUserInfo().getName() == null) {
                throw new BuildException("Username is required.");
            }
            if (this.getUserInfo().getKeyfile() == null && this.getUserInfo().getPassword() == null) {
                throw new BuildException("Password or Keyfile is required.");
            }
            if (this.command == null && this.commandResource == null) {
                throw new BuildException("Command or commandResource is required.");
            }
            int numberOfInputs = (this.inputFile != null ? 1 : 0) + (this.inputProperty != null ? 1 : 0) + (this.inputString != null ? 1 : 0);
            if (numberOfInputs > 1) {
                throw new BuildException("You can't specify more than one of inputFile, inputProperty and inputString.");
            }
            if (this.inputFile != null && !this.inputFile.exists()) {
                throw new BuildException("The input file " + this.inputFile.getAbsolutePath() + " does not exist.");
            }
            session = null;
            StringBuffer output = new StringBuffer();
            try {
                try {
                    session = this.openSession();
                    if (this.command != null) {
                        this.log("cmd : " + this.command, 2);
                        this.executeCommand(session, this.command, output);
                    } else {
                        try {
                            String cmd;
                            BufferedReader br = new BufferedReader(new InputStreamReader(this.commandResource.getInputStream()));
                            while ((cmd = br.readLine()) != null) {
                                this.log("cmd : " + cmd, 2);
                                output.append(cmd).append(" : ");
                                this.executeCommand(session, cmd, output);
                                output.append("\n");
                            }
                            FileUtils.close((Reader)br);
                        }
                        catch (IOException e) {
                            if (this.getFailonerror()) {
                                throw new BuildException((Throwable)e);
                            }
                            this.log("Caught exception: " + e.getMessage(), 0);
                        }
                    }
                    Object var7_8 = null;
                    if (this.outputProperty == null) break block20;
                }
                catch (JSchException e) {
                    if (this.getFailonerror()) {
                        throw new BuildException((Throwable)e);
                    }
                    this.log("Caught exception: " + e.getMessage(), 0);
                    Object var7_9 = null;
                    if (this.outputProperty != null) {
                        this.getProject().setNewProperty(this.outputProperty, output.toString());
                    }
                    if (session == null) return;
                    if (!session.isConnected()) return;
                    session.disconnect();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (this.outputProperty != null) {
                    this.getProject().setNewProperty(this.outputProperty, output.toString());
                }
                if (session == null) throw throwable;
                if (!session.isConnected()) throw throwable;
                session.disconnect();
                throw throwable;
            }
            this.getProject().setNewProperty(this.outputProperty, output.toString());
        }
        if (session == null) return;
        if (!session.isConnected()) return;
        session.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeCommand(Session session, String cmd, StringBuffer sb) throws BuildException {
        String inputData;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream errout = new ByteArrayOutputStream();
        ByteArrayOutputStream teeErr = this.suppressSystemErr ? errout : new TeeOutputStream((OutputStream)errout, (OutputStream)KeepAliveOutputStream.wrapSystemErr());
        ByteArrayOutputStream tee = this.suppressSystemOut ? out : new TeeOutputStream((OutputStream)out, (OutputStream)KeepAliveOutputStream.wrapSystemOut());
        InputStream istream = null;
        if (this.inputFile != null) {
            try {
                istream = new FileInputStream(this.inputFile);
            }
            catch (IOException e) {
                this.log("Failed to read " + this.inputFile + " because of: " + e.getMessage(), 1);
            }
        }
        if (this.inputProperty != null && (inputData = this.getProject().getProperty(this.inputProperty)) != null) {
            istream = new ByteArrayInputStream(inputData.getBytes());
        }
        if (this.inputString != null) {
            istream = new ByteArrayInputStream(this.inputString.getBytes());
        }
        if (this.useSystemIn) {
            istream = KeepAliveInputStream.wrapSystemIn();
        }
        try {
            block25: {
                try {
                    session.setTimeout((int)this.maxwait);
                    final ChannelExec channel = (ChannelExec)session.openChannel("exec");
                    channel.setCommand(cmd);
                    channel.setOutputStream((OutputStream)tee);
                    channel.setExtOutputStream((OutputStream)tee);
                    channel.setErrStream((OutputStream)teeErr);
                    if (istream != null) {
                        channel.setInputStream(istream);
                    }
                    channel.setPty(this.usePty);
                    channel.connect();
                    this.thread = new Thread(){

                        public void run() {
                            while (!channel.isClosed()) {
                                if (SSHExec.this.thread == null) {
                                    return;
                                }
                                try {
                                    1.sleep(500L);
                                }
                                catch (Exception exception) {}
                            }
                        }
                    };
                    this.thread.start();
                    this.thread.join(this.maxwait);
                    if (this.thread.isAlive()) {
                        this.thread = null;
                        if (this.getFailonerror()) {
                            throw new BuildException(TIMEOUT_MESSAGE);
                        }
                        this.log(TIMEOUT_MESSAGE, 0);
                        break block25;
                    }
                    if (this.outputFile != null) {
                        this.writeToFile(out.toString(), this.append, this.outputFile);
                    }
                    if (this.errorProperty != null) {
                        this.getProject().setNewProperty(this.errorProperty, errout.toString());
                    }
                    if (this.errorFile != null) {
                        this.writeToFile(errout.toString(), this.appenderr, this.errorFile);
                    }
                    int ec = channel.getExitStatus();
                    if (this.resultProperty != null) {
                        this.getProject().setNewProperty(this.resultProperty, Integer.toString(ec));
                    }
                    if (ec == 0) break block25;
                    String msg = "Remote command failed with exit status " + ec;
                    if (this.getFailonerror()) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (JSchException e) {
                    if (e.getMessage().contains("session is down")) {
                        if (this.getFailonerror()) {
                            throw new BuildException(TIMEOUT_MESSAGE, (Throwable)e);
                        }
                        this.log(TIMEOUT_MESSAGE, 0);
                    } else {
                        if (this.getFailonerror()) {
                            throw new BuildException((Throwable)e);
                        }
                        this.log("Caught exception: " + e.getMessage(), 0);
                    }
                    Object var13_17 = null;
                    sb.append(out.toString());
                    FileUtils.close((InputStream)istream);
                    return;
                }
                catch (Exception e) {
                    if (this.getFailonerror()) {
                        throw new BuildException((Throwable)e);
                    }
                    this.log("Caught exception: " + e.getMessage(), 0);
                    Object var13_18 = null;
                    sb.append(out.toString());
                    FileUtils.close((InputStream)istream);
                    return;
                }
            }
            Object var13_16 = null;
            sb.append(out.toString());
            FileUtils.close((InputStream)istream);
            return;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            sb.append(out.toString());
            FileUtils.close((InputStream)istream);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeToFile(String from, boolean append, File to) throws IOException {
        FileWriter out = null;
        try {
            int bytesRead;
            out = new FileWriter(to.getAbsolutePath(), append);
            StringReader in = new StringReader(from);
            char[] buffer = new char[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            Object var9_8 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }
}

