/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.HaltException;
import com.google.web.bindery.requestfactory.apt.Messages;
import com.google.web.bindery.requestfactory.apt.State;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner6;

class ScannerBase<R>
extends ElementScanner6<R, State> {
    ScannerBase() {
    }

    protected static void poisonIfAnnotationPresent(State state, TypeElement x, Annotation ... annotations) {
        for (Annotation a : annotations) {
            if (a == null) continue;
            state.poison(x, Messages.redundantAnnotation(a.annotationType().getSimpleName()));
        }
    }

    protected static ExecutableType viewIn(TypeElement lookIn, ExecutableElement methodElement, State state) {
        try {
            return (ExecutableType)state.types.asMemberOf((DeclaredType)lookIn.asType(), methodElement);
        }
        catch (IllegalArgumentException e) {
            return (ExecutableType)methodElement.asType();
        }
    }

    @Override
    public final R scan(Element x, State state) {
        try {
            return super.scan(x, state);
        }
        catch (HaltException e) {
            throw e;
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            state.poison(x, sw.toString());
            throw new HaltException();
        }
    }

    protected boolean isGetter(ExecutableElement x, State state) {
        String name = x.getSimpleName().toString();
        TypeMirror returnType = x.getReturnType();
        if (!x.getParameters().isEmpty()) {
            return false;
        }
        if (name.startsWith("get")) {
            return true;
        }
        if (name.startsWith("is") || name.startsWith("has")) {
            TypeMirror javaLangBoolean = state.types.boxedClass(state.types.getPrimitiveType(TypeKind.BOOLEAN)).asType();
            if (returnType.getKind().equals((Object)TypeKind.BOOLEAN) || state.types.isSameType(returnType, javaLangBoolean)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isSetter(ExecutableElement x, State state) {
        String name = x.getSimpleName().toString();
        TypeMirror returnType = x.getReturnType();
        if (x.getParameters().size() != 1) {
            return false;
        }
        if (!name.startsWith("set")) {
            return false;
        }
        if (returnType.getKind().equals((Object)TypeKind.VOID)) {
            return true;
        }
        return x.getEnclosingElement() != null && state.types.isAssignable(x.getEnclosingElement().asType(), returnType);
    }

    protected R scanAllInheritedMethods(TypeElement x, State state) {
        Object toReturn = this.DEFAULT_VALUE;
        List<ExecutableElement> methods = ElementFilter.methodsIn(state.elements.getAllMembers(x));
        for (ExecutableElement method : methods) {
            toReturn = this.scan((Element)method, state);
        }
        return (R)toReturn;
    }

    protected boolean shouldIgnore(ExecutableElement x, State state) {
        TypeMirror enclosingType = x.getEnclosingElement().asType();
        return x.getKind().equals((Object)ElementKind.STATIC_INIT) || state.types.isSameType(state.objectType, enclosingType) || state.types.isSameType(state.requestFactoryType, enclosingType) || state.types.isSameType(state.requestContextType, enclosingType) || state.types.isSameType(state.entityProxyType, enclosingType) || state.types.isSameType(state.valueProxyType, enclosingType);
    }
}

