/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.baseinfo;

import edu.cornell.med.icb.util.VersionUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.campagnelab.dl.varanalysis.protobuf.SegmentInformationRecords;
import org.campagnelab.goby.baseinfo.BasenameUtils;
import org.campagnelab.goby.baseinfo.SequenceBaseInformationWriter;
import org.campagnelab.goby.compression.MessageChunksWriter;
import org.campagnelab.goby.compression.SequenceSegmentInfoCollectionHandler;
import org.campagnelab.goby.util.FileExtensionHelper;
import org.campagnelab.goby.util.commits.CommitPropertyHelper;

public class SequenceSegmentInformationWriter
implements Closeable {
    private final SegmentInformationRecords.SegmentInformationCollection.Builder collectionBuilder;
    private String basename;
    private final MessageChunksWriter messageChunkWriter;
    private long recordIndex;
    private Properties customProperties = new Properties();
    private long maxNumOfBases = 0L;
    private long maxNumOfLabels = 0L;
    private long maxNumOfFeatures = 0L;

    public SequenceSegmentInformationWriter(String outputFile) throws FileNotFoundException {
        this(new FileOutputStream(BasenameUtils.getBasename(outputFile, FileExtensionHelper.COMPACT_SEQUENCE_SEGMENT_INFORMATION) + ".ssi"));
        this.basename = BasenameUtils.getBasename(outputFile, FileExtensionHelper.COMPACT_SEQUENCE_SEGMENT_INFORMATION);
    }

    public SequenceSegmentInformationWriter(OutputStream output) {
        this.collectionBuilder = SegmentInformationRecords.SegmentInformationCollection.newBuilder();
        this.messageChunkWriter = new MessageChunksWriter(output);
        this.messageChunkWriter.setParser(new SequenceSegmentInfoCollectionHandler());
        this.setNumEntriesPerChunk(1000);
        this.recordIndex = 0L;
    }

    public void setCustomProperties(Properties customProperties) {
        if (customProperties != null) {
            this.customProperties = customProperties;
        }
    }

    public void addCustomProperties(String key, String value) {
        this.customProperties.setProperty(key, value);
    }

    public void appendProperties(Properties p) {
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.customProperties.setProperty(key, (String)p.get(key));
        }
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public static void writeProperties(String basename, List<Properties> properties) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(basename + ".ssip");
        Properties merged = new Properties();
        if (properties.size() >= 1) {
            merged.putAll((Map<?, ?>)properties.get(0));
        }
        merged.setProperty("goby.version", VersionUtils.getImplementationVersion(SequenceBaseInformationWriter.class));
        CommitPropertyHelper.appendCommitInfo(SequenceBaseInformationWriter.class, "/GOBY_COMMIT.properties", merged);
        merged.save(out, basename);
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static void writeProperties(String basename, long numberOfRecords, long maxNumOfLabels, long maxNumOfBases, long maxNumOfFeatures) throws FileNotFoundException {
        Properties p = new Properties();
        SequenceSegmentInformationWriter.writeProperties(basename, numberOfRecords, maxNumOfLabels, maxNumOfBases, maxNumOfFeatures, p);
    }

    private static void writeProperties(String basename, long numberOfSegments, long maxNumOfLabels, long maxNumOfBases, long maxNumOfFeatures, Properties p) throws FileNotFoundException {
        p.setProperty("numSegments", Long.toString(numberOfSegments));
        p.setProperty("maxNumOfLabels", Long.toString(maxNumOfLabels));
        p.setProperty("maxNumOfBases", Long.toString(maxNumOfBases));
        p.setProperty("maxNumOfFeatures", Long.toString(maxNumOfFeatures));
        ArrayList<Properties> lp = new ArrayList<Properties>();
        lp.add(p);
        SequenceSegmentInformationWriter.writeProperties(basename, lp);
    }

    public void setEntryBases(long numOfBases) {
        if (this.maxNumOfBases < numOfBases) {
            this.maxNumOfBases = numOfBases;
        }
    }

    public void setEntryLabels(long numOfLabels) {
        if (this.maxNumOfLabels < numOfLabels) {
            this.maxNumOfLabels = numOfLabels;
        }
    }

    public void setEntryFeatures(long numOfFeatures) {
        if (this.maxNumOfFeatures < numOfFeatures) {
            this.maxNumOfFeatures = numOfFeatures;
        }
    }

    public void appendEntry(SegmentInformationRecords.SegmentInformation segmentInformation) {
        this.collectionBuilder.addRecords(segmentInformation);
        this.setEntryBases(segmentInformation.getLength());
        if (segmentInformation.getSampleCount() > 0 && segmentInformation.getSample(0).getBaseCount() > 0) {
            this.setEntryLabels(segmentInformation.getSample(0).getBase(0).getLabelsCount());
            this.setEntryFeatures(segmentInformation.getSample(0).getBase(0).getFeaturesCount());
        }
        this.messageChunkWriter.writeAsNeeded(this.collectionBuilder);
        ++this.recordIndex;
    }

    public void setNumEntriesPerChunk(int numEntriesPerChunk) {
        this.messageChunkWriter.setNumEntriesPerChunk(numEntriesPerChunk);
    }

    public synchronized void printStats(PrintStream out) {
        this.messageChunkWriter.printStats(out);
        out.println("Number of bytes/baseInformation record " + (double)this.messageChunkWriter.getTotalBytesWritten() / (double)this.recordIndex);
    }

    @Override
    public void close() throws IOException {
        this.messageChunkWriter.close(this.collectionBuilder);
        Properties p = this.getCustomProperties();
        SequenceSegmentInformationWriter.writeProperties(this.basename, this.recordIndex, this.maxNumOfLabels, this.maxNumOfBases, this.maxNumOfFeatures, p);
    }
}

