/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import com.google.protobuf.ByteString;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.lang.MutableString;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.campagnelab.goby.compression.ChunkCodec;
import org.campagnelab.goby.compression.FastBufferedMessageChunksReader;
import org.campagnelab.goby.compression.MessageChunksReader;
import org.campagnelab.goby.exception.GobyRuntimeException;
import org.campagnelab.goby.reads.ReadCodec;
import org.campagnelab.goby.reads.ReadProtobuffCollectionHandler;
import org.campagnelab.goby.reads.Reads;
import org.campagnelab.goby.util.CodecHelper;
import org.campagnelab.goby.util.FileExtensionHelper;

public class ReadsReader
implements Iterator<Reads.ReadEntry>,
Iterable<Reads.ReadEntry>,
Closeable {
    private final MessageChunksReader reader;
    private Reads.ReadCollection collection;
    private final Properties metaData = new Properties();
    private ReadCodec codec;
    boolean first = true;

    public ReadsReader(String path) throws IOException {
        this(FileUtils.openInputStream((File)new File(path)));
    }

    public ReadsReader(File file) throws IOException {
        this(FileUtils.openInputStream((File)file));
    }

    public ReadsReader(InputStream stream) {
        this.reader = new MessageChunksReader(stream);
        this.reader.setHandler(new ReadProtobuffCollectionHandler());
        this.codec = null;
    }

    public ReadsReader(long start, long end, String path) throws IOException {
        this(start, end, new FastBufferedInputStream((InputStream)FileUtils.openInputStream((File)new File(path))));
    }

    public ReadsReader(long start, long end, FastBufferedInputStream stream) throws IOException {
        this.reader = new FastBufferedMessageChunksReader(start, end, stream);
        this.reader.setHandler(new ReadProtobuffCollectionHandler());
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.reader.hasNext(this.collection, this.collection != null ? this.collection.getReadsCount() : 0);
        byte[] compressedBytes = this.reader.getCompressedBytes();
        ChunkCodec chunkCodec = this.reader.getChunkCodec();
        try {
            if (compressedBytes != null) {
                this.collection = (Reads.ReadCollection)chunkCodec.decode(compressedBytes);
                if (this.codec != null) {
                    this.codec.newChunk();
                }
                if (this.collection == null || this.collection.getReadsCount() == 0) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            throw new GobyRuntimeException(e);
        }
        return hasNext;
    }

    @Override
    public final Reads.ReadEntry next() {
        Reads.ReadEntry.Builder result;
        if (!this.reader.hasNext(this.collection, this.collection.getReadsCount())) {
            throw new NoSuchElementException();
        }
        Reads.ReadEntry readEntry = this.collection.getReads(this.reader.incrementEntryIndex());
        if (readEntry.hasCompressedData() && this.codec == null) {
            this.codec = CodecHelper.locateReadCodec(readEntry.getCompressedData());
        }
        if (this.first) {
            for (int i = 0; i < readEntry.getMetaDataCount(); ++i) {
                Reads.MetaData md = readEntry.getMetaData(i);
                this.metaData.put(md.getKey(), md.getValue());
            }
            this.first = false;
        }
        if (this.codec != null && (result = this.codec.decode(readEntry)) != null) {
            return result.build();
        }
        return readEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a reader.");
    }

    public static void decodeSequence(Reads.ReadEntry entry, MutableString sequence) {
        ReadsReader.decodeSequence(entry, sequence, false);
    }

    public static void decodeSequence(Reads.ReadEntry entry, MutableString sequence, boolean decodePair) {
        ByteString seq = decodePair ? entry.getSequencePair() : entry.getSequence();
        int length = decodePair ? entry.getReadLengthPair() : entry.getReadLength();
        sequence.setLength(length);
        for (int i = 0; i < length; ++i) {
            sequence.setCharAt(i, (char)seq.byteAt(i));
        }
    }

    public static byte[] decodeQualityScores(Reads.ReadEntry entry) {
        if (!entry.hasQualityScores()) {
            return null;
        }
        ByteString scores = entry.getQualityScores();
        int length = scores.size();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = scores.byteAt(i);
        }
        return result;
    }

    @Override
    public Iterator<Reads.ReadEntry> iterator() {
        return this;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static String getBasename(String filename) {
        for (String ext : FileExtensionHelper.COMPACT_READS_FILE_EXTS) {
            if (!StringUtils.endsWith((String)filename, (String)ext)) continue;
            return StringUtils.removeEnd((String)filename, (String)ext);
        }
        return filename;
    }

    public static String[] getBasenames(String ... filenames) {
        ObjectArraySet result = new ObjectArraySet();
        if (filenames != null) {
            for (String filename : filenames) {
                result.add((Object)ReadsReader.getBasename(filename));
            }
        }
        return (String[])result.toArray((Object[])new String[result.size()]);
    }

    public Properties getMetaData() {
        return this.metaData;
    }
}

