/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Properties;
import org.campagnelab.goby.alignments.AlignmentPositionComparator;
import org.campagnelab.goby.alignments.AlignmentWriter;
import org.campagnelab.goby.alignments.Alignments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedSortingAlignmentWriter
implements AlignmentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BufferedSortingAlignmentWriter.class);
    private final AlignmentWriter delegate;
    private final ObjectHeapPriorityQueue<Alignments.AlignmentEntry> heap;
    private static final int DEFAULT_CAPACITY = 1000;
    private static final Comparator<? super Alignments.AlignmentEntry> GENOMIC_POSITION_COMPARATOR = new AlignmentPositionComparator();
    private int capacity;
    private int frontTargetIndex;
    private int frontPosition;
    private boolean check = true;

    public BufferedSortingAlignmentWriter(AlignmentWriter destination, int capacity) {
        this.capacity = capacity;
        this.delegate = destination;
        this.heap = new ObjectHeapPriorityQueue(capacity, GENOMIC_POSITION_COMPARATOR);
    }

    public BufferedSortingAlignmentWriter(AlignmentWriter destination) {
        this(destination, 1000);
    }

    @Override
    public void appendEntry(Alignments.AlignmentEntry entry) throws IOException {
        while (this.heap.size() > this.capacity) {
            Alignments.AlignmentEntry queueEntry = (Alignments.AlignmentEntry)this.heap.dequeue();
            this.checkFront(queueEntry);
            this.delegate.appendEntry(queueEntry);
        }
        this.heap.enqueue((Object)entry);
    }

    private void checkFront(Alignments.AlignmentEntry entry) {
        if (this.check) {
            int targetIndex = entry.getTargetIndex();
            int position = entry.getPosition();
            if (targetIndex < this.frontTargetIndex || targetIndex == this.frontTargetIndex && position < this.frontPosition) {
                this.delegate.setSorted(false);
                LOG.warn("Local sorting strategy failed to restore sort order. The destination has been marked as unsorted. You must sort the output manually to improve compression.");
                this.check = false;
            }
            if (this.frontTargetIndex != targetIndex) {
                this.frontPosition = 0;
            }
            this.frontTargetIndex = Math.max(this.frontTargetIndex, targetIndex);
            this.frontPosition = Math.max(this.frontPosition, position);
        }
    }

    @Override
    public void close() throws IOException {
        while (!this.heap.isEmpty()) {
            Alignments.AlignmentEntry queueEntry = (Alignments.AlignmentEntry)this.heap.dequeue();
            this.checkFront(queueEntry);
            this.delegate.appendEntry(queueEntry);
        }
        this.delegate.close();
    }

    @Override
    public void printStats(PrintStream out) {
        this.delegate.printStats(out);
    }

    @Override
    public void setStatistics(Properties statistics) {
        this.delegate.setStatistics(statistics);
    }

    @Override
    public void setSmallestSplitQueryIndex(int smallestSplitQueryIndex) {
        this.delegate.setSmallestSplitQueryIndex(smallestSplitQueryIndex);
    }

    @Override
    public void setLargestSplitQueryIndex(int largestSplitQueryIndex) {
        this.delegate.setLargestSplitQueryIndex(largestSplitQueryIndex);
    }

    @Override
    public void putStatistic(String description, double value) {
        this.delegate.putStatistic(description, value);
    }

    @Override
    public void putStatistic(String description, int value) {
        this.delegate.putStatistic(description, value);
    }

    @Override
    public void putStatistic(String description, String value) {
        this.delegate.putStatistic(description, value);
    }

    @Override
    public void setAlignerName(String alignerName) {
        this.delegate.setAlignerName(alignerName);
    }

    @Override
    public void setAlignerVersion(String alignerVersion) {
        this.delegate.setAlignerVersion(alignerVersion);
    }

    @Override
    public void setNumQueries(int numQueries) {
        this.delegate.setNumQueries(numQueries);
    }

    @Override
    public void setNumTargets(int numTargets) {
        this.delegate.setNumTargets(numTargets);
    }

    @Override
    public void setPermutation(boolean state) {
        this.delegate.setPermutation(state);
    }

    @Override
    public void setQueryIdentifiers(IndexedIdentifier queryIdentifiers) {
        this.delegate.setQueryIdentifiers(queryIdentifiers);
    }

    @Override
    public void setQueryIdentifiersArray(String[] queryIdentifiersArray) {
        this.delegate.setQueryIdentifiersArray(queryIdentifiersArray);
    }

    @Override
    public void setReadOriginInfo(ObjectArrayList<Alignments.ReadOriginInfo.Builder> readOriginInfoBuilderList) {
        this.delegate.setReadOriginInfo(readOriginInfoBuilderList);
    }

    @Override
    public void addReadOriginInfo(ObjectArrayList<Alignments.ReadOriginInfo.Builder> readOriginInfoBuilderList) {
        this.delegate.addReadOriginInfo(readOriginInfoBuilderList);
    }

    @Override
    public void setSorted(boolean sortedState) {
        this.delegate.setSorted(sortedState);
    }

    @Override
    public void setTargetIdentifiers(IndexedIdentifier targetIdentifiers) {
        this.delegate.setTargetIdentifiers(targetIdentifiers);
    }

    @Override
    public void setTargetIdentifiersArray(String[] targetIdentifiersArray) {
        this.delegate.setTargetIdentifiersArray(targetIdentifiersArray);
    }

    @Override
    public void setTargetLengths(int[] targetLengths) {
        this.delegate.setTargetLengths(targetLengths);
    }
}

