type token =
  | Equals
  | Plus
  | Comma
  | End_of_input
  | AttributeType of (string)
  | Oid of (string)
  | String of (string)
  | StringWithPair of (string)
  | HexString of (string)
  | QuoteString of (string)

open Parsing;;
let _ = parse_error;;
# 22 "src/ldap/ldap_dnparser.mly"
  open Ldap_types

  let unhex hex =
    match hex with
        '0' -> 0
      | '1' -> 1
      | '2' -> 2
      | '3' -> 3
      | '4' -> 4
      | '5' -> 5
      | '6' -> 6
      | '7' -> 7
      | '8' -> 8
      | '9' -> 9
      | 'a' -> 10
      | 'b' -> 11
      | 'c' -> 12
      | 'd' -> 13
      | 'e' -> 14
      | 'f' -> 15
      | _ -> failwith "invalid hex digit"

  let unescape_hexpair hex1 hex2 =
    (char_of_int
       ((lor)
          ((lsl) (unhex hex1) 4)
          (unhex hex2)))

  let unescape_stringwithpair s =
    let strm = Stream.of_string s in
    let buf = Buffer.create (String.length s) in
    let rec unescape strm buf =
      try
        match Stream.next strm with
            '\\' ->
              (match Stream.next strm with
                   (',' | '=' | '+' | '<' | '>' | '#' | ';' | '\\' | '"' | ' ') as c ->
                     Buffer.add_char buf c;
                     unescape strm buf
                 | ('0' .. '9' | 'A' .. 'F' | 'a' .. 'f') as hex1 ->
                     let hex2 = Stream.next strm in
                       Buffer.add_char buf (unescape_hexpair hex1 hex2);
                       unescape strm buf
                 | _ -> failwith "invalid escape sequence")
          | c -> Buffer.add_char buf c;unescape strm buf
      with Stream.Failure -> Buffer.contents buf
    in
      unescape strm buf

  let unescape_quotestring s =
    unescape_stringwithpair (String.sub s 1 ((String.length s) - 2))

  let unescape_hexstring s =
    let strm = Stream.of_string s in
    let buf = Buffer.create (String.length s) in
    let rec unescape strm buf =
      try
        let hex1 = Stream.next strm in
        let hex2 = Stream.next strm in
          Buffer.add_char buf (unescape_hexpair hex1 hex2);
          unescape strm buf
      with Stream.Failure -> Buffer.contents buf
    in
      match Stream.next strm with
          '#' -> unescape strm buf
        | _ -> failwith "invalid hexstring"
# 83 "src/ldap/ldap_dnparser.ml"
let yytransl_const = [|
  257 (* Equals *);
  258 (* Plus *);
  259 (* Comma *);
  260 (* End_of_input *);
    0|]

let yytransl_block = [|
  261 (* AttributeType *);
  262 (* Oid *);
  263 (* String *);
  264 (* StringWithPair *);
  265 (* HexString *);
  266 (* QuoteString *);
    0|]

let yylhs = "\255\255\
\002\000\002\000\002\000\002\000\002\000\002\000\003\000\003\000\
\001\000\001\000\001\000\001\000\000\000"

let yylen = "\002\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\005\000\005\000\004\000\001\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\012\000\007\000\008\000\013\000\000\000\000\000\
\001\000\002\000\003\000\004\000\005\000\006\000\000\000\000\000\
\000\000\011\000\009\000\010\000"

let yydgoto = "\002\000\
\006\000\015\000\007\000"

let yysindex = "\013\000\
\002\255\000\000\000\000\000\000\000\000\000\000\014\255\251\254\
\000\000\000\000\000\000\000\000\000\000\000\000\007\255\002\255\
\002\255\000\000\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000"

let yygindex = "\000\000\
\252\255\000\000\000\000"

let yytablesize = 15
let yytable = "\009\000\
\010\000\011\000\012\000\013\000\014\000\003\000\004\000\005\000\
\016\000\017\000\018\000\019\000\020\000\001\000\008\000"

let yycheck = "\005\001\
\006\001\007\001\008\001\009\001\010\001\004\001\005\001\006\001\
\002\001\003\001\004\001\016\000\017\000\001\000\001\001"

let yynames_const = "\
  Equals\000\
  Plus\000\
  Comma\000\
  End_of_input\000\
  "

let yynames_block = "\
  AttributeType\000\
  Oid\000\
  String\000\
  StringWithPair\000\
  HexString\000\
  QuoteString\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 102 "src/ldap/ldap_dnparser.mly"
                 (_1)
# 161 "src/ldap/ldap_dnparser.ml"
               : 'attrval))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 103 "src/ldap/ldap_dnparser.mly"
       (_1)
# 168 "src/ldap/ldap_dnparser.ml"
               : 'attrval))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 104 "src/ldap/ldap_dnparser.mly"
          (_1)
# 175 "src/ldap/ldap_dnparser.ml"
               : 'attrval))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 105 "src/ldap/ldap_dnparser.mly"
                  (unescape_stringwithpair _1)
# 182 "src/ldap/ldap_dnparser.ml"
               : 'attrval))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 106 "src/ldap/ldap_dnparser.mly"
             (unescape_hexstring _1)
# 189 "src/ldap/ldap_dnparser.ml"
               : 'attrval))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 107 "src/ldap/ldap_dnparser.mly"
               (unescape_quotestring _1)
# 196 "src/ldap/ldap_dnparser.ml"
               : 'attrval))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 111 "src/ldap/ldap_dnparser.mly"
                 (_1)
# 203 "src/ldap/ldap_dnparser.ml"
               : 'attrname))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 112 "src/ldap/ldap_dnparser.mly"
       (_1)
# 210 "src/ldap/ldap_dnparser.ml"
               : 'attrname))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'attrname) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'attrval) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ldap_types.dn) in
    Obj.repr(
# 117 "src/ldap/ldap_dnparser.mly"
  (match _5 with
       {attr_type=attr_name;attr_vals=vals} :: tl ->
         if _1 = attr_name then
           {attr_type=attr_name;attr_vals=(_3 :: vals)} :: tl
         else failwith ("invalid multivalued rdn, expected: " ^ _1)
     | [] -> [{attr_type=_1;attr_vals=[_3]}])
# 224 "src/ldap/ldap_dnparser.ml"
               : Ldap_types.dn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'attrname) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'attrval) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Ldap_types.dn) in
    Obj.repr(
# 123 "src/ldap/ldap_dnparser.mly"
                                    ({attr_type=_1;attr_vals=[_3]} :: _5)
# 233 "src/ldap/ldap_dnparser.ml"
               : Ldap_types.dn))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'attrname) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'attrval) in
    Obj.repr(
# 124 "src/ldap/ldap_dnparser.mly"
                                        ([{attr_type=_1;attr_vals=[_3]}])
# 241 "src/ldap/ldap_dnparser.ml"
               : Ldap_types.dn))
; (fun __caml_parser_env ->
    Obj.repr(
# 125 "src/ldap/ldap_dnparser.mly"
                ([])
# 247 "src/ldap/ldap_dnparser.ml"
               : Ldap_types.dn))
(* Entry dn *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let dn (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Ldap_types.dn)
