/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.spider;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.spider.Spider;
import org.parosproxy.paros.core.spider.SpiderListener;
import org.parosproxy.paros.core.spider.SpiderParam;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.spider.OptionsSpiderPanel;
import org.parosproxy.paros.extension.spider.PopupMenuSpider;
import org.parosproxy.paros.extension.spider.SpiderDialog;
import org.parosproxy.paros.extension.spider.SpiderPanel;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;

public class ExtensionSpider
extends ExtensionAdaptor
implements SpiderListener,
SessionChangedListener,
CommandLineListener {
    private static final int ARG_SPIDER_IDX = 0;
    private static final int ARG_URL_IDX = 1;
    private JMenuItem menuItemSpider = null;
    private SpiderDialog dialog = null;
    private Spider spider = null;
    private SiteMap siteTree = null;
    private SiteNode startNode = null;
    private PopupMenuSpider popupMenuSpider = null;
    private SpiderPanel spiderPanel = null;
    private OptionsSpiderPanel optionsSpiderPanel = null;
    private SpiderParam spiderParam = null;
    private CommandLineArgument[] arguments = new CommandLineArgument[2];

    public ExtensionSpider() {
        this.initialize();
    }

    public ExtensionSpider(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionSpider");
    }

    JMenuItem getMenuItemSpider() {
        if (this.menuItemSpider == null) {
            this.menuItemSpider = new JMenuItem();
            this.menuItemSpider.setText("Spider...");
            this.menuItemSpider.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTree jTree = ExtensionSpider.this.getView().getSiteTreePanel().getTreeSite();
                    SiteNode siteNode = (SiteNode)jTree.getLastSelectedPathComponent();
                    HttpMessage httpMessage = null;
                    if (siteNode == null) {
                        ExtensionSpider.this.getView().showWarningDialog("You need to visit the website via a browser first and select a URL/folder/node in the 'Sites' panel displayed.");
                        return;
                    }
                    ExtensionSpider.this.setStartNode(siteNode);
                    if (siteNode.isRoot()) {
                        ExtensionSpider.this.showDialog("All sites will be crawled");
                    } else {
                        try {
                            httpMessage = siteNode.getHistoryReference().getHttpMessage();
                        }
                        catch (Exception exception) {
                            return;
                        }
                        String string = httpMessage.getRequestHeader().getURI().toString();
                        ExtensionSpider.this.showDialog(string);
                    }
                }
            });
        }
        return this.menuItemSpider;
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addAnalyseMenuItem(this.getMenuItemSpider());
            extensionHook.getHookMenu().addAnalyseMenuItem(extensionHook.getHookMenu().getMenuSeparator());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuSpider());
            extensionHook.getHookView().addStatusPanel(this.getSpiderPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsSpiderPanel());
        }
        extensionHook.addSessionListener(this);
        extensionHook.addOptionsParamSet(this.getSpiderParam());
        extensionHook.addCommandLine(this.getCommandLineArguments());
    }

    public void startSpider() {
        this.siteTree = this.getModel().getSession().getSiteTree();
        if (this.startNode == null) {
            this.startNode = (SiteNode)this.siteTree.getRoot();
        }
        this.startSpider(this.startNode);
    }

    private void startSpider(SiteNode siteNode) {
        if (this.spider == null) {
            try {
                this.getModel().getDb().getTableHistory().deleteHistoryType(this.getModel().getSession().getSessionId(), 4);
                this.getModel().getDb().getTableHistory().deleteHistoryType(this.getModel().getSession().getSessionId(), 5);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.spider = new Spider(this.getSpiderParam(), this.getModel().getOptionsParam().getConnectionParam(), this.getModel());
            this.spider.addSpiderListener(this);
            this.inOrderSeed(this.spider, siteNode);
        }
        this.getSpiderPanel().setTabFocus();
        try {
            this.spider.start();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    private void inOrderSeed(Spider spider, SiteNode siteNode) {
        try {
            HttpMessage httpMessage;
            if (!siteNode.isRoot() && (httpMessage = siteNode.getHistoryReference().getHttpMessage()) != null && !httpMessage.getResponseHeader().isImage()) {
                spider.addSeed(httpMessage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!siteNode.isLeaf()) {
            for (int i = 0; i < siteNode.getChildCount(); ++i) {
                try {
                    this.inOrderSeed(spider, (SiteNode)siteNode.getChildAt(i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void spiderComplete() {
        try {
            this.getModel().getDb().getTableHistory().deleteHistoryType(this.getModel().getSession().getSessionId(), 4);
            this.getModel().getDb().getTableHistory().deleteHistoryType(this.getModel().getSession().getSessionId(), 5);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        if (this.getView() != null) {
            this.getMenuItemSpider().setEnabled(true);
            this.getPopupMenuSpider().setEnabled(true);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getView() != null && this.dialog != null) {
            if (EventQueue.isDispatchThread()) {
                this.dialog.dispose();
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ExtensionSpider.this.dialog.dispose();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void foundURI(HttpMessage httpMessage, boolean bl) {
        if (this.getView() != null) {
            if (bl) {
                this.getSpiderPanel().appendFoundButSkip(httpMessage.getRequestHeader().getURI().toString() + "\n");
            } else {
                this.getSpiderPanel().appendFound(httpMessage.getRequestHeader().getURI().toString() + "\n");
            }
        }
    }

    public void readURI(HttpMessage httpMessage) {
        SiteMap siteMap = this.getModel().getSession().getSiteTree();
        HttpMessage httpMessage2 = siteMap.pollPath(httpMessage);
        HistoryReference historyReference = null;
        try {
            historyReference = new HistoryReference(this.getModel().getSession(), 2, httpMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        siteMap.addPath(historyReference, httpMessage);
    }

    public Spider getSpider() {
        return this.spider;
    }

    public void spiderProgress(final URI uRI, final int n, final int n2, final int n3) {
        String string = "";
        if (this.dialog != null) {
            if (EventQueue.isDispatchThread()) {
                this.dialog.getTxtNumCrawled().setText(Integer.toString(n2));
                this.dialog.getTxtOutstandingCrawl().setText(Integer.toString(n3));
                this.dialog.getProgressBar().setValue(n);
                string = "";
                if (uRI != null) {
                    string = uRI.toString();
                }
                this.dialog.getTxtDisplay().setText(string);
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        String string = "";
                        ExtensionSpider.this.dialog.getTxtNumCrawled().setText(Integer.toString(n2));
                        ExtensionSpider.this.dialog.getTxtOutstandingCrawl().setText(Integer.toString(n3));
                        ExtensionSpider.this.dialog.getProgressBar().setValue(n);
                        if (uRI != null) {
                            string = uRI.toString();
                        }
                        ExtensionSpider.this.dialog.getTxtDisplay().setText(string);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SiteNode getStartNode() {
        return this.startNode;
    }

    public void setStartNode(SiteNode siteNode) {
        this.startNode = siteNode;
    }

    void showDialog(String string) {
        this.dialog = new SpiderDialog((Frame)this.getView().getMainFrame(), false);
        this.dialog.setPlugin(this);
        this.dialog.setVisible(true);
        this.dialog.getTxtDisplay().setText(string);
        this.spider = null;
    }

    PopupMenuSpider getPopupMenuSpider() {
        if (this.popupMenuSpider == null) {
            this.popupMenuSpider = new PopupMenuSpider();
            this.popupMenuSpider.setExtension(this);
        }
        return this.popupMenuSpider;
    }

    void clear() {
        this.spider = null;
        System.gc();
    }

    private SpiderPanel getSpiderPanel() {
        if (this.spiderPanel == null) {
            this.spiderPanel = new SpiderPanel();
        }
        return this.spiderPanel;
    }

    public void sessionChanged(Session session) {
        this.getSpiderPanel().clear();
    }

    private OptionsSpiderPanel getOptionsSpiderPanel() {
        if (this.optionsSpiderPanel == null) {
            this.optionsSpiderPanel = new OptionsSpiderPanel();
        }
        return this.optionsSpiderPanel;
    }

    private SpiderParam getSpiderParam() {
        if (this.spiderParam == null) {
            this.spiderParam = new SpiderParam();
        }
        return this.spiderParam;
    }

    public void execute(CommandLineArgument[] commandLineArgumentArray) {
        String string = null;
        if (!this.arguments[1].isEnabled() && this.arguments[0].isEnabled()) {
            return;
        }
        this.spider = new Spider(this.getSpiderParam(), this.getModel().getOptionsParam().getConnectionParam(), this.getModel());
        this.spider.addSpiderListener(this);
        if (this.arguments[1].isEnabled()) {
            Vector vector = this.arguments[1].getArguments();
            for (int i = 0; i < vector.size(); ++i) {
                string = (String)vector.get(i);
                try {
                    System.out.println("Adding seed " + string);
                    this.spider.addSeed(new URI(string, true));
                    continue;
                }
                catch (URIException uRIException) {
                    uRIException.printStackTrace();
                }
            }
        }
        if (this.arguments[0].isEnabled()) {
            System.out.println("Starting spider...");
            this.spider.start();
        }
        while (!this.spider.isStop()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("Spider completed.");
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-spider", 0, null, "", "-spider : run spider.  See other parameters");
        this.arguments[1] = new CommandLineArgument("-seed", -1, "https{0,1}://\\S+", "Seed should be a URL", "-seed {URL1} {URL2} ... : Add seeds to the spider for crawling.");
        return this.arguments;
    }
}

