/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.persistence;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Serializer;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.restclient.bean.Auth;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.bean.TestExceptionResult;
import org.wiztools.restclient.bean.TestResult;
import org.wiztools.restclient.persistence.PersistenceWrite;
import org.wiztools.restclient.persistence.XMLException;
import org.wiztools.restclient.persistence.XmlAuthUtil;
import org.wiztools.restclient.persistence.XmlBodyWrite;
import org.wiztools.restclient.persistence.XmlSslUtil;
import org.wiztools.restclient.util.Util;
import org.wiztools.restclient.util.XMLUtil;

public class XmlPersistenceWrite
implements PersistenceWrite {
    private Element getRootElement() {
        Element eRoot = new Element("rest-client");
        eRoot.addAttribute(new Attribute("version", "3.7.2"));
        return eRoot;
    }

    protected Element getRequestElement(Request bean) {
        String testScript;
        ReqEntity entityBean;
        List<HttpCookie> cookies;
        MultiValueMap<String, String> headers;
        Element reqElement = new Element("request");
        Element e = new Element("http-version");
        e.appendChild(bean.getHttpVersion().versionNumber());
        reqElement.appendChild(e);
        if (bean.isFollowRedirect()) {
            e = new Element("http-follow-redirects");
            reqElement.appendChild(e);
        }
        if (bean.isIgnoreResponseBody()) {
            e = new Element("ignore-response-body");
            reqElement.appendChild(e);
        }
        e = new Element("URL");
        e.appendChild(bean.getUrl().toString());
        reqElement.appendChild(e);
        e = new Element("method");
        e.appendChild(bean.getMethod().name());
        reqElement.appendChild(e);
        Auth auth = bean.getAuth();
        if (auth != null) {
            Element eAuth = XmlAuthUtil.getAuthElement(auth);
            reqElement.appendChild(eAuth);
        }
        if (bean.getSslReq() != null) {
            Element eSsl = XmlSslUtil.getSslReq(bean.getSslReq());
            reqElement.appendChild(eSsl);
        }
        if (!(headers = bean.getHeaders()).isEmpty()) {
            Element e2 = new Element("headers");
            for (String string : headers.keySet()) {
                for (String value : headers.get(string)) {
                    Element ee = new Element("header");
                    ee.addAttribute(new Attribute("key", string));
                    ee.addAttribute(new Attribute("value", value));
                    e2.appendChild(ee);
                }
            }
            reqElement.appendChild(e2);
        }
        if (!(cookies = bean.getCookies()).isEmpty()) {
            Element e3 = new Element("cookies");
            for (HttpCookie cookie : cookies) {
                Element ee = new Element("cookie");
                ee.addAttribute(new Attribute("name", cookie.getName()));
                ee.addAttribute(new Attribute("value", cookie.getValue()));
                ee.addAttribute(new Attribute("version", String.valueOf(cookie.getVersion())));
                e3.appendChild(ee);
            }
            reqElement.appendChild(e3);
        }
        if ((entityBean = bean.getBody()) != null) {
            XmlBodyWrite xmlBodyWrite = new XmlBodyWrite();
            Element e4 = xmlBodyWrite.getReqEntity(entityBean);
            reqElement.appendChild(e4);
        }
        if ((testScript = bean.getTestScript()) != null) {
            Element element = new Element("test-script");
            element.appendChild(testScript);
            reqElement.appendChild(element);
        }
        return reqElement;
    }

    protected Document request2XML(Request bean) throws XMLException {
        Element reqRootElement = this.getRootElement();
        reqRootElement.appendChild(this.getRequestElement(bean));
        Document xomDocument = new Document(reqRootElement);
        return xomDocument;
    }

    protected Element getResponseElement(Response bean) {
        TestResult testResult;
        byte[] responseBody;
        Element respElement = new Element("response");
        Element respChildSubElement = null;
        Element respChildSubSubElement = null;
        respChildSubElement = new Element("execution-time");
        respChildSubElement.appendChild(String.valueOf(bean.getExecutionTime()));
        respElement.appendChild(respChildSubElement);
        respChildSubElement = new Element("status");
        Attribute codeAttributes = new Attribute("code", String.valueOf(bean.getStatusCode()));
        respChildSubElement.addAttribute(codeAttributes);
        respChildSubElement.appendChild(bean.getStatusLine());
        respElement.appendChild(respChildSubElement);
        MultiValueMap<String, String> headers = bean.getHeaders();
        if (!headers.isEmpty()) {
            Attribute keyAttribute = null;
            Attribute valueAttribute = null;
            respChildSubElement = new Element("headers");
            for (String key : headers.keySet()) {
                for (String value : headers.get(key)) {
                    respChildSubSubElement = new Element("header");
                    keyAttribute = new Attribute("key", key);
                    valueAttribute = new Attribute("value", value);
                    respChildSubSubElement.addAttribute(keyAttribute);
                    respChildSubSubElement.addAttribute(valueAttribute);
                    respChildSubElement.appendChild(respChildSubSubElement);
                }
            }
            respElement.appendChild(respChildSubElement);
        }
        if ((responseBody = bean.getResponseBody()) != null) {
            respChildSubElement = new Element("body");
            String base64encodedBody = Util.base64encode(responseBody);
            respChildSubElement.appendChild(base64encodedBody);
            respElement.appendChild(respChildSubElement);
        }
        if ((testResult = bean.getTestResult()) != null) {
            Element e_line;
            Element e_message;
            List<TestExceptionResult> l;
            respChildSubElement = new Element("test-result");
            Element e_runCount = new Element("run-count");
            e_runCount.appendChild(String.valueOf(testResult.getRunCount()));
            Element e_failureCount = new Element("failure-count");
            e_failureCount.appendChild(String.valueOf(testResult.getFailureCount()));
            Element e_errorCount = new Element("error-count");
            e_errorCount.appendChild(String.valueOf(testResult.getErrorCount()));
            respChildSubElement.appendChild(e_runCount);
            respChildSubElement.appendChild(e_failureCount);
            respChildSubElement.appendChild(e_errorCount);
            if (testResult.getFailureCount() > 0) {
                Element e_failures = new Element("failures");
                l = testResult.getFailures();
                for (TestExceptionResult b : l) {
                    e_message = new Element("message");
                    e_message.appendChild(b.getExceptionMessage());
                    e_line = new Element("line-number");
                    e_line.appendChild(String.valueOf(b.getLineNumber()));
                    Element e_failure = new Element("failure");
                    e_failure.appendChild(e_message);
                    e_failure.appendChild(e_line);
                    e_failures.appendChild(e_failure);
                }
                respChildSubElement.appendChild(e_failures);
            }
            if (testResult.getErrorCount() > 0) {
                Element e_errors = new Element("errors");
                l = testResult.getErrors();
                for (TestExceptionResult b : l) {
                    e_message = new Element("message");
                    e_message.appendChild(b.getExceptionMessage());
                    e_line = new Element("line-number");
                    e_line.appendChild(String.valueOf(b.getLineNumber()));
                    Element e_error = new Element("error");
                    e_error.appendChild(e_message);
                    e_error.appendChild(e_line);
                    e_errors.appendChild(e_error);
                }
                respChildSubElement.appendChild(e_errors);
            }
            Element e_trace = new Element("trace");
            e_trace.appendChild(testResult.toString());
            respChildSubElement.appendChild(e_trace);
            respElement.appendChild(respChildSubElement);
        }
        return respElement;
    }

    protected Document response2XML(Response bean) throws XMLException {
        Element respRootElement = this.getRootElement();
        respRootElement.appendChild(this.getResponseElement(bean));
        Document xomDocument = new Document(respRootElement);
        return xomDocument;
    }

    protected void writeXML(Document doc, File f) throws IOException, XMLException {
        try {
            OutputStream out = new FileOutputStream(f);
            out = new BufferedOutputStream(out);
            Serializer serializer = new Serializer(out, XMLUtil.getDocumentCharset(f));
            serializer.write(doc);
            out.close();
        }
        catch (IOException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
    }

    @Override
    public void writeRequest(Request bean, File f) throws IOException, XMLException {
        Document doc = this.request2XML(bean);
        this.writeXML(doc, f);
    }

    @Override
    public void writeResponse(Response bean, File f) throws IOException, XMLException {
        Document doc = this.response2XML(bean);
        this.writeXML(doc, f);
    }
}

