/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqgo;

import com.jidesoft.swing.AutoCompletion;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.wiztools.restclient.ui.reqgo.UrlListPersistUtil;

public class UrlComboBox
extends JComboBox<String> {
    private static final Logger LOG = Logger.getLogger(UrlComboBox.class.getName());
    private final int URL_COUNT_SIZE = 20;

    public UrlComboBox() {
        this.setToolTipText("URL");
        this.setEditable(true);
        final JTextField editorComponent = (JTextField)this.getEditor().getEditorComponent();
        editorComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                editorComponent.selectAll();
            }
        });
        AutoCompletion ac = new AutoCompletion(this);
        ac.setStrict(false);
        ac.setStrictCompletion(false);
    }

    @PostConstruct
    protected void loadComboHistory() {
        try {
            List<String> urls = UrlListPersistUtil.load();
            if (!urls.isEmpty()) {
                Dimension d = this.getPreferredSize();
                for (String url : urls) {
                    this.addItem(url);
                }
                this.setPreferredSize(d);
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
    }

    @PostConstruct
    protected void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ArrayList<String> urls = new ArrayList<String>();
                for (int i = 0; i < UrlComboBox.this.getItemCount(); ++i) {
                    String url = (String)UrlComboBox.this.getItemAt(i);
                    urls.add(url);
                }
                try {
                    UrlListPersistUtil.persist(urls);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
        });
    }

    public void push() {
        String item = (String)this.getSelectedItem();
        int count = this.getItemCount();
        LinkedList<String> l = new LinkedList<String>();
        for (int i = 0; i < count; ++i) {
            l.add((String)this.getItemAt(i));
        }
        if (l.contains(item)) {
            this.removeItem(item);
            this.insertItemAt(item, 0);
        } else if (item.trim().length() != 0) {
            if (count >= 20) {
                this.removeItemAt(count - 1);
            }
            this.insertItemAt(item, 0);
        }
        this.setSelectedItem(item);
    }
}

