require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_RISCV_SYSREG_H_)) {
    eval 'sub _RISCV_SYSREG_H_ () {1;}' unless defined(&_RISCV_SYSREG_H_);
    unless(defined(&_KERNEL)) {
	require 'sys/param.ph';
    }
    require 'riscv/reg.ph';
    eval 'sub FCSR_FMASK () {0;}' unless defined(&FCSR_FMASK);
    eval 'sub FCSR_FRM () { &__BITS(7, 5);}' unless defined(&FCSR_FRM);
    eval 'sub FCSR_FRM_RNE () {0 &b000;}' unless defined(&FCSR_FRM_RNE);
    eval 'sub FCSR_FRM_RTZ () {0 &b001;}' unless defined(&FCSR_FRM_RTZ);
    eval 'sub FCSR_FRM_RDN () {0 &b010;}' unless defined(&FCSR_FRM_RDN);
    eval 'sub FCSR_FRM_RUP () {0 &b011;}' unless defined(&FCSR_FRM_RUP);
    eval 'sub FCSR_FRM_RMM () {0 &b100;}' unless defined(&FCSR_FRM_RMM);
    eval 'sub FCSR_FRM_DYN () {0 &b111;}' unless defined(&FCSR_FRM_DYN);
    eval 'sub FCSR_FFLAGS () { &__BITS(4, 0);}' unless defined(&FCSR_FFLAGS);
    eval 'sub FCSR_NV () { &__BIT(4);}' unless defined(&FCSR_NV);
    eval 'sub FCSR_DZ () { &__BIT(3);}' unless defined(&FCSR_DZ);
    eval 'sub FCSR_OF () { &__BIT(2);}' unless defined(&FCSR_OF);
    eval 'sub FCSR_UF () { &__BIT(1);}' unless defined(&FCSR_UF);
    eval 'sub FCSR_NX () { &__BIT(0);}' unless defined(&FCSR_NX);
    eval 'sub fcsr_read {
        my($void) = @_;
	    eval q({  &uint32_t  &__fcsr;  &asm(\\"frcsr %0\\" : \\"=r\\"( &__fcsr) :: \\"memory\\");  &__fcsr; });
    }' unless defined(&fcsr_read);
    eval 'sub fcsr_write {
        my($__new) = @_;
	    eval q({  &uint32_t  &__old;  &asm  &volatile(\\"fscsr %0, %1\\" : \\"=r\\"( &__old) : \\"r\\"($__new) : \\"memory\\");  &__old; });
    }' unless defined(&fcsr_write);
    eval 'sub fcsr_fflags_read {
        my($void) = @_;
	    eval q({  &uint32_t  &__old;  &asm(\\"frflags %0\\" : \\"=r\\"( &__old) :: \\"memory\\");  &__old; });
    }' unless defined(&fcsr_fflags_read);
    eval 'sub fcsr_fflags_write {
        my($__new) = @_;
	    eval q({  &uint32_t  &__old;  &asm  &volatile(\\"fsflags %0, %1\\" : \\"=r\\"( &__old) : \\"r\\"($__new) : \\"memory\\");  &__old; });
    }' unless defined(&fcsr_fflags_write);
    eval 'sub fcsr_frm_read {
        my($void) = @_;
	    eval q({  &uint32_t  &__old;  &asm(\\"frrm\\\\t%0\\" : \\"=r\\"( &__old) :: \\"memory\\");  &__old; });
    }' unless defined(&fcsr_frm_read);
    eval 'sub fcsr_frm_write {
        my($__new) = @_;
	    eval q({  &uint32_t  &__old;  &asm  &volatile(\\"fsrm\\\\t%0, %1\\" : \\"=r\\"( &__old) : \\"r\\"($__new) : \\"memory\\");  &__old; });
    }' unless defined(&fcsr_frm_write);
    eval 'sub RISCVREG_READ_INLINE {
        my($regname) = @_;
	    eval q( &static  &inline  &uintptr_t  &csr_$regname &_read( &void) {  &uintptr_t  &__rv;  &asm  &volatile(\\"csrr %0, \\" $regname : \\"=r\\"( &__rv) :: \\"memory\\");  &return  &__rv; });
    }' unless defined(&RISCVREG_READ_INLINE);
    eval 'sub RISCVREG_WRITE_INLINE {
        my($regname) = @_;
	    eval q( &static  &inline  &void  &csr_$regname &_write( &uintptr_t  &__val) {  &asm  &volatile(\\"csrw \\" $regname \\", %0\\" :: \\"r\\"( &__val) : \\"memory\\"); });
    }' unless defined(&RISCVREG_WRITE_INLINE);
    eval 'sub RISCVREG_SET_INLINE {
        my($regname) = @_;
	    eval q( &static  &inline  &void  &csr_$regname &_set( &uintptr_t  &__mask) {  &if ( &__builtin_constant_p( &__mask)  &&  &__mask < 0x20) {  &asm  &volatile(\\"csrsi \\" $regname \\", %0\\" :: \\"i\\"( &__mask) : \\"memory\\"); }  &else {  &asm  &volatile(\\"csrs \\" $regname \\", %0\\" :: \\"r\\"( &__mask) : \\"memory\\"); } });
    }' unless defined(&RISCVREG_SET_INLINE);
    eval 'sub RISCVREG_CLEAR_INLINE {
        my($regname) = @_;
	    eval q( &static  &inline  &void  &csr_$regname &_clear( &uintptr_t  &__mask) {  &if ( &__builtin_constant_p( &__mask)  &&  &__mask < 0x20) {  &asm  &volatile(\\"csrci \\" $regname \\", %0\\" :: \\"i\\"( &__mask) : \\"memory\\"); }  &else {  &asm  &volatile(\\"csrc \\" $regname \\", %0\\" :: \\"r\\"( &__mask) : \\"memory\\"); } });
    }' unless defined(&RISCVREG_CLEAR_INLINE);
    eval 'sub RISCVREG_READ_WRITE_INLINE {
        my($regname) = @_;
	    eval q( &RISCVREG_READ_INLINE($regname)  &RISCVREG_WRITE_INLINE($regname));
    }' unless defined(&RISCVREG_READ_WRITE_INLINE);
    eval 'sub RISCVREG_SET_CLEAR_INLINE {
        my($regname) = @_;
	    eval q( &RISCVREG_SET_INLINE($regname)  &RISCVREG_CLEAR_INLINE($regname));
    }' unless defined(&RISCVREG_SET_CLEAR_INLINE);
    eval 'sub RISCVREG_READ_SET_CLEAR_INLINE {
        my($regname) = @_;
	    eval q( &RISCVREG_READ_INLINE($regname)  &RISCVREG_SET_CLEAR_INLINE($regname));
    }' unless defined(&RISCVREG_READ_SET_CLEAR_INLINE);
    eval 'sub RISCVREG_READ_WRITE_SET_CLEAR_INLINE {
        my($regname) = @_;
	    eval q( &RISCVREG_READ_WRITE_INLINE($regname)  &RISCVREG_SET_CLEAR_INLINE($regname));
    }' unless defined(&RISCVREG_READ_WRITE_SET_CLEAR_INLINE);
    if(defined(&_LP64)) {
	eval 'sub SR_WPRI () { &__BITS(62, 34) |  &__BITS(31, 20) |  &__BIT(17) |  &__BITS(12, 11) |  &__BIT(7) |  &__BITS(4, 2) |  &__BIT(0);}' unless defined(&SR_WPRI);
	eval 'sub SR_SD () { &__BIT(63);}' unless defined(&SR_SD);
	eval 'sub SR_UXL () { &__BITS(33, 32);}' unless defined(&SR_UXL);
	eval 'sub SR_UXL_32 () {1;}' unless defined(&SR_UXL_32);
	eval 'sub SR_UXL_64 () {2;}' unless defined(&SR_UXL_64);
	eval 'sub SR_UXL_128 () {3;}' unless defined(&SR_UXL_128);
    } else {
	eval 'sub SR_WPRI () { &__BITS(30, 20) |  &__BIT(17) |  &__BITS(12, 11) |  &__BIT(7) |  &__BITS(4, 2) |  &__BIT(0);}' unless defined(&SR_WPRI);
	eval 'sub SR_SD () { &__BIT(31);}' unless defined(&SR_SD);
    }
    eval 'sub SR_MXR () { &__BIT(19);}' unless defined(&SR_MXR);
    eval 'sub SR_SUM () { &__BIT(18);}' unless defined(&SR_SUM);
    eval 'sub SR_XS () { &__BITS(16, 15);}' unless defined(&SR_XS);
    eval 'sub SR_XS_OFF () {0;}' unless defined(&SR_XS_OFF);
    eval 'sub SR_XS_SOME_ON () {1;}' unless defined(&SR_XS_SOME_ON);
    eval 'sub SR_XS_SOME_CLEAN () {2;}' unless defined(&SR_XS_SOME_CLEAN);
    eval 'sub SR_XS_SOME_DIRTY () {3;}' unless defined(&SR_XS_SOME_DIRTY);
    eval 'sub SR_FS () { &__BITS(14, 13);}' unless defined(&SR_FS);
    eval 'sub SR_FS_OFF () {0;}' unless defined(&SR_FS_OFF);
    eval 'sub SR_FS_INITIAL () {1;}' unless defined(&SR_FS_INITIAL);
    eval 'sub SR_FS_CLEAN () {2;}' unless defined(&SR_FS_CLEAN);
    eval 'sub SR_FS_DIRTY () {3;}' unless defined(&SR_FS_DIRTY);
    eval 'sub SR_VS () { &__BITS(10, 9);}' unless defined(&SR_VS);
    eval 'sub SR_VS_OFF () { &SR_FS_OFF;}' unless defined(&SR_VS_OFF);
    eval 'sub SR_VS_INITIAL () { &SR_FS_INITIAL;}' unless defined(&SR_VS_INITIAL);
    eval 'sub SR_VS_CLEAN () { &SR_FS_CLEAN;}' unless defined(&SR_VS_CLEAN);
    eval 'sub SR_VS_DIRTY () { &SR_FS_DIRTY;}' unless defined(&SR_VS_DIRTY);
    eval 'sub SR_SPP () { &__BIT(8);}' unless defined(&SR_SPP);
    eval 'sub SR_UBE () { &__BIT(6);}' unless defined(&SR_UBE);
    eval 'sub SR_SPIE () { &__BIT(5);}' unless defined(&SR_SPIE);
    eval 'sub SR_SIE () { &__BIT(1);}' unless defined(&SR_SIE);
    eval 'sub SIP_SEIP () { &__BIT(9);}' unless defined(&SIP_SEIP);
    eval 'sub SIP_STIP () { &__BIT(5);}' unless defined(&SIP_STIP);
    eval 'sub SIP_SSIP () { &__BIT(1);}' unless defined(&SIP_SSIP);
    eval 'sub SIE_SEIE () { &__BIT(9);}' unless defined(&SIE_SEIE);
    eval 'sub SIE_STIE () { &__BIT(5);}' unless defined(&SIE_STIE);
    eval 'sub SIE_SSIE () { &__BIT(1);}' unless defined(&SIE_SSIE);
    if(defined(&_LP64)) {
	eval 'sub SR_USER64 () {( &SR_SPIE |  &__SHIFTIN( &SR_UXL_64,  &SR_UXL));}' unless defined(&SR_USER64);
	eval 'sub SR_USER32 () {( &SR_SPIE |  &__SHIFTIN( &SR_UXL_32,  &SR_UXL));}' unless defined(&SR_USER32);
    } else {
	eval 'sub SR_USER () {( &SR_SPIE);}' unless defined(&SR_USER);
    }
    eval 'sub CAUSE_INTERRUPT_P {
        my($cause) = @_;
	    eval q((($cause) &  &__BIT( &XLEN - 1)));
    }' unless defined(&CAUSE_INTERRUPT_P);
    eval 'sub CAUSE_CODE {
        my($cause) = @_;
	    eval q((($cause) &  &__BITS( &XLEN - 2, 0)));
    }' unless defined(&CAUSE_CODE);
    eval 'sub CAUSE_FETCH_MISALIGNED () {0;}' unless defined(&CAUSE_FETCH_MISALIGNED);
    eval 'sub CAUSE_FETCH_ACCESS () {1;}' unless defined(&CAUSE_FETCH_ACCESS);
    eval 'sub CAUSE_ILLEGAL_INSTRUCTION () {2;}' unless defined(&CAUSE_ILLEGAL_INSTRUCTION);
    eval 'sub CAUSE_BREAKPOINT () {3;}' unless defined(&CAUSE_BREAKPOINT);
    eval 'sub CAUSE_LOAD_MISALIGNED () {4;}' unless defined(&CAUSE_LOAD_MISALIGNED);
    eval 'sub CAUSE_LOAD_ACCESS () {5;}' unless defined(&CAUSE_LOAD_ACCESS);
    eval 'sub CAUSE_STORE_MISALIGNED () {6;}' unless defined(&CAUSE_STORE_MISALIGNED);
    eval 'sub CAUSE_STORE_ACCESS () {7;}' unless defined(&CAUSE_STORE_ACCESS);
    eval 'sub CAUSE_USER_ECALL () {8;}' unless defined(&CAUSE_USER_ECALL);
    eval 'sub CAUSE_SYSCALL () { &CAUSE_USER_ECALL;}' unless defined(&CAUSE_SYSCALL);
    eval 'sub CAUSE_SUPERVISOR_ECALL () {9;}' unless defined(&CAUSE_SUPERVISOR_ECALL);
    eval 'sub CAUSE_MACHINE_ECALL () {11;}' unless defined(&CAUSE_MACHINE_ECALL);
    eval 'sub CAUSE_FETCH_PAGE_FAULT () {12;}' unless defined(&CAUSE_FETCH_PAGE_FAULT);
    eval 'sub CAUSE_LOAD_PAGE_FAULT () {13;}' unless defined(&CAUSE_LOAD_PAGE_FAULT);
    eval 'sub CAUSE_STORE_PAGE_FAULT () {15;}' unless defined(&CAUSE_STORE_PAGE_FAULT);
    eval 'sub IRQ_SUPERVISOR_SOFTWARE () {1;}' unless defined(&IRQ_SUPERVISOR_SOFTWARE);
    eval 'sub IRQ_VIRTUAL_SUPERVISOR_SOFTWARE () {2;}' unless defined(&IRQ_VIRTUAL_SUPERVISOR_SOFTWARE);
    eval 'sub IRQ_MACHINE_SOFTWARE () {3;}' unless defined(&IRQ_MACHINE_SOFTWARE);
    eval 'sub IRQ_SUPERVISOR_TIMER () {5;}' unless defined(&IRQ_SUPERVISOR_TIMER);
    eval 'sub IRQ_VIRTUAL_SUPERVISOR_TIMER () {6;}' unless defined(&IRQ_VIRTUAL_SUPERVISOR_TIMER);
    eval 'sub IRQ_MACHINE_TIMER () {7;}' unless defined(&IRQ_MACHINE_TIMER);
    eval 'sub IRQ_SUPERVISOR_EXTERNAL () {9;}' unless defined(&IRQ_SUPERVISOR_EXTERNAL);
    eval 'sub IRQ_VIRTUAL_SUPERVISOR_EXTERNAL () {10;}' unless defined(&IRQ_VIRTUAL_SUPERVISOR_EXTERNAL);
    eval 'sub IRQ_MACHINE_EXTERNAL () {11;}' unless defined(&IRQ_MACHINE_EXTERNAL);
    eval 'sub IRQ_SUPERVISOR_GUEST_EXTERNAL () {12;}' unless defined(&IRQ_SUPERVISOR_GUEST_EXTERNAL);
    eval 'sub IRQ_NSOURCES () {16;}' unless defined(&IRQ_NSOURCES);
    if(defined(&_LP64)) {
    } else {
	eval 'sub csr_cycle_read {
	    my($void) = @_;
    	    eval q({  &uint32_t  &__hi0,  &__hi1,  &__lo0;  &do {  &asm  &volatile( \\"csrr\\\\t%[__hi0], cycleh\\" \\"\\\\n\\\\t\\" \\"csrr\\\\t%[__lo0], cycle\\" \\"\\\\n\\\\t\\" \\"csrr\\\\t%[__hi1], cycleh\\" : [ &__hi0] \\"=r\\"( &__hi0), [ &__lo0] \\"=r\\"( &__lo0), [ &__hi1] \\"=r\\"( &__hi1)); }  &while ( &__hi0 !=  &__hi1);  &__SHIFTIN( &__hi0,  &__BITS(63, 32)) |  &__SHIFTIN( &__lo0,  &__BITS(31, 0)); });
	}' unless defined(&csr_cycle_read);
    }
    if(defined(&_LP64)) {
	eval 'sub SATP_MODE () { &__BITS(63, 60);}' unless defined(&SATP_MODE);
	eval 'sub SATP_MODE_BARE () {0;}' unless defined(&SATP_MODE_BARE);
	eval 'sub SATP_MODE_SV39 () {8;}' unless defined(&SATP_MODE_SV39);
	eval 'sub SATP_MODE_SV48 () {9;}' unless defined(&SATP_MODE_SV48);
	eval 'sub SATP_MODE_SV57 () {10;}' unless defined(&SATP_MODE_SV57);
	eval 'sub SATP_MODE_SV64 () {11;}' unless defined(&SATP_MODE_SV64);
	eval 'sub SATP_ASID () { &__BITS(59, 44);}' unless defined(&SATP_ASID);
	eval 'sub SATP_PPN () { &__BITS(43, 0);}' unless defined(&SATP_PPN);
    } else {
	eval 'sub SATP_MODE () { &__BIT(31);}' unless defined(&SATP_MODE);
	eval 'sub SATP_MODE_BARE () {0;}' unless defined(&SATP_MODE_BARE);
	eval 'sub SATP_MODE_SV32 () {1;}' unless defined(&SATP_MODE_SV32);
	eval 'sub SATP_ASID () { &__BITS(30, 22);}' unless defined(&SATP_ASID);
	eval 'sub SATP_PPN () { &__BITS(21, 0);}' unless defined(&SATP_PPN);
    }
    eval 'sub csr_asid_write {
        my($asid) = @_;
	    eval q({  &uintptr_t  &satp =  &csr_satp_read();  &satp &= ~ &SATP_ASID;  &satp |=  &__SHIFTIN($asid,  &SATP_ASID);  &csr_satp_write( &satp); });
    }' unless defined(&csr_asid_write);
}
1;
