/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityMap<E> {
    int first;
    int base;
    int size;
    Object[] elements = new Object[1];

    public E put(int key, E value) {
        E rc = null;
        if (this.isEmpty()) {
            this.base = key;
            this.elements[0] = value;
            this.first = 0;
        } else if (key > this.base) {
            int index = key - this.base;
            if (this.elements.length <= index) {
                this.resize(index + 1, 0);
            }
            if (index < this.first) {
                this.first = index;
            }
            rc = this.element(index);
            this.elements[index] = value;
        } else {
            int oldLastIndex = this.indexOfLast();
            int newLastIndex = this.base + oldLastIndex - key;
            this.resize(newLastIndex + 1, this.first + (this.base - key), oldLastIndex - this.first + 1);
            this.elements[0] = value;
            this.first = 0;
        }
        if (rc == null) {
            ++this.size;
        }
        return rc;
    }

    private int indexOfLast() {
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (this.elements[i] == null) continue;
            return i;
        }
        return -1;
    }

    private void resize(int newSize, int firstOffset) {
        int count = Math.min(this.elements.length - this.first, newSize);
        this.resize(newSize, firstOffset, count);
    }

    private void resize(int newSize, int firstOffset, int copyCount) {
        Object[] t;
        if (this.elements.length == newSize) {
            t = this.elements;
            System.arraycopy(this.elements, this.first, t, firstOffset, copyCount);
            Arrays.fill(t, 0, firstOffset, null);
        } else {
            t = new Object[newSize];
            System.arraycopy(this.elements, this.first, t, firstOffset, copyCount);
        }
        this.base += this.first - firstOffset;
        this.elements = t;
    }

    public E get(int priority) {
        int index = priority - this.base;
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        return this.element(index);
    }

    private E element(int index) {
        return (E)this.elements[index];
    }

    public E remove(int priority) {
        int index = priority - this.base;
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        E rc = this.element(index);
        this.elements[index] = null;
        if (rc != null) {
            --this.size;
        }
        return rc;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public E firstValue() {
        if (this.size == 0) {
            return null;
        }
        E rc = this.element(this.first);
        while (rc == null) {
            ++this.first;
            rc = this.element(this.first);
        }
        return rc;
    }

    public Integer firstKey() {
        if (this.size == 0) {
            return null;
        }
        E rc = this.element(this.first);
        while (rc == null) {
            ++this.first;
            rc = this.element(this.first);
        }
        return this.first;
    }
}

