/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import org.diylc.common.PropertyWrapper;

public class ColorEditor
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final String title = "Click to edit";

    public ColorEditor(final PropertyWrapper propertyWrapper) {
        super(propertyWrapper.isUnique() ? title : "(multi value) Click to edit");
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground((Color)propertyWrapper.getValue());
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Color color = JColorChooser.showDialog(ColorEditor.this, "Choose Color", ColorEditor.this.getBackground());
                if (color != null) {
                    propertyWrapper.setChanged(true);
                    propertyWrapper.setValue((Object)color);
                    ColorEditor.this.setBackground(color);
                }
            }
        });
    }

    @Override
    public void setBackground(Color color) {
        if (color.getRed() < 127 || color.getBlue() < 127 || color.getGreen() < 127) {
            this.setForeground(Color.white);
        } else {
            this.setForeground(Color.black);
        }
        super.setBackground(color);
    }
}

