/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import java.awt.Point;
import org.flexdock.docking.state.DockingPath;
import org.flexdock.docking.state.DockingState;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.flexdock.perspective.persist.xml.SerializerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DockingStateSerializer
implements ISerializer {
    private static final String OPENED_STATE = "opened";
    private static final String MINIMIZED_STATE = "minimized";
    private static final String FLOATING_STATE = "floating";

    public Element serialize(Document document, Object object) {
        DockingState dockingState = (DockingState)object;
        Element dockingStateElement = document.createElement("DockingState");
        dockingStateElement.setAttribute("dockableId", dockingState.getDockableId());
        if (dockingState.getRelativeParentId() != null && !dockingState.getRelativeParentId().equals("")) {
            dockingStateElement.setAttribute("relativeParentId", dockingState.getRelativeParentId());
        }
        dockingStateElement.setAttribute("dockingRegion", dockingState.getRegion().toLowerCase());
        if (dockingState.getSplitRatio() != -1.0f) {
            dockingStateElement.setAttribute("splitRatio", String.valueOf(dockingState.getSplitRatio()));
        }
        this.handleDockingState(dockingStateElement, dockingState);
        if (dockingState.isFloating()) {
            dockingStateElement.setAttribute("floatingGroupName", dockingState.getFloatingGroup());
        } else if (dockingState.isMinimized()) {
            int constraint = dockingState.getMinimizedConstraint();
            String presConstraint = this.getPresentationMinimizeConstraint(constraint);
            dockingStateElement.setAttribute("minimizeConstraint", presConstraint);
        }
        if (dockingState.hasCenterPoint()) {
            ISerializer pointSerializer = SerializerRegistry.getSerializer(Point.class);
            Element pointElement = pointSerializer.serialize(document, dockingState.getCenterPoint());
            dockingStateElement.appendChild(pointElement);
        }
        if (dockingState.hasDockingPath()) {
            ISerializer dockingPathSerializer = SerializerRegistry.getSerializer(DockingPath.class);
            Element dockingPathElement = dockingPathSerializer.serialize(document, dockingState.getPath());
            dockingStateElement.appendChild(dockingPathElement);
        }
        return dockingStateElement;
    }

    private void handleDockingState(Element dockingStateElement, DockingState dockingState) {
        if (dockingState.isMinimized()) {
            dockingStateElement.setAttribute("state", MINIMIZED_STATE);
        } else if (dockingState.isFloating()) {
            dockingStateElement.setAttribute("state", FLOATING_STATE);
        } else {
            dockingStateElement.setAttribute("state", OPENED_STATE);
        }
    }

    private String getPresentationMinimizeConstraint(int constraint) {
        switch (constraint) {
            case 2: {
                return "left";
            }
            case 3: {
                return "bottom";
            }
            case 0: {
                return "center";
            }
            case 4: {
                return "right";
            }
            case 1: {
                return "top";
            }
            case -1: {
                return "unspecified";
            }
        }
        throw new RuntimeException("Unknown dockbarEdge");
    }

    private int getRealMinimizeConstraint(String presConstraint) {
        if (presConstraint.equals("left")) {
            return 2;
        }
        if (presConstraint.equals("bottom")) {
            return 3;
        }
        if (presConstraint.equals("center")) {
            return 0;
        }
        if (presConstraint.equals("right")) {
            return 4;
        }
        if (presConstraint.equals("top")) {
            return 1;
        }
        throw new RuntimeException("Minimization conversion error!");
    }

    public Object deserialize(Element element) {
        String dockingStateState;
        String dockableId = element.getAttribute("dockableId");
        String relativeParentId = element.getAttribute("relativeParentId");
        String region = element.getAttribute("dockingRegion");
        DockingState dockingState = new DockingState(dockableId);
        if (relativeParentId != null && !relativeParentId.equals("")) {
            dockingState.setRelativeParentId(relativeParentId);
        }
        dockingState.setRegion(region.toUpperCase());
        String splitRatioString = element.getAttribute("splitRatio");
        if (splitRatioString != null && !splitRatioString.equals("")) {
            float splitRatio = Float.parseFloat(splitRatioString);
            dockingState.setSplitRatio(splitRatio);
        }
        if ((dockingStateState = element.getAttribute("state")).equals(FLOATING_STATE)) {
            String floatingGroupName = element.getAttribute("floatingGroupName");
            if (floatingGroupName != null && !floatingGroupName.equals("")) {
                dockingState.setFloatingGroup(floatingGroupName);
            }
        } else if (dockingStateState.equals(MINIMIZED_STATE)) {
            String minimizeConstraint = element.getAttribute("minimizeConstraint");
            int minimizeConstraintInt = this.getRealMinimizeConstraint(minimizeConstraint);
            dockingState.setMinimizedConstraint(minimizeConstraintInt);
        }
        ISerializer pointDeserializer = SerializerRegistry.getSerializer(Point.class);
        NodeList pointNodeList = element.getElementsByTagName("Point");
        if (pointNodeList.getLength() > 0 && pointNodeList.item(0) instanceof Element) {
            Element centerPointElement = (Element)pointNodeList.item(0);
            Point centerPoint = (Point)pointDeserializer.deserialize(centerPointElement);
            dockingState.setCenter(centerPoint);
        }
        ISerializer dockingPathDeserializer = SerializerRegistry.getSerializer(DockingPath.class);
        NodeList dockingPathNodeList = element.getElementsByTagName("DockingPath");
        if (dockingPathNodeList.getLength() > 0 && dockingPathNodeList.item(0) instanceof Element) {
            Element dockingPathElement = (Element)dockingPathNodeList.item(0);
            DockingPath dockingPath = (DockingPath)dockingPathDeserializer.deserialize(dockingPathElement);
            dockingState.setPath(dockingPath);
        }
        return dockingState;
    }
}

