/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjdoc;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.javacc.jjdoc.JJDoc;
import org.javacc.jjdoc.JJDocGlobals;
import org.javacc.jjdoc.JJDocOptions;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCParser;
import org.javacc.parser.Main;
import org.javacc.parser.MetaParseException;
import org.javacc.parser.ParseException;

public final class JJDocMain
extends JJDocGlobals {
    private JJDocMain() {
    }

    static void help_message() {
        JJDocMain.info("");
        JJDocMain.info("    jjdoc option-settings - (to read from standard input)");
        JJDocMain.info("OR");
        JJDocMain.info("    jjdoc option-settings inputfile (to read from a file)");
        JJDocMain.info("");
        JJDocMain.info("WHERE");
        JJDocMain.info("    \"option-settings\" is a sequence of settings separated by spaces.");
        JJDocMain.info("");
        JJDocMain.info("Each option setting must be of one of the following forms:");
        JJDocMain.info("");
        JJDocMain.info("    -optionname=value (e.g., -TEXT=false)");
        JJDocMain.info("    -optionname:value (e.g., -TEXT:false)");
        JJDocMain.info("    -optionname       (equivalent to -optionname=true.  e.g., -TEXT)");
        JJDocMain.info("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOTEXT)");
        JJDocMain.info("");
        JJDocMain.info("Option settings are not case-sensitive, so one can say \"-nOtExT\" instead");
        JJDocMain.info("of \"-NOTEXT\".  Option values must be appropriate for the corresponding");
        JJDocMain.info("option, and must be either an integer, boolean or string value.");
        JJDocMain.info("");
        JJDocMain.info("The string valued options are:");
        JJDocMain.info("");
        JJDocMain.info("    OUTPUT_FILE");
        JJDocMain.info("    CSS");
        JJDocMain.info("");
        JJDocMain.info("The boolean valued options are:");
        JJDocMain.info("");
        JJDocMain.info("    ONE_TABLE              (default true)");
        JJDocMain.info("    TEXT                   (default false)");
        JJDocMain.info("    BNF                    (default false)");
        JJDocMain.info("");
        JJDocMain.info("");
        JJDocMain.info("EXAMPLES:");
        JJDocMain.info("    jjdoc -ONE_TABLE=false mygrammar.jj");
        JJDocMain.info("    jjdoc - < mygrammar.jj");
        JJDocMain.info("");
        JJDocMain.info("ABOUT JJDoc:");
        JJDocMain.info("    JJDoc generates JavaDoc documentation from JavaCC grammar files.");
        JJDocMain.info("");
        JJDocMain.info("    For more information, see the online JJDoc documentation at");
        JJDocMain.info("    https://javacc.dev.java.net/doc/JJDoc.html");
    }

    public static void main(String[] stringArray) throws Exception {
        int n = JJDocMain.mainProgram(stringArray);
        System.exit(n);
    }

    public static int mainProgram(String[] stringArray) throws Exception {
        Main.reInitAll();
        JJDocOptions.init();
        JJDocMain.bannerLine("Documentation Generator", "0.1.4");
        JavaCCParser javaCCParser = null;
        if (stringArray.length == 0) {
            JJDocMain.help_message();
            return 1;
        }
        JJDocMain.info("(type \"jjdoc\" with no arguments for help)");
        if (JJDocOptions.isOption(stringArray[stringArray.length - 1])) {
            JJDocMain.error("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename or \"-\".  ");
            return 1;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!JJDocOptions.isOption(stringArray[i])) {
                JJDocMain.error("Argument \"" + stringArray[i] + "\" must be an option setting.  ");
                return 1;
            }
            JJDocOptions.setCmdLineOption(stringArray[i]);
        }
        if (stringArray[stringArray.length - 1].equals("-")) {
            JJDocMain.info("Reading from standard input . . .");
            javaCCParser = new JavaCCParser(new DataInputStream(System.in));
            JJDocGlobals.input_file = "standard input";
            JJDocGlobals.output_file = "standard output";
        } else {
            JJDocMain.info("Reading from file " + stringArray[stringArray.length - 1] + " . . .");
            try {
                File file = new File(stringArray[stringArray.length - 1]);
                if (!file.exists()) {
                    JJDocMain.error("File " + stringArray[stringArray.length - 1] + " not found.");
                    return 1;
                }
                if (file.isDirectory()) {
                    JJDocMain.error(stringArray[stringArray.length - 1] + " is a directory. Please use a valid file name.");
                    return 1;
                }
                JJDocGlobals.input_file = file.getName();
                javaCCParser = new JavaCCParser(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stringArray[stringArray.length - 1]), JJDocOptions.getGrammarEncoding())));
            }
            catch (SecurityException securityException) {
                JJDocMain.error("Security violation while trying to open " + stringArray[stringArray.length - 1]);
                return 1;
            }
            catch (FileNotFoundException fileNotFoundException) {
                JJDocMain.error("File " + stringArray[stringArray.length - 1] + " not found.");
                return 1;
            }
        }
        try {
            javaCCParser.javacc_input();
            JJDoc.start();
            if (JavaCCErrors.get_error_count() == 0) {
                if (JavaCCErrors.get_warning_count() == 0) {
                    JJDocMain.info("Grammar documentation generated successfully in " + JJDocGlobals.output_file);
                } else {
                    JJDocMain.info("Grammar documentation generated with 0 errors and " + JavaCCErrors.get_warning_count() + " warnings.");
                }
                return 0;
            }
            JJDocMain.error("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return JavaCCErrors.get_error_count() == 0 ? 0 : 1;
        }
        catch (MetaParseException metaParseException) {
            JJDocMain.error(metaParseException.toString());
            JJDocMain.error("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
        catch (ParseException parseException) {
            JJDocMain.error(parseException.toString());
            JJDocMain.error("Detected " + (JavaCCErrors.get_error_count() + 1) + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
    }
}

