/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class ViewportLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -788225906076097229L;

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        JViewport jViewport = (JViewport)container;
        Component component = jViewport.getView();
        if (component != null) {
            if (component instanceof Scrollable) {
                return ((Scrollable)((Object)component)).getPreferredScrollableViewportSize();
            }
            return component.getPreferredSize();
        }
        return new Dimension();
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(4, 4);
    }

    public void layoutContainer(Container container) {
        JViewport jViewport = (JViewport)container;
        Component component = jViewport.getView();
        if (component == null) {
            return;
        }
        Rectangle rectangle = jViewport.getViewRect();
        Dimension dimension = component.getPreferredSize();
        Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        if (component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            if (scrollable.getScrollableTracksViewportWidth()) {
                dimension.width = rectangle.width;
                rectangle.x = 0;
            }
            if (scrollable.getScrollableTracksViewportHeight()) {
                dimension.height = rectangle.height;
                rectangle.y = 0;
            }
        } else {
            if (dimension.width < rectangle.width) {
                dimension.width = rectangle.width;
            }
            if (dimension.height < rectangle.height) {
                dimension.height = rectangle.height;
            }
            if (point.x > dimension.width) {
                rectangle.x = 0;
            }
            if (point.y > dimension.height) {
                rectangle.y = 0;
            }
        }
        jViewport.setViewSize(dimension);
        jViewport.setViewPosition(rectangle.getLocation());
    }
}

