###############################################################################
#                                                                             #
# Test: To compare Explain vs Explain Other plans of RQG queries              #
#                                                                             #
#                                                                             #
# Creation Date: 2012-12-15                                                   #
# Author : Tarique Saleem                                                     #
#                                                                             #
#                                                                             #
# Description:This test contains Explain vs Explain Other plans on different  #
#             queries generated from RQG optimizer grammaers. Some distinct   #
#             have been taken from the differences cases reported.            #
#                                                                             #               
#             1. Sync Point used is "before_reset_query_plan"                 #
#             2. Format used is JSON                                          #
#                                                                             #
#                                                                             #
###############################################################################

 echo "WL6369 Explain for Connection";

####################################################################################################################
#   Checking if the build is Debug build else skip the test because debug sync points are avilable in Debug build  #
####################################################################################################################

--source include/have_debug.inc
--source include/have_debug_sync.inc
--source include/not_embedded.inc
--source include/not_windows.inc
--source include/have_grep.inc

--disable_query_log
--disable_result_log
--disable_warnings


connect (ce, localhost, root,,test);
connect (cq, localhost, root,,test);
connection cq;
SET GLOBAL innodb_stats_persistent=on;
let $point= before_reset_query_plan;

###############################
#MTR FOR BUG#14581870         #    
###############################

CREATE TABLE a1 (
  col_int int(11) DEFAULT NULL,
  pk int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (pk)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

 CREATE TABLE aa1 (
  col_int int(11) DEFAULT NULL,
  pk int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (pk)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

let $query=SELECT DISTINCT   alias2.col_int AS field1 , alias2.col_int AS field2 FROM  a1 AS alias1 LEFT  JOIN aa1 AS alias2 ON  alias1.pk =  alias2.pk WHERE ( alias1.col_int = 8 OR alias1 .pk <= alias1.col_int ) GROUP BY field1, field2  ORDER BY field1, field2 DESC;
--source include/explain_for_connection.inc

DROP TABLE a1;
DROP TABLE aa1;

###############################
#MTR FOR BUG#14582154         #
###############################

CREATE TABLE f1 (
  col_varchar_1024_latin1_key varchar(1024) DEFAULT NULL,
  pk int(11) NOT NULL AUTO_INCREMENT,
   PRIMARY KEY (pk),
  KEY col_varchar_1024_latin1_key (col_varchar_1024_latin1_key(1000))
  ) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

insert ignore into f1 values
(1,"I'll"),
(2,'v'),
(3,'time'),
(4,"I'm"),
(5,'o'),
(6,'rkmqmknbtoervqlzsvasurqdhucjxdoygxqxnvgqmwcidtumxwcftedxqyciakhxptzfpjwrge
ozxnbycjzxiecurgmhbubpijrllquntppirzdphpduhwqhnsmujjjbldnkiwsrsxndolpujdnozrhh
cxsxwujulpjdzvkpaijursprnwgrpquarwkazzjeiwvdmdivjqsxmhjwagewclcfykywlcnemiuaab
rrifnhuufzasunkrcpvasdqkxbwptigbpnesqigwegcnfeuvrgnecpthmhffqbythjwpukqubzpomn
trddrwhzjtqvbjiklcekxqyoxsolbxthdcprswpjxixmvfwmsyseblwcvumvyvbitxqjxdzdytunqv
vrmpyxrencqhuyrfluezqekmqpwutxnzddrbjycyoyqbzsoxvillooqxuvoxcgohdbytybwcqxdwtq
rebgjzbycekyjgbpmqadutrqluyxhrdodxqqjwasfkvetfobocgpftrhvxugmmszwpoglvarsfiljr
zimqeplevleqdhepkhcfrahcpjjvhkkwblfenfpetwejamgeefplsksusqvazujabvkfek'),
(7,'y');

ANALYZE TABLE f1;

CREATE TABLE a2 (
  col_varchar_10_utf8_key varchar(10) CHARACTER SET utf8 DEFAULT NULL,
  KEY col_varchar_10_utf8_key (col_varchar_10_utf8_key)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

let $query=SELECT DISTINCT   alias1.pk AS field1 FROM  f1 AS alias1 LEFT  JOIN a2 AS alias2 ON  alias1.col_varchar_1024_latin1_key =  alias2 .col_varchar_10_utf8_key WHERE alias1.pk  IN (5, 5) GROUP BY field1 HAVING field1 <= 3;
--source include/explain_for_connection.inc

DROP TABLE f1;
DROP TABLE a2;

###############################
#MTR FOR BUG#14586538         #  
###############################

CREATE TABLE h2 (
pk int(11) NOT NULL AUTO_INCREMENT,
PRIMARY KEY (pk)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

insert into h2 values (1),(2),(3),(4),(5),(6),(7),(8),(9);

ANALYZE TABLE h2;

CREATE TABLE aa3 (
  col_int_key int(11) DEFAULT NULL,
  KEY col_int_key (col_int_key)
 ) ENGINE=InnoDB DEFAULT CHARSET=latin1;

let $query=SELECT alias1.pk AS field1 FROM  h2 AS alias1 LEFT  JOIN aa3 AS alias2 ON  alias1.pk =  alias2.col_int_key WHERE alias1.pk <> 9 GROUP BY field1 ORDER BY field1 LIMIT 1 OFFSET 3;
--source include/explain_for_connection.inc

DROP TABLE h2;
DROP TABLE aa3;

###############################
#MTR FOR BUG#14591376         #
###############################

CREATE TABLE e1 (
  col_int int(11) DEFAULT NULL,
  pk int(11) NOT NULL AUTO_INCREMENT,
  col_int_key int(11) DEFAULT NULL,
  PRIMARY KEY (pk),
  KEY col_int_key (col_int_key)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

insert into e1 values (1, NULL,NULL);
insert into e1 values (2,6,NULL);
insert into e1 values (3,8,-1131610112);
insert into e1 values (4,2,-1009057792);
insert into e1 values (5,-1220345856,1);
insert into e1 values (6,NULL,-185204736);

ANALYZE TABLE e1;

CREATE TABLE cc2 (
  col_int int(11) DEFAULT NULL
 ) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

insert into cc2 values ( 685899776),(NULL);

ANALYZE TABLE CC2;

let $query=SELECT    alias1.pk AS field1 FROM  e1 AS alias1 RIGHT  JOIN cc2 AS alias2 ON  alias1.col_int =  alias2.col_int WHERE alias1.col_int_key  IN (8) ; 
--source include/explain_for_connection.inc

DROP TABLE e1;
DROP TABLE cc2;

###############################
#MTR FOR Bug#15915676         #
###############################

CREATE TABLE t1 (
  pk INT NOT NULL,
  col_int INT,
  col_varchar_key VARCHAR(10),
  PRIMARY KEY (pk),
  KEY col_varchar_key (col_varchar_key)
) ENGINE=InnoDB;

CREATE TABLE t2 (
  pk INT NOT NULL,
  col_varchar_key VARCHAR(10),
  PRIMARY KEY (pk),
  KEY col_varchar_key (col_varchar_key)
) ENGINE=InnoDB;

let $query=SELECT DISTINCT alias2.pk AS field1, alias2.pk AS field2, alias2.pk AS field3 FROM t1 AS alias1 RIGHT JOIN t2 AS alias2  ON  alias1.col_varchar_key =  alias2.col_varchar_key WHERE alias1.col_int >alias1.col_int HAVING field3 = 7 ORDER BY field1, field2, field3 LIMIT 10 OFFSET 1;

--source include/explain_for_connection.inc

drop table t1;
drop table t2;


#ALL OTHER TESTS FROM RQG RUNS

DROP TABLE IF EXISTS  a;
CREATE TABLE a (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,col_date_key DATE ,col_date_nokey DATE ,col_time_key TIME ,col_time_nokey TIME ,col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),KEY (col_time_key),KEY (col_datetime_key),KEY (col_varchar_key, col_int_key)) ENGINE=INNODB;

DROP TABLE IF EXISTS  b;

CREATE TABLE b (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,col_date_key DATE ,col_date_nokey DATE ,	col_time_key TIME ,col_time_nokey TIME ,col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),KEY (col_time_key),KEY (col_datetime_key),KEY (col_varchar_key, col_int_key))  ENGINE=INNODB;

INSERT IGNORE  INTO b (	col_int_key, col_int_nokey,col_date_key, col_date_nokey,col_time_key, col_time_nokey,col_datetime_key, col_datetime_nokey,col_varchar_key,col_varchar_nokey) VALUES (7, 1, '1900-01-01', '1900-01-01', NULL, NULL, '2001-11-04 19:07:55.051133', '2001-11-04 19:07:55.051133', 'x', 'x');
DROP TABLE IF EXISTS  c;

CREATE TABLE c (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,col_date_key DATE ,col_date_nokey DATE ,col_time_key TIME ,col_time_nokey TIME ,col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,	col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),KEY (col_time_key),KEY (col_datetime_key),KEY (col_varchar_key, col_int_key))  ENGINE=INNODB;

INSERT IGNORE  INTO c (	col_int_key, col_int_nokey,col_date_key, col_date_nokey,col_time_key, col_time_nokey,col_datetime_key, col_datetime_nokey,col_varchar_key,col_varchar_nokey) VALUES (4, 2, '2008-12-05', '2008-12-05', '22:34:09.023306', '22:34:09.023306', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'v', 'v'),(62, 150, '2005-03-27', '2005-03-27', '14:26:02.007788', '14:26:02.007788', '2008-01-03 10:33:32.027981', '2008-01-03 10:33:32.027981', 'v', 'v'),(7, NULL, '2004-04-09', '2004-04-09', '14:03:03.042673', '14:03:03.042673', '2001-11-28 00:50:27.051028', '2001-11-28 00:50:27.051028', 'c', 'c'),(1, 2, '2006-05-13', '2006-05-13', '01:46:09.016386', '01:46:09.016386', '2007-10-09 19:53:04.008332', '2007-10-09 19:53:04.008332', NULL, NULL),(0, 5, '2001-05-06', '2001-05-06', '16:21:18.052408', '16:21:18.052408', '2001-11-08 21:02:12.009395', '2001-11-08 21:02:12.009395', 'x', 'x'),(7, 3, '2006-03-03', '2006-03-03', '18:56:33.027423', '18:56:33.027423', '2003-04-01 00:00:00', '2003-04-01 00:00:00', 'i', 'i'),(7, 1, '2007-12-28', '2007-12-28', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'e', 'e'),(1, 4, '2004-10-20', '2004-10-20', '09:29:08.048031', '09:29:08.048031', '2007-07-12 00:00:00', '2007-07-12 00:00:00', 'p', 'p'),(7, NULL, '2008-04-09', '2008-04-09', '19:11:10.040728', '19:11:10.040728', '2005-04-04 01:21:01.040391', '2005-04-04 01:21:01.040391', 's', 's'),(1, 2, '2005-12-25', '2005-12-25', '11:57:26.013363', '11:57:26.013363', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'j', 'j'),(5, 6, '1900-01-01', '1900-01-01', '00:39:46.041355', '00:39:46.041355', '2003-03-05 03:41:18.061978', '2003-03-05 03:41:18.061978', 'z', 'z'),(2, 6, NULL, NULL, '03:28:15.007081', '03:28:15.007081', '2008-08-03 11:33:04.049998', '2008-08-03 11:33:04.049998', 'c', 'c'),(0, 8, '1900-01-01', '1900-01-01', '06:44:18.007092', '06:44:18.007092', '2004-04-28 21:44:45.050791', '2004-04-28 21:44:45.050791', 'a', 'a'),(1, 2, '2001-01-16', '2001-01-16', '14:36:39.062494', '14:36:39.062494', '2001-04-06 00:00:00', '2001-04-06 00:00:00', 'q', 'q'),(8, 6, '1900-01-01', '1900-01-01', '18:42:45.053707', '18:42:45.053707', '2001-04-18 00:00:00', '2001-04-18 00:00:00', 'y', 'y'),(1, 8, '2001-11-23', '2001-11-23', '02:57:29.012755', '02:57:29.012755', '2008-12-18 19:39:55.005399', '2008-12-18 19:39:55.005399', NULL, NULL),(1, 3, '2004-11-04', '2004-11-04', '16:46:13.015460', '16:46:13.015460', '2000-08-01 12:19:39.028493', '2000-08-01 12:19:39.028493', 'r', 'r'),(9, 3, '2003-03-12', '2003-03-12', '19:39:02.040624', '19:39:02.040624', '2004-09-25 21:29:06.004058', '2004-09-25 21:29:06.004058', 'v', 'v'),(1, 9, '2002-06-22', '2002-06-22', NULL, NULL, '2009-09-20 09:11:48.065041', '2009-09-20 09:11:48.065041', NULL, NULL),(5, 6, '2004-10-10', '2004-10-10', '20:58:33.049572', '20:58:33.049572', '2004-03-27 09:32:04.056959', '2004-03-27 09:32:04.056959', 'r', 'r');
DROP TABLE IF EXISTS  d;

CREATE TABLE d (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,	col_date_key DATE ,col_date_nokey DATE ,col_time_key TIME ,col_time_nokey TIME ,	col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),KEY (col_time_key),	KEY (col_datetime_key),KEY (col_varchar_key, col_int_key))  ENGINE=INNODB;

INSERT IGNORE  INTO d (	col_int_key, col_int_nokey,col_date_key, col_date_nokey,col_time_key, col_time_nokey,col_datetime_key, col_datetime_nokey,col_varchar_key,col_varchar_nokey) VALUES (4, 8, '2002-01-03', '2002-01-03', '01:01:02.033918', '01:01:02.033918', NULL, NULL, 'c', 'c'),(5, 3, '2007-07-08', '2007-07-08', '03:22:30.013692', '03:22:30.013692', '2003-11-06 04:59:50.060815', '2003-11-06 04:59:50.060815', 'c', 'c'),(8, 3, '2000-08-02', '2000-08-02', '18:30:05.036576', '18:30:05.036576', '2007-08-13 00:00:00', '2007-08-13 00:00:00', 'q', 'q'),(4, NULL, '2000-03-06', '2000-03-06', '07:30:51.053695', '07:30:51.053695', '2007-07-23 22:15:05.039929', '2007-07-23 22:15:05.039929', 'g', 'g'),(8, 7, '2002-06-05', '2002-06-05', NULL, NULL, '2009-01-24 15:15:41.015816', '2009-01-24 15:15:41.015816', 'e', 'e'),(2, 4, '2009-08-09', '2009-08-09', '00:00:00', '00:00:00', '2004-04-25 15:55:43.024669', '2004-04-25 15:55:43.024669', 'l', 'l'),(9, 7, '2001-03-22', '2001-03-22', '02:43:46.044368', '02:43:46.044368', '2006-05-21 00:00:00', '2006-05-21 00:00:00', NULL, NULL),(6, 7, '2002-10-08', '2002-10-08', '23:08:56.006835', '23:08:56.006835', '2007-11-19 18:59:17.041110', '2007-11-19 18:59:17.041110', 'v', 'v'),(NULL, 8, NULL, NULL, '21:14:43.049256', '21:14:43.049256', '2004-10-11 00:00:00', '2004-10-11 00:00:00', 'c', 'c'),(NULL, 6, '2007-09-13', '2007-09-13', '10:37:15.026137', '10:37:15.026137', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'u', 'u'),(48, 3, '2003-12-08', '2003-12-08', '00:50:58.018981', '00:50:58.018981', '2003-11-22 00:42:24.007216', '2003-11-22 00:42:24.007216', 'x', 'x'),(228, 210, '2006-06-01', '2006-06-01', '15:11:05.037254', '15:11:05.037254', '2009-05-06 15:57:54.046100', '2009-05-06 15:57:54.046100', 'x', 'x'),(3, 1, '2001-10-04', '2001-10-04', '17:56:53.016427', '17:56:53.016427', '2000-12-26 00:33:56.056159', '2000-12-26 00:33:56.056159', 'x', 'x'),(5, 2, '2004-11-16', '2004-11-16', '01:40:28.015719', '01:40:28.015719', '2002-03-12 00:00:00', '2002-03-12 00:00:00', 'l', 'l'),(39, 251, NULL, NULL, '01:21:50.043186', '01:21:50.043186', '2005-06-12 11:13:17.034994', '2005-06-12 11:13:17.034994', 'e', 'e'),(6, 4, '2005-06-22', '2005-06-22', '21:17:36.004741', '21:17:36.004741', '2009-06-10 00:00:00', '2009-06-10 00:00:00', 's', 's'),(8, 4, '2003-04-19', '2003-04-19', '09:16:37.022128', '09:16:37.022128', '2002-04-07 00:00:00', '2002-04-07 00:00:00', 'k', 'k'),(3, 9, '2006-03-23', '2006-03-23', '16:41:37.000305', '16:41:37.000305', '2002-08-01 01:33:30.032947', '2002-08-01 01:33:30.032947', 'm', 'm'),(NULL, 4, NULL, NULL, '03:13:46.009571', '03:13:46.009571', '2003-04-05 11:02:01.035782', '2003-04-05 11:02:01.035782', 'x', 'x'),(2, NULL, '2008-10-22', '2008-10-22', '17:27:08.029558', '17:27:08.029558', '2003-10-25 12:46:30.035123', '2003-10-25 12:46:30.035123', 's', 's'),(6, 4, '2009-04-04', '2009-04-04', '19:27:17.002465', '19:27:17.002465', '2007-08-10 00:00:00', '2007-08-10 00:00:00', 'h', 'h'),(3, NULL, NULL, NULL, '00:51:44.035596', '00:51:44.035596', '2002-07-12 19:18:28.007325', '2002-07-12 19:18:28.007325', 'u', 'u'),(1, 1, '2001-07-15', '2001-07-15', '10:57:22.061270', '10:57:22.061270', '2004-06-24 00:00:00', '2004-06-24 00:00:00', 'x', 'x'),(4, 6, '2004-09-25', '2004-09-25', '13:28:27.053467', '13:28:27.053467', '2009-06-10 09:54:42.024934', '2009-06-10 09:54:42.024934', 'l', 'l'),(3, 2, '2001-02-20', '2001-02-20', '06:40:59.047885', '06:40:59.047885', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'p', 'p'),(1, NULL, '1900-01-01', '1900-01-01', '22:56:45.062451', '22:56:45.062451', '2002-03-09 11:26:35.022784', '2002-03-09 11:26:35.022784', 'i', 'i'),(NULL, 4, '2004-08-02', '2004-08-02', '12:51:42.058226', '12:51:42.058226', '2004-02-22 21:45:20.001412', '2004-02-22 21:45:20.001412', 'u', 'u'),(97, 248, '2009-02-26', '2009-02-26', '01:52:32.022616', '01:52:32.022616', NULL, NULL, 'i', 'i'),(0, 4, '2002-11-23', '2002-11-23', '20:42:07.019441', '20:42:07.019441', '2000-08-12 00:00:00', '2000-08-12 00:00:00', 'i', 'i'),(0, 8, '2008-12-17', '2008-12-17', '12:53:30.021802', '12:53:30.021802', '2003-05-24 18:11:13.003533', '2003-05-24 18:11:13.003533', 'e', 'e'),(9, 4, '2005-08-26', '2005-08-26', '02:10:47.019184', '02:10:47.019184', '2000-12-21 15:20:30.054478', '2000-12-21 15:20:30.054478', 'h', 'h'),(5, 5, '2001-03-10', '2001-03-10', '02:13:00.039788', '02:13:00.039788', '2006-10-27 05:05:38.051899', '2006-10-27 05:05:38.051899', 'f', 'f'),(9, 9, '1900-01-01', '1900-01-01', '08:21:57.049920', '08:21:57.049920', '2008-08-04 14:29:37.030503', '2008-08-04 14:29:37.030503', NULL, NULL),(0, 2, '2003-08-04', '2003-08-04', '01:48:05.048577', '01:48:05.048577', '2006-11-03 00:00:00', '2006-11-03 00:00:00', 'p', 'p'),(2, 4, '2007-11-06', '2007-11-06', '00:00:00', '00:00:00', '2009-11-26 19:28:11.005115', '2009-11-26 19:28:11.005115', 'n', 'n'),(172, 211, '2009-04-23', '2009-04-23', '00:00:00', '00:00:00', '2000-12-07 10:17:40.013275', '2000-12-07 10:17:40.013275', 'h', 'h'),(NULL, 2, '2002-10-06', '2002-10-06', '00:50:49.017545', '00:50:49.017545', NULL, NULL, 'm', 'm'),(5, 4, '2008-02-12', '2008-02-12', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'x', 'x'),(119, 125, '2007-09-18', '2007-09-18', NULL, NULL, '2007-11-27 00:00:00', '2007-11-27 00:00:00', 'd', 'd'),(1, 9, '2007-06-26', '2007-06-26', '07:26:24.062529', '07:26:24.062529', '2007-11-17 06:51:08.060652', '2007-11-17 06:51:08.060652', 'd', 'd'),(4, 4, NULL, NULL, '13:41:48.021803', '13:41:48.021803', '2009-12-03 06:39:37.009950', '2009-12-03 06:39:37.009950', 't', 't'),(8, 8, '2009-05-05', '2009-05-05', '04:03:35.044842', '04:03:35.044842', '2004-03-11 16:35:26.052472', '2004-03-11 16:35:26.052472', NULL, NULL),(NULL, 8, '2003-05-04', '2003-05-04', '03:45:26.017635', '03:45:26.017635', '2008-09-08 17:10:40.057585', '2008-09-08 17:10:40.057585', NULL, NULL),(6, NULL, '2003-11-10', '2003-11-10', '00:00:00', '00:00:00', '2004-04-15 20:15:45.050577', '2004-04-15 20:15:45.050577', 'v', 'v'),(5, 8, '2009-02-19', '2009-02-19', '17:06:44.046549', '17:06:44.046549', '2005-04-19 21:52:38.017765', '2005-04-19 21:52:38.017765', 'u', 'u'),(5, 4, '2006-11-17', '2006-11-17', '18:47:54.003829', '18:47:54.003829', '2000-02-03 00:00:00', '2000-02-03 00:00:00', 'p', 'p'),(1, 8, '2000-02-23', '2000-02-23', '14:35:14.013323', '14:35:14.013323', '2002-06-10 17:21:09.045864', '2002-06-10 17:21:09.045864', 'o', 'o'),(7, NULL, '1900-01-01', '1900-01-01', '07:50:59.050471', '07:50:59.050471', NULL, NULL, 'v', 'v'),(2, 1, '2003-04-08', '2003-04-08', NULL, NULL, '2005-02-09 17:44:31.001526', '2005-02-09 17:44:31.001526', 'm', 'm'),(8, 3, '2006-07-08', '2006-07-08', '12:35:26.016053', '12:35:26.016053', '2002-12-19 09:51:49.003532', '2002-12-19 09:51:49.003532', 'x', 'x'),(9, 5, '2001-05-21', '2001-05-21', '05:30:51.057418', '05:30:51.057418', NULL, NULL, 'n', 'n'),(NULL, 8, NULL, NULL, '00:00:00', '00:00:00', '2005-06-27 07:34:53.063059', '2005-06-27 07:34:53.063059', 'b', 'b'),(NULL, 7, '2009-01-05', '2009-01-05', '12:42:04.055539', '12:42:04.055539', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(3, 2, '2001-08-05', '2001-08-05', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'r', 'r'),(172, NULL, '2000-11-01', '2000-11-01', '17:54:39.046453', '17:54:39.046453', '2003-07-08 10:33:13.028775', '2003-07-08 10:33:13.028775', 'v', 'v'),(NULL, 3, '2004-12-16', '2004-12-16', '17:47:16.019040', '17:47:16.019040', '2006-07-18 04:16:49.034600', '2006-07-18 04:16:49.034600', 'a', 'a'),(6, NULL, '2003-02-06', '2003-02-06', '00:15:18.053252', '00:15:18.053252', NULL, NULL, 'u', 'u'),(6, 9, '2008-04-23', '2008-04-23', '01:39:11.061332', '01:39:11.061332', '2004-05-19 17:08:35.008795', '2004-05-19 17:08:35.008795', NULL, NULL),(5, 1, '2005-12-20', '2005-12-20', '14:46:31.017448', '14:46:31.017448', NULL, NULL, 'b', 'b'),(4, 0, '2002-03-13', '2002-03-13', '17:05:47.020057', '17:05:47.020057', '2006-04-27 12:42:58.026518', '2006-04-27 12:42:58.026518', 's', 's'),(3, 0, NULL, NULL, '05:32:59.012082', '05:32:59.012082', '2007-06-12 00:00:00', '2007-06-12 00:00:00', 't', 't'),(2, 8, '2006-07-20', '2006-07-20', '13:41:32.043263', '13:41:32.043263', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'b', 'b'),(7, NULL, '2002-12-19', '2002-12-19', NULL, NULL, '2001-05-18 02:54:34.025888', '2001-05-18 02:54:34.025888', 'm', 'm'),(4, 9, '2001-07-09', '2001-07-09', '04:25:19.045271', '04:25:19.045271', '2008-06-07 08:08:32.056989', '2008-06-07 08:08:32.056989', 'v', 'v'),(6, 1, '2006-05-27', '2006-05-27', '07:51:52.025057', '07:51:52.025057', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'n', 'n'),(0, 9, '2007-02-26', '2007-02-26', '16:19:53.006682', '16:19:53.006682', '2005-05-11 00:00:00', '2005-05-11 00:00:00', 'j', 'j'),(8, 7, NULL, NULL, '00:00:00', '00:00:00', '2003-12-17 21:47:57.031968', '2003-12-17 21:47:57.031968', NULL, NULL),(5, 2, '2007-02-07', '2007-02-07', '02:59:31.001254', '02:59:31.001254', NULL, NULL, NULL, NULL),(8, 1, '2005-01-22', '2005-01-22', '09:04:17.013295', '09:04:17.013295', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(2, 9, '2006-04-25', '2006-04-25', '19:44:22.031201', '19:44:22.031201', NULL, NULL, 'k', 'k'),(9, 5, '2002-11-13', '2002-11-13', '00:00:00', '00:00:00', '2009-06-08 21:21:31.059876', '2009-06-08 21:21:31.059876', 'k', 'k'),(7, 4, '2007-10-26', '2007-10-26', '00:00:00', '00:00:00', '2008-05-25 23:36:30.001155', '2008-05-25 23:36:30.001155', NULL, NULL),(5, 6, '2003-06-16', '2003-06-16', '22:16:47.019207', '22:16:47.019207', '2009-10-17 23:46:36.026550', '2009-10-17 23:46:36.026550', 'n', 'n'),(7, 5, '2006-01-18', '2006-01-18', '06:12:32.043645', '06:12:32.043645', '2009-02-28 00:00:00', '2009-02-28 00:00:00', 'e', 'e'),(0, 2, '1900-01-01', '1900-01-01', NULL, NULL, '2004-04-14 13:27:34.062542', '2004-04-14 13:27:34.062542', 's', 's'),(4, 4, '2000-09-13', '2000-09-13', '02:38:48.001225', '02:38:48.001225', '2007-10-20 00:00:00', '2007-10-20 00:00:00', 'w', 'w'),(3, 0, '2003-01-26', '2003-01-26', '00:00:00', '00:00:00', '2007-11-11 20:10:29.001244', '2007-11-11 20:10:29.001244', 'y', 'y'),(1, 3, '2002-09-09', '2002-09-09', '02:02:49.060941', '02:02:49.060941', '2001-03-08 00:00:00', '2001-03-08 00:00:00', 'z', 'z'),(0, 0, '2001-09-06', '2001-09-06', '23:43:38.037436', '23:43:38.037436', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'b', 'b'),(6, 6, '2006-02-23', '2006-02-23', NULL, NULL, '2006-07-21 19:26:57.063604', '2006-07-21 19:26:57.063604', 'f', 'f'),(2, 1, '2004-06-21', '2004-06-21', '12:35:01.002238', '12:35:01.002238', NULL, NULL, 's', 's'),(NULL, 9, '2006-12-02', '2006-12-02', '00:18:04.035712', '00:18:04.035712', NULL, NULL, 'd', 'd'),(8, 4, '2005-05-17', '2005-05-17', '11:53:29.063533', '11:53:29.063533', '2002-10-24 03:10:15.057252', '2002-10-24 03:10:15.057252', NULL, NULL),(NULL, 9, '2001-12-27', '2001-12-27', '13:53:19.031137', '13:53:19.031137', '2002-08-16 00:00:00', '2002-08-16 00:00:00', 'd', 'd'),(NULL, 4, '2008-04-11', '2008-04-11', NULL, NULL, NULL, NULL, 'n', 'n'),(NULL, 1, '2000-09-24', '2000-09-24', '08:53:20.006718', '08:53:20.006718', '2005-09-09 12:56:20.057724', '2005-09-09 12:56:20.057724', 'i', 'i'),(3, 2, '2004-04-20', '2004-04-20', '10:38:45.052399', '10:38:45.052399', '2002-06-09 00:00:00', '2002-06-09 00:00:00', NULL, NULL),(7, 8, '2008-07-10', '2008-07-10', '22:27:36.021373', '22:27:36.021373', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(3, 1, '2007-08-14', '2007-08-14', '18:06:56.008989', '18:06:56.008989', '2009-01-21 23:43:07.004846', '2009-01-21 23:43:07.004846', 'd', 'd'),(5, 0, '2008-06-08', '2008-06-08', '03:44:30.021705', '03:44:30.021705', NULL, NULL, 'c', 'c'),(5, 2, '2001-07-26', '2001-07-26', '11:49:25.040600', '11:49:25.040600', '2007-09-06 20:49:33.054044', '2007-09-06 20:49:33.054044', 'i', 'i'),(1, 0, '2008-09-17', '2008-09-17', '22:16:07.029978', '22:16:07.029978', '2005-09-20 10:11:02.005667', '2005-09-20 10:11:02.005667', 't', 't'),(2, 1, NULL, NULL, '17:14:13.044120', '17:14:13.044120', '2007-10-11 00:00:00', '2007-10-11 00:00:00', 'g', 'g'),(1, 2, '2004-02-25', '2004-02-25', '14:49:31.012541', '14:49:31.012541', '2005-06-13 00:26:39.015322', '2005-06-13 00:26:39.015322', 'q', 'q'),(7, NULL, '2009-11-02', '2009-11-02', '00:27:36.065229', '00:27:36.065229', '2001-06-18 08:40:49.042917', '2001-06-18 08:40:49.042917', 'l', 'l'),(1, 3, '2001-12-14', '2001-12-14', '13:59:24.049387', '13:59:24.049387', '2006-06-07 00:00:00', '2006-06-07 00:00:00', 'n', 'n'),(9, 8, NULL, NULL, '01:48:46.042584', '01:48:46.042584', '2004-03-18 22:35:04.041716', '2004-03-18 22:35:04.041716', 'z', 'z'),(9, 4, '1900-01-01', '1900-01-01', NULL, NULL, NULL, NULL, 'n', 'n'),(8, 4, '2002-04-12', '2002-04-12', '11:07:46.040645', '11:07:46.040645', '2001-07-15 12:46:49.046948', '2001-07-15 12:46:49.046948', 'r', 'r'),(3, NULL, '2000-02-09', '2000-02-09', NULL, NULL, '2001-03-27 06:53:22.006663', '2001-03-27 06:53:22.006663', 'p', 'p');
DROP TABLE IF EXISTS  E;

CREATE TABLE e (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,	col_date_key DATE ,col_date_nokey DATE ,col_time_key TIME ,col_time_nokey TIME ,	col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),KEY (col_time_key),KEY (col_datetime_key),KEY (col_varchar_key, col_int_key))  ENGINE=INNODB;
INSERT IGNORE  INTO e (	col_int_key, col_int_nokey,col_date_key, col_date_nokey,col_time_key, col_time_nokey,col_datetime_key, col_datetime_nokey,col_varchar_key,col_varchar_nokey) VALUES (7, 9, '2005-07-23', '2005-07-23', '15:01:53.007896', '15:01:53.007896', '2004-05-13 01:01:39.020951', '2004-05-13 01:01:39.020951', 't', 't'),(4, 2, '2009-11-01', '2009-11-01', '15:44:41.053734', '15:44:41.053734', '2003-12-24 07:39:29.020532', '2003-12-24 07:39:29.020532', 'h', 'h'),(9, 6, NULL, NULL, NULL, NULL, '2008-07-03 05:32:22.042740', '2008-07-03 05:32:22.042740', 'l', 'l'),(0, 6, '2007-07-16', '2007-07-16', '13:32:31.059995', '13:32:31.059995', '2008-08-28 18:46:11.030956', '2008-08-28 18:46:11.030956', 'j', 'j'),(3, 5, NULL, NULL, '19:08:59.062416', '19:08:59.062416', '2001-07-12 21:27:00.024781', '2001-07-12 21:27:00.024781', 'h', 'h'),(8, 3, '2007-07-22', '2007-07-22', '13:06:13.033877', '13:06:13.033877', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'p', 'p'),(9, 2, '2000-11-21', '2000-11-21', NULL, NULL, '2007-05-25 11:58:54.015689', '2007-05-25 11:58:54.015689', 'g', 'g'),(9, 6, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2009-06-03 17:11:10.011464', '2009-06-03 17:11:10.011464', 'i', 'i'),(4, 2, '2008-02-10', '2008-02-10', '23:02:06.047880', '23:02:06.047880', '2001-06-15 16:20:07.027178', '2001-06-15 16:20:07.027178', 'p', 'p'),(7, 3, '2009-06-04', '2009-06-04', '08:05:21.035383', '08:05:21.035383', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(1, 9, '2007-04-25', '2007-04-25', '20:26:40.010634', '20:26:40.010634', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'e', 'e'),(8, 9, '2006-03-02', '2006-03-02', '12:47:47.026796', '12:47:47.026796', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'e', 'e'),(6, 1, '1900-01-01', '1900-01-01', NULL, NULL, '2002-11-08 09:33:27.034302', '2002-11-08 09:33:27.034302', 'u', 'u'),(6, 7, '2008-07-13', '2008-07-13', '00:00:00', '00:00:00', '2007-08-07 17:35:52.017101', '2007-08-07 17:35:52.017101', 'j', 'j'),(6, 0, '2004-11-12', '2004-11-12', '20:58:23.064148', '20:58:23.064148', '2006-05-01 00:00:00', '2006-05-01 00:00:00', 'e', 'e'),(1, 0, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2003-05-01 00:00:00', '2003-05-01 00:00:00', 'z', 'z'),(227, 112, '2009-09-02', '2009-09-02', '07:43:46.015324', '07:43:46.015324', '2007-02-12 09:30:49.063767', '2007-02-12 09:30:49.063767', 'w', 'w'),(NULL, 0, '2004-11-06', '2004-11-06', '21:16:35.040813', '21:16:35.040813', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(9, 4, '2003-01-06', '2003-01-06', '15:54:47.061688', '15:54:47.061688', '2002-07-03 02:51:11.057287', '2002-07-03 02:51:11.057287', 'i', 'i'),(1, 6, '2006-01-14', '2006-01-14', '20:29:36.026082', '20:29:36.026082', '2008-02-26 04:57:32.018208', '2008-02-26 04:57:32.018208', 'i', 'i'),(8, 0, '2002-01-19', '2002-01-19', '05:18:40.006865', '05:18:40.006865', '2009-02-12 00:00:00', '2009-02-12 00:00:00', 'i', 'i'),(5, 8, '2007-02-12', '2007-02-12', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'b', 'b'),(8, 4, '1900-01-01', '1900-01-01', '00:44:45.033511', '00:44:45.033511', '2001-05-16 05:28:40.005808', '2001-05-16 05:28:40.005808', 'm', 'm'),(7, 2, '2005-07-16', '2005-07-16', '23:16:07.026979', '23:16:07.026979', NULL, NULL, 'j', 'j'),(2, 1, '2004-09-04', '2004-09-04', '02:05:51.032461', '02:05:51.032461', '2001-01-24 21:45:18.038169', '2001-01-24 21:45:18.038169', 'v', 'v'),(4, 3, '2009-07-01', '2009-07-01', '13:34:23.036481', '13:34:23.036481', NULL, NULL, NULL, NULL),(3, 2, '2009-07-21', '2009-07-21', '07:04:18.014012', '07:04:18.014012', '2002-07-24 00:00:00', '2002-07-24 00:00:00', 'h', 'h'),(1, 4, NULL, NULL, '16:19:19.003601', '16:19:19.003601', '2001-11-03 12:22:30.004586', '2001-11-03 12:22:30.004586', 'q', 'q'),(140, 144, '2002-06-22', '2002-06-22', '15:14:52.048461', '15:14:52.048461', '2008-06-17 03:17:59.000622', '2008-06-17 03:17:59.000622', 'f', 'f'),(0, 7, '2005-06-23', '2005-06-23', '23:33:23.054970', '23:33:23.054970', '2005-12-24 00:00:00', '2005-12-24 00:00:00', 'p', 'p'),(6, 6, '2001-05-20', '2001-05-20', NULL, NULL, '2008-10-23 00:00:00', '2008-10-23 00:00:00', NULL, NULL),(8, 3, '2001-10-01', '2001-10-01', '03:34:01.048002', '03:34:01.048002', '2000-10-12 16:32:35.040067', '2000-10-12 16:32:35.040067', 'o', 'o'),(6, 3, '2001-01-07', '2001-01-07', '00:00:00', '00:00:00', '2005-09-11 10:09:54.058784', '2005-09-11 10:09:54.058784', 'w', 'w'),(0, 6, '2007-11-02', '2007-11-02', '12:23:27.002886', '12:23:27.002886', '2009-09-10 01:44:18.063431', '2009-09-10 01:44:18.063431', 'l', 'l'),(0, 6, NULL, NULL, NULL, NULL, NULL, NULL, 'i', 'i'),(NULL, 9, NULL, NULL, '09:41:12.040690', '09:41:12.040690', '2002-05-18 15:21:55.029222', '2002-05-18 15:21:55.029222', 'd', 'd'),(9, 4, '2008-12-21', '2008-12-21', '01:56:54.023346', '01:56:54.023346', '2004-10-15 10:09:54.052542', '2004-10-15 10:09:54.052542', 'j', 'j'),(0, 6, '2003-10-05', '2003-10-05', '20:32:50.052486', '20:32:50.052486', '2009-07-13 03:51:02.028166', '2009-07-13 03:51:02.028166', 'e', 'e'),(5, 2, '2001-03-03', '2001-03-03', '12:24:59.017466', '12:24:59.017466', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'e', 'e'),(169, 28, '2007-04-04', '2007-04-04', '23:31:22.033214', '23:31:22.033214', '2001-11-08 21:14:52.045368', '2001-11-08 21:14:52.045368', 'q', 'q'),(8, 5, NULL, NULL, '11:11:27.003079', '11:11:27.003079', '2006-12-02 00:00:00', '2006-12-02 00:00:00', 'm', 'm'),(2, NULL, '2009-01-04', '2009-01-04', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(8, 8, '2008-04-03', '2008-04-03', '01:17:44.047711', '01:17:44.047711', '2005-01-01 11:55:18.027373', '2005-01-01 11:55:18.027373', 'q', 'q'),(9, 8, NULL, NULL, '00:00:00', '00:00:00', '2005-02-28 03:44:02.034839', '2005-02-28 03:44:02.034839', 'w', 'w'),(NULL, 0, '2003-08-22', '2003-08-22', '22:07:31.039364', '22:07:31.039364', NULL, NULL, 'c', 'c'),(7, 9, '1900-01-01', '1900-01-01', '20:27:30.021356', '20:27:30.021356', NULL, NULL, 'y', 'y'),(8, NULL, NULL, NULL, '08:11:41.025328', '08:11:41.025328', '2006-08-25 16:28:09.055065', '2006-08-25 16:28:09.055065', 'g', 'g'),(9, 5, '2004-07-04', '2004-07-04', '00:00:00', '00:00:00', '2002-08-11 00:00:00', '2002-08-11 00:00:00', 'z', 'z'),(103, 172, '1900-01-01', '1900-01-01', '00:42:57.032859', '00:42:57.032859', '2007-07-22 21:19:18.023363', '2007-07-22 21:19:18.023363', 'm', 'm'),(3, 2, '2007-02-04', '2007-02-04', NULL, NULL, '2006-02-10 18:41:38.028428', '2006-02-10 18:41:38.028428', 't', 't'),(48, 244, '1900-01-01', '1900-01-01', NULL, NULL, '2009-02-16 14:58:58.035762', '2009-02-16 14:58:58.035762', 'd', 'd'),(8, 7, '2001-03-14', '2001-03-14', '23:28:51.063369', '23:28:51.063369', '2007-08-14 00:00:00', '2007-08-14 00:00:00', 'h', 'h'),(9, 0, NULL, NULL, NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(2, 1, '2008-10-05', '2008-10-05', '20:31:20.029466', '20:31:20.029466', NULL, NULL, 'f', 'f'),(0, 6, '2001-11-25', '2001-11-25', '21:39:14.036494', '21:39:14.036494', '2008-12-03 06:59:23.009921', '2008-12-03 06:59:23.009921', 'l', 'l'),(205, NULL, '2003-01-27', '2003-01-27', '02:10:00.025845', '02:10:00.025845', '2008-10-04 00:00:00', '2008-10-04 00:00:00', 'g', 'g'),(NULL, 8, '2008-08-08', '2008-08-08', '02:03:54.028936', '02:03:54.028936', '2009-07-07 07:00:21.041778', '2009-07-07 07:00:21.041778', 'v', 'v'),(3, 8, '2006-07-03', '2006-07-03', '22:37:33.064975', '22:37:33.064975', '2001-04-15 00:00:00', '2001-04-15 00:00:00', NULL, NULL),(3, 5, '2002-11-21', '2002-11-21', '12:17:48.022067', '12:17:48.022067', '2007-07-08 04:01:58.053285', '2007-07-08 04:01:58.053285', 'm', 'm'),(1, 5, '2006-04-08', '2006-04-08', '17:18:11.045199', '17:18:11.045199', '2007-09-23 00:01:35.034137', '2007-09-23 00:01:35.034137', 'i', 'i'),(4, 5, '2001-05-06', '2001-05-06', '09:10:39.028897', '09:10:39.028897', '2008-05-15 00:00:00', '2008-05-15 00:00:00', 'h', 'h'),(3, 7, '1900-01-01', '1900-01-01', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'u', 'u'),(224, 30, '2007-04-16', '2007-04-16', NULL, NULL, '2004-03-05 23:35:38.005131', '2004-03-05 23:35:38.005131', 'o', 'o'),(5, NULL, '1900-01-01', '1900-01-01', '19:22:16.015548', '19:22:16.015548', '2007-08-25 01:32:47.008806', '2007-08-25 01:32:47.008806', 'z', 'z'),(9, 6, '2004-12-03', '2004-12-03', '06:10:18.037692', '06:10:18.037692', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'o', 'o'),(1, 8, '2001-06-23', '2001-06-23', '01:13:18.058150', '01:13:18.058150', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'f', 'f'),(2, NULL, '2008-12-15', '2008-12-15', '18:52:35.005366', '18:52:35.005366', '2001-05-19 08:28:28.039933', '2001-05-19 08:28:28.039933', 'a', 'a'),(7, 9, '2000-02-15', '2000-02-15', NULL, NULL, '2009-09-03 06:07:22.008308', '2009-09-03 06:07:22.008308', 'd', 'd'),(NULL, 2, '2001-08-05', '2001-08-05', '23:06:15.000718', '23:06:15.000718', '2006-10-08 07:17:27.035884', '2006-10-08 07:17:27.035884', 'k', 'k'),(2, 5, '2004-01-17', '2004-01-17', '08:30:40.000924', '08:30:40.000924', '2003-09-06 20:36:01.002386', '2003-09-06 20:36:01.002386', 'd', 'd'),(NULL, 4, '2003-10-01', '2003-10-01', '15:34:56.022049', '15:34:56.022049', '2001-02-05 18:10:49.016231', '2001-02-05 18:10:49.016231', 'u', 'u'),(6, 4, '2003-07-28', '2003-07-28', NULL, NULL, '2001-01-07 16:11:37.029378', '2001-01-07 16:11:37.029378', 'h', 'h'),(NULL, 0, '1900-01-01', '1900-01-01', '02:12:41.017388', '02:12:41.017388', '2008-08-01 05:26:38.022655', '2008-08-01 05:26:38.022655', 'w', 'w'),(5, 9, '1900-01-01', '1900-01-01', '18:36:00.006583', '18:36:00.006583', '2001-05-08 00:00:00', '2001-05-08 00:00:00', 't', 't'),(4, 1, '2000-04-17', '2000-04-17', '00:40:07.063490', '00:40:07.063490', '2008-07-10 21:26:28.060686', '2008-07-10 21:26:28.060686', 'i', 'i'),(2, 8, '2002-01-05', '2002-01-05', '09:53:23.016697', '09:53:23.016697', '2006-08-06 20:56:35.046044', '2006-08-06 20:56:35.046044', 'k', 'k'),(NULL, 9, '2001-04-10', '2001-04-10', '13:46:23.009802', '13:46:23.009802', '2003-02-17 00:00:00', '2003-02-17 00:00:00', 'z', 'z'),(9, 0, '2009-12-04', '2009-12-04', '00:00:00', '00:00:00', NULL, NULL, 'h', 'h'),(8, 7, NULL, NULL, '16:15:25.055155', '16:15:25.055155', '2004-10-27 00:29:57.038535', '2004-10-27 00:29:57.038535', 'h', 'h'),(7, 2, '2006-03-07', '2006-03-07', '13:08:22.047664', '13:08:22.047664', '2008-03-04 06:14:13.038463', '2008-03-04 06:14:13.038463', 'b', 'b'),(8, 0, '2001-10-15', '2001-10-15', '12:54:48.043906', '12:54:48.043906', '2001-03-17 00:00:00', '2001-03-17 00:00:00', 'm', 'm'),(NULL, 5, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2009-02-21 11:35:50.034553', '2009-02-21 11:35:50.034553', 'i', 'i'),(0, 4, NULL, NULL, '20:56:23.065393', '20:56:23.065393', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'w', 'w'),(1, 5, '2009-04-05', '2009-04-05', '04:25:03.030845', '04:25:03.030845', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'm', 'm'),(NULL, 6, '2001-03-19', '2001-03-19', '00:00:00', '00:00:00', '2001-04-12 00:00:00', '2001-04-12 00:00:00', 'q', 'q'),(9, NULL, '2009-12-08', '2009-12-08', '00:00:00', '00:00:00', '2001-12-04 20:21:01.004651', '2001-12-04 20:21:01.004651', 'k', 'k'),(9, 2, '2005-02-09', '2005-02-09', '00:58:58.048190', '00:58:58.048190', '2001-05-27 08:41:01.063012', '2001-05-27 08:41:01.063012', 'l', 'l'),(1, 9, '2004-05-25', '2004-05-25', '18:39:28.028681', '18:39:28.028681', '2004-09-18 00:00:00', '2004-09-18 00:00:00', 'c', 'c'),(1, 3, '2005-01-17', '2005-01-17', '19:47:45.001466', '19:47:45.001466', '2002-09-12 11:18:48.011992', '2002-09-12 11:18:48.011992', 'd', 'd'),(3, 0, '2003-08-28', '2003-08-28', '05:20:00.048417', '05:20:00.048417', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'k', 'k'),(7, 6, '2006-10-11', '2006-10-11', '11:43:03.056432', '11:43:03.056432', '2003-10-28 03:31:02.009211', '2003-10-28 03:31:02.009211', 'a', 'a'),(4, 5, '1900-01-01', '1900-01-01', '02:38:39.048687', '02:38:39.048687', '2001-08-22 10:20:09.035860', '2001-08-22 10:20:09.035860', 'p', 'p'),(NULL, 8, '1900-01-01', '1900-01-01', '05:34:27.032927', '05:34:27.032927', '2008-04-24 00:00:00', '2008-04-24 00:00:00', 'o', 'o'),(4, 4, '2005-08-18', '2005-08-18', '11:13:16.013590', '11:13:16.013590', '2006-11-10 10:08:49.031891', '2006-11-10 10:08:49.031891', 'e', 'e'),(1, NULL, '2007-03-12', '2007-03-12', '00:00:00', '00:00:00', '2007-10-16 00:00:00', '2007-10-16 00:00:00', 'n', 'n'),(6, 157, '2000-11-18', '2000-11-18', '08:56:42.047453', '08:56:42.047453', '2009-05-27 12:25:07.000073', '2009-05-27 12:25:07.000073', 't', 't'),(5, 4, '2001-03-03', '2001-03-03', '03:20:29.048141', '03:20:29.048141', NULL, NULL, 'u', 'u'),(4, 3, '2003-09-11', '2003-09-11', NULL, NULL, '2001-09-10 18:10:10.061262', '2001-09-10 18:10:10.061262', 'f', 'f'),(1, 4, '2007-06-17', '2007-06-17', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(5, NULL, '2008-09-11', '2008-09-11', '10:39:48.064273', '10:39:48.064273', '2004-06-07 23:17:09.000266', '2004-06-07 23:17:09.000266', 'k', 'k'),(NULL, 3, '2008-05-03', '2008-05-03', '00:00:00', '00:00:00', '2007-06-09 02:05:46.008700', '2007-06-09 02:05:46.008700', 'm', 'm'),(4, 8, '2009-09-07', '2009-09-07', '10:52:33.060993', '10:52:33.060993', '2000-07-03 00:00:00', '2000-07-03 00:00:00', 'y', 'y'),(4, 6, '2005-12-15', '2005-12-15', '21:41:45.005597', '21:41:45.005597', '2001-04-15 14:12:38.049789', '2001-04-15 14:12:38.049789', 'm', 'm'),(203, 98, '2005-05-10', '2005-05-10', NULL, NULL, '2007-04-12 13:29:59.034258', '2007-04-12 13:29:59.034258', 'x', 'x'),(9, 9, '2008-01-22', '2008-01-22', '08:33:38.048965', '08:33:38.048965', '2002-03-24 01:35:46.052300', '2002-03-24 01:35:46.052300', NULL, NULL),(7, 1, '2005-10-23', '2005-10-23', '19:27:01.009576', '19:27:01.009576', '2001-12-27 07:56:29.005615', '2001-12-27 07:56:29.005615', 'q', 'q'),(NULL, NULL, '2005-11-01', '2005-11-01', '09:31:22.017074', '09:31:22.017074', '2002-06-08 09:04:13.048999', '2002-06-08 09:04:13.048999', 'f', 'f'),(NULL, 3, NULL, NULL, '17:16:58.050245', '17:16:58.050245', '2002-02-05 12:54:23.001251', '2002-02-05 12:54:23.001251', 't', 't'),(0, NULL, '2005-06-25', '2005-06-25', '16:44:24.057868', '16:44:24.057868', '2009-09-19 00:00:00', '2009-09-19 00:00:00', 'x', 'x'),(1, 1, '2005-12-09', '2005-12-09', '05:22:56.065526', '05:22:56.065526', '2006-12-18 02:43:37.038767', '2006-12-18 02:43:37.038767', 's', 's'),(5, 9, '2006-06-28', '2006-06-28', '13:32:21.055520', '13:32:21.055520', '2002-10-18 00:00:00', '2002-10-18 00:00:00', 'i', 'i'),(NULL, NULL, '2002-03-16', '2002-03-16', '15:59:32.026962', '15:59:32.026962', '2004-08-03 22:46:02.023201', '2004-08-03 22:46:02.023201', 'l', 'l'),(6, NULL, '2006-07-20', '2006-07-20', '07:19:58.006509', '07:19:58.006509', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(7, 3, '1900-01-01', '1900-01-01', '12:50:41.053008', '12:50:41.053008', '2006-11-15 05:00:37.028540', '2006-11-15 05:00:37.028540', 'b', 'b'),(NULL, 2, '2002-09-13', '2002-09-13', '04:38:11.003482', '04:38:11.003482', '2005-01-21 07:18:44.001886', '2005-01-21 07:18:44.001886', 'h', 'h'),(6, 4, '2002-08-17', '2002-08-17', '20:25:46.033561', '20:25:46.033561', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(9, 3, NULL, NULL, '00:00:00', '00:00:00', '2002-09-22 01:36:27.063456', '2002-09-22 01:36:27.063456', NULL, NULL),(5, 2, '2007-12-08', '2007-12-08', '10:53:24.024992', '10:53:24.024992', '2003-04-22 16:42:22.052607', '2003-04-22 16:42:22.052607', NULL, NULL),(1, 9, '2008-07-05', '2008-07-05', '06:16:28.011698', '06:16:28.011698', '2000-10-18 08:28:55.018533', '2000-10-18 08:28:55.018533', 'x', 'x'),(0, 4, '2001-03-25', '2001-03-25', '13:41:03.021975', '13:41:03.021975', NULL, NULL, 'o', 'o'),(6, 5, '2002-09-27', '2002-09-27', '08:14:06.050501', '08:14:06.050501', '2007-06-12 18:50:24.018166', '2007-06-12 18:50:24.018166', NULL, NULL),(6, 4, '2000-08-26', '2000-08-26', '07:22:25.033657', '07:22:25.033657', '2004-01-21 05:17:01.015777', '2004-01-21 05:17:01.015777', 'r', 'r'),(0, 5, '1900-01-01', '1900-01-01', '16:02:31.028377', '16:02:31.028377', NULL, NULL, 'z', 'z'),(161, 132, '2009-01-20', '2009-01-20', '11:46:57.017685', '11:46:57.017685', '2001-05-01 01:51:11.057447', '2001-05-01 01:51:11.057447', 'q', 'q'),(9, 8, '2004-07-25', '2004-07-25', '12:31:54.025418', '12:31:54.025418', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'e', 'e'),(4, 0, '2007-01-08', '2007-01-08', '22:17:31.011278', '22:17:31.011278', '2008-01-22 14:23:58.061403', '2008-01-22 14:23:58.061403', NULL, NULL),(3, 7, '1900-01-01', '1900-01-01', '12:45:11.033264', '12:45:11.033264', '2006-03-04 23:40:14.016198', '2006-03-04 23:40:14.016198', 'r', 'r'),(47, 108, '2002-03-20', '2002-03-20', '08:56:28.028528', '08:56:28.028528', '2005-09-18 03:45:38.031040', '2005-09-18 03:45:38.031040', 's', 's'),(2, 4, '2009-03-11', '2009-03-11', '00:00:00', '00:00:00', '2003-11-24 21:40:19.064803', '2003-11-24 21:40:19.064803', 't', 't'),(0, 7, '2002-06-08', '2002-06-08', '01:34:16.010736', '01:34:16.010736', '2006-02-07 15:01:12.036147', '2006-02-07 15:01:12.036147', 'g', 'g'),(3, 6, '2001-03-23', '2001-03-23', NULL, NULL, '2002-02-22 00:00:00', '2002-02-22 00:00:00', 'm', 'm'),(1, NULL, '2009-03-03', '2009-03-03', '12:55:39.037290', '12:55:39.037290', NULL, NULL, 'y', 'y'),(5, 0, '1900-01-01', '1900-01-01', '06:52:09.000450', '06:52:09.000450', '2008-06-15 09:48:37.061544', '2008-06-15 09:48:37.061544', 'u', 'u'),(7, 9, '2008-04-16', '2008-04-16', '23:58:21.020974', '23:58:21.020974', '2004-01-22 23:45:50.012256', '2004-01-22 23:45:50.012256', 'x', 'x'),(9, NULL, '2000-05-04', '2000-05-04', '09:56:19.013982', '09:56:19.013982', '2000-08-14 08:35:51.018999', '2000-08-14 08:35:51.018999', 'x', 'x'),(3, 5, '2009-07-22', '2009-07-22', '09:47:26.020837', '09:47:26.020837', '2002-07-08 19:35:57.024921', '2002-07-08 19:35:57.024921', NULL, NULL),(6, 5, '2000-08-09', '2000-08-09', '04:57:44.017563', '04:57:44.017563', '2009-11-05 00:00:00', '2009-11-05 00:00:00', 'j', 'j'),(0, 2, '2008-03-17', '2008-03-17', '07:11:41.062975', '07:11:41.062975', '2000-08-21 19:09:01.049621', '2000-08-21 19:09:01.049621', 's', 's'),(5, 9, '2003-03-17', '2003-03-17', '00:00:00', '00:00:00', '2000-03-24 19:37:00.005614', '2000-03-24 19:37:00.005614', 'm', 'm'),(1, 1, '2004-05-12', '2004-05-12', '05:44:22.016820', '05:44:22.016820', '2000-05-13 00:00:00', '2000-05-13 00:00:00', 'e', 'e'),(7, 0, '2003-02-17', '2003-02-17', '00:00:00', '00:00:00', '2005-10-28 16:31:41.022417', '2005-10-28 16:31:41.022417', 'g', 'g'),(8, 0, '2001-09-23', '2001-09-23', '22:22:44.040748', '22:22:44.040748', '2009-01-12 00:00:00', '2009-01-12 00:00:00', 'y', 'y'),(2, 4, '2001-09-03', '2001-09-03', '02:09:22.035682', '02:09:22.035682', '2007-09-20 10:53:23.013950', '2007-09-20 10:53:23.013950', 'j', 'j'),(1, 6, '2007-12-06', '2007-12-06', '07:12:40.025928', '07:12:40.025928', '2007-11-12 23:18:08.016834', '2007-11-12 23:18:08.016834', 'w', 'w'),(1, 8, '2008-07-20', '2008-07-20', '20:09:41.045541', '20:09:41.045541', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'y', 'y'),(24, 123, '2000-02-20', '2000-02-20', '08:34:44.001370', '08:34:44.001370', '2004-06-22 00:00:00', '2004-06-22 00:00:00', 'x', 'x'),(8, 3, '2005-08-08', '2005-08-08', NULL, NULL, '2001-04-17 04:01:28.026167', '2001-04-17 04:01:28.026167', 'z', 'z'),(9, 3, '2005-07-10', '2005-07-10', '22:32:37.032245', '22:32:37.032245', '2008-11-07 15:56:22.007129', '2008-11-07 15:56:22.007129', NULL, NULL),(NULL, 1, '2004-09-23', '2004-09-23', '00:00:00', '00:00:00', '2008-03-12 13:55:27.047687', '2008-03-12 13:55:27.047687', 'i', 'i'),(2, 2, '2003-05-28', '2003-05-28', '12:08:24.012480', '12:08:24.012480', '2000-05-18 09:51:42.063533', '2000-05-18 09:51:42.063533', 'd', 'd'),(2, NULL, '2002-04-11', '2002-04-11', '22:27:11.024150', '22:27:11.024150', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'q', 'q'),(6, NULL, '2008-12-18', '2008-12-18', '00:00:00', '00:00:00', '2004-08-05 15:08:08.041550', '2004-08-05 15:08:08.041550', 'a', 'a'),(2, 2, '2008-12-15', '2008-12-15', '06:04:40.022308', '06:04:40.022308', '2002-08-11 00:00:00', '2002-08-11 00:00:00', 'b', 'b'),(8, 6, '2007-03-17', '2007-03-17', '02:01:19.015610', '02:01:19.015610', NULL, NULL, 't', 't'),(229, 22, '2009-01-03', '2009-01-03', '10:04:44.012250', '10:04:44.012250', '2009-02-25 13:55:36.006617', '2009-02-25 13:55:36.006617', 'z', 'z'),(8, 8, '2009-10-05', '2009-10-05', '03:15:39.029731', '03:15:39.029731', '2004-05-12 00:00:00', '2004-05-12 00:00:00', 'l', 'l'),(1, NULL, '2002-02-14', '2002-02-14', '11:40:07.064681', '11:40:07.064681', '2004-06-22 11:06:17.026497', '2004-06-22 11:06:17.026497', 'j', 'j'),(3, 4, '2002-12-03', '2002-12-03', '05:40:58.040070', '05:40:58.040070', '2008-12-12 07:44:58.043908', '2008-12-12 07:44:58.043908', 't', 't'),(NULL, 5, '2008-11-05', '2008-11-05', '08:23:12.048072', '08:23:12.048072', '2002-03-14 10:12:56.059515', '2002-03-14 10:12:56.059515', 'z', 'z'),(6, 0, '2006-06-19', '2006-06-19', '22:47:51.035634', '22:47:51.035634', '2001-06-26 00:52:28.008578', '2001-06-26 00:52:28.008578', 'l', 'l'),(1, 5, '2002-11-24', '2002-11-24', '14:00:38.064140', '14:00:38.064140', '2003-11-13 17:26:31.060212', '2003-11-13 17:26:31.060212', 'i', 'i'),(192, 144, '2008-10-06', '2008-10-06', '16:03:33.014981', '16:03:33.014981', '2004-02-09 15:46:56.055798', '2004-02-09 15:46:56.055798', 'a', 'a'),(NULL, 5, '2004-07-11', '2004-07-11', '07:58:14.034094', '07:58:14.034094', '2004-04-21 00:00:00', '2004-04-21 00:00:00', 'w', 'w'),(8, 1, NULL, NULL, NULL, NULL, '2003-07-05 00:00:00', '2003-07-05 00:00:00', 'p', 'p'),(2, 5, '2005-05-18', '2005-05-18', '12:35:20.061910', '12:35:20.061910', NULL, NULL, 'b', 'b'),(230, 35, '2005-09-05', '2005-09-05', '00:55:03.028324', '00:55:03.028324', '2002-10-05 00:00:00', '2002-10-05 00:00:00', NULL, NULL),(4, 5, '2004-12-19', '2004-12-19', '22:25:07.010419', '22:25:07.010419', '2002-02-19 00:00:00', '2002-02-19 00:00:00', 'p', 'p'),(2, 5, '2005-10-18', '2005-10-18', '18:20:08.045830', '18:20:08.045830', '2005-08-15 00:00:00', '2005-08-15 00:00:00', 'y', 'y'),(130, 171, NULL, NULL, '08:27:30.053774', '08:27:30.053774', NULL, NULL, NULL, NULL),(8, 1, '2005-10-15', '2005-10-15', '03:38:24.055204', '03:38:24.055204', '2000-10-19 21:57:19.058395', '2000-10-19 21:57:19.058395', 'm', 'm'),(9, NULL, '1900-01-01', '1900-01-01', '05:01:46.020841', '05:01:46.020841', '2002-01-19 03:06:35.062818', '2002-01-19 03:06:35.062818', 'l', 'l'),(4, 0, '2004-04-14', '2004-04-14', '02:57:15.007040', '02:57:15.007040', '2001-08-01 10:45:49.058784', '2001-08-01 10:45:49.058784', 'b', 'b'),(2, 9, '2004-11-07', '2004-11-07', '00:44:12.057454', '00:44:12.057454', '2006-02-04 14:47:09.030956', '2006-02-04 14:47:09.030956', NULL, NULL),(9, 5, '2007-02-28', '2007-02-28', '20:35:31.033783', '20:35:31.033783', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(168, 28, '2004-12-16', '2004-12-16', '15:27:50.024237', '15:27:50.024237', '2009-05-18 11:17:07.013427', '2009-05-18 11:17:07.013427', 'j', 'j'),(8, NULL, '2006-10-18', '2006-10-18', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(7, NULL, '2009-09-19', '2009-09-19', '18:47:56.027699', '18:47:56.027699', '2008-06-09 05:03:20.061052', '2008-06-09 05:03:20.061052', NULL, NULL),(NULL, NULL, '2001-04-21', '2001-04-21', '20:06:48.018465', '20:06:48.018465', '2004-04-06 11:29:09.047428', '2004-04-06 11:29:09.047428', NULL, NULL),(5, NULL, '2007-09-19', '2007-09-19', '16:48:51.017385', '16:48:51.017385', '2007-11-05 13:29:33.003632', '2007-11-05 13:29:33.003632', 'y', 'y'),(1, NULL, '2006-04-11', '2006-04-11', '00:00:00', '00:00:00', '2008-03-26 00:00:00', '2008-03-26 00:00:00', 'f', 'f'),(4, 3, '2009-08-16', '2009-08-16', '16:28:15.038842', '16:28:15.038842', '2006-05-19 22:17:56.026258', '2006-05-19 22:17:56.026258', 'm', 'm'),(237, 7, '2009-02-10', '2009-02-10', '00:00:00', '00:00:00', '2002-01-11 16:39:37.030007', '2002-01-11 16:39:37.030007', 'd', 'd'),(4, 6, '2002-01-03', '2002-01-03', NULL, NULL, '2005-07-28 17:03:18.024439', '2005-07-28 17:03:18.024439', 'b', 'b'),(35, 235, '2003-11-07', '2003-11-07', '00:00:00', '00:00:00', NULL, NULL, 'z', 'z'),(162, 46, '2008-09-27', '2008-09-27', '09:36:30.005190', '09:36:30.005190', '2003-10-16 09:48:42.055969', '2003-10-16 09:48:42.055969', 'u', 'u'),(3, 0, '2000-11-02', '2000-11-02', '00:00:00', '00:00:00', '2005-07-17 08:37:44.021873', '2005-07-17 08:37:44.021873', 'b', 'b'),(8, 0, '2000-12-05', '2000-12-05', '17:10:09.006359', '17:10:09.006359', '2006-11-02 00:24:04.054859', '2006-11-02 00:24:04.054859', 'o', 'o'),(9, 0, '1900-01-01', '1900-01-01', '10:00:50.061246', '10:00:50.061246', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 's', 's'),(2, 8, '2008-05-21', '2008-05-21', '12:06:31.036247', '12:06:31.036247', '2007-01-08 19:11:58.049704', '2007-01-08 19:11:58.049704', 'f', 'f'),(67, 118, NULL, NULL, '18:20:57.009809', '18:20:57.009809', '2003-12-12 13:58:32.061496', '2003-12-12 13:58:32.061496', 'x', 'x'),(1, 5, '2009-12-19', '2009-12-19', '00:45:40.017191', '00:45:40.017191', '2001-06-11 02:03:39.014331', '2001-06-11 02:03:39.014331', 'f', 'f'),(2, 0, '2007-05-12', '2007-05-12', '12:34:50.052556', '12:34:50.052556', '2009-06-16 08:00:03.019340', '2009-06-16 08:00:03.019340', 'm', 'm'),(5, 0, '2006-01-26', '2006-01-26', '07:24:44.020701', '07:24:44.020701', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'l', 'l'),(7, 9, '2007-05-19', '2007-05-19', '03:55:07.008179', '03:55:07.008179', '2006-12-11 00:00:00', '2006-12-11 00:00:00', 'n', 'n'),(4, 3, '1900-01-01', '1900-01-01', '11:18:36.020832', '11:18:36.020832', NULL, NULL, NULL, NULL),(9, 2, '2005-08-22', '2005-08-22', '22:04:46.043018', '22:04:46.043018', '2007-05-27 00:00:00', '2007-05-27 00:00:00', 'b', 'b'),(65, 114, '1900-01-01', '1900-01-01', '19:56:30.055280', '19:56:30.055280', '2008-09-23 00:00:00', '2008-09-23 00:00:00', 'm', 'm'),(NULL, 8, '2007-03-03', '2007-03-03', '18:53:08.015995', '18:53:08.015995', '2007-03-08 22:50:59.031257', '2007-03-08 22:50:59.031257', NULL, NULL),(240, 170, '2003-09-21', '2003-09-21', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'j', 'j'),(236, 131, '2001-12-04', '2001-12-04', '08:43:37.057479', '08:43:37.057479', '2002-07-16 23:51:09.060515', '2002-07-16 23:51:09.060515', 'w', 'w'),(1, 2, '2004-02-22', '2004-02-22', '01:23:11.014485', '01:23:11.014485', NULL, NULL, 's', 's'),(6, 2, '2009-03-21', '2009-03-21', '10:44:58.063708', '10:44:58.063708', '2002-07-19 19:06:51.053051', '2002-07-19 19:06:51.053051', 'h', 'h'),(9, 0, '2009-10-20', '2009-10-20', '11:26:59.043332', '11:26:59.043332', '2007-11-01 13:09:33.010116', '2007-11-01 13:09:33.010116', 'k', 'k'),(NULL, 2, '2001-12-13', '2001-12-13', '14:16:27.039357', '14:16:27.039357', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'o', 'o'),(120, 49, '2002-12-24', '2002-12-24', '09:29:35.050222', '09:29:35.050222', '2009-09-23 11:00:21.008223', '2009-09-23 11:00:21.008223', 'j', 'j'),(7, 6, '1900-01-01', '1900-01-01', '04:35:02.009941', '04:35:02.009941', '2004-06-05 00:00:00', '2004-06-05 00:00:00', NULL, NULL),(NULL, 7, NULL, NULL, '04:19:06.039364', '04:19:06.039364', '2007-04-08 00:22:44.025018', '2007-04-08 00:22:44.025018', 'o', 'o'),(3, 9, '2000-10-03', '2000-10-03', NULL, NULL, '2002-06-19 23:02:56.030151', '2002-06-19 23:02:56.030151', 'y', 'y'),(NULL, 2, '2001-01-08', '2001-01-08', '00:00:00', '00:00:00', '2003-04-07 19:40:54.037199', '2003-04-07 19:40:54.037199', 'd', 'd'),(NULL, 5, '2004-10-20', '2004-10-20', '23:45:21.054808', '23:45:21.054808', '2002-02-01 00:00:00', '2002-02-01 00:00:00', 'b', 'b'),(NULL, 2, '2000-10-17', '2000-10-17', '05:00:38.043922', '05:00:38.043922', '2003-03-02 13:04:36.026635', '2003-03-02 13:04:36.026635', 'u', 'u'),(NULL, 0, '2000-11-16', '2000-11-16', '16:06:03.059850', '16:06:03.059850', '2008-11-04 23:02:08.051231', '2008-11-04 23:02:08.051231', 'd', 'd'),(7, 4, '2008-08-12', '2008-08-12', '21:11:55.041754', '21:11:55.041754', '2003-11-10 13:45:37.034510', '2003-11-10 13:45:37.034510', 'w', 'w'),(121, 242, '1900-01-01', '1900-01-01', '11:40:08.038618', '11:40:08.038618', '2008-02-12 00:00:00', '2008-02-12 00:00:00', 'z', 'z'),(6, 5, '2005-02-20', '2005-02-20', '14:56:43.020077', '14:56:43.020077', '2006-10-07 14:18:30.023797', '2006-10-07 14:18:30.023797', 'u', 'u'),(8, 5, NULL, NULL, '22:03:39.059060', '22:03:39.059060', '2004-04-10 00:00:00', '2004-04-10 00:00:00', 'g', 'g'),(240, 251, '2006-02-26', '2006-02-26', '08:23:40.032186', '08:23:40.032186', NULL, NULL, 'o', 'o'),(7, 1, '2001-01-19', '2001-01-19', '10:15:37.010143', '10:15:37.010143', '2005-05-26 16:03:41.040941', '2005-05-26 16:03:41.040941', 'h', 'h'),(5, NULL, '2003-01-11', '2003-01-11', '00:00:00', '00:00:00', '2000-03-06 21:25:55.054047', '2000-03-06 21:25:55.054047', 'h', 'h'),(4, 4, NULL, NULL, '02:59:15.057629', '02:59:15.057629', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'n', 'n'),(NULL, 1, '2006-12-08', '2006-12-08', NULL, NULL, '2005-03-10 17:30:25.019829', '2005-03-10 17:30:25.019829', 't', 't'),(1, 4, '2006-10-16', '2006-10-16', '03:38:20.009625', '03:38:20.009625', NULL, NULL, 'y', 'y'),(2, 3, NULL, NULL, '03:17:35.014995', '03:17:35.014995', '2007-10-12 00:00:00', '2007-10-12 00:00:00', 't', 't'),(6, 3, NULL, NULL, '03:43:10.005369', '03:43:10.005369', '2004-09-08 01:15:20.014497', '2004-09-08 01:15:20.014497', 'a', 'a'),(NULL, 7, '2001-09-19', '2001-09-19', '00:00:00', '00:00:00', NULL, NULL, 'y', 'y'),(0, 7, '2000-08-05', '2000-08-05', '20:14:28.013061', '20:14:28.013061', '2008-01-05 18:47:14.049915', '2008-01-05 18:47:14.049915', 'p', 'p'),(NULL, 7, '2001-01-16', '2001-01-16', '19:55:14.016743', '19:55:14.016743', NULL, NULL, 'r', 'r'),(0, 4, '2009-12-26', '2009-12-26', '18:10:27.003941', '18:10:27.003941', '2004-03-25 09:04:18.055435', '2004-03-25 09:04:18.055435', 'n', 'n'),(6, 2, '2006-09-14', '2006-09-14', '00:00:00', '00:00:00', '2002-01-08 06:25:08.033286', '2002-01-08 06:25:08.033286', 'v', 'v'),(NULL, 0, '2001-06-21', '2001-06-21', '14:25:27.012332', '14:25:27.012332', '2004-09-28 12:51:04.034136', '2004-09-28 12:51:04.034136', 'u', 'u'),(4, 3, '2006-11-26', '2006-11-26', '19:45:18.001908', '19:45:18.001908', NULL, NULL, 'w', 'w'),(8, 5, '2005-03-23', '2005-03-23', '10:58:03.022898', '10:58:03.022898', '2002-10-10 15:50:58.021141', '2002-10-10 15:50:58.021141', 'x', 'x'),(8, 5, '2002-05-18', '2002-05-18', '16:57:06.041041', '16:57:06.041041', '2002-01-25 00:00:00', '2002-01-25 00:00:00', 'd', 'd'),(7, 1, '2008-01-17', '2008-01-17', '13:02:51.061359', '13:02:51.061359', '2005-10-03 04:21:29.030514', '2005-10-03 04:21:29.030514', 'm', 'm'),(9, 6, '2008-04-07', '2008-04-07', '11:28:23.037208', '11:28:23.037208', '2005-08-05 16:14:11.045568', '2005-08-05 16:14:11.045568', 'z', 'z'),(4, 4, '2002-03-21', '2002-03-21', '00:00:00', '00:00:00', '2004-10-06 23:55:56.033537', '2004-10-06 23:55:56.033537', 's', 's'),(7, 4, NULL, NULL, '05:24:40.026869', '05:24:40.026869', '2009-07-13 17:46:55.042744', '2009-07-13 17:46:55.042744', 'g', 'g'),(5, 9, '1900-01-01', '1900-01-01', '04:31:20.020509', '04:31:20.020509', '2004-03-19 00:00:00', '2004-03-19 00:00:00', 'q', 'q'),(5, 8, '2005-12-15', '2005-12-15', '01:22:10.002395', '01:22:10.002395', '2009-07-25 02:58:47.056043', '2009-07-25 02:58:47.056043', 'u', 'u'),(NULL, 1, '2007-08-20', '2007-08-20', '03:02:42.026399', '03:02:42.026399', '2008-07-06 10:09:42.026704', '2008-07-06 10:09:42.026704', 't', 't'),(5, 7, '2005-05-13', '2005-05-13', '12:40:06.058272', '12:40:06.058272', '2007-10-27 18:02:15.009624', '2007-10-27 18:02:15.009624', 'o', 'o'),(4, 8, '2000-03-21', '2000-03-21', '20:04:49.024749', '20:04:49.024749', NULL, NULL, 'w', 'w'),(176, 249, '2008-08-28', '2008-08-28', '03:56:57.045962', '03:56:57.045962', '2006-09-02 05:43:58.026431', '2006-09-02 05:43:58.026431', 'p', 'p'),(4, 8, '2005-11-23', '2005-11-23', '00:00:00', '00:00:00', '2003-03-10 23:37:10.030186', '2003-03-10 23:37:10.030186', 'y', 'y'),(5, 0, '2003-08-08', '2003-08-08', '10:00:38.013676', '10:00:38.013676', '2001-08-06 00:00:00', '2001-08-06 00:00:00', 'd', 'd'),(NULL, 1, '2009-06-27', '2009-06-27', '07:29:23.053975', '07:29:23.053975', '2005-08-08 14:14:11.050944', '2005-08-08 14:14:11.050944', 'v', 'v'),(19, NULL, '2008-08-11', '2008-08-11', '00:00:00', '00:00:00', '2002-04-05 19:25:12.055192', '2002-04-05 19:25:12.055192', 'h', 'h'),(NULL, 3, '1900-01-01', '1900-01-01', '10:45:29.048819', '10:45:29.048819', '2007-06-09 07:37:03.002789', '2007-06-09 07:37:03.002789', 'z', 'z'),(86, 51, '2003-11-21', '2003-11-21', '00:57:57.060407', '00:57:57.060407', '2005-04-06 06:43:01.058103', '2005-04-06 06:43:01.058103', 'l', 'l'),(5, 2, '2008-10-10', '2008-10-10', '16:31:18.052942', '16:31:18.052942', '2007-03-01 02:37:25.035407', '2007-03-01 02:37:25.035407', 'j', 'j'),(NULL, 5, '1900-01-01', '1900-01-01', '04:04:03.020380', '04:04:03.020380', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'g', 'g'),(3, 4, '2001-11-15', '2001-11-15', '22:07:09.020612', '22:07:09.020612', '2001-04-10 14:46:36.034710', '2001-04-10 14:46:36.034710', 'b', 'b'),(6, 0, NULL, NULL, '12:37:47.002545', '12:37:47.002545', '2007-06-04 20:05:03.026041', '2007-06-04 20:05:03.026041', 'w', 'w'),(7, 6, '2006-04-23', '2006-04-23', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'w', 'w'),(120, NULL, NULL, NULL, NULL, NULL, '2009-07-14 14:29:35.046600', '2009-07-14 14:29:35.046600', 'w', 'w'),(8, 1, NULL, NULL, '00:43:31.033296', '00:43:31.033296', '2005-06-19 00:00:00', '2005-06-19 00:00:00', 'c', 'c'),(0, 6, '2001-01-18', '2001-01-18', '02:03:25.034368', '02:03:25.034368', NULL, NULL, 'a', 'a'),(NULL, NULL, '2005-04-04', '2005-04-04', '08:38:34.034082', '08:38:34.034082', '2008-11-02 05:08:02.037855', '2008-11-02 05:08:02.037855', 'o', 'o'),(NULL, 2, '2005-05-25', '2005-05-25', '03:34:51.046375', '03:34:51.046375', '2003-07-09 17:42:09.017411', '2003-07-09 17:42:09.017411', 'h', 'h'),(NULL, 7, '2000-09-09', '2000-09-09', '13:21:14.002621', '13:21:14.002621', '2008-05-11 00:00:00', '2008-05-11 00:00:00', 'd', 'd'),(0, 7, '2007-03-18', '2007-03-18', '00:00:00', '00:00:00', '2009-02-15 00:00:00', '2009-02-15 00:00:00', 'a', 'a'),(0, 7, '2005-06-27', '2005-06-27', '00:48:34.032616', '00:48:34.032616', '2008-07-19 04:07:12.008096', '2008-07-19 04:07:12.008096', 'j', 'j'),(3, 4, '2009-01-14', '2009-01-14', '12:10:42.034634', '12:10:42.034634', '2006-07-23 05:06:48.050284', '2006-07-23 05:06:48.050284', 'w', 'w'),(2, 9, NULL, NULL, '02:28:23.047612', '02:28:23.047612', '2009-09-08 17:46:45.061382', '2009-09-08 17:46:45.061382', 'k', 'k'),(8, 9, '2004-02-15', '2004-02-15', '15:00:50.031633', '15:00:50.031633', '2008-12-04 07:43:44.022333', '2008-12-04 07:43:44.022333', 'j', 'j'),(6, 7, NULL, NULL, '08:57:46.040289', '08:57:46.040289', '2005-01-09 11:59:42.015139', '2005-01-09 11:59:42.015139', 'h', 'h'),(NULL, 1, '2007-08-23', '2007-08-23', NULL, NULL, NULL, NULL, 'r', 'r'),(4, 2, '2001-11-24', '2001-11-24', '12:31:32.060060', '12:31:32.060060', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'f', 'f'),(1, 6, NULL, NULL, '02:17:53.021687', '02:17:53.021687', '2009-03-07 06:45:51.005414', '2009-03-07 06:45:51.005414', 'e', 'e'),(1, 1, '2003-01-01', '2003-01-01', '00:00:00', '00:00:00', '2006-04-26 09:43:52.006274', '2006-04-26 09:43:52.006274', 'h', 'h'),(2, 8, '2004-06-08', '2004-06-08', '03:07:22.007318', '03:07:22.007318', '2002-01-26 16:31:31.049490', '2002-01-26 16:31:31.049490', 'r', 'r'),(2, 7, '2008-03-07', '2008-03-07', '11:36:34.013598', '11:36:34.013598', '2002-12-12 00:05:25.022192', '2002-12-12 00:05:25.022192', 'u', 'u'),(0, NULL, '2008-10-19', '2008-10-19', '14:36:51.014419', '14:36:51.014419', '2007-08-13 23:05:27.013905', '2007-08-13 23:05:27.013905', 'x', 'x'),(1, 1, '2002-02-09', '2002-02-09', '00:00:00', '00:00:00', '2009-10-17 15:02:17.031290', '2009-10-17 15:02:17.031290', 'd', 'd'),(0, 1, '2003-05-06', '2003-05-06', '13:26:21.046263', '13:26:21.046263', '2007-09-02 09:41:34.036912', '2007-09-02 09:41:34.036912', 'm', 'm'),(9, 5, '2006-05-22', '2006-05-22', '14:34:58.010309', '14:34:58.010309', '2003-10-20 09:53:57.029299', '2003-10-20 09:53:57.029299', 'w', 'w'),(8, 8, '2000-12-28', '2000-12-28', '12:36:29.059371', '12:36:29.059371', '2009-10-22 12:41:41.030410', '2009-10-22 12:41:41.030410', 'a', 'a'),(9, 8, '2008-06-09', '2008-06-09', '15:18:04.046770', '15:18:04.046770', NULL, NULL, 'g', 'g'),(2, 6, '2002-02-01', '2002-02-01', '01:44:07.000507', '01:44:07.000507', '2006-04-16 02:39:44.036931', '2006-04-16 02:39:44.036931', 'g', 'g'),(191, 207, '2009-05-01', '2009-05-01', '10:58:10.045009', '10:58:10.045009', '2001-01-25 23:04:52.027144', '2001-01-25 23:04:52.027144', 'b', 'b'),(2, 9, '2004-01-08', '2004-01-08', '20:53:12.023180', '20:53:12.023180', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(6, 0, '2009-05-04', '2009-05-04', '20:58:07.042339', '20:58:07.042339', '2006-01-27 02:48:23.025881', '2006-01-27 02:48:23.025881', 'u', 'u'),(2, 2, '2005-08-16', '2005-08-16', '00:27:48.003217', '00:27:48.003217', '2004-06-08 00:00:00', '2004-06-08 00:00:00', 'l', 'l'),(1, 8, '1900-01-01', '1900-01-01', '16:22:16.021240', '16:22:16.021240', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'x', 'x'),(7, 8, '2007-10-05', '2007-10-05', '02:53:27.002185', '02:53:27.002185', '2000-10-03 15:38:51.049185', '2000-10-03 15:38:51.049185', 'q', 'q'),(0, 5, '2008-07-12', '2008-07-12', '11:18:33.000511', '11:18:33.000511', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'm', 'm'),(5, 2, '2005-09-15', '2005-09-15', '02:26:37.034908', '02:26:37.034908', '2006-07-26 02:56:37.042438', '2006-07-26 02:56:37.042438', 's', 's'),(34, 195, '2007-04-12', '2007-04-12', '03:55:19.062613', '03:55:19.062613', '2002-03-15 12:08:55.051620', '2002-03-15 12:08:55.051620', 'j', 'j'),(2, 8, '2007-12-10', '2007-12-10', '11:53:57.030553', '11:53:57.030553', '2001-06-25 00:00:00', '2001-06-25 00:00:00', 'l', 'l'),(5, 3, '2007-12-17', '2007-12-17', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'z', 'z'),(0, 7, '2009-12-08', '2009-12-08', '13:13:53.018522', '13:13:53.018522', '2002-06-13 18:30:24.001760', '2002-06-13 18:30:24.001760', 'g', 'g'),(2, 7, '2005-07-11', '2005-07-11', '01:52:16.043900', '01:52:16.043900', NULL, NULL, 'h', 'h'),(1, 5, '2005-01-14', '2005-01-14', '13:40:04.043861', '13:40:04.043861', '2002-10-17 20:37:07.051450', '2002-10-17 20:37:07.051450', 'c', 'c'),(0, 9, '2001-08-10', '2001-08-10', '19:27:42.012449', '19:27:42.012449', '2002-09-07 05:27:45.035433', '2002-09-07 05:27:45.035433', 'y', 'y'),(1, 6, '2009-03-06', '2009-03-06', '00:00:00', '00:00:00', '2005-09-19 06:01:44.045544', '2005-09-19 06:01:44.045544', 'e', 'e'),(55, 141, '2003-03-19', '2003-03-19', '04:48:49.058161', '04:48:49.058161', '2007-09-04 03:14:29.012179', '2007-09-04 03:14:29.012179', 'n', 'n'),(5, 5, '2006-03-07', '2006-03-07', '01:11:43.043720', '01:11:43.043720', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'q', 'q'),(2, 7, NULL, NULL, '20:59:44.010869', '20:59:44.010869', '2002-07-21 20:10:51.034329', '2002-07-21 20:10:51.034329', 'i', 'i'),(4, 7, '2000-02-04', '2000-02-04', '03:02:18.048166', '03:02:18.048166', '2007-11-26 10:34:39.044191', '2007-11-26 10:34:39.044191', 'f', 'f'),(NULL, 5, '2006-01-21', '2006-01-21', '14:12:47.009524', '14:12:47.009524', NULL, NULL, 'q', 'q'),(5, 7, '1900-01-01', '1900-01-01', '05:45:50.009326', '05:45:50.009326', '2009-01-08 00:00:00', '2009-01-08 00:00:00', 'r', 'r'),(4, 3, '2002-10-16', '2002-10-16', '17:16:43.030750', '17:16:43.030750', NULL, NULL, NULL, NULL),(3, 7, '2006-06-08', '2006-06-08', '09:19:46.016061', '09:19:46.016061', NULL, NULL, 'a', 'a'),(NULL, 0, NULL, NULL, '09:18:01.029961', '09:18:01.029961', '2008-08-26 05:09:30.057897', '2008-08-26 05:09:30.057897', 'u', 'u'),(2, 6, NULL, NULL, '16:17:42.045766', '16:17:42.045766', '2002-08-09 03:55:40.027669', '2002-08-09 03:55:40.027669', 'l', 'l'),(1, NULL, '2005-12-19', '2005-12-19', '12:32:23.055161', '12:32:23.055161', '2000-10-08 10:14:36.025857', '2000-10-08 10:14:36.025857', 'e', 'e'),(1, NULL, '2008-12-06', '2008-12-06', '01:41:25.012900', '01:41:25.012900', '2003-01-15 00:00:00', '2003-01-15 00:00:00', 'w', 'w'),(7, 7, '1900-01-01', '1900-01-01', '11:53:34.037526', '11:53:34.037526', NULL, NULL, 'l', 'l'),(3, 3, '2006-09-14', '2006-09-14', '00:00:00', '00:00:00', NULL, NULL, 's', 's'),(3, 2, NULL, NULL, NULL, NULL, '2000-03-16 12:37:17.006684', '2000-03-16 12:37:17.006684', NULL, NULL),(5, 6, '2003-07-18', '2003-07-18', '09:20:59.044434', '09:20:59.044434', '2009-09-07 02:14:06.050509', '2009-09-07 02:14:06.050509', 'n', 'n'),(NULL, 3, '2001-05-19', '2001-05-19', '14:44:58.033857', '14:44:58.033857', '2001-09-27 11:44:45.064834', '2001-09-27 11:44:45.064834', 'c', 'c'),(7, 4, NULL, NULL, '09:59:58.035128', '09:59:58.035128', '2004-09-03 14:19:35.058667', '2004-09-03 14:19:35.058667', 's', 's'),(3, 9, '2008-03-13', '2008-03-13', '23:46:32.053417', '23:46:32.053417', '2009-06-18 07:50:16.035104', '2009-06-18 07:50:16.035104', 'w', 'w'),(7, 7, '2000-09-26', '2000-09-26', '05:37:58.027262', '05:37:58.027262', '2001-01-04 02:26:48.033897', '2001-01-04 02:26:48.033897', 'h', 'h'),(NULL, 0, NULL, NULL, NULL, NULL, '2001-01-28 00:00:00', '2001-01-28 00:00:00', 'v', 'v'),(3, NULL, '2002-07-10', '2002-07-10', '00:05:54.016021', '00:05:54.016021', '2008-09-04 10:43:59.055331', '2008-09-04 10:43:59.055331', 'q', 'q'),(4, NULL, '2000-04-27', '2000-04-27', '18:53:46.064085', '18:53:46.064085', '2002-04-22 12:33:28.037271', '2002-04-22 12:33:28.037271', 'k', 'k'),(5, 1, '1900-01-01', '1900-01-01', NULL, NULL, '2000-10-06 19:13:11.002929', '2000-10-06 19:13:11.002929', NULL, NULL),(1, 1, '2008-02-11', '2008-02-11', '00:00:00', '00:00:00', '2001-04-19 23:14:27.022644', '2001-04-19 23:14:27.022644', 'c', 'c'),(0, NULL, '2008-07-18', '2008-07-18', '14:08:42.053972', '14:08:42.053972', '2003-04-06 06:14:54.018713', '2003-04-06 06:14:54.018713', 'd', 'd'),(2, 4, '2005-06-11', '2005-06-11', '19:56:40.015796', '19:56:40.015796', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(NULL, 1, '2000-08-23', '2000-08-23', '00:00:00', '00:00:00', '2007-11-09 01:53:02.009771', '2007-11-09 01:53:02.009771', 'v', 'v'),(7, 0, '2009-01-08', '2009-01-08', '16:24:26.054238', '16:24:26.054238', NULL, NULL, 'u', 'u'),(NULL, 2, '2005-04-18', '2005-04-18', '10:59:44.043890', '10:59:44.043890', '2004-07-11 13:09:42.021113', '2004-07-11 13:09:42.021113', NULL, NULL),(NULL, 5, '2007-09-20', '2007-09-20', '00:00:00', '00:00:00', '2002-01-18 00:00:00', '2002-01-18 00:00:00', 'w', 'w'),(3, 0, NULL, NULL, '00:00:00', '00:00:00', NULL, NULL, 'k', 'k'),(5, NULL, '2008-12-24', '2008-12-24', '15:39:26.002716', '15:39:26.002716', '2005-08-06 16:11:55.034907', '2005-08-06 16:11:55.034907', 'b', 'b'),(0, 3, '2003-01-16', '2003-01-16', '16:06:45.060711', '16:06:45.060711', '2003-09-24 00:00:00', '2003-09-24 00:00:00', 's', 's'),(4, 5, '2002-10-25', '2002-10-25', '15:54:08.053182', '15:54:08.053182', '2003-09-07 14:43:32.006553', '2003-09-07 14:43:32.006553', 'u', 'u'),(6, 6, '2001-06-01', '2001-06-01', '03:46:38.033474', '03:46:38.033474', '2002-04-22 00:00:00', '2002-04-22 00:00:00', 'r', 'r'),(1, 1, '2009-05-02', '2009-05-02', '05:43:51.047352', '05:43:51.047352', '2001-03-07 00:00:00', '2001-03-07 00:00:00', 's', 's'),(4, NULL, '1900-01-01', '1900-01-01', '12:22:14.029334', '12:22:14.029334', NULL, NULL, NULL, NULL),(NULL, 1, '2009-08-28', '2009-08-28', '05:12:03.053488', '05:12:03.053488', '2006-11-09 17:04:42.027336', '2006-11-09 17:04:42.027336', 'v', 'v'),(9, 4, '2009-02-20', '2009-02-20', '08:07:08.033992', '08:07:08.033992', '2009-11-04 21:13:34.059626', '2009-11-04 21:13:34.059626', 'f', 'f'),(4, 0, '2008-09-01', '2008-09-01', '01:00:16.028034', '01:00:16.028034', '2002-01-27 00:13:48.037339', '2002-01-27 00:13:48.037339', 's', 's'),(NULL, 3, '2001-03-27', '2001-03-27', '00:23:44.007725', '00:23:44.007725', '2009-10-24 14:35:10.057946', '2009-10-24 14:35:10.057946', 'z', 'z'),(NULL, 3, NULL, NULL, '04:52:28.016964', '04:52:28.016964', '2001-02-15 03:55:02.043581', '2001-02-15 03:55:02.043581', 'c', 'c'),(7, 1, '1900-01-01', '1900-01-01', '07:18:26.045449', '07:18:26.045449', NULL, NULL, 'w', 'w'),(3, 6, '2008-05-07', '2008-05-07', '03:52:16.015402', '03:52:16.015402', '2002-10-21 10:53:15.051193', '2002-10-21 10:53:15.051193', 'k', 'k'),(1, 3, '2000-06-15', '2000-06-15', '13:20:39.047468', '13:20:39.047468', '2005-05-04 17:14:08.003850', '2005-05-04 17:14:08.003850', 'l', 'l'),(1, 5, '2005-02-19', '2005-02-19', '16:52:16.009390', '16:52:16.009390', NULL, NULL, 'f', 'f'),(55, 108, '2000-09-02', '2000-09-02', '17:08:53.013197', '17:08:53.013197', '2009-02-16 15:41:51.039299', '2009-02-16 15:41:51.039299', 's', 's'),(8, 0, '1900-01-01', '1900-01-01', '23:52:11.052274', '23:52:11.052274', '2002-06-10 19:46:10.032204', '2002-06-10 19:46:10.032204', 'k', 'k'),(6, 6, '2008-09-16', '2008-09-16', '13:09:13.036644', '13:09:13.036644', '2003-10-21 22:19:20.017134', '2003-10-21 22:19:20.017134', 'y', 'y'),(4, 0, '2000-08-04', '2000-08-04', '16:04:58.047005', '16:04:58.047005', '2000-09-10 14:51:30.017698', '2000-09-10 14:51:30.017698', 'm', 'm'),(3, 2, '2008-05-11', '2008-05-11', '01:32:41.049358', '01:32:41.049358', NULL, NULL, 'w', 'w'),(4, 1, '2005-10-22', '2005-10-22', '09:41:14.026105', '09:41:14.026105', '2009-03-03 00:00:00', '2009-03-03 00:00:00', 'x', 'x'),(9, 9, '2000-08-28', '2000-08-28', '10:30:35.038628', '10:30:35.038628', '2008-10-26 07:50:37.014570', '2008-10-26 07:50:37.014570', 'i', 'i'),(221, NULL, '2005-02-02', '2005-02-02', '15:39:35.044057', '15:39:35.044057', '2006-09-13 18:51:43.046377', '2006-09-13 18:51:43.046377', 'z', 'z'),(5, 7, '2005-12-09', '2005-12-09', '11:39:58.038218', '11:39:58.038218', '2004-03-02 02:51:15.065237', '2004-03-02 02:51:15.065237', 'f', 'f'),(7, 2, '2003-11-21', '2003-11-21', '09:40:20.046022', '09:40:20.046022', '2005-11-13 00:00:00', '2005-11-13 00:00:00', 'c', 'c'),(7, NULL, '2008-01-19', '2008-01-19', NULL, NULL, '2007-04-19 06:55:07.002105', '2007-04-19 06:55:07.002105', 'p', 'p'),(3, 5, '2008-07-01', '2008-07-01', '04:32:34.003943', '04:32:34.003943', '2004-01-12 22:50:49.017673', '2004-01-12 22:50:49.017673', NULL, NULL),(5, 9, '1900-01-01', '1900-01-01', '03:03:29.023434', '03:03:29.023434', '2002-03-08 20:39:37.014665', '2002-03-08 20:39:37.014665', 'g', 'g'),(1, 5, '2003-06-02', '2003-06-02', '15:26:29.015592', '15:26:29.015592', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(3, 8, NULL, NULL, '11:05:51.025033', '11:05:51.025033', '2004-02-01 19:54:12.031426', '2004-02-01 19:54:12.031426', 'w', 'w'),(2, 6, '1900-01-01', '1900-01-01', '00:03:44.000534', '00:03:44.000534', '2008-01-02 07:16:21.065229', '2008-01-02 07:16:21.065229', 'h', 'h'),(1, 9, '2002-04-25', '2002-04-25', '16:43:48.050330', '16:43:48.050330', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'r', 'r'),(2, 6, '2008-08-05', '2008-08-05', '20:25:08.050337', '20:25:08.050337', NULL, NULL, 'v', 'v'),(24, 207, '2009-01-22', '2009-01-22', '18:56:19.027314', '18:56:19.027314', '2003-04-03 00:00:00', '2003-04-03 00:00:00', 'v', 'v'),(4, 9, NULL, NULL, '09:51:00.036234', '09:51:00.036234', '2009-10-15 00:00:00', '2009-10-15 00:00:00', 'f', 'f'),(5, 3, '2008-10-23', '2008-10-23', '08:16:04.015887', '08:16:04.015887', '2003-09-24 16:00:47.041116', '2003-09-24 16:00:47.041116', 'j', 'j'),(4, 7, '2009-03-15', '2009-03-15', '07:33:15.006758', '07:33:15.006758', '2009-05-06 03:49:51.019258', '2009-05-06 03:49:51.019258', NULL, NULL),(3, NULL, '2004-02-21', '2004-02-21', '22:18:07.060540', '22:18:07.060540', '2004-09-05 00:00:00', '2004-09-05 00:00:00', 'n', 'n'),(0, 1, '1900-01-01', '1900-01-01', '04:58:26.024642', '04:58:26.024642', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'g', 'g'),(9, 5, '2002-04-15', '2002-04-15', '09:46:09.023701', '09:46:09.023701', '2008-07-04 19:02:55.023893', '2008-07-04 19:02:55.023893', 'n', 'n'),(NULL, 2, '2008-03-06', '2008-03-06', '05:55:16.023106', '05:55:16.023106', '2008-09-28 08:48:36.004066', '2008-09-28 08:48:36.004066', 'k', 'k'),(4, 1, '2000-05-14', '2000-05-14', '15:52:54.061816', '15:52:54.061816', '2005-01-03 19:49:38.042368', '2005-01-03 19:49:38.042368', 't', 't'),(1, 6, '2007-03-08', '2007-03-08', '17:00:05.051810', '17:00:05.051810', '2007-10-05 00:00:00', '2007-10-05 00:00:00', 'w', 'w'),(1, 1, '2006-12-09', '2006-12-09', '06:27:23.026519', '06:27:23.026519', '2004-06-22 10:40:35.054283', '2004-06-22 10:40:35.054283', 'q', 'q'),(2, 1, '2002-07-14', '2002-07-14', '00:20:46.020456', '00:20:46.020456', '2006-10-09 09:56:18.028618', '2006-10-09 09:56:18.028618', 'z', 'z'),(4, 2, '1900-01-01', '1900-01-01', '18:30:14.025146', '18:30:14.025146', '2000-10-11 00:00:00', '2000-10-11 00:00:00', 'z', 'z'),(81, 11, '2001-01-27', '2001-01-27', '00:00:00', '00:00:00', '2008-11-01 16:39:20.040419', '2008-11-01 16:39:20.040419', 'z', 'z'),(1, 7, '2003-08-23', '2003-08-23', '11:24:08.043566', '11:24:08.043566', '2005-08-04 11:01:11.025601', '2005-08-04 11:01:11.025601', 'u', 'u'),(9, 7, '2001-01-05', '2001-01-05', '19:38:37.012379', '19:38:37.012379', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'p', 'p'),(48, 155, '2008-07-24', '2008-07-24', '21:55:15.032904', '21:55:15.032904', '2009-06-09 00:00:00', '2009-06-09 00:00:00', 'v', 'v'),(2, 7, NULL, NULL, '09:43:23.027255', '09:43:23.027255', '2007-04-01 00:00:00', '2007-04-01 00:00:00', 'a', 'a'),(3, 2, '2006-09-19', '2006-09-19', NULL, NULL, '2006-09-22 20:53:53.017932', '2006-09-22 20:53:53.017932', 'd', 'd'),(9, 0, '1900-01-01', '1900-01-01', '13:26:00.029063', '13:26:00.029063', '2005-05-11 00:00:00', '2005-05-11 00:00:00', 'a', 'a'),(6, 0, '2007-08-13', '2007-08-13', '13:10:48.033588', '13:10:48.033588', '2008-04-16 03:09:58.051805', '2008-04-16 03:09:58.051805', 'k', 'k'),(5, NULL, '1900-01-01', '1900-01-01', '13:58:12.062405', '13:58:12.062405', '2003-12-16 09:13:26.053817', '2003-12-16 09:13:26.053817', 'j', 'j'),(9, 9, '2008-05-26', '2008-05-26', '00:00:00', '00:00:00', '2001-01-06 18:04:35.059873', '2001-01-06 18:04:35.059873', 's', 's'),(2, 9, '2009-06-02', '2009-06-02', '12:03:52.057143', '12:03:52.057143', NULL, NULL, 'w', 'w'),(0, 0, '2007-04-20', '2007-04-20', '19:12:21.053786', '19:12:21.053786', '2007-07-08 17:25:18.029649', '2007-07-08 17:25:18.029649', 'k', 'k'),(NULL, NULL, '2007-06-11', '2007-06-11', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'n', 'n'),(9, 2, '2004-09-21', '2004-09-21', '01:03:07.021337', '01:03:07.021337', '2002-07-27 18:13:04.060783', '2002-07-27 18:13:04.060783', 'o', 'o'),(2, 5, '2006-04-20', '2006-04-20', '09:02:08.010808', '09:02:08.010808', '2007-08-28 20:09:01.055267', '2007-08-28 20:09:01.055267', 'z', 'z'),(8, 8, '2005-07-11', '2005-07-11', NULL, NULL, '2009-10-07 05:56:42.044404', '2009-10-07 05:56:42.044404', 'u', 'u'),(3, 1, '2007-09-12', '2007-09-12', '23:59:50.039828', '23:59:50.039828', '2008-02-26 23:56:03.024006', '2008-02-26 23:56:03.024006', 'v', 'v'),(0, 7, '2005-02-04', '2005-02-04', NULL, NULL, '2001-04-14 23:08:04.032395', '2001-04-14 23:08:04.032395', 'h', 'h'),(3, 2, '1900-01-01', '1900-01-01', '23:50:10.007329', '23:50:10.007329', '2007-01-04 00:27:37.054187', '2007-01-04 00:27:37.054187', 'o', 'o'),(7, 9, '2007-03-26', '2007-03-26', NULL, NULL, '2009-08-13 05:16:57.042362', '2009-08-13 05:16:57.042362', NULL, NULL),(7, 0, '2001-11-19', '2001-11-19', '16:01:04.029311', '16:01:04.029311', '2001-11-26 00:00:00', '2001-11-26 00:00:00', 'w', 'w'),(1, 8, '2007-03-06', '2007-03-06', NULL, NULL, '2004-11-15 04:59:46.025322', '2004-11-15 04:59:46.025322', 'w', 'w'),(57, NULL, NULL, NULL, '19:30:06.015423', '19:30:06.015423', '2001-05-04 01:42:59.042282', '2001-05-04 01:42:59.042282', 'l', 'l'),(7, 7, '2008-09-03', '2008-09-03', '05:02:52.027361', '05:02:52.027361', '2008-10-08 06:04:10.026309', '2008-10-08 06:04:10.026309', 's', 's'),(9, 3, '2009-01-16', '2009-01-16', '16:53:44.006887', '16:53:44.006887', '2000-02-01 19:50:27.014927', '2000-02-01 19:50:27.014927', 'i', 'i'),(7, 7, '2001-04-03', '2001-04-03', '15:57:21.059570', '15:57:21.059570', '2007-01-04 15:17:43.037883', '2007-01-04 15:17:43.037883', NULL, NULL),(0, 7, '2007-03-03', '2007-03-03', '00:00:00', '00:00:00', '2006-01-05 15:12:48.029595', '2006-01-05 15:12:48.029595', 's', 's'),(3, 2, '2000-09-08', '2000-09-08', '07:55:18.021246', '07:55:18.021246', '2003-04-18 10:43:19.024679', '2003-04-18 10:43:19.024679', 'm', 'm'),(NULL, 3, '2008-05-05', '2008-05-05', '17:59:45.001624', '17:59:45.001624', '2001-04-02 19:20:18.063445', '2001-04-02 19:20:18.063445', 'b', 'b'),(8, 3, NULL, NULL, NULL, NULL, '2007-10-21 00:00:00', '2007-10-21 00:00:00', 'o', 'o'),(114, 221, '2004-04-08', '2004-04-08', '23:20:45.021316', '23:20:45.021316', '2009-10-17 05:49:00.028196', '2009-10-17 05:49:00.028196', 'a', 'a'),(40, 34, '2003-07-14', '2003-07-14', '15:56:31.045208', '15:56:31.045208', '2007-04-13 15:56:14.029096', '2007-04-13 15:56:14.029096', 'g', 'g'),(9, 7, '2009-10-24', '2009-10-24', '05:14:36.045315', '05:14:36.045315', '2003-04-01 09:49:43.039174', '2003-04-01 09:49:43.039174', 'o', 'o'),(5, 3, '2003-06-20', '2003-06-20', '16:49:08.061670', '16:49:08.061670', '2009-02-07 19:31:27.009867', '2009-02-07 19:31:27.009867', 'y', 'y'),(0, 6, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'w', 'w'),(0, 1, '2003-10-10', '2003-10-10', '19:08:35.029723', '19:08:35.029723', '2008-06-16 02:12:52.054594', '2008-06-16 02:12:52.054594', 'i', 'i'),(NULL, NULL, '1900-01-01', '1900-01-01', '07:22:36.015383', '07:22:36.015383', '2000-09-16 20:06:11.021122', '2000-09-16 20:06:11.021122', 'f', 'f'),(NULL, 4, '2004-05-26', '2004-05-26', '02:14:32.012471', '02:14:32.012471', '2003-10-24 20:02:30.033726', '2003-10-24 20:02:30.033726', NULL, NULL),(0, NULL, '2006-03-17', '2006-03-17', '12:36:08.031308', '12:36:08.031308', '2009-12-07 04:29:58.001059', '2009-12-07 04:29:58.001059', 'y', 'y'),(3, 8, '2001-01-14', '2001-01-14', '09:14:08.014936', '09:14:08.014936', '2004-01-07 23:49:25.037930', '2004-01-07 23:49:25.037930', 'f', 'f'),(NULL, 9, '2006-09-08', '2006-09-08', '21:48:45.049745', '21:48:45.049745', '2008-03-02 00:07:03.039450', '2008-03-02 00:07:03.039450', 'g', 'g'),(3, 7, '2004-03-13', '2004-03-13', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'd', 'd'),(5, 9, NULL, NULL, '03:53:40.008828', '03:53:40.008828', '2002-05-16 20:42:48.039009', '2002-05-16 20:42:48.039009', 'm', 'm'),(8, 9, '2005-08-05', '2005-08-05', '10:39:51.040961', '10:39:51.040961', '2004-08-13 03:55:16.038602', '2004-08-13 03:55:16.038602', 'b', 'b'),(5, 1, '2000-09-07', '2000-09-07', '00:00:00', '00:00:00', '2002-05-21 23:48:48.015133', '2002-05-21 23:48:48.015133', 'r', 'r'),(101, 242, '1900-01-01', '1900-01-01', '19:38:44.001407', '19:38:44.001407', '2002-10-10 00:00:00', '2002-10-10 00:00:00', 'u', 'u'),(7, 7, NULL, NULL, '00:00:00', '00:00:00', '2001-10-28 17:35:06.003399', '2001-10-28 17:35:06.003399', 'u', 'u'),(6, 9, '2004-11-03', '2004-11-03', '09:43:13.031489', '09:43:13.031489', '2007-02-25 00:00:00', '2007-02-25 00:00:00', 'n', 'n'),(0, 3, '2004-01-23', '2004-01-23', '00:00:00', '00:00:00', '2000-04-08 03:06:41.018829', '2000-04-08 03:06:41.018829', 'b', 'b'),(5, 2, '2008-05-15', '2008-05-15', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'b', 'b'),(0, 6, '2007-05-20', '2007-05-20', '20:33:51.064039', '20:33:51.064039', NULL, NULL, 'd', 'd'),(6, 1, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(8, 1, '2007-04-01', '2007-04-01', '15:55:06.041752', '15:55:06.041752', '2002-05-28 16:59:50.040294', '2002-05-28 16:59:50.040294', 'd', 'd'),(6, 2, '2002-01-05', '2002-01-05', NULL, NULL, '2001-06-26 08:01:40.053583', '2001-06-26 08:01:40.053583', 'e', 'e'),(18, 247, '2004-10-22', '2004-10-22', NULL, NULL, '2000-07-19 00:47:37.049348', '2000-07-19 00:47:37.049348', 'i', 'i'),(NULL, 1, '2006-03-10', '2006-03-10', '06:21:20.056375', '06:21:20.056375', '2004-09-27 17:43:01.051000', '2004-09-27 17:43:01.051000', 'i', 'i'),(NULL, 1, '1900-01-01', '1900-01-01', '16:24:00.031463', '16:24:00.031463', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 's', 's'),(6, 4, '2001-03-01', '2001-03-01', '17:39:17.032723', '17:39:17.032723', NULL, NULL, NULL, NULL),(7, 3, '2005-08-21', '2005-08-21', NULL, NULL, '2006-06-26 12:57:48.030306', '2006-06-26 12:57:48.030306', 'g', 'g'),(5, 2, '2004-04-07', '2004-04-07', '21:41:53.065501', '21:41:53.065501', NULL, NULL, 'j', 'j'),(9, 9, '2004-06-02', '2004-06-02', '05:36:23.041549', '05:36:23.041549', '2007-07-26 17:21:00.000677', '2007-07-26 17:21:00.000677', 'z', 'z'),(3, 7, '2000-08-24', '2000-08-24', '15:21:53.041439', '15:21:53.041439', '2009-10-22 17:11:04.006245', '2009-10-22 17:11:04.006245', 'v', 'v'),(8, 7, '2005-04-20', '2005-04-20', '05:45:04.003839', '05:45:04.003839', '2006-03-04 06:12:34.018454', '2006-03-04 06:12:34.018454', 'v', 'v'),(53, NULL, '1900-01-01', '1900-01-01', '09:50:07.057089', '09:50:07.057089', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'm', 'm'),(5, 0, NULL, NULL, '01:08:11.042247', '01:08:11.042247', NULL, NULL, 's', 's'),(3, 6, '2008-12-17', '2008-12-17', '20:13:41.030057', '20:13:41.030057', '2008-12-05 00:01:47.059495', '2008-12-05 00:01:47.059495', 'f', 'f'),(134, 159, '2003-01-12', '2003-01-12', NULL, NULL, '2009-04-08 00:00:00', '2009-04-08 00:00:00', 'm', 'm'),(NULL, 0, '2002-04-24', '2002-04-24', '21:08:35.064143', '21:08:35.064143', '2000-12-05 05:53:11.049227', '2000-12-05 05:53:11.049227', 'j', 'j'),(1, 2, '2001-07-06', '2001-07-06', '11:12:35.007134', '11:12:35.007134', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(4, 7, '2004-12-25', '2004-12-25', '23:37:35.039451', '23:37:35.039451', '2005-03-27 00:00:00', '2005-03-27 00:00:00', 'f', 'f'),(2, 4, '2007-08-08', '2007-08-08', '06:16:07.020290', '06:16:07.020290', '2007-03-08 00:00:00', '2007-03-08 00:00:00', 'n', 'n'),(NULL, 2, '2007-03-15', '2007-03-15', '07:09:49.043306', '07:09:49.043306', '2005-02-11 09:44:26.002323', '2005-02-11 09:44:26.002323', 'q', 'q'),(2, 8, NULL, NULL, '03:21:04.044293', '03:21:04.044293', '2004-06-28 10:59:34.013861', '2004-06-28 10:59:34.013861', 'w', 'w'),(8, 1, '2005-11-05', '2005-11-05', '17:39:52.005798', '17:39:52.005798', '2002-12-27 19:10:36.035034', '2002-12-27 19:10:36.035034', 's', 's'),(44, NULL, '2006-11-18', '2006-11-18', '12:04:58.057932', '12:04:58.057932', '2006-05-16 23:27:16.031447', '2006-05-16 23:27:16.031447', 'i', 'i'),(NULL, 8, '2008-07-09', '2008-07-09', '00:00:00', '00:00:00', '2006-08-02 07:22:45.042382', '2006-08-02 07:22:45.042382', 'y', 'y'),(34, 174, '2009-09-11', '2009-09-11', '12:13:25.003041', '12:13:25.003041', '2000-09-22 00:00:00', '2000-09-22 00:00:00', 'e', 'e'),(5, NULL, '2005-07-28', '2005-07-28', '07:03:44.026155', '07:03:44.026155', '2004-01-15 07:01:15.042331', '2004-01-15 07:01:15.042331', 'j', 'j'),(8, 4, '2006-02-12', '2006-02-12', '07:38:56.039714', '07:38:56.039714', '2001-01-07 02:14:44.056832', '2001-01-07 02:14:44.056832', 'k', 'k'),(7, 7, '2003-08-17', '2003-08-17', '22:13:22.006556', '22:13:22.006556', '2004-05-08 13:57:15.001926', '2004-05-08 13:57:15.001926', NULL, NULL),(9, 6, '2009-06-05', '2009-06-05', '08:57:29.004833', '08:57:29.004833', '2003-02-13 16:59:25.037906', '2003-02-13 16:59:25.037906', 'n', 'n'),(7, 0, NULL, NULL, '07:46:38.004941', '07:46:38.004941', '2005-03-25 08:01:05.057241', '2005-03-25 08:01:05.057241', 'k', 'k'),(2, 5, '1900-01-01', '1900-01-01', '09:12:49.005795', '09:12:49.005795', NULL, NULL, 't', 't'),(9, 4, NULL, NULL, NULL, NULL, '2005-08-03 00:00:00', '2005-08-03 00:00:00', 'j', 'j'),(9, 3, '2008-10-04', '2008-10-04', '20:52:50.052383', '20:52:50.052383', '2007-12-25 00:00:00', '2007-12-25 00:00:00', 'f', 'f'),(9, 2, '2004-06-07', '2004-06-07', '00:00:00', '00:00:00', '2005-12-23 00:00:00', '2005-12-23 00:00:00', 'b', 'b'),(NULL, 0, NULL, NULL, '09:57:48.009744', '09:57:48.009744', '2009-07-22 11:19:09.041762', '2009-07-22 11:19:09.041762', 'a', 'a'),(3, 2, '1900-01-01', '1900-01-01', '15:08:15.019683', '15:08:15.019683', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 's', 's'),(1, 2, '2002-01-08', '2002-01-08', '08:17:54.031784', '08:17:54.031784', '2007-05-06 17:04:32.016955', '2007-05-06 17:04:32.016955', 'f', 'f'),(NULL, 6, '2007-09-26', '2007-09-26', '14:48:01.022750', '14:48:01.022750', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'i', 'i'),(9, NULL, '2003-11-06', '2003-11-06', NULL, NULL, '2008-07-16 13:29:17.008529', '2008-07-16 13:29:17.008529', 't', 't'),(3, 2, '1900-01-01', '1900-01-01', NULL, NULL, '2008-11-05 23:43:03.012720', '2008-11-05 23:43:03.012720', 'p', 'p'),(0, 1, '2006-09-14', '2006-09-14', '16:17:13.050513', '16:17:13.050513', NULL, NULL, 'j', 'j'),(2, 0, '2000-11-13', '2000-11-13', '08:38:50.019098', '08:38:50.019098', '2002-04-15 16:06:31.007161', '2002-04-15 16:06:31.007161', 'f', 'f'),(9, NULL, '2003-06-10', '2003-06-10', '13:30:27.007395', '13:30:27.007395', '2007-06-27 00:00:00', '2007-06-27 00:00:00', 'r', 'r'),(9, 9, NULL, NULL, '23:27:20.041652', '23:27:20.041652', '2009-10-08 00:00:00', '2009-10-08 00:00:00', 'r', 'r'),(1, 2, '2000-04-05', '2000-04-05', '10:03:25.059085', '10:03:25.059085', NULL, NULL, 'x', 'x'),(6, 1, '2007-01-16', '2007-01-16', '04:49:53.004479', '04:49:53.004479', '2002-05-08 02:15:26.011460', '2002-05-08 02:15:26.011460', 'r', 'r'),(0, 3, '2003-12-26', '2003-12-26', '08:12:18.061207', '08:12:18.061207', '2009-05-27 17:49:29.005791', '2009-05-27 17:49:29.005791', 'p', 'p'),(0, NULL, '2002-01-16', '2002-01-16', '15:43:06.030398', '15:43:06.030398', '2000-05-02 21:41:31.054358', '2000-05-02 21:41:31.054358', 'r', 'r'),(234, 46, '2007-08-27', '2007-08-27', '05:28:25.060940', '05:28:25.060940', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(1, 0, '2006-04-15', '2006-04-15', '00:00:00', '00:00:00', '2005-03-03 00:00:00', '2005-03-03 00:00:00', 't', 't'),(7, 0, '2008-10-08', '2008-10-08', '23:35:37.062802', '23:35:37.062802', NULL, NULL, NULL, NULL),(2, NULL, '2002-06-01', '2002-06-01', '08:13:56.023832', '08:13:56.023832', '2007-12-12 00:00:00', '2007-12-12 00:00:00', 'p', 'p'),(0, 1, '2009-05-12', '2009-05-12', '05:09:15.018700', '05:09:15.018700', '2006-05-06 07:54:22.057975', '2006-05-06 07:54:22.057975', 'k', 'k'),(246, 250, '2003-02-28', '2003-02-28', '01:55:07.055524', '01:55:07.055524', '2005-03-16 02:52:20.048044', '2005-03-16 02:52:20.048044', 'r', 'r'),(7, 6, '2004-05-15', '2004-05-15', '15:54:45.006812', '15:54:45.006812', '2004-06-21 01:23:41.034172', '2004-06-21 01:23:41.034172', 'e', 'e'),(2, 6, '2004-10-07', '2004-10-07', '15:27:01.008802', '15:27:01.008802', '2004-03-07 14:45:09.042955', '2004-03-07 14:45:09.042955', 'n', 'n'),(4, NULL, '2004-08-17', '2004-08-17', '23:15:28.020449', '23:15:28.020449', '2003-08-08 02:54:27.043077', '2003-08-08 02:54:27.043077', 's', 's'),(6, 8, '1900-01-01', '1900-01-01', NULL, NULL, '2003-04-16 10:48:02.021564', '2003-04-16 10:48:02.021564', 'u', 'u'),(0, 4, '1900-01-01', '1900-01-01', '08:44:06.051333', '08:44:06.051333', '2006-11-04 19:22:36.017784', '2006-11-04 19:22:36.017784', 'c', 'c'),(3, 5, '2004-08-13', '2004-08-13', '01:06:35.026457', '01:06:35.026457', '2009-01-08 17:02:44.018323', '2009-01-08 17:02:44.018323', 'j', 'j'),(9, NULL, '2005-07-28', '2005-07-28', '05:29:11.047121', '05:29:11.047121', '2005-10-15 00:00:00', '2005-10-15 00:00:00', 'l', 'l'),(9, 4, '2003-08-13', '2003-08-13', '23:18:43.031522', '23:18:43.031522', NULL, NULL, 'a', 'a'),(7, 3, '2009-02-12', '2009-02-12', '03:26:39.033624', '03:26:39.033624', '2001-09-12 15:07:08.017170', '2001-09-12 15:07:08.017170', 'k', 'k'),(7, 9, '2007-05-20', '2007-05-20', '02:53:34.062820', '02:53:34.062820', '2005-06-06 22:49:46.064617', '2005-06-06 22:49:46.064617', NULL, NULL),(9, 1, '2003-07-04', '2003-07-04', '23:01:20.033543', '23:01:20.033543', '2008-03-24 12:14:38.027337', '2008-03-24 12:14:38.027337', 'c', 'c'),(5, 3, '2004-07-13', '2004-07-13', '08:11:25.057573', '08:11:25.057573', '2008-11-01 05:50:14.059578', '2008-11-01 05:50:14.059578', 'v', 'v'),(NULL, NULL, '2003-11-28', '2003-11-28', '22:53:10.011970', '22:53:10.011970', '2008-10-10 00:00:00', '2008-10-10 00:00:00', 'i', 'i'),(8, 4, '2003-09-07', '2003-09-07', '02:54:46.030415', '02:54:46.030415', '2004-02-25 00:00:00', '2004-02-25 00:00:00', NULL, NULL),(NULL, 0, '2004-08-19', '2004-08-19', '19:01:43.054283', '19:01:43.054283', '2004-02-18 06:22:53.050204', '2004-02-18 06:22:53.050204', NULL, NULL),(NULL, NULL, '2004-12-18', '2004-12-18', '00:00:00', '00:00:00', '2008-07-21 19:03:30.018626', '2008-07-21 19:03:30.018626', 't', 't'),(2, 9, '2000-12-23', '2000-12-23', '01:56:39.007901', '01:56:39.007901', NULL, NULL, 'x', 'x'),(NULL, 2, '2002-05-26', '2002-05-26', '16:35:30.001448', '16:35:30.001448', '2001-01-17 23:54:15.018659', '2001-01-17 23:54:15.018659', 'v', 'v'),(0, 9, '2002-01-13', '2002-01-13', '13:32:09.055338', '13:32:09.055338', '2005-05-27 22:23:05.051593', '2005-05-27 22:23:05.051593', 'w', 'w'),(4, 1, '2006-04-18', '2006-04-18', '04:16:09.013197', '04:16:09.013197', '2005-08-25 11:29:00.027528', '2005-08-25 11:29:00.027528', 'b', 'b'),(5, 2, NULL, NULL, '23:22:44.017949', '23:22:44.017949', '2004-11-01 00:00:00', '2004-11-01 00:00:00', 'q', 'q');

INSERT IGNORE  INTO e (col_int_key, col_int_nokey,col_date_key, col_date_nokey,col_time_key, col_time_nokey,col_datetime_key, col_datetime_nokey,col_varchar_key,col_varchar_nokey) VALUES (NULL, NULL, '2003-04-07', '2003-04-07', '11:35:28.045661', '11:35:28.045661', '2003-03-10 08:32:27.002582', '2003-03-10 08:32:27.002582', 'c', 'c'),(41, NULL, '2005-09-16', '2005-09-16', '15:48:10.027855', '15:48:10.027855', '2001-12-01 12:30:18.029401', '2001-12-01 12:30:18.029401', 'n', 'n'),(NULL, 2, '2007-11-20', '2007-11-20', '17:00:59.028030', '17:00:59.028030', '2001-06-25 00:00:00', '2001-06-25 00:00:00', 'p', 'p'),(1, NULL, '2009-05-06', '2009-05-06', '03:37:51.063952', '03:37:51.063952', '2000-12-19 22:33:52.062768', '2000-12-19 22:33:52.062768', 'e', 'e'),(243, 140, '2008-02-20', '2008-02-20', '12:38:17.040726', '12:38:17.040726', '2007-03-24 21:20:40.006127', '2007-03-24 21:20:40.006127', 'i', 'i'),(210, 117, '2009-03-22', '2009-03-22', '01:25:56.010118', '01:25:56.010118', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'x', 'x'),(6, 3, '2002-01-08', '2002-01-08', '03:11:55.020845', '03:11:55.020845', '2004-10-20 00:00:00', '2004-10-20 00:00:00', 'j', 'j'),(8, 7, '2002-10-28', '2002-10-28', '09:28:14.034846', '09:28:14.034846', '2004-11-01 00:00:00', '2004-11-01 00:00:00', 'f', 'f'),(8, 1, '2002-12-01', '2002-12-01', '21:46:15.028457', '21:46:15.028457', '2009-05-25 13:59:10.015856', '2009-05-25 13:59:10.015856', 'h', 'h'),(1, NULL, NULL, NULL, '11:39:31.035699', '11:39:31.035699', '2007-01-18 00:00:00', '2007-01-18 00:00:00', 'b', 'b'),(7, 2, '2003-02-19', '2003-02-19', NULL, NULL, '2003-05-08 11:59:38.037113', '2003-05-08 11:59:38.037113', NULL, NULL),(6, 0, '2008-10-11', '2008-10-11', '20:47:22.029194', '20:47:22.029194', '2004-02-16 22:59:29.007792', '2004-02-16 22:59:29.007792', 'x', 'x'),(8, 1, '2009-10-16', '2009-10-16', '20:50:53.006491', '20:50:53.006491', '2008-02-26 00:00:00', '2008-02-26 00:00:00', 'b', 'b'),(9, 7, '1900-01-01', '1900-01-01', '08:37:33.010965', '08:37:33.010965', '2006-10-03 17:55:00.051919', '2006-10-03 17:55:00.051919', 'r', 'r'),(4, 6, '2009-02-28', '2009-02-28', '23:46:16.059378', '23:46:16.059378', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'o', 'o'),(9, 4, '2006-12-13', '2006-12-13', '00:00:00', '00:00:00', '2002-02-07 10:31:03.064620', '2002-02-07 10:31:03.064620', 'h', 'h'),(NULL, 1, '2001-08-23', '2001-08-23', '06:15:57.040369', '06:15:57.040369', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'y', 'y'),(9, 0, '2009-07-21', '2009-07-21', '10:09:02.053342', '10:09:02.053342', '2002-06-12 19:53:09.057868', '2002-06-12 19:53:09.057868', 'm', 'm'),(2, 8, '2009-09-14', '2009-09-14', '23:09:10.023898', '23:09:10.023898', '2005-07-08 02:39:04.042286', '2005-07-08 02:39:04.042286', 'r', 'r'),(9, 1, '2002-06-22', '2002-06-22', '15:51:45.005252', '15:51:45.005252', '2008-12-10 00:00:00', '2008-12-10 00:00:00', 'v', 'v'),(9, 4, '2006-10-14', '2006-10-14', '20:36:56.015807', '20:36:56.015807', NULL, NULL, NULL, NULL),(2, 0, '2004-03-22', '2004-03-22', '22:21:30.052427', '22:21:30.052427', '2005-12-09 11:03:19.022933', '2005-12-09 11:03:19.022933', NULL, NULL),(2, 7, NULL, NULL, '00:11:31.050819', '00:11:31.050819', '2003-02-01 11:00:07.011299', '2003-02-01 11:00:07.011299', 't', 't'),(2, 7, '2001-08-18', '2001-08-18', '11:16:01.053212', '11:16:01.053212', '2004-09-23 22:13:40.011910', '2004-09-23 22:13:40.011910', 'k', 'k'),(7, 2, NULL, NULL, '00:00:00', '00:00:00', '2001-05-26 00:00:00', '2001-05-26 00:00:00', NULL, NULL),(4, 6, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2003-07-02 00:00:00', '2003-07-02 00:00:00', NULL, NULL),(4, 7, '2000-11-26', '2000-11-26', NULL, NULL, '2007-04-18 06:34:56.064774', '2007-04-18 06:34:56.064774', 'z', 'z'),(2, 2, '2003-10-18', '2003-10-18', NULL, NULL, '2008-12-27 01:56:27.036817', '2008-12-27 01:56:27.036817', 'a', 'a'),(7, 7, '2001-05-16', '2001-05-16', '21:20:31.043620', '21:20:31.043620', '2000-05-21 01:01:53.023204', '2000-05-21 01:01:53.023204', NULL, NULL),(0, 2, '2009-06-21', '2009-06-21', '21:55:51.037686', '21:55:51.037686', '2008-07-25 00:00:00', '2008-07-25 00:00:00', 'c', 'c'),(4, 6, '2007-03-01', '2007-03-01', '11:10:28.046668', '11:10:28.046668', '2001-08-10 10:30:25.060185', '2001-08-10 10:30:25.060185', 'y', 'y'),(1, NULL, '2002-10-10', '2002-10-10', '10:13:49.041158', '10:13:49.041158', '2007-12-10 13:02:02.022620', '2007-12-10 13:02:02.022620', 'p', 'p'),(6, 7, '2007-11-03', '2007-11-03', '15:41:59.032077', '15:41:59.032077', '2009-04-04 05:43:17.006420', '2009-04-04 05:43:17.006420', 'p', 'p'),(7, 7, '2004-04-08', '2004-04-08', '04:34:06.055538', '04:34:06.055538', '2003-04-23 00:00:00', '2003-04-23 00:00:00', 't', 't'),(4, 2, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2003-10-24 00:00:00', '2003-10-24 00:00:00', 'j', 'j'),(9, 7, '2005-07-08', '2005-07-08', '00:00:00', '00:00:00', '2007-05-14 18:23:36.056674', '2007-05-14 18:23:36.056674', 'c', 'c'),(7, 2, '2001-02-17', '2001-02-17', '19:13:19.065257', '19:13:19.065257', NULL, NULL, 'p', 'p'),(8, NULL, '1900-01-01', '1900-01-01', '02:26:43.010965', '02:26:43.010965', '2000-11-16 00:00:00', '2000-11-16 00:00:00', 'c', 'c'),(2, 8, '2003-02-24', '2003-02-24', '15:32:10.055227', '15:32:10.055227', '2007-01-02 00:00:00', '2007-01-02 00:00:00', 'b', 'b'),(0, 2, '2005-04-21', '2005-04-21', '04:02:38.006039', '04:02:38.006039', '2003-04-08 12:58:14.037127', '2003-04-08 12:58:14.037127', 'x', 'x'),(132, 209, NULL, NULL, '03:16:07.035665', '03:16:07.035665', '2001-04-15 00:00:00', '2001-04-15 00:00:00', 'y', 'y'),(2, 1, '2007-02-26', '2007-02-26', NULL, NULL, '2005-06-21 00:00:00', '2005-06-21 00:00:00', 'h', 'h'),(1, 4, NULL, NULL, '15:17:05.057277', '15:17:05.057277', '2008-07-08 21:25:39.040989', '2008-07-08 21:25:39.040989', 'g', 'g'),(0, 5, '2006-11-10', '2006-11-10', '00:20:42.037859', '00:20:42.037859', '2001-01-06 20:30:01.024083', '2001-01-06 20:30:01.024083', 't', 't'),(0, 7, '2004-11-22', '2004-11-22', '19:58:08.007502', '19:58:08.007502', '2008-11-20 00:00:00', '2008-11-20 00:00:00', 'v', 'v'),(7, NULL, '2002-03-27', '2002-03-27', '09:21:43.017343', '09:21:43.017343', '2008-11-14 04:36:13.026126', '2008-11-14 04:36:13.026126', NULL, NULL),(3, NULL, '2003-03-08', '2003-03-08', '18:09:14.058708', '18:09:14.058708', '2001-01-26 00:00:00', '2001-01-26 00:00:00', 'j', 'j'),(0, 1, '2009-06-03', '2009-06-03', '23:38:59.015970', '23:38:59.015970', NULL, NULL, 'g', 'g'),(8, 7, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2009-05-17 02:42:20.043025', '2009-05-17 02:42:20.043025', NULL, NULL),(NULL, NULL, NULL, NULL, '03:51:20.064383', '03:51:20.064383', '2008-08-28 17:58:49.016088', '2008-08-28 17:58:49.016088', 'n', 'n'),(7, 6, '2001-07-11', '2001-07-11', '00:42:15.030724', '00:42:15.030724', '2009-08-04 01:29:42.028729', '2009-08-04 01:29:42.028729', 'f', 'f'),(0, 4, '2008-11-25', '2008-11-25', '13:23:02.002560', '13:23:02.002560', '2009-05-04 03:00:30.013615', '2009-05-04 03:00:30.013615', 'i', 'i'),(NULL, 2, '2006-09-12', '2006-09-12', '04:26:24.025834', '04:26:24.025834', '2007-12-21 10:02:25.042495', '2007-12-21 10:02:25.042495', 'v', 'v'),(2, 3, '2002-01-11', '2002-01-11', '07:00:20.019302', '07:00:20.019302', '2003-05-16 00:45:25.034007', '2003-05-16 00:45:25.034007', 'z', 'z'),(6, 3, '1900-01-01', '1900-01-01', '14:13:48.062742', '14:13:48.062742', '2008-11-18 13:00:49.008766', '2008-11-18 13:00:49.008766', 'b', 'b'),(3, NULL, '2001-12-06', '2001-12-06', '17:00:36.018765', '17:00:36.018765', '2009-05-20 00:00:00', '2009-05-20 00:00:00', 't', 't'),(7, 8, '2000-05-12', '2000-05-12', '06:26:21.000341', '06:26:21.000341', '2007-11-09 05:17:13.021684', '2007-11-09 05:17:13.021684', NULL, NULL),(1, 7, '2006-07-07', '2006-07-07', '04:59:39.026856', '04:59:39.026856', NULL, NULL, NULL, NULL),(6, 0, '2001-04-26', '2001-04-26', '04:49:44.047201', '04:49:44.047201', '2001-02-28 00:00:00', '2001-02-28 00:00:00', NULL, NULL),(134, 51, '2000-12-02', '2000-12-02', '08:10:39.021540', '08:10:39.021540', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(7, 6, '2002-04-11', '2002-04-11', '06:55:19.011602', '06:55:19.011602', '2003-02-10 18:28:05.033292', '2003-02-10 18:28:05.033292', 'w', 'w'),(9, 2, '2001-04-01', '2001-04-01', '11:21:42.047091', '11:21:42.047091', '2008-06-22 08:58:56.004154', '2008-06-22 08:58:56.004154', 'c', 'c'),(0, 8, '2002-04-12', '2002-04-12', '03:53:32.021948', '03:53:32.021948', '2001-10-04 12:01:35.001528', '2001-10-04 12:01:35.001528', 'r', 'r'),(5, NULL, '2007-06-17', '2007-06-17', '04:21:34.043960', '04:21:34.043960', '2009-01-19 00:47:43.035833', '2009-01-19 00:47:43.035833', 'e', 'e'),(NULL, 2, '1900-01-01', '1900-01-01', '11:34:06.026653', '11:34:06.026653', '2003-01-24 15:50:49.010361', '2003-01-24 15:50:49.010361', 'j', 'j'),(NULL, 6, '1900-01-01', '1900-01-01', '12:16:23.019185', '12:16:23.019185', '2003-02-12 19:12:27.027429', '2003-02-12 19:12:27.027429', 'x', 'x'),(NULL, 5, '2002-07-16', '2002-07-16', '00:00:00', '00:00:00', '2002-01-05 16:43:57.048900', '2002-01-05 16:43:57.048900', 'm', 'm'),(9, 4, '2000-07-16', '2000-07-16', '06:17:47.011473', '06:17:47.011473', '2005-10-06 00:00:00', '2005-10-06 00:00:00', 'a', 'a'),(1, 4, '2003-11-06', '2003-11-06', '18:01:27.023383', '18:01:27.023383', '2009-05-27 00:00:00', '2009-05-27 00:00:00', 'z', 'z'),(NULL, 6, '2002-04-16', '2002-04-16', '00:43:36.049683', '00:43:36.049683', '2002-05-14 10:52:52.038546', '2002-05-14 10:52:52.038546', NULL, NULL),(6, 0, '2006-08-14', '2006-08-14', '18:08:29.010446', '18:08:29.010446', '2002-09-21 14:22:57.011039', '2002-09-21 14:22:57.011039', 'z', 'z'),(0, 6, '1900-01-01', '1900-01-01', '18:05:26.053412', '18:05:26.053412', '2001-11-27 16:47:52.011968', '2001-11-27 16:47:52.011968', 'i', 'i'),(1, 2, '2006-12-04', '2006-12-04', '15:12:21.052523', '15:12:21.052523', '2001-10-22 03:50:35.011492', '2001-10-22 03:50:35.011492', 'a', 'a'),(4, NULL, '2005-03-19', '2005-03-19', '04:02:48.012642', '04:02:48.012642', '2007-03-19 19:56:34.006751', '2007-03-19 19:56:34.006751', 'd', 'd'),(1, NULL, '2001-04-14', '2001-04-14', '19:32:38.049521', '19:32:38.049521', '2004-10-10 09:43:15.045240', '2004-10-10 09:43:15.045240', 'v', 'v'),(239, 135, '1900-01-01', '1900-01-01', '03:43:19.033254', '03:43:19.033254', '2005-10-03 16:40:55.036758', '2005-10-03 16:40:55.036758', 'k', 'k'),(148, 18, '1900-01-01', '1900-01-01', NULL, NULL, '2000-08-11 06:21:54.032882', '2000-08-11 06:21:54.032882', 'l', 'l'),(2, 6, '2008-11-26', '2008-11-26', '15:49:50.023788', '15:49:50.023788', '2003-11-27 00:00:00', '2003-11-27 00:00:00', 't', 't'),(4, 6, '2000-05-16', '2000-05-16', '00:26:32.056681', '00:26:32.056681', '2006-06-15 03:20:13.039548', '2006-06-15 03:20:13.039548', NULL, NULL),(6, 8, '2004-03-09', '2004-03-09', '15:22:51.041911', '15:22:51.041911', '2003-12-27 18:33:42.061189', '2003-12-27 18:33:42.061189', 'm', 'm'),(2, 4, '2007-10-26', '2007-10-26', '15:32:12.053127', '15:32:12.053127', '2008-11-13 12:28:55.063752', '2008-11-13 12:28:55.063752', 'a', 'a'),(9, 0, '2009-07-23', '2009-07-23', '14:37:24.005577', '14:37:24.005577', '2003-01-27 01:49:35.004786', '2003-01-27 01:49:35.004786', NULL, NULL),(6, NULL, '2008-04-04', '2008-04-04', '13:12:48.048064', '13:12:48.048064', NULL, NULL, 'a', 'a'),(9, 3, NULL, NULL, '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'v', 'v'),(3, 3, '2005-01-12', '2005-01-12', '19:12:44.028918', '19:12:44.028918', '2008-05-05 00:00:00', '2008-05-05 00:00:00', 'g', 'g'),(8, 5, '2007-05-08', '2007-05-08', '18:19:40.019925', '18:19:40.019925', '2003-09-11 14:54:37.030533', '2003-09-11 14:54:37.030533', 'w', 'w'),(1, 5, '2009-03-24', '2009-03-24', '18:20:33.055880', '18:20:33.055880', '2000-09-21 14:43:29.058750', '2000-09-21 14:43:29.058750', 'w', 'w'),(2, 1, '1900-01-01', '1900-01-01', '09:44:18.032640', '09:44:18.032640', '2004-10-20 19:47:04.053111', '2004-10-20 19:47:04.053111', NULL, NULL),(6, 8, '2009-06-17', '2009-06-17', '00:00:00', '00:00:00', NULL, NULL, 'u', 'u'),(4, 2, NULL, NULL, '09:46:31.000021', '09:46:31.000021', '2003-08-27 13:03:41.016053', '2003-08-27 13:03:41.016053', 'f', 'f'),(0, 6, '2005-03-11', '2005-03-11', '07:19:37.012977', '07:19:37.012977', '2008-03-15 03:18:19.040555', '2008-03-15 03:18:19.040555', 'm', 'm'),(4, 6, '1900-01-01', '1900-01-01', '12:04:20.032887', '12:04:20.032887', '2006-09-25 00:00:00', '2006-09-25 00:00:00', 's', 's'),(1, 3, '2003-05-09', '2003-05-09', NULL, NULL, '2004-01-12 03:02:21.003059', '2004-01-12 03:02:21.003059', NULL, NULL),(NULL, 2, '2002-02-23', '2002-02-23', '10:02:29.008106', '10:02:29.008106', NULL, NULL, 'o', 'o'),(9, 4, '2009-09-02', '2009-09-02', '07:35:46.059826', '07:35:46.059826', NULL, NULL, 'm', 'm'),(1, 2, '2009-09-24', '2009-09-24', '22:47:35.033950', '22:47:35.033950', '2002-09-05 13:45:32.049869', '2002-09-05 13:45:32.049869', NULL, NULL),(0, 1, '2005-08-27', '2005-08-27', NULL, NULL, NULL, NULL, 'r', 'r'),(147, 34, '2001-05-20', '2001-05-20', '13:31:48.008744', '13:31:48.008744', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'r', 'r'),(5, 2, '1900-01-01', '1900-01-01', '23:43:58.019812', '23:43:58.019812', '2003-01-07 14:12:31.027024', '2003-01-07 14:12:31.027024', 'i', 'i'),(5, 4, '2007-02-02', '2007-02-02', '21:47:50.013962', '21:47:50.013962', '2004-02-15 21:01:50.033136', '2004-02-15 21:01:50.033136', NULL, NULL),(8, 3, '2002-01-03', '2002-01-03', '02:01:19.000385', '02:01:19.000385', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'p', 'p'),(6, NULL, '2004-05-02', '2004-05-02', '00:00:00', '00:00:00', '2009-01-11 20:03:56.016472', '2009-01-11 20:03:56.016472', 'n', 'n'),(3, 2, '2002-01-20', '2002-01-20', '12:25:19.006945', '12:25:19.006945', '2000-05-15 22:14:42.047175', '2000-05-15 22:14:42.047175', 'l', 'l'),(6, NULL, '2007-07-13', '2007-07-13', '03:27:51.011417', '03:27:51.011417', NULL, NULL, 'y', 'y'),(9, 2, '1900-01-01', '1900-01-01', '22:58:10.033215', '22:58:10.033215', '2009-12-03 09:33:35.063982', '2009-12-03 09:33:35.063982', 'i', 'i'),(7, 6, '2003-06-16', '2003-06-16', '05:42:21.030041', '05:42:21.030041', '2005-09-11 00:00:00', '2005-09-11 00:00:00', 'q', 'q'),(80, 227, '2008-06-25', '2008-06-25', '22:13:18.041274', '22:13:18.041274', '2004-09-21 00:00:00', '2004-09-21 00:00:00', 't', 't'),(0, 7, '2008-03-09', '2008-03-09', '01:07:52.053968', '01:07:52.053968', '2007-01-01 04:50:43.041562', '2007-01-01 04:50:43.041562', 'k', 'k'),(9, NULL, '2002-04-23', '2002-04-23', '12:45:29.026192', '12:45:29.026192', '2005-04-01 20:47:28.000420', '2005-04-01 20:47:28.000420', 'r', 'r'),(5, 6, NULL, NULL, '00:00:00', '00:00:00', '2002-06-23 11:44:55.060983', '2002-06-23 11:44:55.060983', NULL, NULL),(0, 2, '2008-06-27', '2008-06-27', '14:56:01.044072', '14:56:01.044072', '2002-10-03 17:53:55.022071', '2002-10-03 17:53:55.022071', 'p', 'p'),(9, 7, '2004-09-05', '2004-09-05', NULL, NULL, '2008-09-26 04:22:15.012259', '2008-09-26 04:22:15.012259', 'n', 'n'),(0, NULL, '2004-03-11', '2004-03-11', '12:15:49.034909', '12:15:49.034909', '2007-05-13 17:04:01.052493', '2007-05-13 17:04:01.052493', 'j', 'j'),(4, 6, '2007-06-03', '2007-06-03', '23:48:47.033108', '23:48:47.033108', '2001-04-11 00:00:46.032988', '2001-04-11 00:00:46.032988', 'k', 'k'),(6, 5, NULL, NULL, '12:10:51.019928', '12:10:51.019928', '2004-03-14 22:11:43.064751', '2004-03-14 22:11:43.064751', 'a', 'a'),(1, 3, '2000-04-04', '2000-04-04', NULL, NULL, '2005-05-12 19:03:33.044866', '2005-05-12 19:03:33.044866', 'z', 'z'),(0, 5, '2007-03-13', '2007-03-13', '20:38:31.057678', '20:38:31.057678', '2000-12-22 20:15:23.037753', '2000-12-22 20:15:23.037753', 'l', 'l'),(9, 6, '2007-09-10', '2007-09-10', '13:36:38.038817', '13:36:38.038817', '2007-06-24 00:00:00', '2007-06-24 00:00:00', 'f', 'f'),(1, 7, '2009-04-02', '2009-04-02', '04:33:46.014678', '04:33:46.014678', '2006-10-23 17:21:26.061900', '2006-10-23 17:21:26.061900', NULL, NULL),(7, 0, '2005-12-10', '2005-12-10', '00:00:00', '00:00:00', NULL, NULL, NULL, NULL),(9, 6, '2002-07-05', '2002-07-05', '14:11:44.026508', '14:11:44.026508', '2009-01-04 00:54:06.047147', '2009-01-04 00:54:06.047147', 'h', 'h'),(6, 3, '2007-08-26', '2007-08-26', '03:22:20.054777', '03:22:20.054777', NULL, NULL, 'x', 'x'),(3, 4, '2005-10-09', '2005-10-09', '04:13:39.009452', '04:13:39.009452', '2006-09-23 16:43:07.050898', '2006-09-23 16:43:07.050898', 'y', 'y'),(5, 1, '2002-12-13', '2002-12-13', NULL, NULL, '2005-02-12 11:00:38.054563', '2005-02-12 11:00:38.054563', 'c', 'c'),(3, 4, NULL, NULL, '15:05:05.035525', '15:05:05.035525', '2000-05-08 00:49:12.062264', '2000-05-08 00:49:12.062264', 'j', 'j'),(2, 3, '1900-01-01', '1900-01-01', NULL, NULL, NULL, NULL, 'b', 'b'),(NULL, 8, '2007-06-09', '2007-06-09', '21:19:05.003333', '21:19:05.003333', '2009-07-16 10:36:58.016098', '2009-07-16 10:36:58.016098', 's', 's'),(5, 0, '2002-06-07', '2002-06-07', '17:33:46.009697', '17:33:46.009697', '2000-09-14 23:32:56.032831', '2000-09-14 23:32:56.032831', 'p', 'p'),(81, 187, NULL, NULL, '00:00:00', '00:00:00', '2005-03-28 05:41:01.063423', '2005-03-28 05:41:01.063423', 's', 's'),(2, 2, '1900-01-01', '1900-01-01', '20:36:42.003849', '20:36:42.003849', '2006-05-02 11:08:24.048316', '2006-05-02 11:08:24.048316', 'j', 'j'),(6, NULL, '2001-05-26', '2001-05-26', '23:52:04.037897', '23:52:04.037897', '2002-12-11 12:07:58.018486', '2002-12-11 12:07:58.018486', 'q', 'q'),(5, 3, '2006-02-24', '2006-02-24', '16:08:55.056013', '16:08:55.056013', '2000-12-14 13:21:07.021172', '2000-12-14 13:21:07.021172', 'b', 'b'),(0, NULL, NULL, NULL, NULL, NULL, '2000-09-24 01:04:47.005084', '2000-09-24 01:04:47.005084', 'g', 'g'),(9, 8, '2009-06-28', '2009-06-28', '05:31:34.056445', '05:31:34.056445', '2003-07-01 04:53:00.062981', '2003-07-01 04:53:00.062981', 'b', 'b'),(9, 2, '2002-11-10', '2002-11-10', '09:32:37.037373', '09:32:37.037373', '2002-11-06 19:30:57.063505', '2002-11-06 19:30:57.063505', NULL, NULL),(NULL, 7, '2001-03-03', '2001-03-03', '10:20:13.000582', '10:20:13.000582', '2006-10-11 15:18:30.001549', '2006-10-11 15:18:30.001549', 'q', 'q'),(8, 6, '2009-11-04', '2009-11-04', '00:00:00', '00:00:00', '2008-02-06 00:00:00', '2008-02-06 00:00:00', 'o', 'o'),(NULL, 3, '2003-10-18', '2003-10-18', '10:17:31.053124', '10:17:31.053124', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'd', 'd'),(8, 4, '2001-04-03', '2001-04-03', '01:14:35.014317', '01:14:35.014317', '2007-01-18 20:30:16.023806', '2007-01-18 20:30:16.023806', 'z', 'z'),(7, 9, '2009-11-02', '2009-11-02', '07:52:11.065199', '07:52:11.065199', NULL, NULL, 's', 's'),(4, 8, '2008-04-01', '2008-04-01', '23:45:50.008203', '23:45:50.008203', '2005-08-06 14:43:37.057073', '2005-08-06 14:43:37.057073', 'w', 'w'),(0, 1, '2003-01-20', '2003-01-20', '12:51:05.062599', '12:51:05.062599', '2003-11-17 02:26:52.034758', '2003-11-17 02:26:52.034758', 's', 's'),(NULL, 2, '1900-01-01', '1900-01-01', '02:15:43.008915', '02:15:43.008915', '2008-01-16 00:00:00', '2008-01-16 00:00:00', 'q', 'q'),(NULL, 6, '2008-12-02', '2008-12-02', '03:46:21.042997', '03:46:21.042997', '2008-01-18 06:29:36.029069', '2008-01-18 06:29:36.029069', 'a', 'a'),(4, 4, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2003-12-07 18:58:28.029914', '2003-12-07 18:58:28.029914', NULL, NULL),(0, 0, '2001-10-15', '2001-10-15', NULL, NULL, '2004-09-22 02:24:34.014331', '2004-09-22 02:24:34.014331', 'd', 'd'),(3, 9, '2004-12-07', '2004-12-07', '12:35:15.048737', '12:35:15.048737', '2008-09-21 00:42:07.007676', '2008-09-21 00:42:07.007676', 'u', 'u'),(3, 2, '1900-01-01', '1900-01-01', '09:26:17.046768', '09:26:17.046768', '2007-06-04 03:42:26.036312', '2007-06-04 03:42:26.036312', 'h', 'h'),(243, 17, '2003-08-04', '2003-08-04', '11:13:24.049547', '11:13:24.049547', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(2, 0, '2005-05-23', '2005-05-23', '13:34:32.012992', '13:34:32.012992', '2007-08-05 16:52:41.023157', '2007-08-05 16:52:41.023157', 'l', 'l'),(2, 0, NULL, NULL, '21:44:00.022394', '21:44:00.022394', '2002-02-13 15:16:49.006744', '2002-02-13 15:16:49.006744', NULL, NULL),(0, NULL, '1900-01-01', '1900-01-01', '08:16:02.062255', '08:16:02.062255', '2006-12-25 03:35:43.054809', '2006-12-25 03:35:43.054809', 'i', 'i'),(9, 9, '1900-01-01', '1900-01-01', '22:22:25.007763', '22:22:25.007763', '2002-02-27 05:22:54.045966', '2002-02-27 05:22:54.045966', 'i', 'i'),(186, 4, '2006-07-07', '2006-07-07', '06:51:45.003451', '06:51:45.003451', '2005-02-16 21:55:18.061240', '2005-02-16 21:55:18.061240', 'a', 'a'),(4, NULL, '2004-12-25', '2004-12-25', '04:18:51.039943', '04:18:51.039943', '2009-06-23 03:08:14.035102', '2009-06-23 03:08:14.035102', 'g', 'g'),(7, 3, '2000-06-28', '2000-06-28', '03:34:42.005510', '03:34:42.005510', NULL, NULL, 'g', 'g'),(8, 2, '1900-01-01', '1900-01-01', '12:18:55.063263', '12:18:55.063263', '2001-08-05 03:28:05.004738', '2001-08-05 03:28:05.004738', 'o', 'o'),(7, 6, '2009-07-16', '2009-07-16', '00:26:40.029938', '00:26:40.029938', NULL, NULL, 'x', 'x'),(181, 15, '2007-09-23', '2007-09-23', '23:00:58.034952', '23:00:58.034952', '2005-07-14 00:00:00', '2005-07-14 00:00:00', 'd', 'd'),(115, 46, '2000-07-13', '2000-07-13', '10:20:36.025621', '10:20:36.025621', '2005-05-20 00:00:00', '2005-05-20 00:00:00', 'u', 'u'),(9, 1, '2007-07-07', '2007-07-07', '10:58:16.031679', '10:58:16.031679', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'e', 'e'),(NULL, 7, '1900-01-01', '1900-01-01', '05:45:43.047125', '05:45:43.047125', '2001-11-01 23:18:58.047359', '2001-11-01 23:18:58.047359', 'q', 'q'),(9, 2, '2004-06-15', '2004-06-15', '18:19:26.048959', '18:19:26.048959', '2001-04-12 23:50:31.064807', '2001-04-12 23:50:31.064807', 'y', 'y'),(NULL, 6, '2001-05-22', '2001-05-22', '17:56:58.060502', '17:56:58.060502', '2002-06-15 22:56:26.044339', '2002-06-15 22:56:26.044339', NULL, NULL),(5, 3, '2004-08-18', '2004-08-18', '15:06:12.004953', '15:06:12.004953', '2009-03-21 11:52:51.024943', '2009-03-21 11:52:51.024943', 'l', 'l'),(3, 9, NULL, NULL, '18:12:52.002805', '18:12:52.002805', '2004-09-27 00:00:00', '2004-09-27 00:00:00', 't', 't'),(9, 4, '2001-08-03', '2001-08-03', '05:17:37.034971', '05:17:37.034971', '2007-04-24 00:00:00', '2007-04-24 00:00:00', NULL, NULL),(NULL, 8, '2000-10-02', '2000-10-02', '10:38:48.033760', '10:38:48.033760', '2001-06-06 07:57:13.000978', '2001-06-06 07:57:13.000978', 'z', 'z'),(130, 129, '2006-01-14', '2006-01-14', '20:21:23.006161', '20:21:23.006161', NULL, NULL, 'u', 'u'),(6, 2, '2007-02-27', '2007-02-27', '22:53:17.000215', '22:53:17.000215', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'q', 'q'),(2, 8, '2007-04-13', '2007-04-13', '21:12:48.020341', '21:12:48.020341', '2001-05-22 06:09:52.033921', '2001-05-22 06:09:52.033921', 'y', 'y'),(5, 6, '2009-07-04', '2009-07-04', '12:27:33.038055', '12:27:33.038055', '2009-10-26 08:11:08.030574', '2009-10-26 08:11:08.030574', 'k', 'k'),(3, 4, '2007-09-12', '2007-09-12', '20:59:24.047897', '20:59:24.047897', '2001-05-08 00:00:00', '2001-05-08 00:00:00', 'v', 'v'),(0, NULL, '2002-06-16', '2002-06-16', NULL, NULL, '2009-03-07 01:05:40.034028', '2009-03-07 01:05:40.034028', NULL, NULL),(0, 4, '2005-03-26', '2005-03-26', '20:25:41.035068', '20:25:41.035068', '2000-06-26 05:42:27.017683', '2000-06-26 05:42:27.017683', 'i', 'i'),(1, 6, '2001-01-23', '2001-01-23', '00:00:00', '00:00:00', '2005-06-16 01:35:46.041411', '2005-06-16 01:35:46.041411', 'a', 'a'),(NULL, 5, '1900-01-01', '1900-01-01', '12:40:43.020324', '12:40:43.020324', '2003-05-07 05:33:14.027510', '2003-05-07 05:33:14.027510', 'd', 'd'),(7, 6, '2003-12-21', '2003-12-21', NULL, NULL, '2000-02-26 06:50:42.053364', '2000-02-26 06:50:42.053364', NULL, NULL),(NULL, 9, '2008-11-10', '2008-11-10', '04:17:19.044986', '04:17:19.044986', '2007-07-07 10:43:19.025090', '2007-07-07 10:43:19.025090', 'a', 'a'),(3, NULL, NULL, NULL, '22:12:35.008504', '22:12:35.008504', '2009-07-07 10:07:51.015698', '2009-07-07 10:07:51.015698', 'p', 'p'),(2, 5, '2000-04-05', '2000-04-05', '10:49:21.030238', '10:49:21.030238', '2003-03-26 00:00:00', '2003-03-26 00:00:00', 'z', 'z'),(2, 2, '2003-07-13', '2003-07-13', '10:57:27.018002', '10:57:27.018002', NULL, NULL, 'p', 'p'),(8, NULL, '2000-08-05', '2000-08-05', '10:19:53.032669', '10:19:53.032669', '2007-01-13 19:23:01.003201', '2007-01-13 19:23:01.003201', 'n', 'n'),(5, 1, '2005-11-01', '2005-11-01', '22:56:53.042035', '22:56:53.042035', '2005-11-07 11:55:47.006402', '2005-11-07 11:55:47.006402', 't', 't'),(2, 9, '1900-01-01', '1900-01-01', '17:08:37.008961', '17:08:37.008961', NULL, NULL, 'm', 'm'),(1, 9, '2002-11-23', '2002-11-23', '21:42:12.006807', '21:42:12.006807', '2006-08-22 05:21:06.030050', '2006-08-22 05:21:06.030050', NULL, NULL),(0, 3, '1900-01-01', '1900-01-01', '09:28:11.040250', '09:28:11.040250', '2008-12-27 21:01:14.048207', '2008-12-27 21:01:14.048207', 'f', 'f'),(2, 4, '2003-02-11', '2003-02-11', '02:55:19.036208', '02:55:19.036208', '2007-11-25 03:31:15.057899', '2007-11-25 03:31:15.057899', 'r', 'r'),(8, 7, '2004-07-13', '2004-07-13', '14:09:38.038391', '14:09:38.038391', NULL, NULL, 'v', 'v'),(NULL, 6, NULL, NULL, '17:44:47.018959', '17:44:47.018959', '2008-09-23 00:05:44.013359', '2008-09-23 00:05:44.013359', 'z', 'z'),(0, 8, '2002-08-22', '2002-08-22', '20:45:28.051163', '20:45:28.051163', '2000-04-21 09:30:39.028003', '2000-04-21 09:30:39.028003', 'g', 'g'),(NULL, 7, '2002-08-28', '2002-08-28', '21:09:46.038584', '21:09:46.038584', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'f', 'f'),(7, 1, '2008-01-05', '2008-01-05', '23:47:54.049987', '23:47:54.049987', '2003-09-23 00:00:00', '2003-09-23 00:00:00', 'j', 'j'),(6, 4, '2004-06-17', '2004-06-17', NULL, NULL, '2009-11-06 23:22:03.015295', '2009-11-06 23:22:03.015295', 's', 's'),(8, 8, '2000-01-22', '2000-01-22', '13:32:14.009228', '13:32:14.009228', '2002-10-25 02:54:56.060708', '2002-10-25 02:54:56.060708', 'p', 'p'),(5, 5, '2008-10-19', '2008-10-19', '14:38:29.000767', '14:38:29.000767', NULL, NULL, 'p', 'p'),(8, 5, '2000-08-05', '2000-08-05', '06:56:36.037308', '06:56:36.037308', NULL, NULL, 'm', 'm'),(7, 1, '2004-02-07', '2004-02-07', '04:12:03.054381', '04:12:03.054381', '2009-02-13 00:11:56.043224', '2009-02-13 00:11:56.043224', 'g', 'g'),(0, 8, '1900-01-01', '1900-01-01', '17:58:26.061533', '17:58:26.061533', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 's', 's'),(3, 4, '2000-10-09', '2000-10-09', '04:15:39.003365', '04:15:39.003365', '2001-09-27 00:59:33.019037', '2001-09-27 00:59:33.019037', 's', 's'),(2, 5, NULL, NULL, '21:39:03.055051', '21:39:03.055051', '2008-03-14 14:59:22.057299', '2008-03-14 14:59:22.057299', 'f', 'f'),(157, 54, '2007-10-22', '2007-10-22', '12:00:56.013353', '12:00:56.013353', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'o', 'o'),(0, 5, '2009-07-17', '2009-07-17', '07:10:45.061354', '07:10:45.061354', '2006-05-06 03:57:56.062676', '2006-05-06 03:57:56.062676', 'y', 'y'),(NULL, 2, '2009-03-10', '2009-03-10', '18:20:45.036865', '18:20:45.036865', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(5, 7, '2002-02-28', '2002-02-28', '23:50:17.022808', '23:50:17.022808', NULL, NULL, NULL, NULL),(5, 1, '2004-10-23', '2004-10-23', '19:33:57.035997', '19:33:57.035997', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'v', 'v'),(7, 2, '2007-02-22', '2007-02-22', '22:05:37.011479', '22:05:37.011479', '2005-01-14 08:37:03.061176', '2005-01-14 08:37:03.061176', NULL, NULL),(9, 7, NULL, NULL, '15:01:08.004779', '15:01:08.004779', '2001-02-26 04:04:45.011144', '2001-02-26 04:04:45.011144', NULL, NULL),(212, 78, '2003-01-04', '2003-01-04', '00:45:32.065442', '00:45:32.065442', '2007-03-27 00:00:00', '2007-03-27 00:00:00', NULL, NULL),(7, 4, '2003-03-02', '2003-03-02', '14:36:14.014659', '14:36:14.014659', '2009-11-17 00:00:00', '2009-11-17 00:00:00', 'b', 'b'),(NULL, 0, '2009-07-08', '2009-07-08', '21:32:47.053133', '21:32:47.053133', '2003-04-02 00:00:00', '2003-04-02 00:00:00', 's', 's'),(6, 1, '2004-10-01', '2004-10-01', '16:08:26.062429', '16:08:26.062429', '2007-06-26 11:10:08.003095', '2007-06-26 11:10:08.003095', 'o', 'o'),(1, 0, '2003-07-05', '2003-07-05', '09:30:05.037620', '09:30:05.037620', '2008-09-27 00:00:00', '2008-09-27 00:00:00', 't', 't'),(7, 6, '2009-11-19', '2009-11-19', '05:13:57.020190', '05:13:57.020190', '2002-01-17 13:27:22.038442', '2002-01-17 13:27:22.038442', 'g', 'g'),(6, 7, '2009-11-11', '2009-11-11', NULL, NULL, '2002-07-11 00:00:00', '2002-07-11 00:00:00', 'k', 'k'),(8, 4, '2005-05-23', '2005-05-23', NULL, NULL, '2008-01-19 00:21:19.021373', '2008-01-19 00:21:19.021373', 'f', 'f'),(0, 2, NULL, NULL, '12:51:38.007190', '12:51:38.007190', '2006-01-23 06:19:18.060097', '2006-01-23 06:19:18.060097', NULL, NULL),(9, 3, '2002-12-23', '2002-12-23', '11:11:03.036097', '11:11:03.036097', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'v', 'v'),(8, 1, '2002-01-16', '2002-01-16', '20:45:16.032827', '20:45:16.032827', NULL, NULL, 'l', 'l'),(4, 4, '2002-06-26', '2002-06-26', '06:24:21.064401', '06:24:21.064401', '2007-11-06 00:58:46.063229', '2007-11-06 00:58:46.063229', 'c', 'c'),(6, 9, '2005-06-23', '2005-06-23', NULL, NULL, '2009-12-18 21:36:44.053098', '2009-12-18 21:36:44.053098', 'z', 'z'),(7, 3, '2006-08-11', '2006-08-11', '07:33:06.039836', '07:33:06.039836', '2006-06-27 00:00:00', '2006-06-27 00:00:00', 'h', 'h'),(132, 59, '2007-12-23', '2007-12-23', '07:29:56.028927', '07:29:56.028927', '2007-01-03 00:00:00', '2007-01-03 00:00:00', NULL, NULL),(1, NULL, '2001-04-26', '2001-04-26', '08:35:52.004223', '08:35:52.004223', '2004-12-19 09:47:53.030617', '2004-12-19 09:47:53.030617', 'p', 'p'),(0, 5, '2003-04-23', '2003-04-23', '23:59:57.047904', '23:59:57.047904', '2006-03-07 00:00:00', '2006-03-07 00:00:00', 'v', 'v'),(1, 1, '2002-11-05', '2002-11-05', '17:31:44.013471', '17:31:44.013471', '2002-06-09 18:30:21.047130', '2002-06-09 18:30:21.047130', 'z', 'z'),(4, 2, NULL, NULL, '05:35:32.001841', '05:35:32.001841', '2005-12-13 02:41:54.030148', '2005-12-13 02:41:54.030148', NULL, NULL),(2, 0, '2005-02-21', '2005-02-21', '13:42:03.058193', '13:42:03.058193', NULL, NULL, 'm', 'm'),(2, 5, '1900-01-01', '1900-01-01', '11:21:22.035537', '11:21:22.035537', '2005-05-14 01:51:21.008086', '2005-05-14 01:51:21.008086', 'd', 'd'),(4, 6, '2000-05-03', '2000-05-03', '20:34:40.006564', '20:34:40.006564', '2000-10-06 00:26:36.044664', '2000-10-06 00:26:36.044664', 'x', 'x'),(5, 4, '2009-05-11', '2009-05-11', '12:09:46.050147', '12:09:46.050147', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'z', 'z'),(7, 0, '2006-05-07', '2006-05-07', '14:04:15.033391', '14:04:15.033391', '2006-08-21 15:48:12.014655', '2006-08-21 15:48:12.014655', 's', 's'),(221, 163, '2000-07-10', '2000-07-10', '03:51:05.004123', '03:51:05.004123', '2006-07-11 06:44:49.015949', '2006-07-11 06:44:49.015949', 'c', 'c'),(2, 9, '2008-04-05', '2008-04-05', '11:38:09.015218', '11:38:09.015218', '2009-01-12 22:24:18.032069', '2009-01-12 22:24:18.032069', 'v', 'v'),(NULL, 5, '2001-03-16', '2001-03-16', '18:23:44.012443', '18:23:44.012443', '2001-11-13 05:39:30.010374', '2001-11-13 05:39:30.010374', 'g', 'g'),(7, NULL, '2004-11-09', '2004-11-09', '22:31:55.018477', '22:31:55.018477', '2001-10-25 00:00:00', '2001-10-25 00:00:00', 'm', 'm'),(3, 7, '2008-05-26', '2008-05-26', '12:03:48.041882', '12:03:48.041882', '2004-05-21 00:00:00', '2004-05-21 00:00:00', 'p', 'p'),(9, NULL, '1900-01-01', '1900-01-01', '08:26:08.057949', '08:26:08.057949', '2007-03-04 06:38:21.031134', '2007-03-04 06:38:21.031134', 'v', 'v'),(NULL, 2, NULL, NULL, '04:03:21.053586', '04:03:21.053586', '2008-06-11 22:13:02.064543', '2008-06-11 22:13:02.064543', 'c', 'c'),(45, 127, '2009-09-20', '2009-09-20', '17:00:00.022377', '17:00:00.022377', '2002-03-26 22:47:36.020746', '2002-03-26 22:47:36.020746', 'i', 'i'),(1, 2, '2007-03-21', '2007-03-21', '00:00:00', '00:00:00', '2006-05-19 09:52:45.019721', '2006-05-19 09:52:45.019721', 'f', 'f'),(2, 6, '2005-07-06', '2005-07-06', '15:23:59.039596', '15:23:59.039596', '2001-06-03 22:49:27.053605', '2001-06-03 22:49:27.053605', 'u', 'u'),(8, 7, '2006-03-12', '2006-03-12', '06:55:07.000580', '06:55:07.000580', '2001-07-20 20:44:05.007093', '2001-07-20 20:44:05.007093', 'f', 'f'),(8, 5, '2007-04-03', '2007-04-03', '06:44:45.043884', '06:44:45.043884', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'o', 'o'),(NULL, 4, '2008-07-27', '2008-07-27', NULL, NULL, '2001-03-23 22:15:15.049775', '2001-03-23 22:15:15.049775', 'p', 'p'),(3, 2, '2008-11-10', '2008-11-10', '19:42:39.035552', '19:42:39.035552', '2003-06-10 00:00:00', '2003-06-10 00:00:00', 'c', 'c'),(7, 5, '2002-12-21', '2002-12-21', '17:55:47.030055', '17:55:47.030055', '2009-07-07 21:45:37.051201', '2009-07-07 21:45:37.051201', 'n', 'n'),(4, 7, NULL, NULL, '23:07:42.058090', '23:07:42.058090', '2001-04-25 21:06:34.013020', '2001-04-25 21:06:34.013020', 'v', 'v'),(4, 2, '2009-11-25', '2009-11-25', '12:02:43.058806', '12:02:43.058806', '2001-10-10 00:00:00', '2001-10-10 00:00:00', NULL, NULL),(130, 35, NULL, NULL, '20:22:28.041728', '20:22:28.041728', '2000-09-12 07:31:44.019413', '2000-09-12 07:31:44.019413', 'w', 'w'),(3, 0, '1900-01-01', '1900-01-01', NULL, NULL, '2001-09-21 02:55:27.051025', '2001-09-21 02:55:27.051025', 'u', 'u'),(4, 1, NULL, NULL, '00:00:00', '00:00:00', '2004-09-16 14:59:41.024541', '2004-09-16 14:59:41.024541', 'k', 'k'),(1, 6, '2007-09-25', '2007-09-25', '09:22:38.012195', '09:22:38.012195', '2003-11-13 13:45:35.026002', '2003-11-13 13:45:35.026002', 'b', 'b'),(6, 8, '2006-05-26', '2006-05-26', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'q', 'q'),(9, 2, NULL, NULL, '16:54:40.060311', '16:54:40.060311', NULL, NULL, 'i', 'i'),(8, 3, '2002-03-07', '2002-03-07', '08:17:10.043400', '08:17:10.043400', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'c', 'c'),(9, 7, '2000-05-23', '2000-05-23', '03:50:53.039745', '03:50:53.039745', NULL, NULL, 'i', 'i'),(7, NULL, '2004-03-03', '2004-03-03', '00:00:00', '00:00:00', '2001-01-16 00:00:00', '2001-01-16 00:00:00', 's', 's'),(6, 1, '2002-09-10', '2002-09-10', '18:27:10.002128', '18:27:10.002128', '2006-08-16 17:41:13.000174', '2006-08-16 17:41:13.000174', 'g', 'g'),(5, 8, NULL, NULL, '10:19:22.020539', '10:19:22.020539', '2007-02-05 01:11:27.005106', '2007-02-05 01:11:27.005106', 'h', 'h'),(3, 4, '2003-06-10', '2003-06-10', NULL, NULL, '2004-05-19 05:00:03.012017', '2004-05-19 05:00:03.012017', 'p', 'p'),(9, 5, '2004-10-23', '2004-10-23', '23:17:47.027275', '23:17:47.027275', '2002-03-03 00:00:00', '2002-03-03 00:00:00', 'i', 'i'),(4, 0, '1900-01-01', '1900-01-01', '00:06:59.005672', '00:06:59.005672', NULL, NULL, 'a', 'a'),(NULL, 6, '2002-04-19', '2002-04-19', '03:28:44.059718', '03:28:44.059718', '2006-07-28 04:52:59.064825', '2006-07-28 04:52:59.064825', NULL, NULL),(6, 9, '2001-11-08', '2001-11-08', '20:04:11.050347', '20:04:11.050347', '2009-12-16 17:26:24.033895', '2009-12-16 17:26:24.033895', 's', 's'),(8, 5, '2009-11-09', '2009-11-09', '20:38:25.057949', '20:38:25.057949', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'p', 'p'),(1, 0, '2006-02-26', '2006-02-26', '00:00:00', '00:00:00', '2005-05-27 11:29:27.030070', '2005-05-27 11:29:27.030070', 'o', 'o'),(3, 9, '2002-04-13', '2002-04-13', '07:51:02.024188', '07:51:02.024188', '2009-05-12 00:00:00', '2009-05-12 00:00:00', 'x', 'x'),(1, 1, '2002-08-14', '2002-08-14', '08:22:04.031189', '08:22:04.031189', '2001-09-21 22:55:59.063290', '2001-09-21 22:55:59.063290', 't', 't'),(NULL, 7, NULL, NULL, '19:59:37.019604', '19:59:37.019604', '2001-05-19 11:16:06.030379', '2001-05-19 11:16:06.030379', NULL, NULL),(8, 9, '2006-01-21', '2006-01-21', '12:07:24.029041', '12:07:24.029041', NULL, NULL, NULL, NULL),(3, NULL, NULL, NULL, '03:07:48.061015', '03:07:48.061015', '2007-02-16 06:26:08.026013', '2007-02-16 06:26:08.026013', 'f', 'f'),(1, 2, '2003-02-01', '2003-02-01', '00:40:57.021210', '00:40:57.021210', '2004-07-28 00:00:00', '2004-07-28 00:00:00', 'a', 'a'),(6, 5, '2003-05-13', '2003-05-13', '13:44:34.030833', '13:44:34.030833', '2006-01-08 00:00:00', '2006-01-08 00:00:00', 'c', 'c'),(3, 5, '2003-11-05', '2003-11-05', '02:29:52.000725', '02:29:52.000725', '2005-06-08 02:02:02.055771', '2005-06-08 02:02:02.055771', 'i', 'i'),(6, NULL, NULL, NULL, '07:59:25.055017', '07:59:25.055017', '2003-06-05 19:03:45.021791', '2003-06-05 19:03:45.021791', 'i', 'i'),(3, 7, '2009-06-21', '2009-06-21', NULL, NULL, '2001-03-27 20:03:23.052994', '2001-03-27 20:03:23.052994', 'h', 'h'),(0, 8, '2003-02-10', '2003-02-10', NULL, NULL, '2007-02-15 10:22:11.034231', '2007-02-15 10:22:11.034231', 'e', 'e'),(4, 9, '2006-01-09', '2006-01-09', NULL, NULL, NULL, NULL, 'v', 'v'),(7, 5, NULL, NULL, '20:55:31.028960', '20:55:31.028960', NULL, NULL, 'g', 'g'),(6, 5, '2008-07-13', '2008-07-13', '02:17:44.020596', '02:17:44.020596', '2008-03-09 07:06:38.024039', '2008-03-09 07:06:38.024039', NULL, NULL),(0, 5, NULL, NULL, '01:09:15.030848', '01:09:15.030848', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'v', 'v'),(2, 3, '2005-12-18', '2005-12-18', NULL, NULL, '2001-11-17 00:00:00', '2001-11-17 00:00:00', 'f', 'f'),(4, 1, '2009-04-09', '2009-04-09', NULL, NULL, '2009-04-15 21:13:31.041063', '2009-04-15 21:13:31.041063', 'w', 'w'),(0, 4, '2005-08-09', '2005-08-09', '20:39:11.033844', '20:39:11.033844', '2001-03-07 11:03:01.024750', '2001-03-07 11:03:01.024750', 'p', 'p'),(2, NULL, '2007-09-08', '2007-09-08', '05:34:10.039601', '05:34:10.039601', '2000-10-27 00:00:00', '2000-10-27 00:00:00', 'j', 'j'),(4, 1, '2009-12-15', '2009-12-15', '07:12:20.048354', '07:12:20.048354', '2005-12-21 00:00:00', '2005-12-21 00:00:00', NULL, NULL),(0, 5, '2000-12-16', '2000-12-16', '17:11:29.001848', '17:11:29.001848', '2009-11-08 04:53:35.034642', '2009-11-08 04:53:35.034642', 'p', 'p'),(0, 5, '2005-01-15', '2005-01-15', '03:52:44.014719', '03:52:44.014719', '2008-12-03 07:01:57.019111', '2008-12-03 07:01:57.019111', 'j', 'j'),(2, 9, '2003-10-25', '2003-10-25', '12:29:45.037997', '12:29:45.037997', '2006-01-28 07:54:10.055911', '2006-01-28 07:54:10.055911', 'n', 'n'),(5, 6, '2006-05-03', '2006-05-03', '00:00:00', '00:00:00', '2002-07-04 00:00:00', '2002-07-04 00:00:00', 'y', 'y'),(224, 112, '2007-06-07', '2007-06-07', '02:35:04.015161', '02:35:04.015161', '2009-04-21 22:51:28.061865', '2009-04-21 22:51:28.061865', 'w', 'w'),(9, 5, '2000-07-23', '2000-07-23', '23:34:40.028940', '23:34:40.028940', '2003-09-05 00:00:00', '2003-09-05 00:00:00', 'w', 'w'),(5, 1, '2007-11-18', '2007-11-18', NULL, NULL, '2007-07-03 10:06:33.029084', '2007-07-03 10:06:33.029084', 'e', 'e'),(6, NULL, '1900-01-01', '1900-01-01', '01:40:52.031737', '01:40:52.031737', '2009-04-09 03:44:01.028743', '2009-04-09 03:44:01.028743', 'a', 'a'),(3, 0, '2009-09-17', '2009-09-17', '01:29:32.032774', '01:29:32.032774', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'k', 'k'),(2, 2, '2000-02-06', '2000-02-06', '03:47:43.054930', '03:47:43.054930', '2004-03-17 15:45:10.061034', '2004-03-17 15:45:10.061034', 'h', 'h'),(3, 2, '2008-02-28', '2008-02-28', '18:45:49.028789', '18:45:49.028789', '2001-03-21 08:49:49.019963', '2001-03-21 08:49:49.019963', 'w', 'w'),(3, 5, NULL, NULL, '16:24:28.044943', '16:24:28.044943', NULL, NULL, 's', 's'),(2, 6, '2003-01-13', '2003-01-13', '00:29:56.033652', '00:29:56.033652', '2007-03-12 00:00:00', '2007-03-12 00:00:00', 'k', 'k'),(6, 4, NULL, NULL, '00:00:00', '00:00:00', '2003-03-14 06:43:18.057784', '2003-03-14 06:43:18.057784', 'g', 'g'),(4, 9, '2003-09-26', '2003-09-26', '04:43:37.021887', '04:43:37.021887', '2005-05-05 08:16:42.005270', '2005-05-05 08:16:42.005270', 's', 's'),(NULL, 9, '2006-02-02', '2006-02-02', '12:36:40.029188', '12:36:40.029188', '2002-08-04 05:41:54.015337', '2002-08-04 05:41:54.015337', 'f', 'f'),(20, 132, '1900-01-01', '1900-01-01', '13:15:02.030543', '13:15:02.030543', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'l', 'l'),(8, 8, '2007-05-17', '2007-05-17', '07:27:56.033471', '07:27:56.033471', '2009-12-26 01:30:40.033242', '2009-12-26 01:30:40.033242', 'o', 'o'),(7, 0, '1900-01-01', '1900-01-01', '07:53:37.008341', '07:53:37.008341', '2005-05-17 20:08:15.054767', '2005-05-17 20:08:15.054767', 'h', 'h'),(6, 5, NULL, NULL, '11:44:58.031288', '11:44:58.031288', '2009-02-17 04:05:12.036928', '2009-02-17 04:05:12.036928', 'l', 'l'),(2, 4, '2000-05-22', '2000-05-22', '17:41:58.021948', '17:41:58.021948', '2003-03-11 14:38:10.011842', '2003-03-11 14:38:10.011842', 'n', 'n'),(104, 101, '2002-02-05', '2002-02-05', '18:56:32.002187', '18:56:32.002187', NULL, NULL, 'i', 'i'),(2, 6, NULL, NULL, '09:48:05.026778', '09:48:05.026778', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'u', 'u'),(7, 2, '2004-12-06', '2004-12-06', '06:10:12.038685', '06:10:12.038685', '2005-04-14 12:30:29.057500', '2005-04-14 12:30:29.057500', 'g', 'g'),(2, NULL, '2008-07-07', '2008-07-07', '12:43:56.016044', '12:43:56.016044', '2002-08-07 18:56:00.023313', '2002-08-07 18:56:00.023313', 's', 's'),(7, 6, NULL, NULL, '05:46:10.032243', '05:46:10.032243', '2009-07-09 17:04:43.007916', '2009-07-09 17:04:43.007916', 'w', 'w'),(3, 9, '2006-06-28', '2006-06-28', '00:00:00', '00:00:00', '2002-01-03 20:07:20.032840', '2002-01-03 20:07:20.032840', 'k', 'k'),(8, 9, '2003-09-24', '2003-09-24', '23:27:15.010726', '23:27:15.010726', '2008-05-04 06:10:26.048150', '2008-05-04 06:10:26.048150', 'd', 'd'),(2, 7, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2003-12-17 00:00:00', '2003-12-17 00:00:00', 'n', 'n'),(0, NULL, '2002-02-10', '2002-02-10', '02:37:51.058199', '02:37:51.058199', '2009-08-10 14:33:50.028308', '2009-08-10 14:33:50.028308', 'm', 'm'),(2, 2, '2007-01-10', '2007-01-10', '20:57:08.055051', '20:57:08.055051', '2000-06-20 00:33:26.047713', '2000-06-20 00:33:26.047713', 'i', 'i'),(3, 6, '2002-05-07', '2002-05-07', '04:12:42.056240', '04:12:42.056240', '2009-02-09 14:37:35.005917', '2009-02-09 14:37:35.005917', 'm', 'm'),(2, 5, '2006-01-07', '2006-01-07', '18:46:35.062704', '18:46:35.062704', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'o', 'o'),(2, 6, '2000-09-15', '2000-09-15', '19:51:10.015964', '19:51:10.015964', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'x', 'x'),(NULL, 3, NULL, NULL, '21:35:53.056741', '21:35:53.056741', '2009-07-28 01:36:16.025131', '2009-07-28 01:36:16.025131', 'q', 'q'),(6, 6, '2009-09-11', '2009-09-11', '11:11:43.014406', '11:11:43.014406', '2007-11-19 02:07:02.010446', '2007-11-19 02:07:02.010446', 'r', 'r'),(9, 1, '2007-06-06', '2007-06-06', '17:18:54.065065', '17:18:54.065065', '2000-06-20 05:20:28.004425', '2000-06-20 05:20:28.004425', 'w', 'w'),(21, NULL, NULL, NULL, '16:59:18.057019', '16:59:18.057019', '2004-12-24 07:16:48.025173', '2004-12-24 07:16:48.025173', 'h', 'h'),(3, NULL, '2002-10-18', '2002-10-18', '15:28:29.013006', '15:28:29.013006', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'a', 'a'),(1, 3, '2006-08-06', '2006-08-06', '00:00:00', '00:00:00', '2000-02-24 00:00:00', '2000-02-24 00:00:00', 'd', 'd'),(0, NULL, '1900-01-01', '1900-01-01', NULL, NULL, '2005-08-12 10:17:53.038330', '2005-08-12 10:17:53.038330', 'd', 'd'),(9, 7, '2002-01-15', '2002-01-15', NULL, NULL, '2005-06-17 05:02:47.057705', '2005-06-17 05:02:47.057705', 'z', 'z'),(4, 5, '1900-01-01', '1900-01-01', '11:46:50.065379', '11:46:50.065379', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'n', 'n'),(6, 1, '2001-12-06', '2001-12-06', '11:58:35.016647', '11:58:35.016647', '2006-07-21 00:00:00', '2006-07-21 00:00:00', 'p', 'p'),(7, 4, '2005-02-11', '2005-02-11', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(NULL, 6, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2005-01-10 00:00:00', '2005-01-10 00:00:00', 'q', 'q'),(8, 3, '2008-01-13', '2008-01-13', NULL, NULL, NULL, NULL, 'x', 'x'),(180, 89, '2006-07-25', '2006-07-25', '03:41:18.005153', '03:41:18.005153', '2002-04-06 06:54:03.052861', '2002-04-06 06:54:03.052861', 'j', 'j'),(NULL, 9, '2008-01-01', '2008-01-01', '20:36:54.050898', '20:36:54.050898', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'n', 'n'),(8, NULL, '2001-09-20', '2001-09-20', '09:41:08.039942', '09:41:08.039942', '2007-03-24 08:29:24.014468', '2007-03-24 08:29:24.014468', 'h', 'h'),(6, 5, '2004-02-25', '2004-02-25', '01:05:23.039576', '01:05:23.039576', '2000-01-15 00:00:00', '2000-01-15 00:00:00', 'k', 'k'),(2, 0, '1900-01-01', '1900-01-01', '06:08:49.055115', '06:08:49.055115', '2008-10-05 15:47:53.061469', '2008-10-05 15:47:53.061469', 'i', 'i'),(6, 2, '2001-01-14', '2001-01-14', NULL, NULL, '2005-03-14 21:34:08.043121', '2005-03-14 21:34:08.043121', 'k', 'k'),(3, 0, '2007-02-23', '2007-02-23', '12:32:58.027966', '12:32:58.027966', '2006-12-09 10:22:12.033908', '2006-12-09 10:22:12.033908', 'p', 'p'),(5, 8, '2003-11-06', '2003-11-06', '05:41:38.063202', '05:41:38.063202', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(2, 1, '2006-04-15', '2006-04-15', '20:59:28.024923', '20:59:28.024923', NULL, NULL, 'v', 'v'),(NULL, NULL, '2001-01-01', '2001-01-01', '17:04:00.041160', '17:04:00.041160', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'f', 'f'),(0, NULL, '2001-03-21', '2001-03-21', '00:00:00', '00:00:00', '2004-03-11 19:31:27.016536', '2004-03-11 19:31:27.016536', 'k', 'k'),(6, 4, '2002-04-17', '2002-04-17', '02:19:46.020759', '02:19:46.020759', '2009-03-15 00:00:00', '2009-03-15 00:00:00', 'o', 'o'),(4, 4, '2001-11-15', '2001-11-15', '06:16:12.005866', '06:16:12.005866', '2002-07-11 14:01:47.057123', '2002-07-11 14:01:47.057123', 'm', 'm'),(2, 3, NULL, NULL, '02:45:25.055565', '02:45:25.055565', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'k', 'k'),(9, 2, NULL, NULL, '15:23:48.022202', '15:23:48.022202', '2002-02-05 12:38:02.034242', '2002-02-05 12:38:02.034242', 's', 's'),(2, NULL, '1900-01-01', '1900-01-01', NULL, NULL, '2001-06-11 00:00:00', '2001-06-11 00:00:00', 'a', 'a'),(5, 0, '2005-03-13', '2005-03-13', NULL, NULL, '2004-02-03 10:13:11.036057', '2004-02-03 10:13:11.036057', 'r', 'r'),(7, 4, '2002-03-02', '2002-03-02', '00:34:05.050057', '00:34:05.050057', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'f', 'f'),(0, 8, NULL, NULL, '12:28:12.027612', '12:28:12.027612', '2004-05-25 16:03:39.024905', '2004-05-25 16:03:39.024905', 'o', 'o'),(5, 6, '2004-07-06', '2004-07-06', '00:00:00', '00:00:00', '2001-05-03 00:00:00', '2001-05-03 00:00:00', 'x', 'x'),(8, 4, '2002-01-12', '2002-01-12', '11:04:06.000124', '11:04:06.000124', '2007-02-18 14:25:23.063246', '2007-02-18 14:25:23.063246', 'v', 'v'),(8, 5, '1900-01-01', '1900-01-01', '16:36:23.016741', '16:36:23.016741', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'n', 'n'),(6, 6, '2008-09-04', '2008-09-04', '22:01:08.043654', '22:01:08.043654', '2003-12-02 00:00:00', '2003-12-02 00:00:00', 'c', 'c'),(7, 2, '2005-09-26', '2005-09-26', '18:18:59.053957', '18:18:59.053957', '2007-03-04 12:16:07.011259', '2007-03-04 12:16:07.011259', 'k', 'k'),(243, 71, '2002-05-23', '2002-05-23', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'h', 'h'),(7, 4, '2005-07-13', '2005-07-13', '00:00:00', '00:00:00', '2003-03-23 00:01:00.009895', '2003-03-23 00:01:00.009895', 'x', 'x'),(4, 1, NULL, NULL, '14:46:17.012609', '14:46:17.012609', '2007-10-07 09:15:07.010118', '2007-10-07 09:15:07.010118', 'j', 'j'),(250, 100, '1900-01-01', '1900-01-01', '07:59:32.005359', '07:59:32.005359', '2007-07-26 05:15:02.051919', '2007-07-26 05:15:02.051919', 'g', 'g'),(1, 4, '2008-11-02', '2008-11-02', '00:00:00', '00:00:00', '2007-09-02 05:22:18.043998', '2007-09-02 05:22:18.043998', 'g', 'g'),(NULL, NULL, '2004-07-07', '2004-07-07', '05:20:51.025291', '05:20:51.025291', '2002-12-27 08:03:42.045858', '2002-12-27 08:03:42.045858', 'o', 'o'),(5, 9, '2009-12-07', '2009-12-07', '09:45:41.025723', '09:45:41.025723', '2007-04-21 11:22:42.002990', '2007-04-21 11:22:42.002990', 'v', 'v'),(8, 0, '2008-12-22', '2008-12-22', '03:08:20.010681', '03:08:20.010681', '2001-04-11 00:00:00', '2001-04-11 00:00:00', 'r', 'r'),(2, 2, '2002-02-27', '2002-02-27', '11:18:06.006904', '11:18:06.006904', '2007-05-25 22:35:40.000888', '2007-05-25 22:35:40.000888', 'd', 'd'),(8, 4, '2000-09-03', '2000-09-03', '22:58:15.037270', '22:58:15.037270', '2003-08-03 00:00:00', '2003-08-03 00:00:00', 'j', 'j'),(5, NULL, '2009-02-22', '2009-02-22', '17:11:39.047578', '17:11:39.047578', NULL, NULL, 'b', 'b'),(NULL, 8, NULL, NULL, '11:57:52.057990', '11:57:52.057990', '2003-12-22 03:21:50.061746', '2003-12-22 03:21:50.061746', NULL, NULL),(NULL, NULL, NULL, NULL, '19:58:40.018134', '19:58:40.018134', '2009-01-11 17:51:59.011108', '2009-01-11 17:51:59.011108', 'g', 'g'),(7, 5, '2001-02-03', '2001-02-03', '10:09:14.032117', '10:09:14.032117', '2007-01-13 03:53:44.014868', '2007-01-13 03:53:44.014868', NULL, NULL),(2, 0, '2008-11-23', '2008-11-23', '13:20:18.021767', '13:20:18.021767', '2002-12-02 00:00:00', '2002-12-02 00:00:00', 'm', 'm'),(8, 8, '2009-08-23', '2009-08-23', '01:04:24.008252', '01:04:24.008252', '2004-12-18 07:10:49.024475', '2004-12-18 07:10:49.024475', 'x', 'x'),(5, 8, '2009-10-19', '2009-10-19', '09:31:55.063503', '09:31:55.063503', '2001-02-10 09:07:30.056797', '2001-02-10 09:07:30.056797', 'o', 'o'),(0, 8, '2000-03-06', '2000-03-06', '18:50:55.033180', '18:50:55.033180', '2004-11-16 08:00:46.015543', '2004-11-16 08:00:46.015543', 'c', 'c'),(9, 3, '2007-08-26', '2007-08-26', '14:38:41.046687', '14:38:41.046687', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(9, 7, '2002-05-04', '2002-05-04', '22:07:25.055153', '22:07:25.055153', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'c', 'c'),(1, 6, NULL, NULL, '08:10:49.031151', '08:10:49.031151', '2008-03-03 00:00:00', '2008-03-03 00:00:00', 'w', 'w'),(1, 3, '2006-06-03', '2006-06-03', '19:22:35.035011', '19:22:35.035011', '2009-01-26 08:27:08.017109', '2009-01-26 08:27:08.017109', 'z', 'z'),(1, 4, '2009-09-11', '2009-09-11', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(79, 137, '2005-03-12', '2005-03-12', '04:12:20.021897', '04:12:20.021897', '2009-12-13 00:00:00', '2009-12-13 00:00:00', 'i', 'i'),(3, 5, '2003-10-19', '2003-10-19', '09:19:38.053767', '09:19:38.053767', '2002-02-21 00:00:00', '2002-02-21 00:00:00', 'm', 'm'),(6, 5, '2008-01-04', '2008-01-04', '20:56:09.026986', '20:56:09.026986', '2000-12-04 18:40:31.032844', '2000-12-04 18:40:31.032844', 'x', 'x'),(130, 29, NULL, NULL, '05:48:23.027611', '05:48:23.027611', '2000-01-02 00:00:00', '2000-01-02 00:00:00', 'r', 'r'),(5, 7, '2008-08-22', '2008-08-22', '11:00:11.043509', '11:00:11.043509', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(5, 3, '1900-01-01', '1900-01-01', '00:55:47.033355', '00:55:47.033355', '2004-02-10 00:00:00', '2004-02-10 00:00:00', 'o', 'o'),(9, NULL, '2005-11-01', '2005-11-01', '00:00:00', '00:00:00', NULL, NULL, 'h', 'h'),(9, 8, '2001-12-24', '2001-12-24', '00:00:00', '00:00:00', '2003-09-06 15:42:53.022884', '2003-09-06 15:42:53.022884', 't', 't'),(7, 3, '2000-10-16', '2000-10-16', '17:03:22.008263', '17:03:22.008263', '2002-09-10 00:00:00', '2002-09-10 00:00:00', 'n', 'n'),(8, 7, '1900-01-01', '1900-01-01', '15:05:46.031459', '15:05:46.031459', '2006-05-06 12:50:40.003759', '2006-05-06 12:50:40.003759', 'f', 'f'),(9, 9, '2009-10-04', '2009-10-04', '00:00:00', '00:00:00', '2008-01-28 21:26:06.032028', '2008-01-28 21:26:06.032028', 'p', 'p'),(9, NULL, '2007-05-28', '2007-05-28', '10:27:05.045794', '10:27:05.045794', '2001-10-03 05:16:55.019473', '2001-10-03 05:16:55.019473', 't', 't'),(7, 9, '2007-02-11', '2007-02-11', NULL, NULL, '2001-01-21 00:00:00', '2001-01-21 00:00:00', 'a', 'a'),(8, 9, '2002-02-02', '2002-02-02', '15:47:37.063280', '15:47:37.063280', '2007-02-18 01:53:15.019895', '2007-02-18 01:53:15.019895', 'p', 'p'),(0, 8, '2007-01-15', '2007-01-15', '01:22:51.019987', '01:22:51.019987', '2002-04-26 18:58:06.010672', '2002-04-26 18:58:06.010672', 'm', 'm'),(1, 2, '2004-08-19', '2004-08-19', '02:21:20.057445', '02:21:20.057445', '2000-08-26 15:52:27.038529', '2000-08-26 15:52:27.038529', 'q', 'q'),(6, 6, '2005-05-15', '2005-05-15', NULL, NULL, '2007-06-02 09:03:39.054643', '2007-06-02 09:03:39.054643', 'u', 'u'),(0, 8, '2002-10-09', '2002-10-09', '00:40:21.062880', '00:40:21.062880', '2007-12-04 06:27:17.020202', '2007-12-04 06:27:17.020202', 'j', 'j'),(8, 2, NULL, NULL, '09:40:53.053029', '09:40:53.053029', '2006-10-19 15:20:32.012388', '2006-10-19 15:20:32.012388', 'm', 'm'),(NULL, 7, '2009-10-28', '2009-10-28', '13:41:28.055195', '13:41:28.055195', NULL, NULL, 's', 's'),(NULL, 0, NULL, NULL, '06:36:11.022425', '06:36:11.022425', '2005-11-12 15:43:00.016456', '2005-11-12 15:43:00.016456', 'p', 'p'),(2, 2, '1900-01-01', '1900-01-01', NULL, NULL, '2008-11-25 10:02:45.048626', '2008-11-25 10:02:45.048626', 'k', 'k'),(8, 2, NULL, NULL, '01:19:14.060752', '01:19:14.060752', '2004-11-04 16:28:06.018274', '2004-11-04 16:28:06.018274', 'q', 'q'),(9, 0, '2003-10-16', '2003-10-16', '23:46:43.012460', '23:46:43.012460', '2002-04-10 02:03:46.040802', '2002-04-10 02:03:46.040802', 'r', 'r'),(8, 5, '1900-01-01', '1900-01-01', '01:10:17.001463', '01:10:17.001463', '2008-04-03 11:26:44.052464', '2008-04-03 11:26:44.052464', 'x', 'x'),(6, 8, '2005-12-01', '2005-12-01', '20:07:04.050041', '20:07:04.050041', '2000-03-25 00:00:00', '2000-03-25 00:00:00', 'u', 'u'),(7, NULL, '2001-06-06', '2001-06-06', '12:25:47.044992', '12:25:47.044992', NULL, NULL, 'l', 'l'),(NULL, 2, '2003-09-01', '2003-09-01', '07:33:01.054701', '07:33:01.054701', '2009-09-07 16:59:37.055368', '2009-09-07 16:59:37.055368', NULL, NULL),(2, 1, '2007-06-26', '2007-06-26', '14:03:42.037507', '14:03:42.037507', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'l', 'l'),(1, 8, '2008-06-03', '2008-06-03', '20:19:58.001645', '20:19:58.001645', '2008-08-16 00:00:00', '2008-08-16 00:00:00', NULL, NULL),(5, 2, '2001-05-08', '2001-05-08', '00:38:55.023531', '00:38:55.023531', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'm', 'm'),(NULL, 2, '2009-02-10', '2009-02-10', '08:13:52.051586', '08:13:52.051586', '2009-02-13 08:53:48.039414', '2009-02-13 08:53:48.039414', 'z', 'z'),(NULL, 3, '2005-08-04', '2005-08-04', '21:38:08.039892', '21:38:08.039892', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(9, 9, '2002-12-15', '2002-12-15', '15:07:13.006148', '15:07:13.006148', '2004-02-27 00:00:00', '2004-02-27 00:00:00', 'x', 'x'),(5, 1, '2009-04-15', '2009-04-15', '01:00:31.003288', '01:00:31.003288', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'r', 'r'),(9, 5, '2002-09-12', '2002-09-12', '14:20:08.057609', '14:20:08.057609', '2009-03-06 01:26:24.034801', '2009-03-06 01:26:24.034801', 't', 't'),(NULL, 5, '2009-07-28', '2009-07-28', '17:05:03.056288', '17:05:03.056288', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'y', 'y'),(NULL, 6, '2008-08-07', '2008-08-07', NULL, NULL, '2007-07-11 21:16:50.041396', '2007-07-11 21:16:50.041396', 'k', 'k'),(9, 123, '2005-01-25', '2005-01-25', '01:30:45.040459', '01:30:45.040459', '2003-05-08 06:01:17.029507', '2003-05-08 06:01:17.029507', 'r', 'r'),(5, 0, '1900-01-01', '1900-01-01', '02:27:49.023860', '02:27:49.023860', '2006-06-05 00:00:00', '2006-06-05 00:00:00', 'l', 'l'),(0, 6, '2007-08-10', '2007-08-10', '19:11:59.003445', '19:11:59.003445', '2009-01-12 17:02:49.022000', '2009-01-12 17:02:49.022000', 'p', 'p'),(NULL, 0, '2009-02-08', '2009-02-08', NULL, NULL, '2003-05-14 01:51:17.032708', '2003-05-14 01:51:17.032708', 'v', 'v'),(98, 75, '2009-03-28', '2009-03-28', '07:23:53.051441', '07:23:53.051441', '2008-10-25 00:20:09.043547', '2008-10-25 00:20:09.043547', 'r', 'r'),(5, 9, '2007-09-18', '2007-09-18', '19:03:45.062055', '19:03:45.062055', '2005-01-13 12:59:38.029975', '2005-01-13 12:59:38.029975', 'j', 'j'),(242, 69, '2006-06-13', '2006-06-13', NULL, NULL, '2005-07-14 04:37:14.046584', '2005-07-14 04:37:14.046584', 'k', 'k'),(7, 8, '2007-11-21', '2007-11-21', '09:44:43.012921', '09:44:43.012921', '2005-12-04 23:45:17.028499', '2005-12-04 23:45:17.028499', 'u', 'u'),(1, NULL, '2005-09-15', '2005-09-15', '23:10:03.015490', '23:10:03.015490', NULL, NULL, 'g', 'g'),(25, 51, NULL, NULL, '00:00:00', '00:00:00', '2006-06-13 00:00:00', '2006-06-13 00:00:00', NULL, NULL),(4, 8, '2005-04-06', '2005-04-06', '06:11:01.020575', '06:11:01.020575', '2009-11-13 09:32:34.021946', '2009-11-13 09:32:34.021946', 'c', 'c'),(8, 5, '2006-01-02', '2006-01-02', NULL, NULL, NULL, NULL, 'j', 'j'),(9, 5, '2005-09-02', '2005-09-02', '01:27:12.034681', '01:27:12.034681', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'w', 'w'),(NULL, 3, '1900-01-01', '1900-01-01', '05:59:08.018787', '05:59:08.018787', '2001-03-02 02:14:02.043718', '2001-03-02 02:14:02.043718', 'p', 'p'),(3, NULL, NULL, NULL, '04:23:34.053765', '04:23:34.053765', NULL, NULL, 'i', 'i'),(5, NULL, '2004-03-08', '2004-03-08', '14:35:17.047031', '14:35:17.047031', '2001-11-24 18:36:22.051493', '2001-11-24 18:36:22.051493', 's', 's'),(4, 4, '2005-10-02', '2005-10-02', NULL, NULL, '2003-02-14 05:37:14.033400', '2003-02-14 05:37:14.033400', 'o', 'o'),(6, 8, '2000-03-01', '2000-03-01', NULL, NULL, '2006-09-06 12:24:33.043585', '2006-09-06 12:24:33.043585', 'x', 'x'),(3, 5, '1900-01-01', '1900-01-01', '09:14:02.049795', '09:14:02.049795', '2001-07-27 00:00:00', '2001-07-27 00:00:00', 't', 't'),(NULL, 5, '2007-01-01', '2007-01-01', '23:05:59.021128', '23:05:59.021128', '2003-03-20 17:31:41.048082', '2003-03-20 17:31:41.048082', 'p', 'p'),(0, 3, '2008-02-11', '2008-02-11', '00:00:00', '00:00:00', NULL, NULL, 'z', 'z'),(4, 8, '2001-09-21', '2001-09-21', '01:17:20.051058', '01:17:20.051058', '2004-12-04 00:00:00', '2004-12-04 00:00:00', 'c', 'c'),(9, 1, '2004-07-06', '2004-07-06', NULL, NULL, '2009-08-24 08:47:32.057618', '2009-08-24 08:47:32.057618', NULL, NULL),(1, 9, '2003-03-24', '2003-03-24', '11:42:11.033761', '11:42:11.033761', '2003-05-11 05:07:40.010664', '2003-05-11 05:07:40.010664', 's', 's'),(4, 9, '2004-04-23', '2004-04-23', '06:54:13.013122', '06:54:13.013122', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'l', 'l'),(3, 5, '2002-05-22', '2002-05-22', '00:00:00', '00:00:00', '2000-09-22 00:00:00', '2000-09-22 00:00:00', 'i', 'i'),(4, NULL, '2004-06-16', '2004-06-16', NULL, NULL, '2000-05-27 05:15:50.046565', '2000-05-27 05:15:50.046565', 'f', 'f'),(0, NULL, '2008-05-16', '2008-05-16', '02:36:31.011556', '02:36:31.011556', '2006-12-12 01:14:10.064957', '2006-12-12 01:14:10.064957', 'c', 'c'),(0, 7, '2008-12-16', '2008-12-16', NULL, NULL, '2001-08-07 00:00:00', '2001-08-07 00:00:00', 's', 's'),(4, 5, NULL, NULL, '12:52:31.004367', '12:52:31.004367', '2005-01-16 17:25:51.061169', '2005-01-16 17:25:51.061169', 'i', 'i'),(0, 2, '2008-09-09', '2008-09-09', '11:29:47.065068', '11:29:47.065068', '2000-06-06 05:21:12.022745', '2000-06-06 05:21:12.022745', 's', 's'),(9, 8, '2006-12-12', '2006-12-12', '16:14:07.057641', '16:14:07.057641', '2009-01-22 04:22:07.039160', '2009-01-22 04:22:07.039160', 'r', 'r'),(7, NULL, '2004-02-10', '2004-02-10', '20:30:56.048535', '20:30:56.048535', '2006-10-21 09:55:55.050271', '2006-10-21 09:55:55.050271', 'd', 'd'),(152, 245, '2001-02-16', '2001-02-16', '22:26:31.036513', '22:26:31.036513', '2001-03-13 08:10:45.035136', '2001-03-13 08:10:45.035136', 'i', 'i'),(4, NULL, '2005-04-07', '2005-04-07', '01:23:20.031626', '01:23:20.031626', '2004-04-23 00:00:00', '2004-04-23 00:00:00', NULL, NULL),(7, 7, '2006-05-15', '2006-05-15', '23:21:19.004929', '23:21:19.004929', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL),(6, NULL, '2007-01-12', '2007-01-12', '22:02:32.054860', '22:02:32.054860', '2003-12-07 23:35:02.033119', '2003-12-07 23:35:02.033119', 'v', 'v'),(NULL, 9, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2006-02-05 19:41:14.039855', '2006-02-05 19:41:14.039855', 'v', 'v'),(8, NULL, '2008-05-09', '2008-05-09', '01:18:48.005061', '01:18:48.005061', '2006-10-08 00:00:00', '2006-10-08 00:00:00', 'i', 'i'),(5, 6, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'o', 'o'),(3, 5, '2006-04-10', '2006-04-10', '14:27:22.032389', '14:27:22.032389', '2000-08-22 01:39:25.007688', '2000-08-22 01:39:25.007688', 'c', 'c'),(3, 3, NULL, NULL, '00:00:00', '00:00:00', '2001-07-11 06:09:10.040017', '2001-07-11 06:09:10.040017', 'p', 'p'),(3, 6, '2008-06-18', '2008-06-18', '02:52:45.053582', '02:52:45.053582', '2001-10-26 00:00:00', '2001-10-26 00:00:00', 'z', 'z'),(4, 3, '2006-01-22', '2006-01-22', '03:23:17.026609', '03:23:17.026609', '2005-02-28 11:47:01.046955', '2005-02-28 11:47:01.046955', 'r', 'r'),(4, 4, '2006-07-28', '2006-07-28', '00:00:00', '00:00:00', '2004-05-18 02:29:39.032765', '2004-05-18 02:29:39.032765', 'g', 'g'),(5, 2, '2005-08-21', '2005-08-21', '19:07:36.027534', '19:07:36.027534', '2000-03-26 20:22:44.051354', '2000-03-26 20:22:44.051354', 'z', 'z'),(5, 5, '2004-10-10', '2004-10-10', '07:50:55.012251', '07:50:55.012251', '2005-07-17 15:48:30.006706', '2005-07-17 15:48:30.006706', 's', 's'),(9, 4, '2007-08-02', '2007-08-02', '23:55:16.028772', '23:55:16.028772', '2002-12-08 04:55:04.060553', '2002-12-08 04:55:04.060553', 'o', 'o'),(6, 6, '2006-01-18', '2006-01-18', '08:04:32.042008', '08:04:32.042008', '2004-05-18 23:59:48.028236', '2004-05-18 23:59:48.028236', 'o', 'o'),(5, 4, '2000-11-14', '2000-11-14', '00:00:00', '00:00:00', NULL, NULL, 'm', 'm'),(2, 5, '2002-12-27', '2002-12-27', '04:26:38.047173', '04:26:38.047173', '2001-09-23 12:57:03.002046', '2001-09-23 12:57:03.002046', 's', 's'),(5, 5, '2006-04-03', '2006-04-03', '00:00:00', '00:00:00', '2004-07-03 22:48:34.019235', '2004-07-03 22:48:34.019235', 'v', 'v'),(63, 44, '2006-04-23', '2006-04-23', '16:01:55.008164', '16:01:55.008164', '2001-01-13 07:27:19.063347', '2001-01-13 07:27:19.063347', 'h', 'h'),(4, 9, '2004-06-06', '2004-06-06', '10:12:12.005448', '10:12:12.005448', '2000-03-10 20:28:50.045907', '2000-03-10 20:28:50.045907', 'n', 'n'),(9, 5, '2000-09-22', '2000-09-22', NULL, NULL, '2005-09-26 10:39:34.048522', '2005-09-26 10:39:34.048522', 'f', 'f'),(2, 6, '2005-02-07', '2005-02-07', '12:11:06.049699', '12:11:06.049699', '2008-01-03 00:00:00', '2008-01-03 00:00:00', 's', 's'),(3, 6, '2000-05-10', '2000-05-10', '01:11:45.005201', '01:11:45.005201', '2007-09-25 10:58:22.023944', '2007-09-25 10:58:22.023944', 'o', 'o'),(5, 3, '2004-12-23', '2004-12-23', '05:49:25.028992', '05:49:25.028992', '2001-06-20 00:00:00', '2001-06-20 00:00:00', 'i', 'i'),(1, 4, NULL, NULL, '15:12:52.043664', '15:12:52.043664', '2005-10-18 00:00:00', '2005-10-18 00:00:00', 't', 't'),(5, 0, '2002-07-25', '2002-07-25', '00:55:50.003815', '00:55:50.003815', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 's', 's'),(2, 7, '2008-09-14', '2008-09-14', '16:07:36.052501', '16:07:36.052501', '2002-06-15 06:42:45.030009', '2002-06-15 06:42:45.030009', 'x', 'x'),(1, 8, NULL, NULL, '04:51:03.033139', '04:51:03.033139', '2006-05-05 14:30:46.060041', '2006-05-05 14:30:46.060041', 'm', 'm'),(4, 8, '2002-08-02', '2002-08-02', '00:00:00', '00:00:00', '2004-02-12 23:43:12.003073', '2004-02-12 23:43:12.003073', 'n', 'n'),(2, 1, '1900-01-01', '1900-01-01', '19:53:15.016463', '19:53:15.016463', '2008-03-03 00:00:00', '2008-03-03 00:00:00', 'h', 'h'),(8, 7, '2004-12-16', '2004-12-16', '14:49:28.044158', '14:49:28.044158', '2003-09-19 00:00:00', '2003-09-19 00:00:00', 'l', 'l'),(NULL, NULL, '2008-07-16', '2008-07-16', '21:38:43.060664', '21:38:43.060664', '2009-12-21 00:00:00', '2009-12-21 00:00:00', 'y', 'y'),(5, 4, '2003-07-22', '2003-07-22', NULL, NULL, '2008-10-16 13:10:45.040516', '2008-10-16 13:10:45.040516', 's', 's'),(4, 9, NULL, NULL, '07:10:22.054884', '07:10:22.054884', '2004-02-01 12:39:50.057606', '2004-02-01 12:39:50.057606', 'u', 'u'),(7, 6, '2001-12-11', '2001-12-11', '05:27:29.039567', '05:27:29.039567', NULL, NULL, 'r', 'r'),(9, 4, '2005-10-01', '2005-10-01', '16:25:56.045853', '16:25:56.045853', '2006-07-08 18:03:06.058039', '2006-07-08 18:03:06.058039', 's', 's'),(4, NULL, NULL, NULL, '14:20:56.045923', '14:20:56.045923', '2004-03-24 23:16:37.004325', '2004-03-24 23:16:37.004325', 'z', 'z'),(4, 3, '2006-06-03', '2006-06-03', '08:20:32.001162', '08:20:32.001162', '2004-08-14 00:00:00', '2004-08-14 00:00:00', 'w', 'w'),(4, 2, '2000-04-16', '2000-04-16', '17:02:34.039583', '17:02:34.039583', '2009-08-04 02:49:10.056227', '2009-08-04 02:49:10.056227', 'j', 'j'),(6, 7, '2007-04-20', '2007-04-20', '19:32:57.060310', '19:32:57.060310', '2008-04-03 10:06:40.057311', '2008-04-03 10:06:40.057311', 'p', 'p'),(5, 8, '1900-01-01', '1900-01-01', '07:13:26.044366', '07:13:26.044366', NULL, NULL, 'l', 'l'),(2, 8, '1900-01-01', '1900-01-01', '00:00:00', '00:00:00', '2009-08-14 19:44:02.035647', '2009-08-14 19:44:02.035647', 'u', 'u'),(7, 4, '1900-01-01', '1900-01-01', '11:20:49.004399', '11:20:49.004399', '2003-01-24 19:12:54.049510', '2003-01-24 19:12:54.049510', 'f', 'f'),(NULL, 9, '1900-01-01', '1900-01-01', '11:45:16.045773', '11:45:16.045773', '2008-01-28 15:28:23.016941', '2008-01-28 15:28:23.016941', 'm', 'm'),(7, 3, '2008-12-02', '2008-12-02', '14:09:40.055142', '14:09:40.055142', '2002-09-04 14:46:19.058851', '2002-09-04 14:46:19.058851', 'j', 'j'),(32, 51, '2008-11-08', '2008-11-08', '16:29:24.006953', '16:29:24.006953', '2005-04-13 06:52:30.018812', '2005-04-13 06:52:30.018812', 't', 't'),(7, 7, '2006-09-25', '2006-09-25', '23:59:43.046366', '23:59:43.046366', NULL, NULL, 'm', 'm');
DROP TABLE IF EXISTS  aa;

CREATE TABLE aa (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,	col_date_key DATE ,col_date_nokey DATE ,col_time_key TIME ,col_time_nokey TIME ,	col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),KEY (col_time_key),KEY (col_datetime_key),KEY (col_varchar_key, col_int_key))  AUTO_INCREMENT=10 ENGINE=INNODB;
DROP TABLE IF EXISTS  bb;

CREATE TABLE bb (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,	col_date_key DATE ,col_date_nokey DATE ,col_time_key TIME ,col_time_nokey TIME ,	col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),	KEY (col_time_key),KEY (col_datetime_key),KEY (col_varchar_key, col_int_key))  AUTO_INCREMENT=10 ENGINE=INNODB;

INSERT IGNORE  INTO bb (col_int_key, col_int_nokey,col_date_key, col_date_nokey,col_time_key, col_time_nokey,col_datetime_key, col_datetime_nokey,col_varchar_key,col_varchar_nokey) VALUES (8, 7, '2008-10-02', '2008-10-02', '04:07:22.028954', '04:07:22.028954', '2001-10-08 00:00:00', '2001-10-08 00:00:00', 'g', 'g');
DROP TABLE IF EXISTS  CC;

CREATE TABLE cc (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,	col_date_key DATE ,col_date_nokey DATE ,col_time_key TIME ,col_time_nokey TIME ,	col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),KEY (col_time_key),KEY (col_datetime_key),KEY (col_varchar_key, col_int_key))  AUTO_INCREMENT=10 ENGINE=INNODB;

INSERT IGNORE  INTO cc (col_int_key, col_int_nokey,col_date_key, col_date_nokey,col_time_key, col_time_nokey,col_datetime_key, col_datetime_nokey,col_varchar_key,col_varchar_nokey) VALUES (8, NULL, '2000-12-03', '2000-12-03', '22:55:23.019225', '22:55:23.019225', '2005-07-20 00:00:00', '2005-07-20 00:00:00', 'x', 'x'),(7, 8, '2008-05-03', '2008-05-03', '10:19:31.050677', '10:19:31.050677', '2007-10-06 17:56:40.056051', '2007-10-06 17:56:40.056051', 'd', 'd'),(1, 1, '2005-12-06', '2005-12-06', '14:40:36.038608', '14:40:36.038608', NULL, NULL, 'r', 'r'),(7, 9, '2000-04-10', '2000-04-10', '04:37:47.062416', '04:37:47.062416', '2007-12-23 05:17:49.029955', '2007-12-23 05:17:49.029955', 'f', 'f'),(9, 4, '2002-11-05', '2002-11-05', '19:34:06.054514', '19:34:06.054514', NULL, NULL, 'y', 'y'),(NULL, 3, '2000-09-06', '2000-09-06', '20:35:33.022996', '20:35:33.022996', '2000-08-16 00:00:00', '2000-08-16 00:00:00', 'u', 'u'),(1, 2, NULL, NULL, NULL, NULL, NULL, NULL, 'm', 'm'),(9, NULL, '2007-06-14', '2007-06-14', '14:43:37.057393', '14:43:37.057393', '2003-02-07 09:50:39.001189', '2003-02-07 09:50:39.001189', NULL, NULL),(2, 2, '2007-11-17', '2007-11-17', '02:23:09.043438', '02:23:09.043438', '2003-08-04 23:00:25.012582', '2003-08-04 23:00:25.012582', 'o', 'o'),(9, NULL, '2009-02-23', '2009-02-23', '01:22:45.041064', '01:22:45.041064', '2009-08-07 12:57:18.026416', '2009-08-07 12:57:18.026416', 'w', 'w'),(2, 6, '2007-01-08', '2007-01-08', '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'm', 'm'),(4, 7, '2008-06-10', '2008-06-10', '00:13:25.038482', '00:13:25.038482', '2001-06-17 01:34:03.065074', '2001-06-17 01:34:03.065074', 'q', 'q'),(0, 2, '2002-10-20', '2002-10-20', '03:47:16.042671', '03:47:16.042671', NULL, NULL, NULL, NULL),(4, 5, '2008-09-12', '2008-09-12', '01:41:48.007423', '01:41:48.007423', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'd', 'd'),(8, 7, '2006-06-16', '2006-06-16', '00:00:00', '00:00:00', NULL, NULL, 'g', 'g'),(NULL, 6, '2004-09-18', '2004-09-18', '22:32:04.047407', '22:32:04.047407', '2007-08-22 14:10:22.054447', '2007-08-22 14:10:22.054447', 'x', 'x'),(NULL, 6, '1900-01-01', '1900-01-01', '16:44:14.028443', '16:44:14.028443', '2005-01-07 12:15:05.055865', '2005-01-07 12:15:05.055865', 'f', 'f'),(0, 2, '2005-09-13', '2005-09-13', '17:38:37.059754', '17:38:37.059754', '2008-07-18 00:00:00', '2008-07-18 00:00:00', 'p', 'p'),(NULL, 9, '2007-04-09', '2007-04-09', '08:46:48.042388', '08:46:48.042388', '2005-03-24 07:33:11.043368', '2005-03-24 07:33:11.043368', 'j', 'j'),(8, 6, '2000-09-20', '2000-09-20', '14:11:27.044095', '14:11:27.044095', '2003-06-13 23:19:49.018300', '2003-06-13 23:19:49.018300', 'c', 'c');
DROP TABLE IF EXISTS  dd;

CREATE TABLE dd (pk INTEGER AUTO_INCREMENT,col_int_nokey INTEGER ,col_int_key INTEGER ,	col_date_key DATE ,col_date_nokey DATE ,col_time_key TIME ,col_time_nokey TIME ,	col_datetime_key DATETIME ,col_datetime_nokey DATETIME ,col_varchar_key VARCHAR(1) ,col_varchar_nokey VARCHAR(1) ,PRIMARY KEY (pk),KEY (col_int_key),KEY (col_date_key),KEY (col_time_key),KEY (col_datetime_key),KEY (col_varchar_key, col_int_key))  AUTO_INCREMENT=10 ENGINE=INNODB;

INSERT IGNORE  INTO dd (col_int_key, col_int_nokey,col_date_key, col_date_nokey,col_time_key, col_time_nokey,col_datetime_key, col_datetime_nokey,col_varchar_key,col_varchar_nokey) VALUES (8, 0, '1900-01-01', '1900-01-01', '07:55:54.051037', '07:55:54.051037', '2008-11-09 06:28:05.052151', '2008-11-09 06:28:05.052151', 'z', 'z'),(6, 3, NULL, NULL, '14:18:47.011111', '14:18:47.011111', '2009-02-11 10:59:50.050473', '2009-02-11 10:59:50.050473', 'j', 'j'),(2, 8, '2009-09-06', '2009-09-06', '00:00:00', '00:00:00', '2000-02-23 00:39:41.005498', '2000-02-23 00:39:41.005498', NULL, NULL),(3, 8, '2008-08-23', '2008-08-23', '01:57:54.037299', '01:57:54.037299', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'p', 'p'),(1, 6, '2009-03-24', '2009-03-24', '21:24:27.027297', '21:24:27.027297', '2009-07-03 13:47:15.010810', '2009-07-03 13:47:15.010810', 'w', 'w'),(NULL, 0, '2009-11-15', '2009-11-15', NULL, NULL, '2001-04-11 12:39:06.038205', '2001-04-11 12:39:06.038205', 'c', 'c'),(1, NULL, '2001-12-23', '2001-12-23', '21:34:24.023001', '21:34:24.023001', '2007-01-26 15:51:38.027592', '2007-01-26 15:51:38.027592', 'j', 'j'),(10, 158, '2007-02-11', '2007-02-11', '18:11:35.006542', '18:11:35.006542', '2003-04-27 19:48:50.025877', '2003-04-27 19:48:50.025877', 'f', 'f'),(2, 5, '2005-04-16', '2005-04-16', '09:21:51.027414', '09:21:51.027414', '2001-11-15 10:51:46.055784', '2001-11-15 10:51:46.055784', 'v', 'v'),(103, 163, '2007-05-12', '2007-05-12', '09:02:21.047274', '09:02:21.047274', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'f', 'f'),(3, 2, '2000-07-20', '2000-07-20', '22:40:03.005755', '22:40:03.005755', '2000-10-20 17:09:41.008405', '2000-10-20 17:09:41.008405', 'q', 'q'),(6, 8, '2008-08-14', '2008-08-14', '19:29:48.025140', '19:29:48.025140', '2005-10-03 00:00:00', '2005-10-03 00:00:00', 'y', 'y'),(2, 0, '2004-08-04', '2004-08-04', NULL, NULL, '2008-03-06 19:40:18.015845', '2008-03-06 19:40:18.015845', 'a', 'a'),(7, 9, '2002-06-25', '2002-06-25', '01:39:40.022975', '01:39:40.022975', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'w', 'w'),(2, 3, '2004-04-08', '2004-04-08', '18:14:11.006811', '18:14:11.006811', '2004-03-03 15:06:11.026757', '2004-03-03 15:06:11.026757', 'e', 'e'),(2, 1, '2004-12-20', '2004-12-20', '03:28:55.038579', '03:28:55.038579', '2009-06-03 03:14:33.011355', '2009-06-03 03:14:33.011355', NULL, NULL),(4, 9, '2009-07-09', '2009-07-09', '15:00:03.027372', '15:00:03.027372', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'r', 'r'),(6, NULL, '1900-01-01', '1900-01-01', '17:10:27.024761', '17:10:27.024761', '2003-04-18 18:00:26.055211', '2003-04-18 18:00:26.055211', 'k', 'k'),(6, 5, '1900-01-01', '1900-01-01', '09:50:22.010984', '09:50:22.010984', '2005-10-20 00:00:00', '2005-10-20 00:00:00', 'c', 'c'),(8, 3, '2007-09-24', '2007-09-24', '00:00:00', '00:00:00', '2009-07-24 13:01:33.046163', '2009-07-24 13:01:33.046163', 'k', 'k'),(4, 9, '2000-05-07', '2000-05-07', '09:51:13.046778', '09:51:13.046778', '2005-04-14 03:38:00.008685', '2005-04-14 03:38:00.008685', NULL, NULL),(2, 8, '2002-07-15', '2002-07-15', '11:25:28.044423', '11:25:28.044423', NULL, NULL, 'j', 'j'),(8, 1, '2005-09-09', '2005-09-09', NULL, NULL, '2002-07-16 03:25:43.049611', '2002-07-16 03:25:43.049611', 't', 't'),(1, 8, '2006-05-08', '2006-05-08', '11:14:24.017155', '11:14:24.017155', '2005-12-12 08:27:15.009824', '2005-12-12 08:27:15.009824', 'n', 'n'),(NULL, NULL, '2004-02-05', '2004-02-05', '04:00:47.034077', '04:00:47.034077', '2001-11-25 18:24:30.022778', '2001-11-25 18:24:30.022778', 'z', 'z'),(3, 0, '2000-02-21', '2000-02-21', '21:22:12.046674', '21:22:12.046674', '2005-07-28 18:41:31.045474', '2005-07-28 18:41:31.045474', 'u', 'u'),(2, 3, '2006-05-10', '2006-05-10', '14:29:11.045056', '14:29:11.045056', '2003-09-25 22:51:04.037264', '2003-09-25 22:51:04.037264', 'a', 'a'),(NULL, 3, '2007-10-28', '2007-10-28', '16:23:38.048946', '16:23:38.048946', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'g', 'g'),(4, 1, '2007-05-01', '2007-05-01', '20:06:35.055965', '20:06:35.055965', '2005-01-11 07:21:24.021466', '2005-01-11 07:21:24.021466', 'f', 'f'),(60, 64, '2004-02-26', '2004-02-26', '19:33:10.017526', '19:33:10.017526', '2008-09-15 17:25:04.015905', '2008-09-15 17:25:04.015905', 'p', 'p'),(0, 6, '1900-01-01', '1900-01-01', '08:51:41.001482', '08:51:41.001482', '2002-01-07 21:23:06.047700', '2002-01-07 21:23:06.047700', 'm', 'm'),(8, 6, '2007-12-11', '2007-12-11', '22:40:20.000951', '22:40:20.000951', '2008-11-12 05:56:02.042994', '2008-11-12 05:56:02.042994', 't', 't'),(5, 7, '2002-02-05', '2002-02-05', '13:00:50.057511', '13:00:50.057511', '2004-08-27 08:22:13.010392', '2004-08-27 08:22:13.010392', 'i', 'i'),(4, 4, '2003-08-23', '2003-08-23', NULL, NULL, '2004-02-27 00:00:00', '2004-02-27 00:00:00', 'h', 'h'),(207, 38, NULL, NULL, '12:54:06.045953', '12:54:06.045953', '2005-09-27 12:06:03.048560', '2005-09-27 12:06:03.048560', 'd', 'd'),(183, 206, '2009-07-25', '2009-07-25', '22:47:40.000268', '22:47:40.000268', '2003-07-13 16:52:43.054178', '2003-07-13 16:52:43.054178', 'b', 'b'),(7, NULL, '2005-05-25', '2005-05-25', '03:01:56.013760', '03:01:56.013760', '2002-10-13 00:00:00', '2002-10-13 00:00:00', 'o', 'o'),(1, 2, '2008-03-16', '2008-03-16', '12:35:21.015952', '12:35:21.015952', '2004-12-02 00:57:31.056351', '2004-12-02 00:57:31.056351', 'j', 'j'),(17, 36, '2003-12-19', '2003-12-19', '00:00:00', '00:00:00', '2002-03-12 09:48:05.033853', '2002-03-12 09:48:05.033853', 's', 's'),(4, 5, '2005-10-23', '2005-10-23', '20:46:34.003982', '20:46:34.003982', '2007-06-07 08:16:24.030171', '2007-06-07 08:16:24.030171', 'q', 'q'),(0, 6, '2008-03-04', '2008-03-04', '10:48:51.018074', '10:48:51.018074', '2006-08-20 11:54:04.031499', '2006-08-20 11:54:04.031499', 'l', 'l'),(1, 9, NULL, NULL, '07:06:12.019155', '07:06:12.019155', '2007-05-22 00:00:00', '2007-05-22 00:00:00', 'j', 'j'),(5, 6, '2004-05-19', '2004-05-19', '08:11:01.049319', '08:11:01.049319', '2009-02-28 11:00:47.051802', '2009-02-28 11:00:47.051802', 'y', 'y'),(NULL, 0, '2009-01-21', '2009-01-21', NULL, NULL, NULL, NULL, 'i', 'i'),(7, 7, '2004-07-16', '2004-07-16', '00:00:00', '00:00:00', '2006-04-09 11:38:17.004697', '2006-04-09 11:38:17.004697', 'x', 'x'),(5, 2, '1900-01-01', '1900-01-01', '09:05:46.049259', '09:05:46.049259', '2005-10-08 08:08:42.010058', '2005-10-08 08:08:42.010058', 'u', 'u'),(160, 146, NULL, NULL, '10:49:42.003572', '10:49:42.003572', '2003-03-15 00:00:00', '2003-03-15 00:00:00', 't', 't'),(215, 43, '2009-03-28', '2009-03-28', '20:48:06.021170', '20:48:06.021170', '2007-08-11 15:19:38.006113', '2007-08-11 15:19:38.006113', NULL, NULL),(7, 5, '2009-11-12', '2009-11-12', '16:39:08.052868', '16:39:08.052868', '2002-06-20 09:48:09.057405', '2002-06-20 09:48:09.057405', 'm', 'm'),(1, 4, '2003-12-03', '2003-12-03', '18:51:52.020034', '18:51:52.020034', NULL, NULL, 'x', 'x'),(8, 8, '1900-01-01', '1900-01-01', '13:52:22.063256', '13:52:22.063256', '2005-06-28 02:54:54.033897', '2005-06-28 02:54:54.033897', 'x', 'x'),(4, 6, '2005-09-20', '2005-09-20', '21:48:36.057283', '21:48:36.057283', '2002-08-17 00:57:41.045824', '2002-08-17 00:57:41.045824', 'v', 'v'),(1, 8, '2004-07-10', '2004-07-10', '10:59:28.034806', '10:59:28.034806', '2003-12-05 13:07:15.052162', '2003-12-05 13:07:15.052162', 'm', 'm'),(2, 4, NULL, NULL, NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'j', 'j'),(7, 8, '2009-08-17', '2009-08-17', '15:05:06.062377', '15:05:06.062377', '2001-02-03 05:31:15.058452', '2001-02-03 05:31:15.058452', 'z', 'z'),(2, 2, '2001-11-03', '2001-11-03', '15:42:01.052867', '15:42:01.052867', '2006-03-10 17:29:05.006607', '2006-03-10 17:29:05.006607', 'a', 'a'),(0, 9, '2009-06-11', '2009-06-11', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'i', 'i'),(2, 4, '2002-09-27', '2002-09-27', '21:27:57.033453', '21:27:57.033453', '2007-01-12 11:18:49.002045', '2007-01-12 11:18:49.002045', 'g', 'g'),(4, 8, '2000-05-13', '2000-05-13', '00:00:00', '00:00:00', '2004-11-17 00:00:00', '2004-11-17 00:00:00', 'h', 'h'),(NULL, 1, '1900-01-01', '1900-01-01', '06:21:08.052509', '06:21:08.052509', '2001-11-05 15:19:40.050500', '2001-11-05 15:19:40.050500', 'p', 'p'),(6, 8, '2002-03-02', '2002-03-02', '10:17:54.019864', '10:17:54.019864', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'a', 'a'),(4, 0, '2000-06-14', '2000-06-14', '17:57:58.002639', '17:57:58.002639', NULL, NULL, 'x', 'x'),(3, 2, '2007-08-08', '2007-08-08', '06:58:38.000194', '06:58:38.000194', '2002-10-22 17:24:41.065056', '2002-10-22 17:24:41.065056', 's', 's'),(9, 6, '2008-10-02', '2008-10-02', '04:02:57.011013', '04:02:57.011013', '2002-02-11 22:03:47.002844', '2002-02-11 22:03:47.002844', 'k', 'k'),(7, 0, '2007-07-02', '2007-07-02', NULL, NULL, '2001-02-26 10:28:06.024465', '2001-02-26 10:28:06.024465', 'm', 'm'),(3, 6, '2003-01-25', '2003-01-25', NULL, NULL, '2000-08-07 15:19:01.063043', '2000-08-07 15:19:01.063043', NULL, NULL),(9, NULL, '2006-03-21', '2006-03-21', '18:27:23.060158', '18:27:23.060158', '2002-12-04 06:10:53.027755', '2002-12-04 06:10:53.027755', 'y', 'y'),(8, 7, '2003-04-15', '2003-04-15', '06:40:58.037841', '06:40:58.037841', '2008-08-03 00:00:00', '2008-08-03 00:00:00', 'd', 'd'),(4, 7, '2001-04-22', '2001-04-22', '16:21:50.042962', '16:21:50.042962', NULL, NULL, 'w', 'w'),(4, NULL, NULL, NULL, '00:00:00', '00:00:00', NULL, NULL, 'y', 'y'),(9, 9, '2005-08-20', '2005-08-20', '01:36:47.020532', '01:36:47.020532', '2007-01-05 14:23:21.063280', '2007-01-05 14:23:21.063280', 's', 's'),(8, 9, '2002-11-23', '2002-11-23', '00:00:00', '00:00:00', '2004-01-02 22:56:27.051360', '2004-01-02 22:56:27.051360', 'x', 'x'),(2, 6, '1900-01-01', '1900-01-01', '04:52:42.061600', '04:52:42.061600', '2001-12-13 19:09:03.035577', '2001-12-13 19:09:03.035577', 'l', 'l'),(8, 9, '1900-01-01', '1900-01-01', '10:52:49.017566', '10:52:49.017566', '2004-08-13 00:00:00', '2004-08-13 00:00:00', 'f', 'f'),(0, 8, '2005-11-23', '2005-11-23', '11:28:42.039525', '11:28:42.039525', '2001-09-22 08:32:34.025439', '2001-09-22 08:32:34.025439', 'x', 'x'),(1, 1, '2006-03-20', '2006-03-20', '19:34:47.010488', '19:34:47.010488', NULL, NULL, 'p', 'p'),(5, 7, '2003-05-11', '2003-05-11', '22:21:46.031300', '22:21:46.031300', '2002-08-06 08:47:23.055878', '2002-08-06 08:47:23.055878', 'y', 'y'),(4, 6, NULL, NULL, '00:00:00', '00:00:00', '2002-01-21 07:22:54.064410', '2002-01-21 07:22:54.064410', 'p', 'p'),(1, 1, '2002-08-17', '2002-08-17', '22:29:16.064947', '22:29:16.064947', '2000-09-08 00:00:00', '2000-09-08 00:00:00', 'g', 'g'),(0, 3, '2001-06-15', '2001-06-15', '22:49:28.048532', '22:49:28.048532', '2001-11-27 14:59:24.028725', '2001-11-27 14:59:24.028725', 'c', 'c'),(NULL, 5, '1900-01-01', '1900-01-01', '21:49:00.032147', '21:49:00.032147', '2001-04-19 09:35:37.027780', '2001-04-19 09:35:37.027780', 'h', 'h'),(7, 3, '2003-11-19', '2003-11-19', '18:30:23.004396', '18:30:23.004396', '2003-12-17 11:53:23.019811', '2003-12-17 11:53:23.019811', 'p', 'p'),(3, 2, '2004-04-23', '2004-04-23', '20:10:01.023785', '20:10:01.023785', NULL, NULL, 'b', 'b'),(9, NULL, NULL, NULL, '13:05:12.047909', '13:05:12.047909', '2008-09-06 14:21:25.041589', '2008-09-06 14:21:25.041589', NULL, NULL),(225, 121, '2002-03-02', '2002-03-02', NULL, NULL, NULL, NULL, NULL, NULL),(2, NULL, '1900-01-01', '1900-01-01', '11:58:30.020245', '11:58:30.020245', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'y', 'y'),(8, 7, '2009-09-12', '2009-09-12', '07:31:37.045737', '07:31:37.045737', '2005-08-02 00:50:41.045017', '2005-08-02 00:50:41.045017', 's', 's'),(9, 7, '2006-07-17', '2006-07-17', '10:52:59.018506', '10:52:59.018506', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'x', 'x'),(2, 6, '2000-07-07', '2000-07-07', '08:54:56.062434', '08:54:56.062434', NULL, NULL, 'i', 'i'),(4, 9, '2007-02-04', '2007-02-04', NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 't', 't'),(4, 5, NULL, NULL, '06:15:12.059342', '06:15:12.059342', '2003-11-05 09:01:58.046682', '2003-11-05 09:01:58.046682', 'j', 'j'),(6, 0, NULL, NULL, NULL, NULL, '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'u', 'u'),(7, 7, '2005-02-01', '2005-02-01', '08:12:54.047455', '08:12:54.047455', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'r', 'r'),(2, 2, '2003-10-16', '2003-10-16', '00:00:00', '00:00:00', '2003-01-08 06:50:59.023013', '2003-01-08 06:50:59.023013', 'x', 'x'),(2, 8, '2009-09-09', '2009-09-09', '16:21:16.061650', '16:21:16.061650', NULL, NULL, 'e', 'e'),(9, 8, '1900-01-01', '1900-01-01', '22:29:31.058874', '22:29:31.058874', '2003-07-01 19:38:23.047425', '2003-07-01 19:38:23.047425', 'i', 'i'),(198, NULL, '2000-08-08', '2000-08-08', '00:49:30.064187', '00:49:30.064187', NULL, NULL, 'q', 'q'),(9, 8, '2006-05-09', '2006-05-09', '20:22:47.037406', '20:22:47.037406', '2003-04-07 03:25:51.058231', '2003-04-07 03:25:51.058231', 'z', 'z'),(7, 3, '1900-01-01', '1900-01-01', '08:48:30.044928', '08:48:30.044928', '1900-01-01 00:00:00', '1900-01-01 00:00:00', 'k', 'k'),(99, 65, NULL, NULL, '00:00:00', '00:00:00', '1900-01-01 00:00:00', '1900-01-01 00:00:00', NULL, NULL);
DROP TABLE IF EXISTS  dummy;
CREATE TABLE dummy (i INTEGER);
INSERT INTO dummy VALUES(0);
ANALYZE TABLE a,b,c,d,e,bb,cc,dd,dummy;

create view view_a as select * from a;
create view view_b as select * from b;
create view view_c as select * from c;
create view view_d as select * from d;
create view view_aa as select * from aa;
create view view_bb as select * from bb;
create view view_cc as select * from cc;

# Lots of bad queries:
--source include/turn_off_only_full_group_by.inc

let $query=SELECT DISTINCT   alias2.col_time_key AS field1 , alias2.col_varchar_key AS field2 , alias2.col_varchar_key AS field3 , alias2.col_int_nokey AS field4 FROM ( c AS alias1 , ( view_a AS alias2 , c AS alias3 ) )   GROUP BY field1, field2, field3, field4 HAVING (field1 < 'w' OR field1 != 'ni') ORDER BY field3 ;

--source include/explain_for_connection.inc 

let $query=SELECT    alias1.col_int_key AS field1 , alias1.col_int_key AS field2 FROM ( ( SELECT   sq1_alias1.* FROM c AS sq1_alias1  ) AS alias1 RIGHT OUTER JOIN ( SELECT   sq2_alias1.* FROM ( bb AS sq2_alias1 STRAIGHT_JOIN c AS sq2_alias2 ON (sq2_alias2.pk = sq2_alias1.pk  ) )  ) AS alias2 ON (alias2.pk = alias1.col_int_key  ) ) WHERE  NOT EXISTS ( (SELECT   sq3_alias1.pk AS sq3_field1 FROM ( bb AS sq3_alias1 LEFT OUTER JOIN ( cc AS sq3_alias2 STRAIGHT_JOIN bb AS sq3_alias3 ON (sq3_alias3.pk = sq3_alias2.pk  ) ) ON (sq3_alias3.col_int_key = sq3_alias2.col_int_key  AND sq3_alias1.col_int_key > (SELECT   COUNT( DISTINCT c_sq1_alias1.col_int_nokey ) AS c_sq1_field1 FROM d AS c_sq1_alias1 WHERE c_sq1_alias1.col_int_nokey != c_sq1_alias1.pk ) ) )    ) )  GROUP BY field1, field2  ORDER BY alias1.col_date_key DESC , field1, field2 ;

--source include/explain_for_connection.inc

let $query=SELECT DISTINCT  SQL_SMALL_RESULT table2.col_date_key AS field1 FROM ( cc AS table1 INNER JOIN ( ( c AS table2 INNER JOIN bb AS table3 ON (table3.col_varchar_key = table2.col_varchar_key  ) ) ) ON (table3.col_varchar_key = table2.col_varchar_key  ) ) WHERE (   EXISTS ( (SELECT  SQL_SMALL_RESULT subquery1_t2.col_varchar_nokey AS subquery1_field1 FROM ( bb AS subquery1_t1 INNER JOIN cc AS subquery1_t2 ON (subquery1_t2.col_varchar_key = subquery1_t1.col_varchar_nokey  ) )   ) ) ) OR ( table1.col_varchar_key = 'q' AND table1.col_int_key = table2.col_int_key ) OR (  table2.col_varchar_key  IN (SELECT 'a' FROM dummy UNION SELECT 'p' FROM dummy ) OR table1.col_varchar_key IS  NULL ) ;

--source include/explain_for_connection.inc

let $query=SELECT    table2.col_time_key AS field1 FROM ( ( SELECT   subquery1_t1.* FROM ( c AS subquery1_t1 STRAIGHT_JOIN c AS subquery1_t2 ON (subquery1_t2.col_int_key = subquery1_t1.col_int_key  ) ) WHERE subquery1_t1.pk <= 7 ) AS table1 LEFT OUTER JOIN ( ( ( SELECT   subquery2_t1.* FROM b AS subquery2_t1 WHERE subquery2_t1.col_varchar_nokey <= 'l' ) AS table2 LEFT OUTER JOIN c AS table3 ON (table3.col_varchar_key = table2.col_varchar_key  ) ) ) ON (table3.pk = table2.pk  ) ) WHERE (   EXISTS ( (SELECT   subquery3_t1.col_varchar_nokey AS subquery3_field1 FROM ( bb AS subquery3_t1 LEFT  JOIN c AS subquery3_t2 ON (subquery3_t2.col_varchar_key = subquery3_t1.col_varchar_key  ) )   ) ) ) OR table1.col_int_key = 62 AND ( table1.col_int_key = table1.pk AND table2.col_varchar_nokey = table1.col_varchar_nokey ) ORDER BY table1.col_varchar_key DESC /*+JavaDB:Postgres: NULLS LAST */ , CONCAT( table3.col_varchar_key, table1.col_varchar_nokey ) /*+JavaDB:Postgres: NULLS FIRST*/ , table1.col_date_key /*+JavaDB:Postgres: NULLS FIRST*/ , table3 .pk DESC /*+JavaDB:Postgres: NULLS LAST */;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_datetime_key AS field1 FROM ( view_cc AS alias1 , bb AS alias2 , cc AS alias3 ) WHERE  alias2.pk < ALL (SELECT   sq1_alias2.pk AS sq1_field1 FROM ( c AS sq1_alias1 , cc AS sq1_alias2 ) WHERE  sq1_alias1.col_varchar_nokey != (SELECT   COUNT(  c_sq1_alias1.col_varchar_key ) AS c_sq1_field1 FROM ( cc AS c_sq1_alias1 RIGHT OUTER JOIN ( ( cc AS c_sq1_alias2 INNER JOIN b AS c_sq1_alias3 ON (c_sq1_alias3.col_varchar_nokey = c_sq1_alias2.col_varchar_key ) ) ) ON (c_sq1_alias3.pk = c_sq1_alias2.pk ) ) WHERE c_sq1_alias1.col_varchar_key < 'm' )   )  GROUP BY field1 HAVING ((field1 <= 'USA' OR field1 < 2) AND field1 <> 'd') ORDER BY alias1.col_time_key DESC , field1 LIMIT 10 OFFSET 208;
--source include/explain_for_connection.inc
 let $query=SELECT DISTINCT   SUM( DISTINCT alias1.col_int_nokey ) AS field1 , MAX( DISTINCT alias2.col_varchar_key ) AS field2 FROM ( c AS alias1 , c AS alias2 , cc AS alias3 ) WHERE  alias2.col_int_key > (SELECT   COUNT(  sq1_alias1.col_int_key ) AS sq1_field1 FROM ( cc AS sq1_alias1 INNER JOIN view_c AS sq1_alias2 ON (sq1_alias2.col_varchar_key = sq1_alias1.col_varchar_nokey  ) ) WHERE sq1_alias2.col_varchar_nokey < sq1_alias1.col_varchar_key )  HAVING (field1 > 'zc' AND field2 >= 'q') ORDER BY alias1.col_time_key ASC , field1, field2 LIMIT 2 /*  */;
--source include/explain_for_connection.inc
 let $query=SELECT    alias2.col_datetime_key AS field1 , alias1.col_varchar_key AS field2 , alias1.col_varchar_nokey AS field3 , alias2.col_varchar_key AS field4 , alias2.pk AS field5 , alias2.col_date_key AS field6 , alias1.col_date_key AS field7 , alias1.col_int_key AS field8 FROM ( cc AS alias1 LEFT  JOIN ( ( ( SELECT   sq1_alias1.* FROM c AS sq1_alias1  ) AS alias2 INNER JOIN ( SELECT   sq2_alias1.* FROM ( b AS sq2_alias1 , view_aa AS sq2_alias2 )  ) AS alias3 ON (alias3.col_varchar_nokey = alias2.col_varchar_key  ) ) ) ON (alias3.col_int_key = alias2.col_int_key  ) ) WHERE (   EXISTS ( (SELECT   sq3_alias1.col_varchar_nokey AS sq3_field1 FROM ( c AS sq3_alias1 , bb AS sq3_alias2 )   ) ) ) OR ( alias1.col_int_key NOT IN (55, 229) OR alias1.col_int_key > 28 AND alias1.col_int_key < ( 28 + 73 ) ) AND alias1.col_int_key != alias2.pk  HAVING field8 = 'v' ORDER BY field3 , field1, field2, field3, field4, field5, field6, field7, field8 ;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_datetime_key AS field1 , alias2.col_date_key AS field2 FROM ( c AS alias1 LEFT OUTER JOIN ( ( ( SELECT DISTINCT  sq1_alias1.* FROM bb AS sq1_alias1  ) AS alias2 INNER JOIN c AS alias3 ON (alias3.col_int_key = alias2.col_int_key  ) ) ) ON (alias3.pk = alias2.col_int_key  ) ) WHERE (   EXISTS ( (SELECT 9 FROM DUAL ) ) ) OR alias1.col_varchar_key LIKE CONCAT( 'b' , '%')  GROUP BY field1, field2 HAVING field2 != 6 ;
--source include/explain_for_connection.inc
let $query=SELECT  STRAIGHT_JOIN  table1.pk AS field1 , table2.col_int_key AS field2 , table1.col_int_nokey AS field3 , table2.col_varchar_key AS field4 FROM ( ( SELECT   subquery1_t1.* FROM cc AS subquery1_t1 WHERE ( subquery1_t1.col_int_nokey = subquery1_t1.col_int_nokey AND   EXISTS ( (SELECT   child_subquery1_t2.pk AS child_subquery1_field1 FROM ( c AS child_subquery1_t1 RIGHT  JOIN c AS child_subquery1_t2 ON (child_subquery1_t2.col_int_key = child_subquery1_t1.col_int_key ) ) WHERE child_subquery1_t2.col_int_key != 7   ) ) ) ) AS table1 INNER JOIN cc AS table2 ON (table2.col_varchar_nokey = table1.col_varchar_key  ) ) WHERE (  table1.col_varchar_nokey >= ALL (SELECT  SQL_SMALL_RESULT subquery2_t1.col_varchar_key AS subquery2_field1 FROM ( c AS subquery2_t1 INNER JOIN cc AS subquery2_t2 ON (subquery2_t2.pk = subquery2_t1.col_int_nokey  ) )   ) ) OR table1.pk = 98 AND table2.col_varchar_key != 'q' ORDER BY CONCAT( table1.col_varchar_nokey, table1.col_varchar_nokey ) /*+JavaDB:Postgres: NULLS FIRST*/;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_int_key AS field1 , alias2.col_datetime_key AS field2 , alias1.col_varchar_nokey AS field3 , alias1.col_int_nokey AS field4 , alias1.col_int_key AS field5 FROM ( b AS alias1 , view_d AS alias2 ) WHERE  alias1.col_varchar_nokey >= ANY (SELECT  SQL_SMALL_RESULT sq1_alias1.col_varchar_key AS sq1_field1 FROM ( c AS sq1_alias1 INNER JOIN c AS sq1_alias2 ON (sq1_alias2.col_int_key = sq1_alias1.pk  ) )   )  GROUP BY field1, field2, field3, field4, field5  ORDER BY alias1.col_date_key ASC , field1, field2, field3, field4, field5 ;
--source include/explain_for_connection.inc
 let $query=SELECT    CONCAT ( alias1.col_varchar_key , alias1.col_varchar_nokey ) AS field1 FROM ( cc AS alias1 , c AS alias2 , cc AS alias3 ) WHERE (   EXISTS ( (SELECT   sq1_alias1.col_varchar_nokey AS sq1_field1 FROM ( c AS sq1_alias1 , cc AS sq1_alias2 )   ) ) ) AND alias1.col_varchar_key <= 'p' AND alias3.col_varchar_key > alias2.col_varchar_nokey  GROUP BY field1   /*  */;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_int_key AS field1 , alias1.col_date_key AS field2 , alias1.col_varchar_key AS field3 FROM ( c AS alias1 , d AS alias2 , cc AS alias3 ) WHERE (   EXISTS ( (SELECT   sq1_alias1.col_varchar_key AS sq1_field1 FROM ( d AS sq1_alias1 LEFT  JOIN d AS sq1_alias2 ON (sq1_alias2.col_varchar_key = sq1_alias1.col_varchar_key  ) )   ) ) ) AND alias1.col_int_key = alias1.col_int_key AND alias1.col_int_key < alias3.col_int_key  GROUP BY field1, field2, field3 HAVING field2 >= 'a' ;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_datetime_key AS field1 , alias2.col_int_key AS field2 FROM ( c AS alias1 , d AS alias2 , cc AS alias3 ) WHERE (   EXISTS ( (SELECT   sq1_alias1.col_int_key AS sq1_field1 FROM bb AS sq1_alias1 WHERE sq1_alias1.pk < 8   ) ) ) OR alias1.col_int_key > alias3.col_int_key   ORDER BY alias1.col_int_key ASC , field1, field2 LIMIT 2 /*  */;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_int_key AS field1 , alias1.col_int_key AS field2 FROM ( ( SELECT   sq1_alias1.* FROM d AS sq1_alias1  ) AS alias1 , d AS alias2 ) WHERE (  (SELECT   MIN(  sq2_alias1.pk ) AS sq2_field1 FROM ( view_c AS sq2_alias1 RIGHT  JOIN c AS sq2_alias2 ON (sq2_alias2.col_varchar_nokey = sq2_alias1.col_varchar_key  ) )  ) IS NOT NULL ) AND ( alias2.col_varchar_key <= 'z' OR   EXISTS ( (SELECT   sq3_alias1.col_int_nokey AS sq3_field1 FROM a AS sq3_alias1    ) ) )  GROUP BY field1, field2 HAVING field2 < 4 ORDER BY alias1.col_int_key ASC , field1, field2 ;
--source include/explain_for_connection.inc
 let $query=SELECT  STRAIGHT_JOIN  alias1.col_int_key AS field1 FROM ( b AS alias1 , ( SELECT   sq1_alias1.* FROM ( cc AS sq1_alias1 INNER JOIN ( c AS sq1_alias2 INNER JOIN c AS sq1_alias3 ON (sq1_alias3.pk = sq1_alias2.pk  ) ) ON (sq1_alias3.col_varchar_key = sq1_alias2.col_varchar_key  ) ) WHERE  sq1_alias2.col_int_key >= ANY (SELECT   c_sq1_alias1.col_int_key AS c_sq1_field1 FROM c AS c_sq1_alias1  GROUP BY c_sq1_field1  ) ) AS alias2 ) WHERE   EXISTS ( (SELECT   sq2_alias1.col_varchar_key AS sq2_field1 FROM c AS sq2_alias1 WHERE sq2_alias1.col_varchar_nokey < 'p' GROUP BY sq2_field1 ) )  GROUP BY field1 HAVING field1 <> 'o' ORDER BY field1  , alias1.col_time_key , alias2 .pk DESC, field1 ;
--source include/explain_for_connection.inc
let $query=SELECT    CONCAT( table1.col_varchar_nokey , table1.col_varchar_nokey ) AS field1 FROM ( ( SELECT   subquery1_t1.* FROM bb AS subquery1_t1 WHERE ( subquery1_t1.col_varchar_key != 'y' OR subquery1_t1.col_varchar_key <= 'd' ) ) AS table1 RIGHT OUTER JOIN ( ( c AS table2 STRAIGHT_JOIN bb AS table3 ON (table3.pk = table2.pk  OR table2.col_varchar_key  IN (SELECT   subquery2_t2.col_varchar_key AS subquery2_field1 FROM ( c AS subquery2_t1 RIGHT OUTER JOIN c AS subquery2_t2 ON (subquery2_t2.col_int_nokey = subquery2_t1.col_int_key  ) ) WHERE  subquery2_t1.col_int_key >= (SELECT   SUM(  child_subquery1_t1.col_int_key ) AS child_subquery1_field1 FROM cc AS child_subquery1_t1 WHERE ( child_subquery1_t1.pk > child_subquery1_t1.pk OR child_subquery1_t1.col_int_nokey > 6 ) )  ) ) ) ) ON (table3.col_varchar_nokey = table2.col_varchar_key  ) ) WHERE (   EXISTS ( (SELECT   subquery3_t1.pk AS subquery3_field1 FROM ( bb AS subquery3_t1 INNER JOIN ( cc AS subquery3_t2 INNER JOIN c AS subquery3_t3 ON (subquery3_t3.col_varchar_key = subquery3_t2.col_varchar_key  ) ) ON (subquery3_t3.pk = subquery3_t2.col_int_nokey  ) )    ) ) ) AND ( table1.col_varchar_key < 'b' OR table1.col_int_key  BETWEEN 253 AND ( 253 + 77 ) ) OR ( table2.col_varchar_nokey != 't' OR table2.col_varchar_nokey = table1.col_varchar_nokey ) ;
--source include/explain_for_connection.inc
let $query=SELECT DISTINCT col_int_nokey AS field1 , col_int_nokey AS field2 FROM a AS alias1 WHERE ( ( alias1.pk > 54 AND alias1.pk < ( 54 + 151 ) OR ( alias1.col_int_key  IN (240) OR ( alias1.pk > 54 AND alias1.pk < ( 54 + 16 ) OR ( alias1.col_int_key  BETWEEN 54 AND ( 54 + 125 ) OR alias1.pk > 54 AND alias1.pk < ( 54 + 147 ) ) ) ) ) OR alias1 .pk >= alias1.pk )  GROUP BY field1, field2;
--source include/explain_for_connection.inc
 let $query=SELECT    MAX(  alias2.pk ) AS field1 , SUM( DISTINCT alias1.col_varchar_key ) AS field2 ,  (SELECT   MAX( DISTINCT sq1_alias1.col_varchar_nokey ) AS sq1_field1 FROM a AS sq1_alias1  ) AS field3 FROM ( c AS alias1 , ( SELECT   sq2_alias2.* FROM ( d AS sq2_alias1 LEFT OUTER JOIN c AS sq2_alias2 ON (sq2_alias2.col_int_key = sq2_alias1.col_int_nokey  ) ) WHERE ( sq2_alias1.col_varchar_nokey = 'o' OR sq2_alias1.col_varchar_key <= 'd' ) ) AS alias2 , cc AS alias3 ) WHERE   EXISTS ( (SELECT DISTINCT  sq3_alias1.col_varchar_nokey AS sq3_field1 FROM ( b AS sq3_alias1 RIGHT  JOIN bb AS sq3_alias2 ON (sq3_alias2.col_varchar_nokey = sq3_alias1.col_varchar_key  ) )   ) )  GROUP BY field3  ORDER BY alias1.col_datetime_key , alias2 .pk  , alias1.col_date_key , alias1 .pk ASC;
--source include/explain_for_connection.inc
let $query=SELECT  col_int_nokey AS field1 FROM a AS table1 WHERE table1 .pk = table1.pk;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_time_key AS field1 , alias1.col_datetime_key AS field2 , alias1.col_int_key AS field3 FROM ( bb AS alias1 , ( SELECT   sq1_alias1.* FROM ( cc AS sq1_alias1 INNER JOIN cc AS sq1_alias2 ON (sq1_alias2.col_varchar_key = sq1_alias1.col_varchar_nokey  ) )  ) AS alias2 , ( SELECT   sq2_alias1.* FROM b AS sq2_alias1  ) AS alias3 ) WHERE  alias1.col_varchar_nokey <= ANY (SELECT   sq3_alias1.col_varchar_nokey AS sq3_field1 FROM ( c AS sq3_alias1 INNER JOIN ( c AS sq3_alias2 INNER JOIN c AS sq3_alias3 ON (sq3_alias3.pk = sq3_alias2.col_int_key  ) ) ON (sq3_alias3.col_varchar_nokey = sq3_alias2.col_varchar_key  ) )   )   ;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_varchar_nokey AS field1 , alias1.col_varchar_key AS field2 , alias1.col_varchar_key AS field3 FROM ( b AS alias1 , c AS alias2 , b AS alias3 ) WHERE (  alias1.col_varchar_nokey >= ALL (SELECT DISTINCT  sq1_alias1.col_varchar_key AS sq1_field1 FROM ( view_a AS sq1_alias1 LEFT OUTER JOIN c AS sq1_alias2 ON (sq1_alias2.col_varchar_key = sq1_alias1.col_varchar_nokey  ) )   ) ) AND alias1.col_int_key NOT BETWEEN 20 AND ( 20 + 10 ) AND (   EXISTS (SELECT DISTINCT  sq2_alias1.col_int_key AS sq2_field1 FROM ( cc AS sq2_alias1 INNER JOIN b AS sq2_alias2 ON (sq2_alias2.col_int_nokey = sq2_alias1.col_int_key  ) ) WHERE sq2_alias1.col_varchar_nokey != alias3.col_varchar_nokey AND sq2_alias1.col_varchar_nokey <= 'g' ) AND alias1.col_varchar_nokey != 'z' )  HAVING field1 <= 3 ORDER BY CONCAT( alias1.col_varchar_key, alias2.col_varchar_key ), field1, field2, field3 LIMIT 1;
--source include/explain_for_connection.inc
 let $query=SELECT   SQL_SMALL_RESULT  (SELECT   COUNT(  sq1_alias1.col_varchar_nokey ) AS sq1_field1 FROM ( cc AS sq1_alias1 , c AS sq1_alias2 )  ) AS field1 FROM ( c AS alias1 LEFT  JOIN ( ( ( SELECT   sq2_alias1.* FROM bb AS sq2_alias1  ) AS alias2 INNER JOIN ( SELECT   sq3_alias2.* FROM ( bb AS sq3_alias1 , a AS sq3_alias2 ) WHERE sq3_alias1.col_varchar_nokey != sq3_alias2.col_varchar_key ) AS alias3 ON (alias3.pk = alias2.pk  ) ) ) ON (alias3.col_varchar_key = alias2.col_varchar_key  ) ) WHERE  alias3.col_varchar_key > ALL (SELECT   sq4_alias2.col_varchar_nokey AS sq4_field1 FROM ( d AS sq4_alias1 STRAIGHT_JOIN cc AS sq4_alias2 ON (sq4_alias2.pk = sq4_alias1.col_int_key  ) )   )  GROUP BY field1 HAVING field1 = 'u' ORDER BY alias1.col_varchar_key , alias3 .pk DESC , alias1.col_varchar_key , alias1 .pk ;
--source include/explain_for_connection.inc
let $query=SELECT    CONCAT( table1.col_varchar_nokey , table1.col_varchar_key ) AS field1 , table1.col_varchar_key AS field2 , CONCAT( table1.col_varchar_nokey , table1.col_varchar_key ) AS field3 FROM ( cc AS table1 STRAIGHT_JOIN ( ( ( SELECT   subquery1_t2.* FROM ( c AS subquery1_t1 LEFT  JOIN ( c AS subquery1_t2 LEFT OUTER JOIN cc AS subquery1_t3 ON (subquery1_t3.col_int_key = subquery1_t2.pk  ) ) ON (subquery1_t3.col_int_key = subquery1_t2.col_int_key  ) )  ) AS table2 LEFT OUTER JOIN bb AS table3 ON (table3.col_varchar_key = table2.col_varchar_nokey  ) ) ) ON (table3.col_varchar_nokey = table2.col_varchar_key  ) ) WHERE (  table3.col_varchar_key <= (SELECT 'r' FROM dummy ) ) AND ( table1.pk <= table2.col_int_key AND table1.pk > table3.col_int_key ) ;
--source include/explain_for_connection.inc
let $query=SELECT    CONCAT( table2.col_varchar_key , table1.col_varchar_key ) AS field1 , table2.pk AS field2 , table1.pk AS field3 FROM ( cc AS table1 STRAIGHT_JOIN ( ( ( SELECT  SQL_SMALL_RESULT subquery1_t2.* FROM ( cc AS subquery1_t1 RIGHT OUTER JOIN bb AS subquery1_t2 ON (subquery1_t2.col_int_nokey = subquery1_t1.pk  ) )  ) AS table2 INNER JOIN cc AS table3 ON (table3.pk = table2.pk  ) ) ) ON (table3.col_int_key = table2.col_int_nokey  ) ) WHERE (   EXISTS (SELECT   subquery2_t1.col_int_nokey AS subquery2_field1 FROM ( c AS subquery2_t1 INNER JOIN ( c AS subquery2_t2 STRAIGHT_JOIN b AS subquery2_t3 ON (subquery2_t3.col_int_key = subquery2_t2.pk  AND subquery2_t2.col_int_key NOT IN (SELECT   child_subquery1_t1.col_int_nokey AS child_subquery1_field1 FROM ( cc AS child_subquery1_t1 LEFT  JOIN c AS child_subquery1_t2 ON (child_subquery1_t2.col_int_nokey = child_subquery1_t1.col_int_key ) )    ) ) ) ON (subquery2_t3.col_varchar_key = subquery2_t2.col_varchar_key  ) ) WHERE subquery2_t3.col_varchar_nokey <= table2.col_varchar_nokey AND subquery2_t3.pk <= table2.pk ) ) OR ( table3.col_varchar_nokey <= 'c' AND table2.col_varchar_key != table2.col_varchar_nokey ) ORDER BY table1.col_varchar_key /*+JavaDB:Postgres: NULLS FIRST*/ , table1 .pk DESC /*+JavaDB:Postgres: NULLS LAST */, field1 /*+JavaDB:Postgres: NULLS FIRST */, field2 /*+JavaDB:Postgres: NULLS FIRST */, field3 /*+JavaDB:Postgres: NULLS FIRST */ ;
--source include/explain_for_connection.inc
let $query=SELECT     (SELECT   MAX( DISTINCT sq1_alias1.col_int_key ) AS sq1_field1 FROM ( cc AS sq1_alias1 , bb AS sq1_alias2 ) WHERE sq1_alias2.pk <> alias1.pk AND sq1_alias2.pk <= alias1.col_int_key ) AS field1 , COUNT(  alias1.col_varchar_key ) AS field2 FROM ( bb AS alias1 LEFT OUTER JOIN ( ( cc AS alias2 INNER JOIN cc AS alias3 ON (alias3.col_int_key = alias2.col_int_key  ) ) ) ON (alias3.col_varchar_nokey = alias2.col_varchar_key  ) ) WHERE (   EXISTS ( (SELECT   sq2_alias1.col_varchar_nokey AS sq2_field1 FROM c AS sq2_alias1 WHERE  ( sq2_alias1.col_varchar_nokey , sq2_alias1.col_varchar_nokey )  IN (SELECT   c_sq1_alias1.col_varchar_key AS c_sq1_field1 , MAX(  c_sq1_alias1.col_varchar_nokey ) AS c_sq1_field2 FROM cc AS c_sq1_alias1    ) GROUP BY sq2_field1 ) ) ) OR ( alias1.col_int_key > 51 AND alias1.col_int_key < ( 51 + 209 ) OR alias1.col_int_key > 51 AND alias1.col_int_key < ( 51 + 159 ) ) OR  (SELECT  SQL_SMALL_RESULT MIN(  sq3_alias1.pk ) AS sq3_field1 FROM ( c AS sq3_alias1 RIGHT OUTER JOIN c AS sq3_alias2 ON (sq3_alias2.col_int_key = sq3_alias1.pk  ) )  ) IS NOT NULL  GROUP BY field1 HAVING field2 <> 5 ORDER BY alias1.col_time_key ASC , field2  , CONCAT( alias2.col_varchar_key, alias3.col_varchar_key );
--source include/explain_for_connection.inc
let $query=SELECT     (SELECT 5 FROM dummy ) AS field1 FROM ( b AS table1 INNER JOIN ( ( ( SELECT   subquery2_t1.* FROM ( cc AS subquery2_t1 INNER JOIN cc AS subquery2_t2 ON (subquery2_t2.col_varchar_key = subquery2_t1.col_varchar_key  ) )  ) AS table2 LEFT  JOIN cc AS table3 ON (table3.col_int_key = table2.pk  ) ) ) ON (table3.col_varchar_key = table2.col_varchar_key  ) ) WHERE (   EXISTS ( (SELECT   subquery3_t2.col_varchar_nokey AS subquery3_field1 FROM ( d AS subquery3_t1 INNER JOIN bb AS subquery3_t2 ON (subquery3_t2.col_int_key = subquery3_t1.pk  ) )   ) ) ) OR ( table1.col_varchar_key = 'w' AND table1.col_varchar_key = table3.col_varchar_key ) ORDER BY table1.col_varchar_key DESC /*+JavaDB:Postgres: NULLS LAST */ , field1 /*+JavaDB:Postgres: NULLS FIRST */ LIMIT 10 OFFSET 6;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_time_key AS field1 , alias2.col_varchar_key AS field2 FROM ( b AS alias1 , ( SELECT   sq1_alias1.* FROM cc AS sq1_alias1  ) AS alias2 , c AS alias3 ) WHERE (   EXISTS ( (SELECT 5 FROM DUAL ) ) ) OR ( alias1.col_varchar_key  IN ('e' , 'USA') OR alias1.col_varchar_key  IN ('USA') )  GROUP BY field1, field2 HAVING field2 > 'e' ;
--source include/explain_for_connection.inc
let $query=SELECT     (SELECT 'z' FROM dummy ) AS field1 , table1.pk AS field2 , table1.col_time_key AS field3 , table2.col_datetime_key AS field4 , table1.col_datetime_key AS field5 , table2.pk AS field6 FROM ( ( SELECT   subquery2_t1.* FROM ( c AS subquery2_t1 INNER JOIN cc AS subquery2_t2 ON (subquery2_t2.pk = subquery2_t1.pk  ) )  ) AS table1 INNER JOIN ( SELECT   subquery3_t1.* FROM ( b AS subquery3_t1 LEFT  JOIN c AS subquery3_t2 ON (subquery3_t2.pk = subquery3_t1.pk  ) )  ) AS table2 ON (table2.pk = table1.col_int_key  ) ) WHERE (   EXISTS ( (SELECT   subquery4_t1.col_varchar_key AS subquery4_field1 FROM ( cc AS subquery4_t1 LEFT OUTER JOIN c AS subquery4_t2 ON (subquery4_t2.pk = subquery4_t1.col_int_key  ) )   ) ) ) OR ( table1.pk = 141 AND table1.pk = 79 ) ORDER BY table1.col_datetime_key DESC /*+JavaDB:Postgres: NULLS LAST */;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_int_key AS field1 , alias2.col_varchar_key AS field2 FROM ( c AS alias1 , ( SELECT   sq1_alias1.* FROM ( cc AS sq1_alias1 RIGHT  JOIN b AS sq1_alias2 ON (sq1_alias2.col_int_key = sq1_alias1.pk  ) )  ) AS alias2 , ( SELECT   sq2_alias1.* FROM ( cc AS sq2_alias1 INNER JOIN c AS sq2_alias2 ON (sq2_alias2.pk = sq2_alias1.pk  ) )  ) AS alias3 ) WHERE  alias3.col_int_key  IN (SELECT   sq3_alias1.col_int_key AS sq3_field1 FROM ( c AS sq3_alias1 , c AS sq3_alias2 )    )  HAVING ((field1 = 'z' OR field2 < 235) AND field1 != 1) ORDER BY alias1.col_varchar_key DESC;
--source include/explain_for_connection.inc
let $query=SELECT  STRAIGHT_JOIN  table1.pk AS field1 FROM ( c AS table1 INNER JOIN ( ( c AS table2 INNER JOIN ( SELECT   subquery1_t1.* FROM ( bb AS subquery1_t1 STRAIGHT_JOIN cc AS subquery1_t2 ON (subquery1_t2.pk = subquery1_t1.col_int_nokey  ) ) WHERE ( subquery1_t2.col_varchar_key < 'x' AND subquery1_t1.col_int_nokey != subquery1_t2.pk ) ) AS table3 ON (table3.pk = table2.col_int_key  AND table2.col_int_key = (SELECT   MIN(  subquery2_t1.col_int_nokey ) AS subquery2_field1 FROM ( cc AS subquery2_t1 INNER JOIN cc AS subquery2_t2 ON (subquery2_t2.pk = subquery2_t1.col_int_nokey  ) )  ) ) ) ) ON (table3.col_varchar_key = table2.col_varchar_nokey  ) ) WHERE (  table1.pk = ALL (SELECT 25 FROM dummy UNION SELECT 2 FROM dummy ) ) AND ( table1.col_varchar_key NOT IN ('z', 'n') OR table1.pk > 67 AND table1.pk < ( 67 + 32 ) ) ;
--source include/explain_for_connection.inc
let $query=SELECT   SQL_SMALL_RESULT table2.col_varchar_key AS field1 , table2.col_time_key AS field2 , table1.col_time_key AS field3 , table1.col_datetime_key AS field4 , ( ( table1.col_int_key ) - ( table1.pk ) ) AS field5 FROM ( cc AS table1 STRAIGHT_JOIN a AS table2 ON (table2.col_int_key = table1.col_int_nokey  ) ) WHERE (   EXISTS ( (SELECT   subquery1_t1.col_varchar_key AS subquery1_field1 FROM ( c AS subquery1_t1 LEFT  JOIN b AS subquery1_t2 ON (subquery1_t2.col_int_nokey = subquery1_t1.pk  AND subquery1_t1.pk NOT IN (SELECT   child_subquery1_t1.col_int_key AS child_subquery1_field1 FROM b AS child_subquery1_t1    ) ) )  GROUP BY subquery1_field1 ) ) ) AND table2.col_varchar_key >= table1.col_varchar_key ORDER BY table1.col_date_key DESC /*+JavaDB:Postgres: NULLS LAST */ , field1 /*+JavaDB:Postgres: NULLS FIRST */, field2 /*+JavaDB:Postgres: NULLS FIRST */, field3 /*+JavaDB:Postgres: NULLS FIRST */, field4 /*+JavaDB:Postgres: NULLS FIRST */, field5 /*+JavaDB:Postgres: NULLS FIRST */ ;
--source include/explain_for_connection.inc
let $query=SELECT   SQL_SMALL_RESULT table2.col_varchar_key AS field1 FROM ( c AS table1 LEFT OUTER JOIN cc AS table2 ON (table2.col_int_key = table1.pk  ) ) WHERE (  table2.col_varchar_nokey != ANY (SELECT  SQL_SMALL_RESULT subquery1_t1.col_varchar_key AS subquery1_field1 FROM ( c AS subquery1_t1 LEFT OUTER JOIN c AS subquery1_t2 ON (subquery1_t2.col_int_key = subquery1_t1.col_int_key  OR subquery1_t2.col_int_key = (SELECT   MIN(  child_subquery1_t2.pk ) AS child_subquery1_field1 FROM ( c AS child_subquery1_t1 INNER JOIN c AS child_subquery1_t2 ON (child_subquery1_t2.col_int_key = child_subquery1_t1.pk ) ) WHERE child_subquery1_t2.col_varchar_nokey = child_subquery1_t2.col_varchar_key ) ) ) WHERE subquery1_t2.pk >= table1.col_int_nokey ) ) AND ( table1.pk NOT IN (226, 126) OR table1.col_int_key > 241 AND table1.col_int_key < ( 241 + 133 ) ) OR ( table2.col_varchar_key <> 'a' OR table1.col_int_key < table1.pk ) ;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_varchar_key AS field1 FROM ( ( SELECT   sq1_alias1.* FROM ( view_cc AS sq1_alias1 , cc AS sq1_alias2 ) WHERE sq1_alias1.pk < sq1_alias2.col_int_nokey ) AS alias1 RIGHT OUTER JOIN c AS alias2 ON (alias2.col_varchar_nokey = alias1.col_varchar_key  ) ) WHERE (   EXISTS ( (SELECT   sq2_alias1.col_varchar_nokey AS sq2_field1 FROM ( c AS sq2_alias1 , cc AS sq2_alias2 )   ) ) ) AND alias1.col_int_key = 108  HAVING field1 < 'o' ORDER BY alias1.col_date_key , alias2 .pk ASC, field1 ;
--source include/explain_for_connection.inc
let $query=SELECT    table2.pk AS field1 FROM ( ( SELECT   subquery1_t1.* FROM ( cc AS subquery1_t1 INNER JOIN c AS subquery1_t2 ON (subquery1_t2.col_varchar_key = subquery1_t1.col_varchar_key  ) ) WHERE (  NOT EXISTS (SELECT   child_subquery1_t2.col_varchar_nokey AS child_subquery1_field1 FROM ( cc AS child_subquery1_t1 INNER JOIN c AS child_subquery1_t2 ON (child_subquery1_t2.pk = child_subquery1_t1.pk ) ) WHERE child_subquery1_t2.col_int_nokey <> subquery1_t1.pk ) OR subquery1_t2.col_varchar_key >= 'c' ) ) AS table1 INNER JOIN cc AS table2 ON (table2.col_int_nokey = table1.col_int_key  ) ) WHERE (  table2.col_varchar_key > (SELECT 'r' FROM dummy ) ) AND table1.col_int_key = 104 ORDER BY table1.col_time_key ASC /*+JavaDB:Postgres: NULLS FIRST */ , field1 /*+JavaDB:Postgres: NULLS FIRST */ LIMIT 1;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_datetime_key AS field1 , alias1.col_datetime_key AS field2 FROM ( view_cc AS alias1 , cc AS alias2 , ( SELECT   sq1_alias1.* FROM bb AS sq1_alias1  ) AS alias3 ) WHERE (  NOT EXISTS (SELECT   sq2_alias1.col_int_nokey AS sq2_field1 FROM c AS sq2_alias1 WHERE sq2_alias1.col_varchar_key > alias2.col_varchar_nokey AND sq2_alias1.pk >= 8 ) ) AND alias1.col_varchar_key <> 'b'  HAVING field2 < 'b' ORDER BY alias1.col_time_key  , field1, field2 ;
--source include/explain_for_connection.inc
 let $query=SELECT    MAX(  alias1.pk ) AS field1 FROM ( ( SELECT DISTINCT  sq1_alias1.* FROM bb AS sq1_alias1  ) AS alias1 RIGHT OUTER JOIN ( SELECT   sq2_alias1.* FROM cc AS sq2_alias1 WHERE sq2_alias1.pk < sq2_alias1.col_int_nokey ) AS alias2 ON (alias2.col_varchar_key = alias1.col_varchar_nokey  ) ) WHERE  alias2.col_varchar_nokey > (SELECT   SUM(  sq3_alias1.col_varchar_key ) AS sq3_field1 FROM ( cc AS sq3_alias1 INNER JOIN b AS sq3_alias2 ON (sq3_alias2.col_varchar_key = sq3_alias1.col_varchar_key  AND sq3_alias2.pk > ALL (SELECT 7 UNION SELECT 7 ) ) )  )  HAVING ( ( 7, 8 ) NOT IN (SELECT   sq4_alias1.col_int_nokey AS sq4_field1 , MAX(  sq4_alias1.pk ) AS sq4_field2 FROM ( view_bb AS sq4_alias1 LEFT OUTER JOIN ( cc AS sq4_alias2 RIGHT  JOIN c AS sq4_alias3 ON (sq4_alias3.col_varchar_key = sq4_alias2.col_varchar_nokey  ) ) ON (sq4_alias3.col_varchar_key = sq4_alias2.col_varchar_key  ) )    ) AND field1 >= 2) ORDER BY alias1.col_int_key  , field1 ;
--source include/explain_for_connection.inc
 let $query=SELECT    alias1.col_date_key AS field1 FROM ( ( SELECT   sq1_alias1.* FROM b AS sq1_alias1  ) AS alias1 LEFT OUTER JOIN d AS alias2 ON (alias2.col_varchar_key = alias1.col_varchar_key  ) ) WHERE (  alias1.col_varchar_nokey >= SOME (SELECT   sq2_alias1.col_varchar_key AS sq2_field1 FROM cc AS sq2_alias1 WHERE sq2_alias1.col_varchar_nokey <> alias2.col_varchar_key AND sq2_alias1.col_varchar_nokey != alias2.col_varchar_nokey ) ) AND  alias1.col_int_nokey < ANY (SELECT 7 UNION SELECT 3 )  HAVING field1 >= 1 ;
--source include/explain_for_connection.inc
 let $query=SELECT    COUNT(  alias1.col_varchar_nokey ) AS field1 FROM ( cc AS alias1 INNER JOIN ( ( b AS alias2 RIGHT OUTER JOIN ( SELECT   sq1_alias1.* FROM ( b AS sq1_alias1 , cc AS sq1_alias2 )  ) AS alias3 ON (alias3.col_varchar_key = alias2.col_varchar_key  ) ) ) ON (alias3.col_varchar_key = alias2.col_varchar_key  ) ) WHERE  alias2.col_varchar_nokey <= ANY (SELECT 'z' UNION DISTINCT SELECT 'l' )  HAVING (field1 <> 'j' AND field1 >= 'wr') ORDER BY field1 DESC , alias1.col_int_key  , alias1.col_datetime_key DESC;
--source include/explain_for_connection.inc
 let $query=SELECT DISTINCT   alias2.col_varchar_nokey AS field1 , alias1.col_date_key AS field2 , alias2.col_datetime_key AS field3 , alias2.col_date_key AS field4 , alias2.col_varchar_key AS field5 , alias2.col_int_key AS field6 FROM ( cc AS alias1 INNER JOIN ( SELECT DISTINCT  sq1_alias1.* FROM ( cc AS sq1_alias1 INNER JOIN c AS sq1_alias2 ON (sq1_alias2.pk = sq1_alias1.col_int_nokey  ) ) WHERE ( sq1_alias2.pk < sq1_alias2.col_int_nokey OR  sq1_alias2.col_varchar_key > SOME (SELECT 1 UNION DISTINCT SELECT 5 ) ) ) AS alias2 ON (alias2.col_varchar_key = alias1.col_varchar_key  ) ) WHERE   EXISTS ( (SELECT   sq2_alias1.col_int_nokey AS sq2_field1 FROM ( c AS sq2_alias1 , view_c AS sq2_alias2 )    ) )  GROUP BY field1, field2, field3, field4, field5, field6 HAVING field4 <> 3 ORDER BY field2  , alias1.col_datetime_key ;
--source include/explain_for_connection.inc
let $query=SELECT    CONCAT( table2.col_varchar_key , table2.col_varchar_nokey ) AS field1 FROM ( ( SELECT   subquery1_t1.* FROM ( c AS subquery1_t1 INNER JOIN bb AS subquery1_t2 ON (subquery1_t2.col_int_key = subquery1_t1.pk  OR subquery1_t1.col_int_nokey >= ALL (SELECT 3 FROM dummy UNION SELECT 4 FROM dummy ) ) ) WHERE  NOT EXISTS (SELECT  SQL_SMALL_RESULT child_subquery2_t1.col_int_key AS child_subquery1_field1 FROM ( a AS child_subquery2_t1 STRAIGHT_JOIN ( ( cc AS child_subquery2_t2 INNER JOIN c AS child_subquery2_t3 ON (child_subquery2_t3.col_varchar_key = child_subquery2_t2.col_varchar_nokey ) ) ) ON (child_subquery2_t3.col_int_nokey = child_subquery2_t2.pk ) ) WHERE child_subquery2_t1.pk <= subquery1_t2.col_int_key ) ) AS table1 INNER JOIN ( SELECT   subquery2_t1.* FROM c AS subquery2_t1  ) AS table2 ON (table2.pk = table1.pk  ) ) WHERE (  (SELECT  SQL_SMALL_RESULT SUM( DISTINCT subquery3_t1.col_int_key ) AS subquery3_field1 FROM ( bb AS subquery3_t1 INNER JOIN cc AS subquery3_t2 ON (subquery3_t2.col_varchar_key = subquery3_t1.col_varchar_nokey  ) )  ) IS  NULL ) AND ( table1.col_varchar_key  IN ('g', 'z', 'w', 'v', 't') OR table1.pk > 39 AND table1.pk < ( 39 + 233 ) ) OR table1.col_varchar_key IS  NULL ORDER BY table1.col_int_key ASC /*+JavaDB:Postgres: NULLS FIRST */ , field1 /*+JavaDB:Postgres: NULLS FIRST */ LIMIT 100;
--source include/explain_for_connection.inc

DROP TABLE a;
DROP TABLE aa;
DROP TABLE b;
DROP TABLE bb;
DROP TABLE c;
DROP TABLE cc;
DROP TABLE d;
DROP TABLE dd;
DROP TABLE dummy;
DROP TABLE e;
DROP VIEW view_a;
DROP VIEW view_aa;
DROP VIEW view_b;
DROP VIEW view_bb;
DROP VIEW view_c;
DROP VIEW view_cc;
DROP VIEW view_d;
--source include/restore_sql_mode_after_turn_off_only_full_group_by.inc
