#===========================================================================
# proxy for safe use of parallel preloading code.

package Sitescooper::ParProxy;

BEGIN {
  $Sitescooper::ParProxy::need_to_wait = 0;
}

sub lpeval {
  if ($CF::use_lwp_par) {
    my $code = shift;
    my @args = @_;
    if (!eval ('@_ = @args;'.$code.'1;')) {
      warn "preload: LWP::Parallel code broke, preloading disabled: $@\n";
      $CF::use_lwp_par = 0;
    }
  }
}

sub Sitescooper::ParProxy::setup_pua {
  &lpeval ('
    require Sitescooper::ParUserAgent;

    # maintain a persistent rules cache to speed things up
    my $rules = new WWW::RobotRules::AnyDBM_File
	 ("sitescooper", $CF::user_tmpdir.$CF::slash."robot_rules");

    $Scoop::pua = new Sitescooper::ParUserAgent ("sitescooper",
				 "sitescooper\@jmason.org", $rules);
    $Scoop::pua->env_proxy;
    $Scoop::pua->agent ("sitescooper/$Scoop::VERSION ($Scoop::home_url) ".
		"(preloader) ".$Scoop::pua->agent);

    $Scoop::pua->max_size (1024*1024*2);	# 2-meg file limit
    $Scoop::pua->timeout (10);
    $Scoop::pua->delay (2);
    $Scoop::pua->max_req (2);
    $Scoop::pua->max_hosts (10);

    # use LWP::Debug qw(+);
  ');

  # shut up lint if LWP::Parallel is not available
  $_ = $Scoop::pua;
}

sub set_caches {
  &lpeval ('$Scoop::pua->set_caches();');
}

sub register {
  &lpeval ('
    $Scoop::pua->register (@_);
    $Sitescooper::ParProxy::need_to_wait = 1;
  ', @_);
}

sub check_for_responses {
  return unless $Sitescooper::ParProxy::need_to_wait;
  &lpeval ('
    $Scoop::pua->wait (10);
  ');
}

sub check_for_url {
  return if ($Sitescooper::ParProxy::need_to_wait == 0);

  &lpeval ('
    my $url = $_[0];
    my ($retries, $k);

    if (!defined $Scoop::pua->{ok_responses}->{$url}) {
      &Scoop::dbg ("preload: waiting for url: $url");
      for ($retries = 0; $retries < 30; $retries++) {
	my $active = $Scoop::pua->wait (5);
	if (defined $Scoop::pua->{ok_responses}->{$url}) {
	  &Scoop::dbg ("preload: url not in list, stop waiting");
	  last;
	}
      }
    }
  ', @_);
}

sub have_response {
  $TmpGlobal::response = undef;;
  &lpeval ('
    my $url = $_[0];
    if (defined $Scoop::pua->{ok_responses}->{$url}) {
      $TmpGlobal::response = $Scoop::pua->{ok_responses}->{$url};
      delete $Scoop::pua->{ok_responses}->{$url};
    }
  ', @_);
  return $TmpGlobal::response;
}

1;
