/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtdispatch.internal.NioAttachment;
import org.fusesource.hawtdispatch.internal.NioDispatchSource;

public class NioManager {
    final SelectStrategy selectStrategy = Boolean.getBoolean("hawtdispatch.workaround-select-spin") ? new WorkAroundSelectSpin() : new SelectStrategy();
    private Selector selector;
    protected final AtomicInteger wakeupCounter = new AtomicInteger();
    protected volatile int selectCounter;
    protected volatile boolean selecting;
    private final boolean TRACE = false;
    private final LinkedList<String> traces = new LinkedList();

    public NioManager() throws IOException {
        this.selector = Selector.open();
    }

    Selector getSelector() {
        return this.selector;
    }

    public boolean wakeupIfSelecting() {
        if (this.wakeupCounter.getAndIncrement() == this.selectCounter && this.selecting) {
            this.selector.wakeup();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(long timeout) throws IOException {
        block7: {
            try {
                if (timeout == 0L) {
                    this.selector.selectNow();
                    break block7;
                }
                this.selecting = true;
                try {
                    if (this.selectCounter == this.wakeupCounter.get()) {
                        this.selectStrategy.select(timeout);
                    }
                }
                finally {
                    this.selecting = false;
                    this.selectCounter = this.wakeupCounter.get();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
        return this.processSelected();
    }

    private int processSelected() {
        if (this.selector.keys().isEmpty()) {
            return 0;
        }
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        int size = selectedKeys.size();
        if (size != 0) {
            this.trace("selected: %d", size);
            ArrayList<SelectionKey> copy = new ArrayList<SelectionKey>(this.selector.selectedKeys());
            this.selector.selectedKeys().clear();
            for (SelectionKey key : copy) {
                if (key.isValid()) {
                    try {
                        key.interestOps(key.interestOps() & ~key.readyOps());
                        ((NioAttachment)key.attachment()).selected(key);
                    }
                    catch (CancelledKeyException e) {
                        ((NioAttachment)key.attachment()).cancel(key);
                    }
                    continue;
                }
                ((NioAttachment)key.attachment()).cancel(key);
            }
        }
        return size;
    }

    public void shutdown() throws IOException {
        for (SelectionKey key : this.selector.keys()) {
            NioDispatchSource source = (NioDispatchSource)key.attachment();
            source.cancel();
        }
        this.selector.close();
    }

    protected void trace(String str, Object ... args) {
    }

    class WorkAroundSelectSpin
    extends SelectStrategy {
        int spins;

        WorkAroundSelectSpin() {
        }

        public boolean wakeupPending() {
            return NioManager.this.selectCounter != NioManager.this.wakeupCounter.get();
        }

        public int select(long timeout) throws IOException {
            if (NioManager.this.selector.keys().isEmpty() || timeout > 0L || timeout < 100L) {
                return super.select(timeout);
            }
            long start = System.nanoTime();
            int selected = super.select(timeout);
            if (selected == 0 && !this.wakeupPending()) {
                long end = System.nanoTime();
                long duration = TimeUnit.NANOSECONDS.toMillis(end - start);
                if (duration < 50L) {
                    ++this.spins;
                    if (this.spins > 10) {
                        this.reset();
                        this.spins = 0;
                    }
                } else {
                    this.spins = 0;
                }
            } else {
                this.spins = 0;
            }
            return selected;
        }

        private void reset() throws IOException {
            NioManager.this.trace("Selector spin detected... resetting the selector", new Object[0]);
            Selector nextSelector = Selector.open();
            for (SelectionKey key : NioManager.this.selector.keys()) {
                NioAttachment attachment = (NioAttachment)key.attachment();
                if (key.isValid()) {
                    try {
                        SelectionKey nextKey = key.channel().register(nextSelector, key.interestOps());
                        nextKey.attach(attachment);
                        for (NioDispatchSource source : attachment.sources) {
                            NioDispatchSource.KeyState state = source.keyState.get();
                            if (state == null) continue;
                            state.key = nextKey;
                        }
                        continue;
                    }
                    catch (IOException e) {
                        attachment.cancel(key);
                        continue;
                    }
                }
                attachment.cancel(key);
            }
            NioManager.this.selector.close();
            NioManager.this.selector = nextSelector;
        }
    }

    class SelectStrategy {
        SelectStrategy() {
        }

        public int select(long timeout) throws IOException {
            int rc = 0;
            if (timeout == -1L) {
                NioManager.this.trace("entered blocking select", new Object[0]);
                rc = NioManager.this.selector.select();
                NioManager.this.trace("exited blocking select", new Object[0]);
            } else {
                NioManager.this.trace("entered blocking select with timeout", new Object[0]);
                rc = NioManager.this.selector.select(timeout);
                NioManager.this.trace("exited blocking select with timeout", new Object[0]);
            }
            return rc;
        }
    }
}

