/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.gameInfo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.sgf.gameInfo.DateEditorWindow;
import org.igoweb.go.swing.sgf.gameInfo.DateInfo;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.GCLayout;

public class DateListPanel
extends JPanel {
    private JList<DateInfo> dateList;
    private DefaultListModel<DateInfo> dates = new DefaultListModel();
    private JButton removeDateBut;
    private JButton editDateBut;
    private DateEditorWindow currentDateEditor = null;
    private Node sgfRoot;

    public DateListPanel(Tree sgf) {
        super(new GCLayout());
        this.sgfRoot = sgf.root;
        this.parseDate();
        this.dateList = new JList<DateInfo>(this.dates);
        this.add("xGrow=t,ySpan=3", new JScrollPane(this.dateList, 22, 31));
        this.dateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                boolean selection = event.getFirstIndex() <= event.getLastIndex();
                DateListPanel.this.removeDateBut.setEnabled(selection);
                DateListPanel.this.editDateBut.setEnabled(selection);
            }
        });
        this.dateList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    DateListPanel.this.editDate(DateListPanel.this.dateList.locationToIndex(event.getPoint()));
                }
            }
        });
        this.dateList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((DateInfo)value).getText(), index, isSelected, cellHasFocus);
            }
        });
        this.dateList.setForeground(UIManager.getColor("org.igoweb.activeBg"));
        ActionListener dateAdder = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DateListPanel.this.editDate(-1);
            }
        };
        JButton but = new JButton(Defs.getString(-478254177));
        this.add("x=2,y=0,ySpan=1,xGrow=f,yGrow=t", but);
        but.addActionListener(dateAdder);
        this.editDateBut = new JButton(Defs.getString(-478254158));
        this.add("x=2,y=1", this.editDateBut);
        this.editDateBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateListPanel.this.editDate(DateListPanel.this.dateList.getMinSelectionIndex());
            }
        });
        this.editDateBut.setEnabled(false);
        ActionListener dateRemover = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int dateId = DateListPanel.this.dateList.getSelectedIndex();
                if (dateId >= 0) {
                    DateListPanel.this.dates.remove(dateId);
                    DateListPanel.this.editDateBut.setEnabled(false);
                    DateListPanel.this.removeDateBut.setEnabled(false);
                }
            }
        };
        this.removeDateBut = new JButton(Defs.getString(-478254149));
        this.add("x=2,y=2", this.removeDateBut);
        this.removeDateBut.addActionListener(dateRemover);
        this.removeDateBut.setEnabled(false);
    }

    private void parseDate() {
        Prop dateProp = this.sgfRoot.findProp(4);
        if (dateProp == null) {
            return;
        }
        DateInfo prevDate = null;
        StringTokenizer dateTokens = new StringTokenizer(dateProp.getText(), ",");
        while (dateTokens.hasMoreElements()) {
            try {
                DateInfo newDate = new DateInfo(dateTokens.nextToken(), prevDate);
                this.dates.addElement(newDate);
                prevDate = newDate;
            }
            catch (ParseException excep) {
                this.dates.clear();
            }
        }
        this.sortDateList();
    }

    public void sync() {
        if (this.dates.size() == 0) {
            this.sgfRoot.removeType(4);
            return;
        }
        StringBuilder result = new StringBuilder();
        DateInfo prevDate = null;
        Enumeration<DateInfo> dateInfos = this.dates.elements();
        while (dateInfos.hasMoreElements()) {
            DateInfo newDate = dateInfos.nextElement();
            String newText = newDate.toSgf(prevDate);
            prevDate = newDate;
            if (newText == null) continue;
            result.append(newText).append(',');
        }
        result.setLength(result.length() - 1);
        String dateListString = result.toString();
        Prop oldProp = this.sgfRoot.findProp(4);
        if (oldProp != null) {
            if (oldProp.equals(dateListString)) {
                return;
            }
            this.sgfRoot.remove(oldProp);
        }
        this.sgfRoot.add(new Prop(4, dateListString));
    }

    private void sortDateList() {
        if (this.dates.isEmpty()) {
            return;
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            DateInfo prevDateInfo = this.dates.get(0);
            for (int i = 1; i < this.dates.size(); ++i) {
                DateInfo thisDateInfo = this.dates.get(i);
                if (thisDateInfo.comesBefore(prevDateInfo)) {
                    changed = true;
                    this.dates.set(i - 1, thisDateInfo);
                    this.dates.set(i, prevDateInfo);
                    continue;
                }
                prevDateInfo = thisDateInfo;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void editDate(int indexToEdit) {
        DateInfo starter = null;
        if (indexToEdit != -1) {
            starter = this.dates.get(indexToEdit);
        }
        if (this.currentDateEditor != null) {
            this.currentDateEditor.dispose();
        }
        ActionListener dateEdited = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DateListPanel.this.sortDateList();
            }
        };
        this.currentDateEditor = new DateEditorWindow(starter, this, this.dates, dateEdited);
        this.currentDateEditor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ((AFrame)event.getSource()).dispose();
            }

            @Override
            public void windowClosed(WindowEvent event) {
                if (event.getSource() == DateListPanel.this.currentDateEditor) {
                    DateListPanel.this.currentDateEditor = null;
                }
            }
        });
    }
}

