/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;

public class ReadSet {
    private final IntSet filter = new IntOpenHashSet();
    private final Int2IntMap multiplicityMap = new Int2IntOpenHashMap();
    private int smallestStoredMultiplicity;

    public void clear() {
        this.filter.clear();
        this.multiplicityMap.clear();
    }

    public void add(int readIndex, int multiplicity) {
        assert (readIndex >= 0) : "read indices must be positive";
        this.filter.add(readIndex);
        if (multiplicity >= this.smallestStoredMultiplicity) {
            this.multiplicityMap.put(readIndex, multiplicity);
        }
    }

    public boolean contains(int readIndex) {
        return this.filter.contains(readIndex);
    }

    public void save(String basename, String suffix) throws IOException {
        String filename = basename + "-" + suffix + ".filter";
        OutputBitStream out = new OutputBitStream(filename);
        IntArrayList sorted = new IntArrayList();
        sorted.addAll((IntCollection)this.filter);
        Collections.sort(sorted);
        out.writeGamma(this.smallestStoredMultiplicity);
        out.writeGamma(sorted.size());
        int previous = -1;
        IntListIterator intListIterator = sorted.iterator();
        while (intListIterator.hasNext()) {
            int readIndex = (Integer)intListIterator.next();
            out.writeDelta(readIndex - previous);
            int multiplicity = this.multiplicityMap.get(readIndex);
            out.writeGamma(multiplicity);
            previous = readIndex;
        }
        out.close();
    }

    public void load(String basename, String suffix) throws IOException {
        String filename = basename + "-" + suffix + ".filter";
        this.load(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        try (InputBitStream in = null;){
            in = new InputBitStream(file);
            this.filter.clear();
            this.smallestStoredMultiplicity = in.readGamma();
            int numDeltas = in.readGamma();
            int previous = -1;
            for (int i = 0; i < numDeltas; ++i) {
                int delta = in.readDelta();
                int multiplicity = in.readGamma();
                int readIndex = previous + delta;
                this.filter.add(readIndex);
                this.multiplicityMap.put(readIndex, multiplicity);
                previous = readIndex;
            }
        }
    }

    public void add(int readIndex) {
        this.add(readIndex, 0);
    }

    public int size() {
        return this.filter.size();
    }

    public int getMultiplicity(int readIndex) {
        if (this.filter.contains(readIndex)) {
            return this.multiplicityMap.get(readIndex);
        }
        return 0;
    }

    public void addAll(IntSet otherReadIndices, int multiplicity) {
        IntIterator intIterator = otherReadIndices.iterator();
        while (intIterator.hasNext()) {
            int readIndex = (Integer)intIterator.next();
            this.add(readIndex, multiplicity);
        }
    }

    public int getMaxReadIndex() {
        int maxQueryIndex = -1;
        IntIterator intIterator = this.filter.iterator();
        while (intIterator.hasNext()) {
            int queryIndex = (Integer)intIterator.next();
            maxQueryIndex = Math.max(maxQueryIndex, queryIndex);
        }
        return maxQueryIndex;
    }

    public void smallestStoredMultiplicity(int value) {
        this.multiplicityMap.defaultReturnValue(value);
        this.smallestStoredMultiplicity = value;
    }
}

