/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.mlf.metouia.MetouiaGradients;
import net.sourceforge.mlf.metouia.borders.MetouiaDots;

public class MetouiaInternalFrameTitlePane
extends MetalInternalFrameTitlePane
implements LayoutManager {
    protected int frameTitleHeight;
    private int buttonsWidth;
    protected MetouiaDots dots = new MetouiaDots(0, 0);
    protected MetouiaDots paletteDots;

    protected void installDefaults() {
        super.installDefaults();
        this.frameTitleHeight = UIManager.getInt("InternalFrame.frameTitleHeight");
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl = this.frame.getComponentOrientation().isLeftToRight();
        boolean bl2 = this.frame.isSelected();
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        ColorUIResource colorUIResource = MetalLookAndFeel.getWindowTitleInactiveBackground();
        ColorUIResource colorUIResource2 = MetalLookAndFeel.getWindowTitleInactiveForeground();
        ColorUIResource colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n4, n5);
        graphics.setColor(colorUIResource3);
        graphics.drawLine(0, n5 - 2, n4, n5 - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(0, n5 - 1, n4, n5 - 1);
        int n6 = 0;
        int n7 = bl ? 2 : n4 - 2;
        String string = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!bl) {
                n7 -= icon.getIconWidth();
            }
            n3 = n5 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n7, n3);
            n7 += bl ? icon.getIconWidth() + 2 : -2;
        }
        if (string != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n6 = fontMetrics.stringWidth(string);
            graphics.setColor(colorUIResource2);
            n2 = (n5 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            if (!bl) {
                n7 -= n6;
            }
            graphics.drawString(string, n7, n2);
            n7 += bl ? n6 + 2 : -2;
        }
        if (bl) {
            n = n4 - this.buttonsWidth - n7 - 2;
            n3 = n7;
        } else {
            n = n7 - this.buttonsWidth - 2;
            n3 = this.buttonsWidth + 2;
        }
        n2 = 6;
        int n8 = this.getHeight() - 2 * n2 + 1;
        this.dots.setDotsArea(n, n8);
        if (bl2) {
            this.dots.paintIcon(this, graphics, n3, n2);
        }
        MetouiaGradients.drawHorizontalHighlight(graphics, this);
        MetouiaGradients.drawShadow(graphics, new Rectangle(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2 - 1), true, false);
    }

    protected LayoutManager createLayout() {
        return this;
    }

    protected void createButtons() {
        this.iconButton = new NoFocusButton();
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.setContentAreaFilled(false);
        this.maxButton = new NoFocusButton();
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setRolloverEnabled(true);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton = new NoFocusButton();
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.setContentAreaFilled(false);
        this.setButtonIcons();
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
    }

    public void paintPalette(Graphics graphics) {
        boolean bl = this.frame.getComponentOrientation().isLeftToRight();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.paletteDots == null) {
            this.paletteDots = new MetouiaDots(0, 0);
        }
        ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
        colorUIResource = MetalLookAndFeel.getWindowTitleInactiveBackground();
        colorUIResource2 = MetalLookAndFeel.getControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        int n3 = bl ? 2 : this.buttonsWidth + 2;
        int n4 = n - this.buttonsWidth - 1;
        int n5 = this.getHeight() - 2;
        this.paletteDots.setDotsArea(n4, n5);
        this.paletteDots.paintIcon(this, graphics, n3, 2);
        MetouiaGradients.drawHorizontalHighlight(graphics, this);
        MetouiaGradients.drawHorizontalShadow(graphics, this);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize(container);
    }

    public Dimension getPreferredSize(Container container) {
        return new Dimension(container.getSize().width, this.isPalette ? this.paletteTitleHeight : this.frameTitleHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(70, 20);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int n;
        boolean bl = this.frame.getComponentOrientation().isLeftToRight();
        int n2 = this.getWidth();
        int n3 = bl ? n2 : 0;
        int n4 = 2;
        int n5 = this.closeButton.getIcon().getIconHeight();
        int n6 = this.closeButton.getIcon().getIconWidth();
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                n = 0;
                this.closeButton.setBounds(n3 += bl ? -n - n6 : n, n4 - 1, n6, this.getHeight() - 2);
                if (!bl) {
                    n3 += n6;
                }
            } else {
                n = 0;
                this.closeButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                if (!bl) {
                    n3 += n6;
                }
            }
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            n = this.frame.isClosable() ? 0 : 2;
            this.maxButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
            if (!bl) {
                n3 += n6;
            }
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            n = this.frame.isMaximizable() ? 0 : (this.frame.isClosable() ? 0 : 2);
            this.iconButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
            if (!bl) {
                n3 += n6;
            }
        }
        this.buttonsWidth = bl ? n2 - n3 : n3;
    }

    public MetouiaInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    private class NoFocusButton
    extends JButton {
        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        NoFocusButton() {
        }
    }
}

