/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.skin;

import com.birosoft.liquid.skin.SecretLoader;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class SkinImageCache {
    private static SkinImageCache instance = new SkinImageCache();
    static GraphicsConfiguration conf;
    private HashMap map = new HashMap();
    private HashMap iconMap = new HashMap();
    private HashMap bufferedMap = new HashMap();

    public Image getAutomaticImage(String fileName) {
        Image ret = (Image)this.map.get(fileName);
        if (ret == null) {
            Image img = SecretLoader.loadImage(fileName);
            this.map.put(fileName, img);
            return img;
        }
        return ret;
    }

    public Image getImage(String fileName) {
        return this.getAutomaticImage(fileName);
    }

    public BufferedImage getBufferedImage(String fileName) {
        BufferedImage b = (BufferedImage)this.bufferedMap.get(fileName);
        if (b != null) {
            return b;
        }
        Image img = this.getImage(fileName);
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage img2 = conf.createCompatibleImage(w, h);
        Graphics g = img2.getGraphics();
        g.drawImage(img, 0, 0, w, h, 0, 0, w, h, null);
        this.bufferedMap.put(fileName, img2);
        return img2;
    }

    public static SkinImageCache getInstance() {
        return instance;
    }

    protected SkinImageCache() {
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        conf = ge.getDefaultScreenDevice().getDefaultConfiguration();
    }
}

