/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.ConnectionManager;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.Preferences;
import free.jin.Server;
import free.jin.Session;
import free.jin.SessionEvent;
import free.jin.SessionListener;
import free.jin.User;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginUIContainer;
import free.jin.plugin.PluginUIEvent;
import free.jin.ui.AbstractPluginUIContainer;
import free.jin.ui.AbstractUiProvider;
import free.jin.ui.ActionsMenu;
import free.jin.ui.DialogPanel;
import free.jin.ui.HelpMenu;
import free.jin.ui.OptionPanel;
import free.jin.ui.PluginContainersMenu;
import free.jin.ui.PrefsMenu;
import free.util.AWTUtilities;
import free.util.PlatformUtils;
import free.util.RectDouble;
import free.util.Utilities;
import free.util.swing.AdvancedJDesktopPane;
import free.util.swing.BackgroundChooser;
import free.util.swing.InternalFrameSwitcher;
import free.workarounds.FixedJInternalFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultDesktopManager;
import javax.swing.DefaultFocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class MdiUiProvider
extends AbstractUiProvider {
    private JFrame mainFrame;
    private AdvancedJDesktopPane desktop;
    private JMenuBar menubar;
    private PluginContainersMenu windowsMenu;
    private ActionsMenu actionsMenu;
    private InternalFrameSwitcher frameSwitcher;

    public void start() {
        super.start();
        I18n i18n = I18n.get(MdiUiProvider.class);
        this.mainFrame = this.createMainFrame();
        this.restoreFrameGeometry(Jin.getInstance().getPrefs(), this.mainFrame, "frame.", new RectDouble(0.0625, 0.0625, 0.875, 0.875));
        this.desktop = new AdvancedJDesktopPane();
        this.configureDesktop(this.desktop);
        this.menubar = new JMenuBar();
        this.configureMenubar(this.menubar);
        this.mainFrame.setContentPane(this.desktop);
        this.mainFrame.setJMenuBar(this.menubar);
        this.windowsMenu = new PluginContainersMenu();
        i18n.initAbstractButton(this.windowsMenu, "windowsMenu");
        this.addPluginUIContainerCreationListener(this.windowsMenu);
        this.actionsMenu = new ActionsMenu();
        this.menubar.add(new ConnectionMenu());
        this.menubar.add(new MdiPrefsMenu());
        this.menubar.add(new HelpMenu());
        this.frameSwitcher = new InternalFrameSwitcher(this.desktop);
        this.desktop.setDesktopManager(new DesktopManager());
        try {
            FocusManager.setCurrentManager(new FocusManager());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                MdiUiProvider.this.mainFrame.removeWindowListener(this);
                if (MdiUiProvider.this.mainFrame.getJMenuBar() != null && MdiUiProvider.this.mainFrame.getFocusOwner() != null && !PlatformUtils.isMacOSX()) {
                    MdiUiProvider.this.mainFrame.getJMenuBar().requestFocus();
                }
                Jin.getInstance().getConnManager().start();
            }
        });
        this.mainFrame.setVisible(true);
    }

    private JFrame createMainFrame() {
        JFrame jFrame = new JFrame();
        jFrame.setTitle(Jin.getInstance().getAppName());
        jFrame.setIconImage(jFrame.getToolkit().getImage(Jin.class.getResource("resources/icon.gif")));
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Jin.getInstance().quit(true);
            }
        });
        return jFrame;
    }

    private void configureDesktop(AdvancedJDesktopPane advancedJDesktopPane) {
        Preferences preferences = Jin.getInstance().getPrefs();
        Color color = preferences.getColor("desktop.bgcolor", null);
        String string = preferences.getString("desktop.wallpaper.filename", null);
        String string2 = preferences.getString("desktop.wallpaper.layout", "center");
        int n = "scale".equals(string2) ? 3 : ("tile".equals(string2) ? 2 : 1);
        if (color != null) {
            advancedJDesktopPane.setBackground(color);
        }
        advancedJDesktopPane.setWallpaperLayoutStyle(n);
        if (string != null) {
            advancedJDesktopPane.setWallpaper(advancedJDesktopPane.getToolkit().getImage(string));
        }
    }

    private void configureMenubar(JMenuBar jMenuBar) {
    }

    public void showDialog(DialogPanel dialogPanel, Component component) {
        Frame frame = this.mainFrame;
        if (component != null) {
            frame = AWTUtilities.frameForComponent(component);
        }
        dialogPanel.show(new JDialog(frame), component == null ? frame : component);
    }

    public void sessionEstablished(SessionEvent sessionEvent) {
        super.sessionEstablished(sessionEvent);
        Session session = sessionEvent.getSession();
        String string = session.getUser().getUsername();
        String string2 = session.getServer().getShortName();
        String string3 = Jin.getInstance().getAppName();
        I18n i18n = I18n.get(MdiUiProvider.class);
        this.mainFrame.setTitle(i18n.getFormattedString("mainFrame.title", new Object[]{string, string2, string3}));
        this.menubar.add((Component)this.actionsMenu, 1);
        this.menubar.add((Component)this.windowsMenu, 3);
    }

    public void sessionClosed(SessionEvent sessionEvent) {
        super.sessionClosed(sessionEvent);
        this.mainFrame.setTitle(Jin.getInstance().getAppName());
        this.menubar.remove(this.actionsMenu);
        this.menubar.remove(this.windowsMenu);
        if (!PlatformUtils.isMacOSX()) {
            this.menubar.requestFocus();
        }
    }

    public PluginUIContainer createPluginUIContainer(Plugin plugin, String string, int n) {
        InternalFramePluginUIContainer internalFramePluginUIContainer = new InternalFramePluginUIContainer(plugin, string, n);
        this.addPluginContainer(plugin, string, internalFramePluginUIContainer);
        return internalFramePluginUIContainer;
    }

    public boolean isUiVisible() {
        return this.mainFrame.isVisible();
    }

    public void stop() {
        this.saveFrameGeometry(Jin.getInstance().getPrefs(), this.mainFrame, "frame.");
        this.mainFrame.dispose();
    }

    private class DesktopManager
    extends DefaultDesktopManager {
        private static final int X_MARGIN = 100;
        private static final int Y_MARGIN = 50;

        private DesktopManager() {
        }

        public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            int n5;
            Dimension dimension = MdiUiProvider.this.desktop.getSize();
            Rectangle rectangle = jComponent.getBounds();
            boolean bl = rectangle.x != n;
            boolean bl2 = rectangle.y != n2;
            boolean bl3 = n + n3 != rectangle.x + rectangle.width;
            boolean bl4 = n2 + n4 != rectangle.y + rectangle.height;
            Dimension dimension2 = jComponent.getMinimumSize();
            n3 = Math.max(n3, dimension2.width);
            n4 = Math.max(n4, dimension2.height);
            int n6 = n;
            int n7 = n2;
            int n8 = n6 + n3;
            int n9 = n7 + n4;
            int n10 = rectangle.width < 100 ? rectangle.width : 100;
            int n11 = n5 = rectangle.height < 50 ? rectangle.height : 50;
            if (bl3) {
                n8 = Math.min(Math.max(n8, n10), n6 + dimension.width);
            }
            if (bl4) {
                n9 = Math.min(n9, n7 + dimension.height);
            }
            if (bl) {
                n6 = Math.min(Math.max(n6, n8 - dimension.width), dimension.width - n10);
            }
            if (bl2) {
                n7 = Math.max(Math.min(Math.max(n7, 0), dimension.height - n5), n9 - dimension.height);
            }
            super.resizeFrame(jComponent, n6, n7, n8 - n6, n9 - n7);
        }

        public void dragFrame(JComponent jComponent, int n, int n2) {
            Dimension dimension = MdiUiProvider.this.desktop.getSize();
            Rectangle rectangle = jComponent.getBounds();
            int n3 = rectangle.width < 100 ? rectangle.width : 100;
            int n4 = rectangle.height < 50 ? rectangle.height : 50;
            n = Math.max(Math.min(n, dimension.width - n3), n3 - jComponent.getWidth());
            n2 = Math.max(Math.min(n2, dimension.height - n4), 0);
            super.dragFrame(jComponent, n, n2);
        }
    }

    private class FocusManager
    extends DefaultFocusManager {
        private FocusManager() {
        }

        public void processKeyEvent(Component component, KeyEvent keyEvent) {
            if (!SwingUtilities.isDescendingFrom(keyEvent.getComponent(), MdiUiProvider.this.mainFrame.getContentPane())) {
                super.processKeyEvent(component, keyEvent);
                return;
            }
            int n = keyEvent.getKeyCode();
            if (n == 9 && keyEvent.isControlDown() || n == 117 && keyEvent.isControlDown() || n == 192 && keyEvent.isControlDown()) {
                keyEvent.consume();
                if (keyEvent.getID() == 402) {
                    return;
                }
                if (keyEvent.isShiftDown()) {
                    MdiUiProvider.this.frameSwitcher.selectPrevious();
                } else {
                    MdiUiProvider.this.frameSwitcher.selectNext();
                }
            } else {
                super.processKeyEvent(component, keyEvent);
            }
        }
    }

    private class InternalFramePluginUIContainer
    extends AbstractPluginUIContainer
    implements VetoableChangeListener,
    InternalFrameListener {
        private final MdiInternalFrame frame;

        public InternalFramePluginUIContainer(Plugin plugin, String string, int n) {
            super(plugin, string, n);
            this.frame = new MdiInternalFrame();
            this.frame.setDefaultCloseOperation(2);
            this.frame.addVetoableChangeListener(this);
            this.frame.addInternalFrameListener(this);
            this.frame.setVisible(false);
            this.setIconImpl(Toolkit.getDefaultToolkit().getImage((class$free$jin$Jin == null ? (class$free$jin$Jin = MdiUiProvider.class$("free.jin.Jin")) : class$free$jin$Jin).getResource("resources/icon.gif")));
        }

        public void disposeImpl() {
            this.setVisible(false);
            this.frame.dispose();
        }

        protected void insertMenu(JMenu jMenu, int n) {
            JMenuBar jMenuBar = this.frame.getJMenuBar();
            if (jMenuBar == null) {
                jMenuBar = new JMenuBar();
                this.frame.setJMenuBar(jMenuBar);
            }
            jMenuBar.add((Component)jMenu, n);
        }

        protected int getMenuCount() {
            JMenuBar jMenuBar = this.frame.getJMenuBar();
            return jMenuBar == null ? 0 : jMenuBar.getMenuCount();
        }

        public void setActive(boolean bl) {
            try {
                if (bl) {
                    if (!this.isVisible()) {
                        this.setVisible(true);
                    }
                    if (this.frame.isIcon()) {
                        this.frame.setIcon(false);
                    }
                    this.frame.setSelected(true);
                    this.frame.toFront();
                } else {
                    MdiUiProvider.this.frameSwitcher.selectPrevious();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public boolean isActive() {
            return this.frame.isVisible() && this.frame.isSelected();
        }

        public void setResizable(boolean bl) {
            this.frame.setResizable(bl);
        }

        public boolean isResizable() {
            return this.frame.isResizable();
        }

        public Container getContentPane() {
            return this.frame.getContentPane();
        }

        public void setTitleImpl(String string) {
            this.frame.setTitle(string);
            this.frame.repaint();
        }

        public void setIconImpl(Image image) {
            Icon icon = UIManager.getIcon("InternalFrame.icon");
            if (icon != null) {
                int n = icon.getIconWidth();
                int n2 = icon.getIconHeight();
                if (image.getWidth(null) != n || image.getHeight(null) != n2) {
                    image = image.getScaledInstance(n, n2, 4);
                }
            }
            this.frame.setFrameIcon(new ImageIcon(image));
        }

        public void setVisible(boolean bl) {
            if (bl == this.isVisible()) {
                return;
            }
            if (bl) {
                this.show();
            } else {
                this.hide();
            }
        }

        public boolean isVisible() {
            return this.frame.getParent() != null || this.frame.getDesktopIcon() != null && this.frame.getDesktopIcon().getParent() != null;
        }

        private void show() {
            this.loadState();
            MdiUiProvider.this.desktop.add(this.frame);
            this.frame.setVisible(true);
            this.firePluginUIEvent(new PluginUIEvent(this, 1));
        }

        private void hide() {
            this.saveState();
            if (this.frame.isSelected()) {
                MdiUiProvider.this.frameSwitcher.selectPrevious();
            }
            this.frame.setVisible(false);
            MdiUiProvider.this.desktop.remove(this.frame);
            JInternalFrame.JDesktopIcon jDesktopIcon = this.frame.getDesktopIcon();
            if (jDesktopIcon != null && jDesktopIcon.getParent() != null) {
                MdiUiProvider.this.desktop.remove(jDesktopIcon);
                MdiUiProvider.this.desktop.repaint();
            }
            this.firePluginUIEvent(new PluginUIEvent(this, 2));
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("closed") && propertyChangeEvent.getOldValue().equals(Boolean.FALSE) && propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                switch (this.getMode()) {
                    case 1: 
                    case 2: {
                        this.setVisible(false);
                        break;
                    }
                    case 0: {
                        this.closeSession(this.frame);
                        break;
                    }
                    case -1: {
                        this.firePluginUIEvent(new PluginUIEvent(this, 3));
                    }
                }
                throw new PropertyVetoException("Canceled closing", propertyChangeEvent);
            }
        }

        protected void saveState() {
            String string = this.getId();
            if (string == null) {
                return;
            }
            Preferences preferences = this.getPlugin().getPrefs();
            String string2 = this.getPrefsPrefix();
            if (this.frame.isMaximum() != preferences.getBool(string2 + "iframe.isMaximized", false)) {
                preferences.setBool(string2 + "iframe.isMaximized", this.frame.isMaximum());
            }
            if (this.frame.isIcon() != preferences.getBool(string2 + "iframe.isIconified", false)) {
                preferences.setBool(string2 + "iframe.isIconified", this.frame.isIcon());
            }
            try {
                if (this.frame.isMaximum()) {
                    this.frame.setMaximum(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            RectDouble rectDouble = new RectDouble(this.frame.getBounds());
            rectDouble.scale(1.0 / (double)MdiUiProvider.this.desktop.getWidth(), 1.0 / (double)MdiUiProvider.this.desktop.getHeight());
            preferences.setRectDouble(string2 + "iframe.bounds", rectDouble);
        }

        protected void loadState() {
            String string = this.getId();
            Preferences preferences = this.getPlugin().getPrefs();
            String string2 = this.getPrefsPrefix();
            RectDouble rectDouble = this.getInitialBounds(this.frame, MdiUiProvider.this.mainFrame.getContentPane().getSize());
            RectDouble rectDouble2 = string == null ? rectDouble : preferences.getRectDouble(string2 + "iframe.bounds", rectDouble);
            int n = MdiUiProvider.this.desktop.getWidth();
            int n2 = MdiUiProvider.this.desktop.getHeight();
            rectDouble2 = rectDouble2.scale(n, n2);
            rectDouble2.setX(Math.min((double)(n - 40), Math.max(0.0, rectDouble2.getX())));
            rectDouble2.setY(Math.min((double)(n2 - 40), Math.max(0.0, rectDouble2.getY())));
            rectDouble2.setWidth(Math.min((double)n, Math.max(40.0, rectDouble2.getWidth())));
            rectDouble2.setHeight(Math.min((double)n2, Math.max(40.0, rectDouble2.getHeight())));
            this.frame.setBounds(rectDouble2.toRect());
            try {
                this.frame.setMaximum(preferences.getBool(string2 + "iframe.isMaximized", false));
                this.frame.setIcon(preferences.getBool(string2 + "iframe.isIconified", false));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            this.firePluginUIEvent(new PluginUIEvent(this, 4));
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            this.firePluginUIEvent(new PluginUIEvent(this, 5));
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        private class MdiInternalFrame
        extends FixedJInternalFrame {
            public MdiInternalFrame() {
                super("", true, true, true, true);
                this.setContentPane(new JPanel());
            }

            public Dimension getMinimumSize() {
                Insets insets = this.getInsets();
                Dimension dimension = this.getContentPane().getLayout().minimumLayoutSize(this.getContentPane());
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
                return dimension;
            }
        }
    }

    private class MdiPrefsMenu
    extends PrefsMenu {
        public MdiPrefsMenu() {
            JMenuItem jMenuItem = I18n.get(class$free$jin$ui$MdiUiProvider == null ? (class$free$jin$ui$MdiUiProvider = MdiUiProvider.class$("free.jin.ui.MdiUiProvider")) : class$free$jin$ui$MdiUiProvider).createMenuItem("backgroundPrefsMenuItem");
            this.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    Preferences preferences = Jin.getInstance().getPrefs();
                    String string2 = preferences.getString("desktop.wallpaper.filename", null);
                    File file = string2 == null ? null : new File(string2);
                    BackgroundChooser backgroundChooser = new BackgroundChooser(MdiUiProvider.this.mainFrame, MdiUiProvider.this.desktop, null, null, 1, MdiUiProvider.this.desktop.getBackground(), file, MdiUiProvider.this.desktop.getWallpaperLayoutStyle());
                    backgroundChooser.setVisible(true);
                    Color color = backgroundChooser.getColor();
                    File file2 = backgroundChooser.getImageFile();
                    int n = backgroundChooser.getImageLayoutStyle();
                    preferences.setColor("desktop.bgcolor", color);
                    preferences.setString("desktop.wallpaper.filename", file2 == null ? null : file2.getAbsolutePath());
                    switch (n) {
                        case 1: {
                            string = "center";
                            break;
                        }
                        case 2: {
                            string = "tile";
                            break;
                        }
                        case 3: {
                            string = "scale";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    preferences.setString("desktop.wallpaper.layout", string);
                }
            });
        }
    }

    private class ConnectionMenu
    extends JMenu
    implements ActionListener,
    SessionListener {
        private static final int MAX_RECENT_LIST = 5;
        private final JMenuItem newConnection;
        private final JMenuItem closeConnection;
        private final JMenuItem exit;
        private final Vector recentAccounts;
        private final int separatorIndex;

        public ConnectionMenu() {
            I18n i18n = I18n.get(class$free$jin$ui$MdiUiProvider == null ? (class$free$jin$ui$MdiUiProvider = MdiUiProvider.class$("free.jin.ui.MdiUiProvider")) : class$free$jin$ui$MdiUiProvider);
            i18n.initAbstractButton(this, "connectionMenu");
            this.newConnection = i18n.createMenuItem("newConnectionMenuItem");
            this.add(this.newConnection);
            this.closeConnection = i18n.createMenuItem("closeConnectionMenuItem");
            this.add(this.closeConnection);
            this.separatorIndex = this.getItemCount();
            this.addSeparator();
            this.exit = i18n.createMenuItem("exitJinMenuItem");
            this.add(this.exit);
            this.exit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.newConnection.addActionListener(this);
            this.closeConnection.addActionListener(this);
            this.exit.addActionListener(this);
            this.recentAccounts = this.loadRecentAccounts();
            this.updateRecentAccountsMenuItems();
            this.setConnected(false, null);
        }

        public void addNotify() {
            super.addNotify();
            Jin.getInstance().getConnManager().addSessionListener(this);
            Session session = Jin.getInstance().getConnManager().getSession();
            this.setConnected(session != null, session);
        }

        public void removeNotify() {
            super.removeNotify();
            Jin.getInstance().getConnManager().removeSessionListener(this);
        }

        public void sessionEstablished(SessionEvent sessionEvent) {
            this.setConnected(true, sessionEvent.getSession());
        }

        public void sessionClosed(SessionEvent sessionEvent) {
            this.setConnected(false, sessionEvent.getSession());
        }

        public void setConnected(boolean bl, Session session) {
            this.newConnection.setEnabled(!bl);
            this.closeConnection.setEnabled(bl);
            if (!bl && session != null) {
                User user = session.getUser();
                if (Jin.getInstance().isKnownUser(user) && !user.isGuest()) {
                    this.recentAccounts.removeElement(user);
                    this.recentAccounts.insertElementAt(user, 0);
                    this.updateRecentAccountsMenuItems();
                    this.saveRecentAccounts(this.recentAccounts);
                }
            }
            this.setRecentAccountsMenuItemsEnabled(!bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionManager connectionManager = Jin.getInstance().getConnManager();
            Object object = actionEvent.getSource();
            if (object == this.newConnection) {
                connectionManager.displayNewConnUI();
            } else if (object == this.closeConnection) {
                Object object2 = OptionPanel.OK;
                Session session = Jin.getInstance().getConnManager().getSession();
                if (session != null && session.isConnected()) {
                    object2 = I18n.get(class$free$jin$ui$MdiUiProvider == null ? (class$free$jin$ui$MdiUiProvider = MdiUiProvider.class$("free.jin.ui.MdiUiProvider")) : class$free$jin$ui$MdiUiProvider).confirm(OptionPanel.OK, "closeConnectionConfirmationDialog");
                }
                if (object2 == OptionPanel.OK) {
                    connectionManager.closeSession();
                }
            } else if (object == this.exit) {
                Jin.getInstance().quit(true);
            } else {
                int n = Utilities.indexOf(this.getMenuComponents(), object);
                User user = (User)this.recentAccounts.elementAt(n - this.separatorIndex - 1);
                connectionManager.displayNewConnUI(user);
            }
        }

        private void updateRecentAccountsMenuItems() {
            while (this.getItem(this.separatorIndex + 1) != this.exit) {
                this.remove(this.separatorIndex + 1);
            }
            I18n i18n = I18n.get(class$free$jin$ui$MdiUiProvider == null ? (class$free$jin$ui$MdiUiProvider = MdiUiProvider.class$("free.jin.ui.MdiUiProvider")) : class$free$jin$ui$MdiUiProvider);
            for (int i = 1; i <= this.recentAccounts.size(); ++i) {
                User user = (User)this.recentAccounts.elementAt(i - 1);
                String string = i18n.getFormattedString("recentAccountMenuItem.text", new Object[]{user.getUsername(), user.getServer().getShortName()});
                JMenuItem jMenuItem = new JMenuItem(i + " " + string);
                if (i <= 9) {
                    jMenuItem.setDisplayedMnemonicIndex(0);
                }
                jMenuItem.addActionListener(this);
                this.insert(jMenuItem, this.separatorIndex + i);
            }
            if (this.recentAccounts.size() != 0) {
                this.insertSeparator(this.separatorIndex + this.recentAccounts.size() + 1);
            }
        }

        private void setRecentAccountsMenuItemsEnabled(boolean bl) {
            for (int i = 1; i <= this.recentAccounts.size(); ++i) {
                this.getItem(this.separatorIndex + i).setEnabled(bl);
            }
        }

        private Vector loadRecentAccounts() {
            Vector<User> vector = new Vector<User>(5);
            Preferences preferences = Jin.getInstance().getPrefs();
            int n = preferences.getInt("accounts.recent.count", 0);
            for (int i = 0; i < n; ++i) {
                User user;
                String string = preferences.getString("accounts.recent." + i + ".username");
                String string2 = preferences.getString("accounts.recent." + i + ".serverId");
                Server server = Jin.getInstance().getServerById(string2);
                if (server == null || (user = Jin.getInstance().getUser(server, string)) == null) continue;
                vector.addElement(user);
                if (vector.size() == 5) break;
            }
            return vector;
        }

        private void saveRecentAccounts(Vector vector) {
            Preferences preferences = Jin.getInstance().getPrefs();
            int n = vector.size();
            preferences.setInt("accounts.recent.count", n);
            for (int i = 0; i < n; ++i) {
                User user = (User)vector.elementAt(i);
                String string = user.getUsername();
                String string2 = user.getServer().getId();
                preferences.setString("accounts.recent." + i + ".username", string);
                preferences.setString("accounts.recent." + i + ".serverId", string2);
            }
        }
    }
}

