/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/
// compiler message: "GoGrinder.ui.ProbFrame.java uses or overrides a deprecated API."

package GoGrinder.ui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;

import GoGrinder.*;
import GoGrinder.sgf.Validator;
import com.Ostermiller.util.Browser;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
public class ProbFrame extends JFrame {
    public static ProbFrame inst;
    
    private FileUtils fileUtils;
    private GobanPanel goban;
    private WidgetPanel wp;
    private JLabel statusBar;
    private JToggleButton advanceButton;
    private JButton buttonEdit2;

    private long lastNextTime = 0;
//    private Validator localValidator;
    private SGFController sgfController;
    private JMenuItem wgfMenuItem;
    private boolean setFullScreenActive = GS.getFullScreen();
    private Rectangle windowNormalBounds = GS.getWindowedBounds();
    private int windowStatusNoFullScreen = GS.getWindowStatus(); // default = both (=6)
    private Box zwischengeflickt; // (Mac is komisch)
 //   public static boolean isStartup;
    
    public ProbFrame(SplashScreen splash) {
        super(Main.GRINDER_TITLE + Main.VERSION_STRING); //$NON-NLS-1$ // Messages.getString("gg_title")
  //      isStartup = true;
 //CharsetWorks.lastFolder = sgfController.getCurrentProblemPath().getParent();

// d.b.g(">" + CharsetWorks.lastFolder + "<");
        inst = this;
        URL iconURL = getClass().getResource("/GoGrinder/images/Icon.png"); //$NON-NLS-1$
        ImageIcon icon = new ImageIcon(iconURL);
        setIconImage(icon.getImage());
                
        Container cp = getContentPane();
        cp.setLayout(new BoxLayout(cp, BoxLayout.Y_AXIS));
        
        setJMenuBar(createMenuBar());
        // zwischengeflickt: because the Mac-menubar in fullscreen mode sometimes covers a part of the toolbar
        zwischengeflickt = new Box (BoxLayout.X_AXIS);
        zwischengeflickt.setMaximumSize(new Dimension(0, 25));
        zwischengeflickt.add(Box.createVerticalStrut(25));
        zwischengeflickt.setVisible(Main.IS_MAC && setFullScreenActive);
        cp.add(zwischengeflickt);
        
        Box toolPanel = new Box(BoxLayout.X_AXIS);
        // JToolBar myToolBar = createToolbar();
        toolPanel.add(createToolbar()); // myToolBar;
        toolPanel.add(Box.createHorizontalGlue());
        // Dimension toolPanelSize = new Dimension(toolPanelSize.setSize(400, 50)); 
         // myToolBar.getWidth() .. gave "0" - I don't know why 

        toolPanel.setMaximumSize(new Dimension(450, 50))  ;// toolPanelSize
        cp.add(toolPanel);
        
        JPanel topPanel = new JPanel(new BorderLayout());
        
        sgfController = new SGFController();
        
        splash.setStatus(Messages.getString("loading_images")); //$NON-NLS-1$
// Main.splashStartUp = false;
        Board board = new Board(19);
        goban = new GobanPanel(board);
        
        topPanel.add(goban, BorderLayout.CENTER);
        
        JPanel eastPanel = new JPanel(new BorderLayout());
        
        wp = new WidgetPanel(sgfController);
        
        eastPanel.add(wp, BorderLayout.NORTH);
        topPanel.add(eastPanel, BorderLayout.EAST);
        
        cp.add(topPanel);
        
        board.setPanel(goban);
        sgfController.setPanel(goban); // is there a difference between goban and board?? (better: what is...)
                                       // maybe one is organizing, the other is optics
        sgfController.setBoard(board);
        sgfController.setWidgetPanel(wp);
        
        goban.setController(sgfController);
        
        JTextArea commentArea = new JTextArea();
        commentArea.setLineWrap(true);
        commentArea.setWrapStyleWord(true);
        commentArea.setEditable(false);
        
        JScrollPane scrollPane = new JScrollPane(commentArea,
                                                 JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                                 JScrollPane.HORIZONTAL_SCROLLBAR_NEVER) {
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if(d.height < 90)
                    return new Dimension(d.width, 90);
                return d;
            }
            public Dimension getMinimumSize() {
                return new Dimension(0, 90);
            }
        };
        cp.add(scrollPane);
        
        Box statusBox = new Box(BoxLayout.X_AXIS);
        statusBar = new JLabel(" "); //$NON-NLS-1$
        statusBox.add(statusBar);
        statusBox.add(Box.createHorizontalGlue());
        cp.add(statusBox);
        sgfController.setStatusBar(statusBar);
        
        sgfController.setCommentArea(commentArea);
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                Main.onExit();
            }
        });
                
        addComponentListener(new ComponentAdapter() {
            public void componentResized(ComponentEvent e) {
                boolean resize = false;
                int h = getHeight();
                int w = getWidth();
                
                Dimension gSize = goban.getMinimumSize();
                Dimension wpSize = wp.getPreferredSize();
                
                int minWidth = gSize.width + wpSize.width + 30;
                if(w < minWidth) {
                    w = minWidth;
                    resize = true;
                }
                
                int minHeight = gSize.height + 275; // here we should adjust/switch values, if we have a user option "small screen"
                if(h < minHeight) {
                    h = minHeight;
                    resize = true;
                }
                
                if(resize)
                    setSize(w, h);
            }
        });
        
        //setBounds(GS.getProbFrameBounds());
        onSetScreenAppearance(true); //true: isStartUp
        
        //fileUtils = new FileUtils(new JFileChooser()); // initializes the tags, if it is the program's first use
        fileUtils = new FileUtils(); // initializes the tags, if it is the program's first use
    }
    
    public void selectFirstProb() {
        
        if(GS.getSelectedSets().isEmpty())
            onSelectProbs();
        else 
          sgfController.nextProblem();
//        sgfController.currentProblem.charsetW.startup(); 
    }
    
     // ################## TOOL_BAR ####################################################################################
    public JToolBar createToolbar() { 
        JToolBar bar = new JToolBar();
        bar.setFloatable(false); // switch this in settings?
        
      // SELECT SET OF PROBLEMS TO SOLVE
        JButton b = new JButton(Main.getIcon("Zoom16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("select_problems")); //$NON-NLS-1$
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onSelectProbs();
            }
        });
        bar.add(b);
        
      // EDIT SGF OF CURRENT PROBLEM IN EXTERNAL EDITOR // could be a testEdited(): if changed file date, 
                                                       // then send a copy to folder "edited" (set this in settings)
                                                       // or, when edited for repairing: test for valid sgf etc.
                                                       // set visible on/off from the settings menu; all editors in a menu
        JButton buttonEdit1;
        buttonEdit1 = new JButton(Main.getIcon("Edit16-1.gif", this)); //$NON-NLS-1$
        buttonEdit1.setToolTipText(Messages.getString("ProbFrame.EditCurrentProb")); //$NON-NLS-1$
        buttonEdit1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onEdit(1);
            }
        });
        bar.add(buttonEdit1);
        boolean buttonEdit1Visible = true; // later we can change this to be set from the settings
        buttonEdit1.setVisible(buttonEdit1Visible);
        
        buttonEdit2 = new JButton(Main.getIcon("Edit16-2.gif", this)); //$NON-NLS-1$ // 
        buttonEdit2.setToolTipText("2nd editor, can also be a text editor"); //$NON-NLS-1$ 
                                 // Messages.getString("ProbFrame.EditCurrentProb")
        buttonEdit2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onEdit(2);
            }
        });
        bar.add(buttonEdit2);
        buttonEdit2.setVisible(GS.getShow2ndEditorButton());
        
        bar.addSeparator();

      // PREVIOUS PROBLEM IN CURRENT SELECTION
        ActionListener prevListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                sgfController.prevProblem();
            }
        };

      // previous problem (button)
        b = new JButton(Main.getIcon("Back16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("prev_problem")); //$NON-NLS-1$
        b.addActionListener(prevListener);
        bar.add(b);
        
        b.registerKeyboardAction(prevListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_Z, 0),
                                 JComponent.WHEN_IN_FOCUSED_WINDOW);   // keys "z" / "x" adapt to local keyboards
        
        b.registerKeyboardAction(prevListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_COMMA, 0),
                                 JComponent.WHEN_IN_FOCUSED_WINDOW); // keys "." / "," - are they on all local keyboads at the same place?
        
      // NEXT PROBLEM IN CURRENT SELECTION
        ActionListener nextListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              long now = System.currentTimeMillis();
              if(now - lastNextTime >= 350) { // why the delay here, but not for the prevListener
                lastNextTime = now;           // perhaps this is also called, when problem is solved?;
                sgfController.nextProblem();
              }
            }
        };
      // next problem (button)
        b = new JButton(Main.getIcon("Forward16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("next_problem")); //$NON-NLS-1$
        b.addActionListener(nextListener);
        bar.add(b);
        
        b.registerKeyboardAction(nextListener,  // "This method is now obsolete, please use a combination of 
                                                //   getActionMap() and getInputMap() for similiar behavior."
                                 KeyStroke.getKeyStroke(KeyEvent.VK_X, 0),
                                 JComponent.WHEN_IN_FOCUSED_WINDOW); 
                                 // keys "z" / "x" adapt to local keyboards
        
        b.registerKeyboardAction(nextListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_PERIOD, 0),
                                 JComponent.WHEN_IN_FOCUSED_WINDOW); 
                                 // keys "." / "," - are they on all local keyboads at the same place?

      // FIND SGF WHERE NAME CONTAINS _STRING_ IN CURRENT SELECTION (probably it shouldn't take sgf/.sgf as search term)
        b = new JButton(Main.getIcon("Find16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("find_problem")); //$NON-NLS-1$
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onFind();
            }
        });
        bar.add(b);
        
        bar.addSeparator();


      // TOGGLE AUTO ADVANCE
        advanceButton = new JToggleButton(Main.getIcon("Play16.gif", this)); //$NON-NLS-1$
        advanceButton.setToolTipText(Messages.getString("auto_advance")); //$NON-NLS-1$
        advanceButton.setSelected(GS.getAutoAdv());
        advanceButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                GS.setAutoAdv(!GS.getAutoAdv());
            }
        });
        bar.add(advanceButton);
        
      // PREFERENCES
        JButton prefsButton = new JButton(Main.getIcon("Preferences16.gif", this)); //$NON-NLS-1$
        prefsButton.setToolTipText(Messages.getString("preferences")); //$NON-NLS-1$
        prefsButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
         // when too many buttons can be activated / deactivated, it will look a bit canfusing here
                Main.showPrefs(ProbFrame.this);
              // onSettingsWindowClosed
                buttonEdit2.setVisible(GS.getShow2ndEditorButton());

                wgfMenuItem.setVisible(GS.getEnableWGFEditor());
                advanceButton.setSelected(GS.getAutoAdv());
                // ToolTipManager.sharedInstance().setDismissDelay(4000); // we've set it to 10 seconds in the settings frame
            }
        }); 
        prefsButton.setVisible(true);
        bar.add(prefsButton);

        bar.addSeparator();
        
      // IMPORT FROM goproblems.com PROBLEMS ARCHIVE (NAME.tgz [.tar.gz archive]) // I couldn't find a GoGrinder version, where this worked
      // DEACTIVATED BECAUSE FUNCTION NOW ONLY FOR PAYING MEMBERS OF goproblems.com
/*        b = new JButton(Main.getIcon("Export16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("extract_problems")); //$NON-NLS-1$ // "only if you are a paying member ..."
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              ProgressDialog p = new ProgressDialog(ProbFrame.this, Messages.getString("extracting_problems"), new Task() { //$NON-NLS-1$
                public void doTask() {
                  fileUtils.extractProblems(progDlg); 
                }   // this method ( extractProblems() ) has been deleted from FileUtils
                    // would be nice to reactivate this chapter anyhow, maybe with 
                    // a tool to spread them to the kyu/dan folders 
                    // (see disort @ sensei's)
                    // even better: if you already have a collection and update 
                    // it, you could resort them together with the stats files 
                    // (see update-disorted @ sensei's)
              });
              wp.fillTagCB();

              if(p.getSucceeded())
                ReloadDialog.reloadProblems(ProbFrame.this);
            }
        });
        bar.add(b);
*/
        
        bar.addSeparator();
              // Button "Testing" BEGIN ###############################################################
        b = new JButton("testing"); //$NON-NLS-1$
        b.setToolTipText("testing while coding"); //$NON-NLS-1$
        b.addActionListener(new ActionListener(){
          public void actionPerformed(ActionEvent e) {
            onTesting();
            // static String settingsfolder = getenv(String name) //Gets the value of the specified environment variable.
            // System.out.println(System.getenv("MYGG_SETTINGS"));
            // System.out.println(System.getenv("MYGG_DOCS"));
          }
        });
        if (Main.TEST)bar.add(b); 
      // Button "Testing" END

        bar.addSeparator();

      // FULL SCREEN ACTION
        // setFullScreenActive = GS.getFullScreen();
        ActionListener fullScreenListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              onSetScreenAppearance(false);
            }
        };
      
      // #################### Mac: change F11 to e.g. Ctrl-F11 ###########################################################
      // FULLSCREEN (BUTTON)
        b = new JButton(Main.getIcon("fullscreen.gif", this)); //$NON-NLS-1$
        b.setToolTipText("Full screen"); //$NON-NLS-1$
        b.addActionListener(fullScreenListener);
        if (Main.IS_MAC)
          {b.registerKeyboardAction(fullScreenListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_F11, InputEvent.CTRL_DOWN_MASK ), 
                                 // I thought of Ctrl-F11 or similar - this here doesn't work
                                 JComponent.WHEN_IN_FOCUSED_WINDOW);
        }
        //getKeyStroke(Character keyChar, int modifiers)
        else {
          b.registerKeyboardAction(fullScreenListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_F11, 0),
                                 JComponent.WHEN_IN_FOCUSED_WINDOW);
        }
       
        bar.add(b);

      // ABOUT WINDOW (FURTHER BUTTON THERE FOR SYSTEM'S INFO)
        b = new JButton(Main.getIcon("About16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("about_gg")); //$NON-NLS-1$
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AboutDialog d = new AboutDialog(ProbFrame.this, true);
                d.setVisible(true);
            }
        });
        bar.add(b);
        
      // HELP ON GOGRINDER
        b = new JButton(Main.getIcon("Help16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("help")); //$NON-NLS-1$
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) { 
              showLocalHtmlFile(Main.pathToDocs, "docs.html");
            }
        });
        bar.add(b);
        
        return bar;
    }
    
     // ################## ON_XY... ####################################################################################
    private void showLocalHtmlFile(String baseDir, String htmlFile){
      File f = new File(baseDir + File.separator + htmlFile); //$NON-NLS-1$ //$NON-NLS-2$
      if (!f.exists() ){
        d.b.g("Path to help files is apparently wrong: \n" + baseDir + "\nCouldn't find help file " + htmlFile);
        return;
      }
      String url = null;
      try { // THIS DOESN'T  LIKE "#" IN THE PATH !! (browser-problem, file:///E:/%23/docs/download.html is needed)
          url = f.toURL().toString(); // ... .toURI().toURL(). ...
          Browser.displayURL(url); // ostermiller
      }
      catch(Exception ex) {
          JOptionPane.showMessageDialog(ProbFrame.this, Messages.getString("couldnt_display_url")
                                                      + " " + url
                                                      + "\n" + Messages.getString("see_grind_log"));
          Main.logSilent(ex);
      }
    }
    
    public void onTesting() {
    //d.b.g(Params.getCompilerVersion());
     //onChangeTextDisplay();
    //GoGrinder.FileWReadWrite.writeFileStrCharset("e:\\$\\xy.txt", "blubb \u65e0\u6cd5\u663e\u793aURL", "xyz");
    //GoGrinder.sgf.SGFLog.X_SGFLog(3, "D:\\Dokumente und Einstellungen\\erster\\TESTGrinderSettings\\problems\\verschieben\\1.sgf", "Pooops\n", "(;SZ[3])" );
//sgfController.test();
//onChangeTextDisplay();
//FileWCpMv.FileWCpMvSGF(sgfController.getCurrentProblemPath(), "edited", true, FileWCpMv.COPY);
//FileWCpMv.FileWCpMvSGF(sgfController.getCurrentProblemPath(), "defect", true, FileWCpMv.MOVE);
//GoGrinder.CharsetWorks c = new GoGrinder.CharsetWorks(sgfController.getCurrentProblemPath());
//String chars = c.getCharset();

//GoGrinder.CharsetWorks.getCharset(sgfController.getCurrentProblemPath());
  //d.b.g(chars);
//sgfController.nextProblem(); // wenn wir im rckwrtsgang waren, dann sollten wir den beibehalten
    //d.b.g("nix");
// for(int i=0;i<20;i++){d.b.g(Main.rand.nextInt(5));}
      //d.b.g("GOT YOU! " + sgfController.getCurrentProblemPath());
      Toolkit.getDefaultToolkit().beep();                     // TEST
    }
   
    public void onFind() { // here could be more options
        String sub = JOptionPane.showInputDialog(this, Messages.getString("enter_part_of_filename")); //$NON-NLS-1$
        if(sub == null)                                                 // ProbFrame. ...
          return;
        if(".sgf".indexOf(sub) > -1){ // so "." or ".s" is excluded as well as "sgf"
          JOptionPane.showMessageDialog(this, "You shouldn't search for the file name extension (.sgf)"); 
          return; // Messages.getString("ProbFrame.NoValidFindTerm") // would be better not to search in the extension
        }
        if(!sgfController.findProblem(sub))
        // the result is the first matching sgf; a subsequent search gives the next 
        //   matching sgf until the end of the collection is reached
        // * could also search _in_ the sgf, for e.g. in comment "Ko", 
        //    in USer "ferdi" (an author of nice mini problems), SZ = 9 etc.
        // * should search the whole collection (switch: allProbs, currSelect)
        // * result should be a list to choose from (or can use the result as new selection)
        // * should not search "sgf" in extensions
            JOptionPane.showMessageDialog(this, Messages.getString("no_matching_probs_found")); //$NON-NLS-1$
    }                                                            // ProbFrame. ...
    
    private void onEdit(int editorNumber) {
      String editWith = "";
      switch (editorNumber){
        case 1: {editWith = GS.getSGFEditor1Str(); break;}
        case 2: {editWith = GS.getSGFEditor2Str(); break;}
      }
      // copy file to tmp; if edited (closed editor, needs wait for finish editor)
      //   compare file date and if changed, move temp file to (if defect = SETTINGS/defect/PATH/NAME (with datetime?))
      //                                                       (else SETTINGS/edited/PATH/NAME (with datetime?))
      // (if exist - don't overwrite, just delete temp file - there were some more edits)
      // delete also, if no edits have been done
      boolean result = EditorStarter.editorStarter(editWith, sgfController.getCurrentProblemPath());
      // would be nice to reload the problem, after it has been edited (controller, parser,...)
      return;
    }
    
    private static final int SAVEREVISION = 2;
    public void onOpen() {// THIS BELONGS TO THE PROGRESS FILES *.GGS
        String filename = FileWorks.selectFile(this, FileFilters.ggsFilter, Messages.getString("open_file"),
                                               false, Messages.getString("open"));
        //                Main.chooseFile(this, FileFilters.ggsFilter, Messages.getString("open_file"), //$NON-NLS-1$
        //                            false, Messages.getString("open")); //$NON-NLS-1$
        if(filename == null)
            return;
        
        try {  // Could this be a part of FileWorks?
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));

            int rev = in.readInt();
            if(rev > SAVEREVISION) {
                JOptionPane.showMessageDialog(null, Messages.getString("err_data_file_newer")); //$NON-NLS-1$
                return;
            }

            Selection sel = (Selection)in.readObject(); 
            in.close();  // use new stats; 
                         // THIS BELONGS TO THE PROGRESS FILES *.GGS
            if(sel.isEmpty())
                return;
        
            GS.setSelection(sel);
            sgfController.nextProblem();
        }
        catch(Exception e) {
            Main.log(e);
        }
    }
    
    public void onSave() {  // das koennte auch in file utils laufen //Main.chooseFile
        String filename = FileWorks.selectFile(this, FileFilters.ggsFilter, Messages.getString("save_state"), //$NON-NLS-1$
                                    true, Messages.getString("save")); //$NON-NLS-1$
        if(filename == null)
            return;
        if (new File(filename).exists() && !SelectionDialog.OKCancelMsg("Save progress: overwrite existing file?", "Overwrite?")){
          return;
        }
        

        
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeInt(SAVEREVISION);
            out.writeObject(GS.getSelectedSets()); // Grinder saves the complete path (not portable and old Grinder cannot
                    // use new stats; I couldn't find out, how to reduce the path to _relative_to_$GGSETTINGS_)
            out.close();
        }
        catch(Exception e) {
            Main.log(e);
        }
    }
    
    public void onImport() {
        ProgressDialog p = new ProgressDialog(this, Messages.getString("importing_problems"), new Task() { //$NON-NLS-1$
            public void doTask() {
                doImport(progDlg);
            }
        });
        
        if(p.getSucceeded())
            ReloadDialog.reloadProblems(this); 
            // this is also interesting, when program sends msg, that the collection changed
    }
    
     // ############# this in extra class? ###############
    public void doImport(ProgressDialog progDlg) {  // not better to have this in FileUtils or FileWorks? 
                                                    //  "Main.chooseFile(...": the same! //Main.chooseFile
        String filename = FileWorks.selectFile(this, FileFilters.gxpFilter, Messages.getString("import_problems"), //$NON-NLS-1$
                                    false, Messages.getString("import")); //$NON-NLS-1$
        if(filename == null) {
            progDlg.setSucceeded(false);
            return;
        }

        try {
            ZipInputStream zin = new ZipInputStream(
                                 new BufferedInputStream(
                                 new FileInputStream(filename)));
            zin.getNextEntry();
            
            ObjectInputStream in = new ObjectInputStream(zin);

            int rev = in.readInt();
            if(rev > Main.EXPORTREVISION) {
                String msg = Messages.getString("err_data_file_newer");
                JOptionPane.showMessageDialog(null, msg); //$NON-NLS-1$
                Main.log(new Exception());
                in.close();
                return;
            }
         
            int num = in.readInt();
            progDlg.setMaximum(num);
            
            boolean choseAll = false; // overwrite sgf with newer file date
            boolean choseYes = false;
            
            for(int i = 0; i < num; i++) {
                progDlg.bump();
                int pathToProblemsLength = Main.pathToProblems.length() + 1; 
                //   D:\ users\myuser\TESTGrinderSettings\problems\myproblem.sgf
                //                                                ^
                 // ######### WHAT ABOUT PORTABLE?? #######
                File f = (File)in.readObject();
                long impFileTime = in.readLong();
                String sgf = (String)in.readObject();
                HashSet tags = (HashSet)in.readObject();

                String f_st = f.getPath();
                if (!f_st.endsWith(".sgf")) continue; // we only import a file, if its name ends with ".sgf"
                if (f_st.startsWith("problems")){ //   problems\myproblem.sgf // up to now this is to be expected
                  f_st = Main.pathToSettings + Main.SLASH + f_st; 
                  // D:\ users\myuser\TESTGrinderSettings\problems\myproblem.sgf
                  // ######### WHAT ABOUT PORTABLE?? #######
                }else{
                  continue; // Up to now we don't expect to get a .gxp file with 
                            // archived files from outside of a "problems" directory.
                            // But nonetheless the import should always be done into the problems directory
                }                                                 //                                     ^ ^
// JOptionPane.showMessageDialog(null, f_st); 
                f = new File(f_st);

                // this helps (should help) against the zip slip thing (read https://snyk.io/research/zip-slip-vulnerability)
                if (!f.getPath().equals(f.getCanonicalFile().getPath())){
                    boolean abort = d.b.yes("Path possibly doesn't end in our \"problems\" directory!\n" 
                                         + "We skip this file:\n" 
                                         + f.getPath() + " (dirty path)\n" 
                                         + f.getCanonicalFile().getPath() + " (cleaned path)\n"
                                         + "Origin = " + filename + "\n"
                                         + "Abort the import now?");
                    // log(common, msg);
                    if(abort) break;
                    /*else*/continue; // next file - but if someone trys to cheat us with 
                                      // an irregular path, why not abort the import here?
                }
                
                if(f.exists() && f.lastModified() != impFileTime) { 
                  // ?? - asks you for overwrite if new file is older OR NEWER
                    if(choseAll) {
                        if(!choseYes)  // and I thought, choseAll is choseYes included...
                            continue;
                    }
                    else {
                        ChoiceDialog c = new ChoiceDialog(this, f, impFileTime, sgf.length()); // --> ChoiceDialog.java
                        int ch = c.getSelection();
                        switch(ch) {
                            case ChoiceDialog.YES_OPTION:
                                break;
                            case ChoiceDialog.NO_OPTION:
                                continue;
                            case ChoiceDialog.YES_ALL_OPTION:
                                choseAll = choseYes = true;
                                break;
                            case ChoiceDialog.NO_ALL_OPTION:
                                choseAll = true;
                                choseYes = false;
                                continue;
                            default: ;
                        } // what happens with [esc]/[x] ?
                    }
                }
                else {
                    File dir = f.getParentFile();
                    if(!dir.exists()) {
                        if(!dir.mkdirs()) {
                            JOptionPane.showMessageDialog(this, Messages.getString("couldnt_create_dir") + " " + dir.getPath()); //$NON-NLS-1$ //$NON-NLS-2$
                            in.close();
                            return;
                        }
                    }
                }
                
                if(!f.exists() || f.lastModified() != impFileTime) {
                    PrintWriter out = new PrintWriter(new FileWriter(f));
                    out.println(sgf);
                    out.close();
                    
                    f.setLastModified(impFileTime);
                }
                
                // Merge stats, replacing tags  // can merge tags here?
                ProbData p = new ProbData(null, f);
                p.loadStats();
                p.setTags(tags);
                p.saveStats();
                
                GS.getTagList().addTags(tags);
            }
            
            in.close();
        }
        catch(Exception e) {
            Main.log(e);
        }
    }

  // #############################  MENU_BAR  ##########################################################
    private JMenuBar createMenuBar() {
      JMenuBar myMenuBar = new JMenuBar();
      
      // FILE
      JMenu fileMenu = new JMenu("File");
      
      JMenuItem mItem = new JMenuItem("New filter...");
      mItem.setIcon(null);
      //fileMenu.add(mItem);
      
      mItem = new JMenuItem("Load filter ...");
      mItem.setIcon(null);
      //fileMenu.add(mItem);

      mItem = new JMenuItem("Save filter ...");
      mItem.setIcon(null);
      //fileMenu.add(mItem);

      mItem = new JMenuItem("xyz ...");
      mItem.setIcon(null);
      //fileMenu.add(mItem);
      
      mItem = new JMenuItem("Exit ...");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Main.onExit();
            }
      });
      fileMenu.add(mItem);
      
      myMenuBar.add(fileMenu);
      
      JMenu problemsMenu = new JMenu("Problems");
      
      mItem = new JMenuItem("Select");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onSelectProbs();
        }
      });
      problemsMenu.add(mItem);
      
//      mItem = new JMenuItem("Export"); // maybe we better have export and import only in the selection window
//      mItem.setIcon(null);
//      problemsMenu.add(mItem);
      
      mItem = new JMenuItem("Import");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onImport();
        }
      });
      problemsMenu.add(mItem);
      
      mItem = new JMenuItem("xyz");
      mItem.setIcon(null);
      //problemsMenu.add(mItem);
      myMenuBar.add(problemsMenu);
      
      // STATISTICS
      JMenu statsMenu = new JMenu("Statistics");
      
      mItem = new JMenuItem("View ...");
      mItem.setIcon(null);
      //statsMenu.add(mItem);
      
      mItem = new JMenuItem("Reset ..."); // "you are sure?"
      mItem.setIcon(null);
      //statsMenu.add(mItem);
      
      mItem = new JMenuItem("Open progress file");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onOpen();
        }
      });
      statsMenu.add(mItem);
      
      mItem = new JMenuItem("Save progress");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          // JOptionPane.showMessageDialog(null, "This file can only be used in this installation");
          onSave();
        }
      });
      statsMenu.add(mItem);
      
      mItem = new JMenuItem("Save progress as ...");
      mItem.setIcon(null);
      //statsMenu.add(mItem);
      
      mItem = new JMenuItem("XYZ ...");
      mItem.setIcon(null);
      //statsMenu.add(mItem);
     
      myMenuBar.add(statsMenu);
      
      // FIND
      JMenu findMenu = new JMenu("Find");
      
      mItem = new JMenuItem("Find by name"); // (shall give a list to choose from)
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onFind();
        }
      });
      findMenu.add(mItem);
      
      mItem = new JMenuItem("Find by content"); // NOT YET (and shall give a list to choose from)
      mItem.setIcon(null);
      //findMenu.add(mItem);
      
      myMenuBar.add(findMenu);
      
      // VIEW
      JMenu viewMenu = new JMenu("View");
      
      mItem = new JMenuItem("Change text decoding");
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onChangeTextDisplay();
        }
      });
      viewMenu.add(mItem);
      
       // #################### Mac: change F11 to e.g. Ctrl-F11 ###########################################################
      mItem = new JMenuItem(); // not in Mac!
      if (Main.IS_MAC) mItem.setText("Toggle full screen view"); //  (Ctrl+F11) // Doesn't work
      else mItem.setText("Toggle full screen view (F11)");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onSetScreenAppearance(false);
        }
      });
      viewMenu.add(mItem);
      
      mItem = new JMenuItem("Hide/Show menu (F10)"); // + ALT + moveMouseToTop=shows temporary, // if Sys is mac: don't show "F10" // we have "Main.IS_MAC" (F10 - MENU! F11 - FullScreen)
      mItem.setIcon(null); // F10: may not work with Mac!
      //viewMenu.add(mItem);

      myMenuBar.add(viewMenu);
       
      // TOOLS
      JMenu toolsMenu = new JMenu("Tools");

      mItem = new JMenuItem("Edit with 1st editor");
      mItem.setIcon(null);
      // .addActionListener(new ActionListener() { actionPerf. })
      // public void actionPerformed(ActionEvent e) { actions }
      //toolsMenu.add(mItem);

      mItem = new JMenuItem("Edit with 2nd Editor");
      mItem.setIcon(null);
      //toolsMenu.add(mItem);

      mItem = new JMenuItem("Settings");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          Main.showPrefs(ProbFrame.this);
          // onSettingsWindowClosed(); // when many buttons and menu entries
          //  can be activated/deactivated, it can become confusing here
          wgfMenuItem.setVisible(GS.getEnableWGFEditor());
          buttonEdit2.setVisible(GS.getShow2ndEditorButton());
          advanceButton.setSelected(GS.getAutoAdv());
          ToolTipManager.sharedInstance().setDismissDelay(4000); // we've set it to 10 seconds in the settings frame
        }
      });
      toolsMenu.add(mItem);
      
      mItem = new JMenuItem("Split SGF"); // you are sure?
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                fileUtils.splitFile();
            }
      });
      toolsMenu.add(mItem);
      
      mItem = new JMenuItem("Edit with 2nd editor");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onEdit(2); // #####################################################
            }
      });
      toolsMenu.add(mItem);

      mItem = new JMenuItem("Validate files");
      mItem.setToolTipText(Messages.getString("sel_dlg_tip_validate"));
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onValidate();
            }
      });
      toolsMenu.add(mItem);
      
      wgfMenuItem = new JMenuItem("WGF editor");
      wgfMenuItem.setIcon(null);
      wgfMenuItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          Main.switchState();
        }
      });
      wgfMenuItem.setVisible(GS.getEnableWGFEditor());
      toolsMenu.add(wgfMenuItem);
      
      myMenuBar.add(toolsMenu);
      
      // HELP
      JMenu helpMenu = new JMenu("?");
      mItem = new JMenuItem("How to use"); //$NON-NLS-1$
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) { 
               showLocalHtmlFile(Main.pathToDocs, "docs.html");
            }
        }); 
      helpMenu.add(mItem);
      
      mItem = new JMenuItem("System info"); //$NON-NLS-1$
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          SysInfoDialog d = new SysInfoDialog(ProbFrame.this, true);
          d.setVisible(true);
        }
      }); 
      helpMenu.add(mItem);
      
      mItem = new JMenuItem("View log file"); // tooltip: not the startup log
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          // here should be something like DeskTop(...) but that only works in J6 and up
        }
      });
      // helpMenu.add(mItem);
      
      mItem = new JMenuItem(Messages.getString("about_gg")); //$NON-NLS-1$
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
                    AboutDialog d = new AboutDialog(ProbFrame.this, true);
                    d.setVisible(true);
        }
      }); 
      helpMenu.add(mItem);

      mItem = new JMenuItem("License");
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            showLocalHtmlFile(Main.pathToDocs, "license.html");
        }
      });
      helpMenu.add(mItem);
      
      mItem = new JMenuItem("mygogrinder @ sourceforge.net"); // tooltip: not the startup log
      mItem.setIcon(null);
      mItem.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          try { // http://sourceforge.net/project/mygogrinder
            Browser.displayURL(Main.PROJECTPAGE);
          }
          catch(IOException e4){
            JOptionPane.showMessageDialog(ProbFrame.this, Messages.getString("couldnt_display_url") + "\n"
                                                         + Main.PROJECTPAGE + "\n"
                                                         + Messages.getString("see_grind_log"));
            Main.logSilent(e4);
          }
        }
      });
      helpMenu.add(mItem);
      
      myMenuBar.add(helpMenu);
      
      boolean menuBarVisible = true; // idea: switch on/off with F10, viewable for a moment with [Alt]
      // menuBarVisible = GS.getMenuBarVisible()
      myMenuBar.setVisible(menuBarVisible);
      // toggleMenuBar() mit F10
      return myMenuBar;
    }
  // ##############################  MENU BAR end  ##############################

    private void onChangeTextDisplay(){
      sgfController.changeCharacterSet(); // sgfController
      if(sgfController.currentProblem.charsetW.filesCharsetChanged 
        || CharsetWorks.foldersCharsetChanged) sgfController.loadProblem(0); // (0 = restart same);
      GoGrinder.CharsetWorks.foldersCharsetChanged = false;
    }

    private void onSetScreenAppearance(boolean isStartUp){
      if (isStartUp){
        setBounds(GS.getWindowedBounds());
        setExtendedState(GS.getWindowStatus());
        setFullScreenActive = GS.getFullScreen();
        if(!setFullScreenActive) return;
      }
      else {setFullScreenActive = !setFullScreenActive;}
      if (setFullScreenActive != GS.getFullScreen()){ // notEqual: toggle! // else we're here on startup
        GS.setFullScreen(setFullScreenActive);
        if (setFullScreenActive){ // switching TO active
          GS.setWindowStatus(getExtendedState());
          setExtendedState(0); // window -> normal
          GS.setWindowedBounds(getBounds()); // save size normal window 
        }
        // bounds etc are saved, when we switch TO fullscreen, else on exit
        // getExtendedState(): 0 = normal, 6 = MAXIMIZED_BOTH (2 = MAXIMIZED_HORIZ, 4 = MAXIMIZED_VERT, 1 = iconized)
        dispose(); // dismiss previous view
      }//toggle
      
      if (setFullScreenActive) { //startup and toggle
        setUndecorated(true);  // remove system bar and border
        GraphicsDevice sd = getGraphicsConfiguration().getDevice();
        setBounds(sd.getDefaultConfiguration().getBounds()); // adapt view to display
      }
      else if (!isStartUp){ // notActive //toggle //startup and 
        setUndecorated(false); 
        setBounds(GS.getWindowedBounds()); // reset normal window size 
        setExtendedState(GS.getWindowStatus());
      } 
      zwischengeflickt.setVisible(Main.IS_MAC && setFullScreenActive && getExtendedState() != 6); //
      if (!isStartUp) setVisible(true);
    }

    public void onSelectProbs() {
        SelectionDialog d;
        Selection selSets = GS.getSelectedSets();
        do {
            d = new SelectionDialog(this, GS.getCollections(),
            selSets.getSelectedSets(),
            selSets.getSelectedTags(),
            selSets.getOrder(),
            selSets.getMatchType());
            if (d.wasCancelled() && selSets.isEmpty()) 
              JOptionPane.showMessageDialog(null, "Sorry: no valid selection = no \"Problems window\"");
        } while( (d.getNumSelected() == 0 && selSets.isEmpty()) || (d.wasCancelled() && selSets.isEmpty()) );  
                // here we could show a 
                // message "no problems selected" and use a standard problem (built-in?) instead 
                // could this run in SelectionDialog? (as long as no selection was made, selection stays open)
        wp.fillTagCB(); // xxxxxx wp Widgetpanel 
        // Combobox should now become updated (as in  SelectionDialog)
        // also, when "cancelled", because importTags is independent from ok/cancel 
        
        if(!d.wasCancelled()) {  // could this run in SelectionDialog?
            selSets.selectProblems(d.getSelectedSets(), d.getSelectedTags(), d.getOrder(), d.getMatchType());
            sgfController.nextProblem();
        }
        wp.fillTagList(sgfController.currentProblem);
    }
    
    public static void onValidate() {
        //String[] dummy = null;
        Validator localValidator = new Validator();
        File[] gotFolderF = FileWorks.selectFolder(1, "Select folder", "Validate", Main.USER_HOME, false); 
                                 // 1: one folder; "": beginHere, defaults to last opened or USER_HOME; false: needWrite=no
        if (gotFolderF[0] == null || !gotFolderF[0].exists()) return; // here a msg to the user?
        String[] gotFolder = {gotFolderF[0].toString()}; // why String[] and not a simple String? - ahhh! because localValidator.main - wants a String array
 //JOptionPane.showMessageDialog(null, gotFolder[0]);
          try {
            localValidator.main(gotFolder); // this asks for a string array
          }
          catch (Exception e){
            JOptionPane.showMessageDialog(null, "Error while validating; see grind-log.txt");
            Main.logSilent(e);
          }
    }
}
