/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.io.InputStream;
import jline.Terminal;
import jline.TerminalFactory;
import jline.internal.Log;

public abstract class TerminalSupport
implements Terminal {
    public static String DEFAULT_KEYBINDINGS_PROPERTIES = "keybindings.properties";
    public static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_HEIGHT = 24;
    private Thread shutdownHook;
    private boolean supported;
    private boolean echoEnabled;
    private boolean ansiSupported;

    protected TerminalSupport(boolean supported) {
        this.supported = supported;
    }

    public void init() throws Exception {
        this.installShutdownHook(new RestoreHook());
    }

    public void restore() throws Exception {
        TerminalFactory.resetIf(this);
        this.removeShutdownHook();
    }

    public void reset() throws Exception {
        this.restore();
        this.init();
    }

    protected void installShutdownHook(Thread hook) {
        assert (hook != null);
        if (this.shutdownHook != null) {
            throw new IllegalStateException("Shutdown hook already installed");
        }
        try {
            Runtime.getRuntime().addShutdownHook(hook);
            this.shutdownHook = hook;
        }
        catch (AbstractMethodError e) {
            Log.trace("Failed to register shutdown hook: ", e);
        }
    }

    protected void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (AbstractMethodError e) {
                Log.trace("Failed to remove shutdown hook: ", e);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.shutdownHook = null;
        }
    }

    public final boolean isSupported() {
        return this.supported;
    }

    public synchronized boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    protected synchronized void setAnsiSupported(boolean supported) {
        this.ansiSupported = supported;
        Log.debug("Ansi supported: ", supported);
    }

    public int getWidth() {
        return 80;
    }

    public int getHeight() {
        return 24;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void setEchoEnabled(boolean enabled) {
        this.echoEnabled = enabled;
        Log.debug("Echo enabled: ", enabled);
    }

    public int readCharacter(InputStream in) throws IOException {
        return in.read();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        return this.readCharacter(in);
    }

    public InputStream getDefaultBindings() {
        return TerminalSupport.class.getResourceAsStream(DEFAULT_KEYBINDINGS_PROPERTIES);
    }

    protected class RestoreHook
    extends Thread {
        protected RestoreHook() {
        }

        public void start() {
            try {
                TerminalSupport.this.restore();
            }
            catch (Exception e) {
                Log.trace("Failed to restore: ", e);
            }
        }
    }
}

