#!/usr/bin/python
#
# Find out when a failure occurred, using binary search.
#
# Usage:
#
#   python find-failure.py begin_date end_date [name]
#
# where begin_date is a date before the point where the failure
# occurred, and end_date is a date after the failure occurred.
# The dates are given in RCS format, e.g., "2008.09.08.23.36.55".
#
# If the optional "name" is given, the result of each test is stored
# persistently in bracket.db under a variable name formed by appending
# "_status" to the given name.  Care must be taken to avoid name
# clashes between tests, especially with built-in ones.
#
# This script may be used unmodified, in which case it will do builds
# and ask you to test them by hand, or it can be used as a starting
# point for an automated test, by replacing "ask_user_for_status" with
# a function that performs the test and returns a boolean result (True
# for success, False for failure).
#
# If running the test does not require the system to successfully
# install and boot, or if some third condition must be satisfied
# before the test can be run, modify the prerequisite list (currently
# "[install_op, boot_op]") accordingly.
#

from bracket import *

use_current_repository()

if len(sys.argv) > 3:
    name = sys.argv[3]
else:
    name = None

find_failure(rcs2ts(sys.argv[1]),
             rcs2ts(sys.argv[2]),
             TestOp(ask_user_for_status,
                    [install_op, boot_op],
                    name = name))
