# Copyright (C) 2008 Aaron Bentley.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""\
Various useful commands for working with bzr.
"""

from bzrlib import ignores, option
from bzrlib.commands import (
    builtin_command_names,
    plugin_cmds,
    )
from version import version_info, __version__


ignores.add_runtime_ignores(['./.shelf'])


commands = {
    'cmd_branch_history': [],
    'cmd_cbranch': [],
    'cmd_cdiff': [],
    'cmd_conflict_diff': [],
    'cmd_create_mirror': [],
    'cmd_fetch_ghosts': ['fetch-missing'],
    'cmd_graph_ancestry': [],
    'cmd_import': [],
    'cmd_link_tree': [],
    'cmd_multi_pull': [],
    'cmd_patch': [],
    'cmd_rspush': [],
    'cmd_shelf1': [],
    'cmd_shell': [],
    'cmd_shelve1': [],
    'cmd_trees': [],
    'cmd_unshelve1': [],
    'cmd_zap': [],
}


for cmd_name, aliases in commands.items():
    plugin_cmds.register_lazy(cmd_name, aliases,
                              'bzrlib.plugins.bzrtools.command_classes')

list_branches_aliases = (['branches'] if 'branches' not in
                         builtin_command_names() else [])

plugin_cmds.register_lazy('cmd_list_branches', list_branches_aliases,
                          'bzrlib.plugins.bzrtools.command_classes')

plugin_cmds.register_lazy('cmd_heads', [], 'bzrlib.plugins.bzrtools.heads')


option.diff_writer_registry.register_lazy(
    'auto-color', 'bzrlib.plugins.bzrtools.colordiff', 'auto_diff_writer',
    'Colorized diffs, if supported',
)
option.diff_writer_registry.register_lazy(
    'color', 'bzrlib.plugins.bzrtools.colordiff', 'DiffWriter',
    'Colorized diffs',
)
option.diff_writer_registry.default_key = 'auto-color'


def test_suite():
    from bzrlib.tests.TestUtil import TestLoader
    import tests
    from doctest import DocTestSuite, ELLIPSIS
    from unittest import TestSuite
    import bzrtools
    import tests.test_dotgraph
    import tests.test_cbranch
    import tests.test_conflict_diff
    from bzrlib.plugins.bzrtools.tests import test_fetch_ghosts
    import tests.test_graph
    import tests.test_link_tree
    import tests.test_patch
    import tests.test_mirror
    import tests.upstream_import
    import zap
    import tests.blackbox
    import tests.shelf_tests
    result = TestSuite()
    result.addTest(DocTestSuite(bzrtools, optionflags=ELLIPSIS))
    result.addTest(tests.test_suite())
    result.addTest(TestLoader().loadTestsFromModule(tests.shelf_tests))
    result.addTest(tests.blackbox.test_suite())
    result.addTest(TestLoader().loadTestsFromModule(tests.upstream_import))
    result.addTest(zap.test_suite())
    result.addTest(TestLoader().loadTestsFromModule(tests.test_dotgraph))
    result.addTest(TestLoader().loadTestsFromModule(test_fetch_ghosts))
    result.addTest(TestLoader().loadTestsFromModule(tests.test_graph))
    result.addTest(TestLoader().loadTestsFromModule(tests.test_link_tree))
    result.addTest(TestLoader().loadTestsFromModule(tests.test_patch))
    result.addTest(TestLoader().loadTestsFromModule(tests.test_cbranch))
    result.addTest(TestLoader().loadTestsFromModule(tests.test_conflict_diff))
    result.addTest(TestLoader().loadTestsFromModule(tests.test_mirror))
    return result
