#include "softgrip_buttons.inc"

#include "colors.inc"	
#include "textures.inc"	
#include "functions.inc" 

light_source { <0,10,-50>,  White}

plane { z,  1000  pigment{ rgb <2,0,2>}}
plane { z,  -100  pigment{ Gray90}}
plane { y,  -100  pigment{ Gray90}}
plane { y,  100  pigment{ Gray90}}
plane { x,  -100  pigment{ Gray90}}
plane { x,  100  pigment{ Gray90}}

 // +a0.3 +ua +w320 +h144  


camera { orthographic  location <0,1.5,-40>  look_at  <0,1.5,0> right 14*x  up 6.3*y }



intersection {
union{

// core
cylinder { <-10,0,0> <10,0,0> .9 pigment{ Gray50} finish{ specular .2 ambient .2 diffuse .6 metallic reflection{ .2 metallic}}}

difference{
cylinder { <-10,0,0> <10,0,0> 1 pigment{ Gray90} finish{ specular .1 ambient .2 diffuse .6 metallic reflection{ .2 metallic}}}

//volume gap
box { 
  <-1.6, -1.6, -1.6>
  < 1.6, 1.6,  1.6>
rotate z*45 translate <-1.9,0,0>}

// seperator
difference{
box {
  <-1, -1, -1>
  < 1,  1,  1>
rotate z*45 }
box {
  <-1, -1, -1>
  < 1,  1,  1>
rotate z*45 translate <-.3,0,0>}
translate <1.75,0,0>}


// advance gap
difference{
box {
  <-1, -1, -1>
  < 1,  1,  1>
rotate z*45 }
box {
  <-1, -1, -1>
  < 1,  1,  1>
rotate z*45 translate <-.3,0,0>}
translate <5.7,0,0>}

box {
  <3,.1,1.5>
  < 10,  -.1,  -1.5>}
}}

box { -4.8 4.8 rotate z*45}}

cylinder { <-1.9,0,1> <-1.9,0,-2>1.4 pigment{ Gray90} finish{ specular .1  metallic reflection{ .2 metallic}}}

//progress angle meter
difference{
cylinder { <-2.5,0,0> <1.3,5,0>1.1 pigment{ Gray90} finish{ specular .1 ambient .2 diffuse .6 metallic reflection{ .2 metallic}} }
box{ <-10,4,-2><10,10,2>}

        difference { 
        cylinder { <-2.5,0,-1> <1.3,5,-1>.7 pigment{ Gray90} finish{ specular .5 ambient .2 diffuse .6 metallic reflection{ .2 metallic}} }
        box{ <-10,3.8,-2><10,10,2>}
        box{ <-10,1.5,-2><10,0,2>} } 
}



//hardest part - grip

difference {
blob {
  threshold 0.6
 cylinder { <-.5,3.2,0> <5,3.2,0>  2, 1}
 cylinder { <-.35,3.9,-1> <5,3.9,-1> .5, 1}
 cylinder { <-.35,3.2,1> <5,3.2,1>  .5, 1}
  sphere { <6,  3.8, 0>, 2, .5 }
 sphere { <10,  2.6, 0>, 1, .6  scale <.5,1,1>}
 sphere { <8,  2.6, 0>, 1, .6 scale <.5,1,1>}
 sphere { <6,  2.6, 0>, 1, .6 scale <.5,1,1>}

 sphere { <4,  2.6, 0>, 1, .6 scale <.5,1,1>}
 sphere { <2,  2.6, 0>, 1, .6 scale <.5,1,1>}

  sphere { <6.5,  2.3, 0>, 1.2, .7 }
  sphere { <6.1,  3.1, 0>, 1, .7 }



 texture {
    pigment {
      crackle
      form <-2,2,0>
      scale <.7,.2,.2>
      warp { turbulence <.2,.2,.2> octaves 1 lambda 1.01 omega 0.11 }
      frequency 1
         color_map {
           [0.00 color Gray20]
           [0.10 color Gray20 ]
           [0.11 color Gray40 ]
           [1.00 color Gray40 ]
         }
      }
      
          normal {
      crackle .5
      form <-2,2,0>
      scale <.7,.2,.2>
      warp { turbulence <.2,.2,.2> octaves 1 lambda 1.01 omega 0.11 }
      frequency 1

      }
      finish{
         specular 0.1
    }
    scale .3
  }
}

        difference {
        cylinder { <-2.5,0,-1> <1.3,5,-1>.8 pigment{ Gray90} finish{ specular .5 ambient .2 diffuse .6 metallic reflection{ .2 metallic}} }
        box{ <-10,3.85,-2><10,10,2>}
        box{ <-10,1.45,-2><10,0,2>} }

}








// display area
prism {
	linear_sweep   linear_spline -3.5, 3.5,  5,
	< .9, 3.1>, < 5.2,  3.1>, < 5.8, 3.9>, < 1.5,  3.9>, < .9, 3.1>
	pigment{ Gray90} no_shadow rotate x*270
	}

        difference { 
        cylinder { <-2.5,0,.1> <1.3,5,.1>.7
pigment{ 
  gradient y  
color_map {
//  [ 0.0  color Green*2]
  [ clock-.2  color Green*2]
  [ clock+.2  color Black]
//  [ 1.0  color Black]
} // color_map
scale <1,2.3,1> translate y*1.5

//Green*2
}
 }


        box{ <-10,3.8,-2><10,10,2>}
        box{ <-10,1.5,-2><10,0,2>} 

        box{ <-10,1.4,-2><10,1.7,2>} 
        box{ <-10,1.8,-2><10,1.9,2>} 
        box{ <-10,2.0,-2><10,2.1,2>} 
        box{ <-10,2.2,-2><10,2.3,2>} 
        box{ <-10,2.4,-2><10,2.5,2>} 
        box{ <-10,2.6,-2><10,2.7,2>} 
        box{ <-10,2.8,-2><10,2.9,2>} 
        box{ <-10,3.0,-2><10,3.1,2>} 
        box{ <-10,3.2,-2><10,3.3,2>} 
        box{ <-10,3.4,-2><10,3.5,2>} 
        box{ <-10,3.6,-2><10,3.8,2>} 
        } 





















