/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.jsonp.client.JsonpRequestBuilder;
import com.google.gwt.resources.client.ExternalTextResource;
import com.google.gwt.resources.client.ResourceCallback;
import com.google.gwt.resources.client.ResourceException;
import com.google.gwt.resources.client.TextResource;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ExternalTextResourcePrototype
implements ExternalTextResource {
    private final TextResource[] cache;
    private final int index;
    private final String md5Hash;
    private final String name;
    private final SafeUri url;

    private static native JavaScriptObject evalObject(String var0);

    private static native String extractString(JavaScriptObject var0, int var1);

    public ExternalTextResourcePrototype(String name, SafeUri url, TextResource[] cache, int index) {
        this.name = name;
        this.url = url;
        this.cache = cache;
        this.index = index;
        this.md5Hash = null;
    }

    public ExternalTextResourcePrototype(String name, SafeUri url, TextResource[] cache, int index, String md5Hash) {
        this.name = name;
        this.url = url;
        this.cache = cache;
        this.index = index;
        this.md5Hash = md5Hash;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void getText(ResourceCallback<TextResource> callback) throws ResourceException {
        if (this.cache[this.index] != null) {
            callback.onSuccess(this.cache[this.index]);
            return;
        }
        if (this.md5Hash != null) {
            JsonpRequestBuilder rb = new JsonpRequestBuilder();
            rb.setPredeterminedId(this.md5Hash);
            rb.requestObject(this.url.asString(), new ETRCallback(callback));
        } else {
            RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, this.url.asString());
            try {
                rb.sendRequest("", new ETRCallback(callback));
            }
            catch (RequestException e) {
                throw new ResourceException(this, "Unable to initiate request for external resource", e);
            }
        }
    }

    private class ETRCallback
    implements RequestCallback,
    AsyncCallback<JavaScriptObject> {
        final ResourceCallback<TextResource> callback;

        public ETRCallback(ResourceCallback<TextResource> callback) {
            this.callback = callback;
        }

        @Override
        public void onError(Request request, Throwable exception) {
            this.onFailure(exception);
        }

        @Override
        public void onFailure(Throwable exception) {
            this.callback.onError(new ResourceException(ExternalTextResourcePrototype.this, "Unable to retrieve external resource", exception));
        }

        @Override
        public void onResponseReceived(Request request, Response response) {
            String responseText = response.getText();
            JavaScriptObject jso = ExternalTextResourcePrototype.evalObject(responseText);
            this.onSuccess(jso);
        }

        @Override
        public void onSuccess(JavaScriptObject jso) {
            if (jso == null) {
                this.callback.onError(new ResourceException(ExternalTextResourcePrototype.this, "eval() returned null"));
                return;
            }
            final String resourceText = ExternalTextResourcePrototype.extractString(jso, ExternalTextResourcePrototype.this.index);
            ((ExternalTextResourcePrototype)ExternalTextResourcePrototype.this).cache[((ExternalTextResourcePrototype)ExternalTextResourcePrototype.this).index] = new TextResource(){

                @Override
                public String getName() {
                    return ExternalTextResourcePrototype.this.name;
                }

                @Override
                public String getText() {
                    return resourceText;
                }
            };
            this.callback.onSuccess(ExternalTextResourcePrototype.this.cache[ExternalTextResourcePrototype.this.index]);
        }
    }
}

